{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                     ---  RUN-TIME KERNEL  ---                         *
*           ---  Floatting Point Exceptions Entries  ---                *
*               --- Version  3.1-B6 - 03-07-2022 ---                    *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 www.pierre.wolfers.fr                                 *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}


%pragma trace 0; { Always here: called by PAS__ERROR to don't loop }
module PAS_FP_ENV;

%include 'PASSRC:cpas__fenv_api_env';

(*
type
    FpExceptFlag   = (FPE_Inexa, FPE_Dzero, FPE_Overf, FPE_Inval, FPE__Under);
    FpExceptFlags  = set of FpExceptFlag use 32;

    FloatClass     = (FP_Normal, FP_SubNormal, FP_PInf, FP_NInf, FP_Nan);
*)

var
    ClassTab: array[0..4] of FloatClass := [FP_Normal,FP_SubNormal,FP_Pinf,FP_Ninf,FP_Nan];


function CC__FP_CLASSIFY( v: single ): cc__int; external 'CC__FloatClassify_F';
function CC__FP_CLASSIFY( v: double ): cc__int; external 'CC__FloatClassify_D';

function CC__FP_IS_NAN( v: single ): cc__int; external 'isnan';
function CC__FP_IS_NAN( v: double ): cc__int; external 'isnan';
function CC__FP_IS_INF( v: single ): cc__int; external 'isinf';
function CC__FP_IS_INF( v: double ): cc__int; external 'isinf';
function CC__FP_IS_NRM( v: single ): cc__int; external 'isnormal';
function CC__FP_IS_NRM( v: double ): cc__int; external 'isnormal';

function CC__GET_FLOAT_EXCEPT: FpExceptFlags; external 'CC__GetFloatExcept';


procedure PAS__ERROR( ierr: cc__int ); external 'PAS__ERROR';


[global 'Pas__FpClassify_F']
function PAS__FP_CLASSIFY( v: single ): FloatClass;
begin
    return ClassTab[ CC__FP_CLASSIFY( v )]
end PAS__FP_CLASSIFY;


[global 'Pas__FpClassify_D']
function PAS__FP_CLASSIFY( v: double ): FloatClass;
var re: FloatClass;
begin
    return CLassTab[CC__FP_CLASSIFY( v )]
end PAS__FP_CLASSIFY;



[global 'Pas__Check_Fpexc']
function PAS__CHECK_FPEXC: FpExceptFlags;
begin
    return CC__GET_FLOAT_EXCEPT
end PAS__CHECK_FPEXC;



[global 'Pas__Float_Trap']
procedure PAS__FLOAT_TRAP;
var
    exs: FpExceptFlags;
    err:       integer;

begin
    exs := CC__GET_FLOAT_EXCEPT * [FPE_Dzero, FPE_Overf, FPE_Inval];
    if exs <> [] then
    begin
        if exs = [FPE_Dzero] then err := 22
        else
            if exs = [FPE_Overf] then err := 24
            else
                if exs = [FPE_Inval] then err := 27
                else err := 20;
        PAS__ERROR( err )
    end
end PAS__FLOAT_TRAP;



end PAS_FP_ENV.

