{    **************************************************************
     *                                                            *
     *                                                            *
     *              *  C P A S  *  S Y S T E M  *                 *
     *                                                            *
     *                                                            *
     *      * * *   S t a n d a r d   L i b r a r y   * * *       *
     *                                                            *
     *                                                            *
     *         ---  Integer Power of Double Precision ---         *
     *                                                            *
     *   by :                                                     *
     *                                                            *
     *       P. Wolfers                                           *
     *         c.n.r.s.                                           *
     *         Laboratoire de Cristallographie                    *
     *         B.P.  166 X   38042  Grenoble Cedex                *
     *                           FRANCE.                          *
     *                                                            *
     **************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

module CPAS__RW;

[global 'PAS__IGPOWER']
function IGPOW( z: double; n: integer): double;
{ make the integer power n of the real number z }
var  u: double;
begin
  u := double( 1.0 );
  if n < 0 then
  begin
    n := - n; z := u / z
  end;
  while n > 0 do
    if ODD( n ) then
    begin
      n := n - 1; u := u * z
    end
    else
    begin
      n := n div 2; z := SQR( z )
    end;
  IGPOW := u
end IGPOW;

end.
