{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*         ---  PASCAL GLOBAL REFERENCE ENVIRONMENT MODULE  ---          *
*                                                                       *
*               ---  Version  3.1-A4 -- 31/01/2015 ---                  *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////



}


{************     CPAS  version    *************}



  { ******************************************************* }
  { ******************************************************* }
  { ****                                               **** }
  { ****    Global variable  reference declarations    **** }
  { ****                                               **** }
  { ******************************************************* }
  { ******************************************************* }


  [external] var

  trg_sys_name,                                { Target system name (kit_builder compatible) }
  trg_env_fspc,                                { Target system cpas_init environment file }
  cpas_env_dir,                                { CPAS setup directory where are located all cpas*.cpas_init files }
  cpas_env_file:                string;        { CPAS selected environment file }

  path_search_index,                           { Count Index for SEARCH_IN_PATH Routine }
  cpas_envdir_idx:             integer;        { CPAS setup directory index in the PATH }

  srf_free,                                    { List of free source record }
  srf_list:                    srf_ptr;        { Stack pointer of source record }

  sngl_size,                                   { Size of a single in bytes }
  dble_size,                                   { Size of a double in bytes }
  inte_size,                                   { Size of an integer in bytes }
  fptr_size:                   integer;        { Size of a pointer in bytes }

  pas_execute,                                 { Flag for executor to start }
  pas_compile:                 boolean;        { Flag for compiler to start }

  exp_stklvl:                  integer;        { Current expression stack level index }




      {***************************}
      {*  Operator Access Table  *}
      {***************************}


  ope_table: array[operator]  of ope_ptr;


   {**************************************}
   {*  Sensitive Error Manager Variable  *}
   {**************************************}

  err_prt:                     boolean;        { Flag for Enable/disable the Undeclared Identifier Error }



     {***********************************}
     {*  Identifier External Variables  *}
     {***********************************}


  sy_ident:                    id_name;        { Read identifier name }
  sy_casedef:                  boolean;        { Flag for case identifier }
  cntx_label:                  ide_ptr;        { Pointer to the inner context label }
  cntx_lblvl:                  integer;        { Local label level }
  curr_ident:                  nam_ptr;        { Current ptr of ident to re-search }
  cntx_srinf:                  boolean;        { Global source information level }




      {*******************************}
      {*  Identifier Tree Variables  *}
      {*******************************}

  lex_ident_tree:  array[0..max_disp]  of disp_rec;    { Tree roots }

  lex_ident_level: array[0..max_lex]   of  integer;    { Local Display of Each Lex }


  ident_disp,                                  { Lex level for a found identifier }
  cprc_disp,                                   { Current procedure display level }
  curr_disp,                                   { Current display lex level }
  curr_lex:                    integer;        { Current lex level }




        {****************************}
        {*  Standard Type Pointers  *}
        {****************************}


  typ_std: array[typ_forms] of typ_ptr;        { List of Standard Type Def. }

  { Standard input, output and error Text File Variable Pointer }
  std_inp_file,                                { Input  text file identifier pointer }
  std_out_file,                                { Output text file identifier pointer }
  std_err_file:                ide_ptr;        { Err    text file identifier pointer }


  {*******************************************}
  {*  Pointer to Special Procedure/Function  *}
  {*******************************************}

  set_entry_proc,                              { Pointer to large set generator function }
  new_entry_proc,                              { Pointer to the new entry procedure }
  newh_entry_proc,                             { Pointer to the newh entry procedure }
  dispose_entry_proc:          pro_ptr;        { Pointer to the dispose entry procedure }



  {***********************************************}
  {*  Pointer Array to Special I/O Generic List  *}
  {***********************************************}

  gen_std_cnfardsc,                            { Pointer to the Conformant Array Descriptor Generator }
  gen_std_string1,                             { Pointer to CHAR_IN_STRING generator }
  iof_std_open,                                { Pointer to OPEN generic }
  iof_std_close,                               { Pointer to CLOSE generic }
  inp_std_bin,                                 { Pointer to READ binary generic }
  inp_std_eoln,                                { Pointer to READ EOLN generic }
  inp_std_sel,                                 { Pointer to READ SELECTION generic }
  inp_std_gene,                                { Pointer to READ OBJECT generic }
  out_std_bin,                                 { Pointer to WRITE binary generic }
  out_std_eoln,                                { Pointer to WRITE EOLN generic }
  out_std_sel,                                 { Pointer to WRITE SELECTION generic }
  out_std_gene:                ide_ptr;        { Pointer to WRITE OBJECT generic }




  {*******************************************}
  {*  Pointers to Specials Type Definitions  *}
  {*******************************************}

  cta_typ,                                     { Pointer of cte str for ennum ident type }
  ima_typ,                                     { Pointer to the image prototype type }
  lun_typ,                                     { Pointer to the 64 bits unsigned type }
  lin_typ,                                     { Pointer to the 64 bits integer type }
  uns_typ,                                     { Pointer to the 32 bits unsigned type }
  int_typ:                     typ_ptr;        { Pointer of the 32 bits integer type }

  usi_tab,                                     { Pointer to Unsigned Set Image Table }
  csi_tab:                     ide_ptr;        { Pointer to Char Set Image table }




  {***************************************************************}
  {*  List of Dummy Identifiers Used for Undeclared Identifiers  *}
  {***************************************************************}

  ide_udptr: array[class_types] of ide_ptr;



  {*********************************************}
  {*  Lists of Free Special Allocation record  *}
  {*********************************************}

  lgt_free_list:               lgt_ptr;        { List of free LoGical Tree record }
  val_free_list:               val_ptr;        { List of free VALue record }
  all_free_list:               all_ptr;        { List of free ALLocation record }


  {*****************************************************}
  {*  Current Variable/Constant Type Parameter or nil  *}
  {*****************************************************}

  curr_descr:                  lgt_ptr;        { Current descriptor node pointer }



      {********************************}
      {*  Returned Value of INSYMBOL  *}
      {********************************}

  sy_cmin,                                     { Current lower character }
  sy_ch:                          char;        { Current character for INSYMBOL }
  sy_sym:                      sym_rec;        { symbol type and classification }
  lastsymb:                     symbol;        { Last symbol in source }
  sy_ival:                     integer;        { Integer value of constante }
  sy_rval:                      double;        { Real value of constante }
  sy_string:               string(255);        { Read string constante value }
  sy_attrflg:                  boolean;        { Flag for attribut quote readden }



    {*******************************************}
    {*  Pointer of Previously Selected Object  *}
    {*******************************************}

  sy_search:                   ide_ptr;        { Pointer of previously founded identifier }
                                               { Reset to nil by EXP_IDENTIFIER }
                                               { and set by the user with IDE_SEARCH is done }
  sy_type_gfirst:              gen_ptr;        { Generic list memory for GENDECL }
  sy_descr_size:               integer;        { Current Descriptor size ( for TYPE_SPC) }
  sy_lgt:                      lgt_ptr;        { Last LoGical Tree pointer }
  sy_label_flag,                               { Flag to enable label insymbol knowledge }
  sy_var_init_mod,                             { Flag for init standard variable mode }
  sy_generic_qmod,                             { Flag for Queue mode in generic list management }
  sy_init_mod,                                 { Flag for init mode (true)/user mode (false) }
  sy_fix_range_ctl:            boolean;        { Flag for fix range control }
  cntx_varbl:                  ide_ptr;        { Current context variable pointer }

  cntx_procname,                               { Context procedure name pointer offset }
  cntx_srcfname,                               { Context source file name pointer offset }
  cntx_linenbr,                                { Context source line number offset }
  cntx_size,                                   { Context size in byte }

  ctai_stroffset,                              { Cte character array offset }
  stri_stroffset,                              { String offset of the first character }
  stri_descrsz,                                { String descritor size in byte(s) }
  stri_lengthsz:               integer;        { String length size in byte(s) }



     {*********************************}
     {*  Compiler Particular Options  *}
     {*********************************}

  opt_exec,                                    { Flag to exec. the main after compilation }
  opt_check:                   boolean;        { Flag for check range compiler mode }



      {***********************************}
      {*  Keyword Tree Used by INSYMBOL  *}
      {***********************************}

  keyword_tree:            keyword_ptr;        { Keyword definition tree }



     {************************************}
     {*  Procedure/function Definitions  *}
     {************************************}

  proc_seq:                    integer;        { Procedure internal sequence number }
  all_fdata,                                   { Links to first and last procedure ... }
  all_ldata,                                   { ... local constants allocator }
  all_fglobal,                                 { Links to first and last procedure ... }
  all_lglobal,                                 { ... global definition allocation }
  all_fextern,                                 { Links to first and last procedure ... }
  all_lextern,                                 { ... external reference allocation }
  all_fstatic,                                 { Links to first and last procedure ... }
  all_lstatic:                 all_ptr;        { ... local static varbl allocator }




          {************************}
          {*  Module Definitions  *}
          {************************}

  vagd_first,                                  { First and last Global Data Value pointer of module }
  vagd_last,
  vald_first,                                  { First and last Data Value pointer of module }
  vald_last:                   val_ptr;

  algi_first,                                  { First and last Global Data Value pointer of module }
  algi_last,
  alsi_first,                                  { First and last init location ... }
  alsi_last,                                   { ... static pointer of module }

  algs_first,                                  { First and last Global Data Value pointer of module }
  algs_last,
  alls_first,                                  { First and last location descriptor ... }
  alls_last:                   all_ptr;        { ... pointer of module }




     {************************************}
     {*  File Specifications to Compile  *}
     {************************************}

  pas_obj,                                     { For object file }
  pas_src:                     str_ptr;        { For source file }



        {********************************}
        {*  General Compiler Variables  *}
        {********************************}


  lgt_debug0,                                  { Variables for Tree Build debug }
  lgt_debug1,

  lgt_inshde,                                  { Insertion node list head }
  lgt_inslst:                  lgt_ptr;        { Insertion node list end }

  cntx_typ,                                    { Pointer to the context type }
  comp_typ_ptr:                typ_ptr;        { Pointer of resulted generic type descr. }

  enm_range,                                   { Ennumerate type range flag for range check to perform }
  binline:                     boolean;        { Flag for inline procedure compile }


      { *** Emergency Flag to Exit from Compiler *** }

  emergency_stop:              boolean;        { To set the emergency exit of run }

  wildtmp_psz:                 integer;        { Previous Size for tmp stack }
  wildtmp_pal:              align_byte;        { Previous Alignement for tmp stack }
  wildtmp_stk:                 stk_ptr;        { Stack allocation list Pointer }
  wildtmp_typ:                 typ_ptr;        { Wild Var. for large funct. ret. val. type }
  wildtmp_ide:                 ide_ptr;        { Wild Var. for large funct. return value }

  atts_list,                                   { *** special attribut name tree root *** }
  attr_list:                   ide_ptr;        { *** variable attribut name tree root *** }

  env_file:                    str_ptr;        { Environment filename to use }
  env_first,                                   { First environment file to use }  
  env_last:                    env_ptr;        { Last environment file list to use }

  dst_seta,                                    { Maximum size of a dst set in bits }
  dst_setw,                                    { Maximum size of a dst word set in bits }
  dst_seti:                    integer;        { Maximum size of a dst set in word set }




   {*******************************}
   {*  Settable Compiler Options  *}
   {*******************************}

  cmp_optimizelvl:             integer;        { Optimize code level }
  cmp_tracecount,                              { Count for RTL line count tracing }
  cmp_traceopt,                                { Tracing increment opt. of CPAS RTL error }
  cmp_trace,                                   { Active tracing incr. of CPAS RTL error }
  cmp_listlvl,                                 { User Listing Level required }
  cmp_igenv:                   integer;        { Option flag for environment setup }

  cmp_cmpdbg,                                  { Flag to Debug the compiler ** CPAS DEBUG ** (must be set by code edition) }
  cmp_range,                                   { Flag to generate the in range checking code }
  cmp_fsctest,                                 { Flag to generate the variant record field in agreement selector checking code }
  cmp_dynamic,                                 { Flag for Auto. var. size alloc. enable }
  cmp_twicedcl,                                { Flag for twice declaration seen }
  cmp_twicedclon,                              { Flag for twice declaration allowed }
  cmp_debugopt,                                { Flag for Debug option required }
  cmp_debug,                                   { Flag for Debuging option enabled }
  cmp_genenv,                                  { Flag to build a environment file }
  cmp_opt,                                     { Flag for optimize tree }
  cmp_macf,                                    { Create a listing P code file if true } 
  cmp_cobj,                                    { Create a P code bin. file et/ou exec. tree if true }
  cmp_objf,                                    { Create a P code in binary file if true }
  cmp_bltt:                    boolean;        { Create an executable tree if true }





      {*******************************************}
      {*                                         *}
      {*   Informations for the code generator   *}
      {*                                         *}
      {*******************************************}

  std_store_dgf,
  std_store_dgl:               gen_ptr;        { Builtin/Standard Def. for the Store Operator }

  pas_main,                                    { Main procedure pointer }
  pro_current,                                 { Current procedure pointer }
  pro_d_first,                                 { First defined Pascal procedure (expect std.) }
  pro_d_last,                                  { Last defined Pascal procedure (expect std.) }
  pro_first,                                   { First Pascal procedure to compile }
  pro_last:                    pro_ptr;        { Last Pascal procedure to compile }

  srv_first,                                   { First service routine ... }
  srv_last:                    srv_ptr;        { and last one.Service routine list header }

  srv_count,                                   { Service Routine count }
  ireg_count,                                  { Register request count for integer, }
  freg_count,                                  { ... single float, or ... }
  greg_count:                  integer;        { ... double precision values }

  tcas_flag,                                   { Flag to signal a dynamic case in a record }
  ireg_flag,                                   { Register request flags for integer, }
  freg_flag,                                   { ... single float, or ... }
  greg_flag:                   boolean;        { ... double precision values }


  { ***  Table of Name for all the Operators   *** }
  opname: array[operator] of id_name;

