{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                     ---  RUN-TIME KERNEL  ---                         *
*           ---  Standard File Manager Definitions  ---                 *
*              ---  Version  2.3--A -- 15/01/2013 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}


(*
%pragma trace 0; { Always here: called by PAS__ERROR to don't loop }
%pragma code_option c_code '#define BASIC_IO   0';
module CPAS__BASIO;
*)

const
  def_buf_size =           256;
  eoln_char    =    char( 10 ); {* Line Feed *}


type

  {********** LIBRARY I/O MASKS **********}

  lio_flagsty = (
       lio_inp,        { bit00 ==> read is allowed }
       lio_out,        { bit01 ==> write is allowed }
       lio_ran,        { bit02 ==> RANDOM ACCESS mask }
       lio_win,        { bit03 ==> set if buffer is WRITE IN }
       lio_txt,        { bit04 ==> text file }
       lio_bin,        { bit05 ==> binary file }
       lio_dir,        { bit06 ==> Directory file (Presently Unused) }
       lio_std,        { bit07 ==> Standard input or output file }
       lio_chr,        { bit08 ==> Character i/o Device (Line by line exchange) }
       lio_blk,        { bit09 ==> Block i/o Device (as disk and mag-tape) }
       lio_tty,        { bit10 ==> Terminal i/o device }
       lio_pip,        { bit11 ==> PIPE i/o device }
       lio_soc,        { bit12 ==> PIPE is a SOCKET i/o device }
       lio_vir,        { bit13 ==> Virtual i/o }

       lio_b14,        { bit14, bit15 Reserved }
       lio_b15,

       lio_pri,        { bit16 ==> Print on Close time }
       lio_del,        { bit17 ==> Delete on Close time }

       lio_b18,        { bit18..bit23 Reserved }
       lio_b19,
       lio_b20,
       lio_b21,
       lio_b22,
       lio_b23,

       lio_eol,        { bit24 ==> Eoln seen }
       lio_est,        { bit25 ==> End of input string }
       lio_emp,        { bit26 ==> Empty buffer state }
       lio_eof         { bit27 ==> Eof seen }
  );


  {********** USER MASKS **********}
  {******* WARNING: The CONSTANT ORDER is VERY IMPORTANT --> DON'T CHANGE *****}

  open_flagsty = openflg;

  argv_typ     =   packed array[0..255] of char;
  argv_tabty   =   array[0..mxpar_process] of ^argv_typ;


  {***** DESCRIPTOR structure *********}

  lio_flags    =   set of lio_flagsty use 32,32;

  string_ptr   =   ^string;

  buffer_typ   =   packed array[word_unsigned] of char;

  buf_ptr      =   ^buffer_typ;

  { File specification definition }

  fild_ptr     =   ^fild_rec;

  fild_rec = record
    fild_curr:  ^char;         { Current file element pointer }
    fild_buf: buf_ptr;         { File BUFFER }
    fild_nxt,                  { Link to next file DESCRIPTOR }
    fild_prv,                  { Link to previous file DESCRIPTOR }
    fild_rel: fild_ptr;        { Related TTY files (ring) or NULL }
    fild_pro: $wild_pointer;   { Pointer to the related procedure }
    fild_pfname: string_ptr;   { PASCAL filename ptr }
    fild_cfile,                { C file descriptor or virtual index when < 0 }
    fild_objsize,              { =   1 }
    fild_bufsize,              { Size of the buffer }
    fild_bufcnt,               { Count of present bytes in the buffer }
    fild_dcnt,                 { Bytes Decount in the buffer }
    fild_index,                { bytes Index in the buffer }
    fild_curpos: integer;      { Position in BUFFER UNIT for Map Buffer }
    fild_state: lio_flags      { File state flags }
  end;


const
  ifl_read    = 2**ORD( read_file );
  ifl_write   = 2**ORD( write_file );
  ifl_append  = 2**ORD( append_file );
  ifl_append1 = ifl_append + ifl_write;
  ifl_update  = ifl_read + ifl_write;

type

  lioorinty = record
    case boolean of
      false:(iv: integer);
      true: (sv: lio_flags);
  end;

  open_flags = SET of open_flagsty use integer"size*8;

  opeorinty  = record
    case boolean of
      false:(iv: integer);
      true: (sv: open_flags);
  end;


const
  ope_sta =  [new_file, old_file, unknown_file];        { To test new/old/unknown }


procedure PAS__ERROR( ierr: cc__int ); external 'PAS__ERROR';

procedure PAS__INS_PROC( var pp: $wild_pointer;
                         procedure pr( fp: fild_ptr ));
external 'PAS__ins_proc';

procedure PAS__EXE_PROC( pp: $wild_pointer; fp: fild_ptr );
external 'PAS__exe_proc';


