{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*            ---   EXPRESSION ROUTINES PASCAL MODULE   ---              *
*                                                                       *
*               ---  Version  3.0-0 -- 30/11/2013 ---                   *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************




/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////


}


{************     CPAS  version    *************}


(*
[inherit(    'lib:cpas_b__src',        { Use string management definitions }
             'lib:pas_env')]           { Use tree definitions }
*)
module PAS_EXPRESSION( Input, Output );


{ *** Include basic compiler environment *** }
%include 'passrc:pcmp_env';


{
        *** modification(s) from major version ***


			----

		       nothing

			----

}

const
  DEBUG_MOD = false;



[global]
procedure SET_STRNAME( var nam: nam_ptr );
var
  i: integer;

begin
  if sy_sym.sy = stringconst then
  begin
    NEW( nam );
    with nam^ do
    begin
      if sy_string.length > id_maxsize-1 then l := id_maxsize-1
      else l := sy_string.length;
      for i := 1 to l do
        s[i] := sy_string.body[i]
    end;
    INSYMBOL
  end
end SET_STRNAME;



[global]
procedure SET_STDNAME( pr: pro_ptr );
const
  mdnam = 'EXTP';

var
  i: integer;

begin
  with pr^ do
  begin
    if pro_stdname <> nil then SRC_ERROR( mdnam, 129, e_warning );
    if sy_sym.sy = stringconst then SET_STRNAME( pro_stdname )
    else
    begin
      pro_stdname := nil;
      SRC_ERROR( mdnam, 58, e_severe )
    end
  end
end SET_STDNAME;



[global]
function SAME_TYPE( ty1, ty2: typ_ptr ): boolean;
{ To compare the type definition ty1 and ty2 }
var
 sametyp: boolean;

begin { SAME_TYPE }
  enm_range := false;
  sametyp := (ty1 = ty2);
  { OK when the types are sames }
  if not sametyp then
    if (ty1 <> nil) and (ty2 <> nil) then              { Two Defined Types, ... }
      if (ty1^.typ_form = ty2^.typ_form) and           { ... with same form, }
         (ty1^.typ_parent = ty2^.typ_parent) and       { ... same parent, }
         (ty1^.typ_ide = ty2^.typ_ide) and             { ... same type identifier, }
         (ty1^.typ_size = ty2^.typ_size) then          { ... and same size in bytes }
        case ty1^.typ_form of
          form_char, form_lit, form_int:               { Both must be signed or unsigned and same range }
            if (ty1^.typ_unsigned = ty2^.typ_unsigned) and
               (ty1^.typ_min = ty2^.typ_min) and
               (ty1^.typ_max = ty2^.typ_max) then sametyp := true;
          form_single, form_double: sametyp := true;   { Single and Double Float are considered as sames }
          form_pointer, form_nil, form_file:           { Pointers and files to access to the same object type }
              sametyp := SAME_TYPE( ty1^.typ_eltype, ty2^.typ_eltype );
          form_set, form_lset:                         { Set of same cardinalities and same set element type }
            if (ty1^.typ_cardinality = ty2^.typ_cardinality) then
              sametyp := SAME_TYPE( ty1^.typ_seltype, ty2^.typ_seltype );
          form_conf, form_array:                       { Array with same index type and same element type }
            if (ty1^.typ_idim = ty2^.typ_idim) and
               (ty1^.typ_el_size = ty2^.typ_el_size) then
              if SAME_TYPE( ty1^.typ_indtype, ty2^.typ_indtype ) and
                 SAME_TYPE( ty1^.typ_aeltype, ty2^.typ_aeltype ) then
                sametyp := true;
          form_range:                                  { We verify only the parent identity of range }
            sametyp := SAME_TYPE( ty1^.typ_parent, ty2^.typ_parent );
          form_fentry:
            sametyp := COMPARE_ENTRY( ty1^.typ_entry, ty2^.typ_entry );
        otherwise
        end;
  SAME_TYPE := sametyp
end SAME_TYPE;



[global]
function COMPARE_ENTRY( pr1, pr2: pro_ptr ): boolean;
{ To Check the identity of two procedures/functions entry }
var
  id1, id2: ide_ptr;
  sameproc: boolean;

begin
  if pr1 = pr2 then sameproc := pr1 <> nil
  else
  begin
    sameproc := false;
    if (pr1 <> nil) and (pr2 <> nil) then
    begin
      if pr1^.pro_typ <> pr2^.pro_typ then sameproc := SAME_TYPE( pr1^.pro_typ, pr2^.pro_typ )
                                      else sameproc := true;
      if sameproc then
      begin { Procedure or function_of_same_type }
        id1 := pr1^.pro_parmlst; id2 := pr2^.pro_parmlst;
        { For function skip returned value }
        { /// if pr1^.pro_typ <> nil then id1 := id1^.ide_nxt; }
        { /// if pr2^.pro_typ <> nil then id2 := id2^.ide_nxt; }
        if (id1 = nil) or (id2 = nil) then sameproc := (id1 = id2)
        else
        repeat
          sameproc := SAME_TYPE( id1^.ide_typ, id2^.ide_typ );
          if sameproc then
          begin
            if id1^.ide_class = cla_fentry then
              if id2^.ide_class = cla_fentry then
                if (id1^.ide_entry^.pro_pkind = pro_formal) and (id2^.ide_entry^.pro_pkind = pro_formal) then
                  sameproc := COMPARE_ENTRY( id1^.ide_entry, id2^.ide_entry )
                else sameproc := false
              else sameproc := false;
            id1 := id1^.ide_nxt; id2 := id2^.ide_nxt
          end
        until (id1 = nil) or (id2 = nil) or (not sameproc);
        if id1 <> id2 then sameproc := false
      end
    end
  end;
  COMPARE_ENTRY := sameproc
end COMPARE_ENTRY;



[global]
function COMPARE_PROC_ARGID( pgc, pgl: gen_ptr; ent: pro_ptr ): gen_ptr;
{ To Check the identity of two procedures/functions declaration,
  Only a User/(not Builtin) procedure can be found here }
var
  prc:     pro_ptr;
  fndproc: boolean;

begin { COMPARE_PROC_ARGID }
  fndproc := false;                                    { Until showed otherwise }
  if (pgc <> nil) and (ent <> nil) then                { /// and (pgl <> nil) /// }
  begin
    { Loop to find a procedure/function definition identity }
    while (pgc <> nil) and (not fndproc) do
    with pgc^ do
    begin
      if not gen_blt then
      begin
        prc := gen_proc;
        fndproc := COMPARE_ENTRY( prc, ent )
      end;
      if not fndproc then
        if pgc = pgl then pgc := nil                   { When the local lex scan is finish }
                     else pgc := pgc^.gen_link         { Otherwise continue the scan }
    end
  end;
  if not fndproc then pgc := nil;
  COMPARE_PROC_ARGID := pgc
end COMPARE_PROC_ARGID;



function COMP_SCALAR( te, tf: typ_ptr ): integer;
{ To compare two scalar types and return :
        0 - For same/identic types,
        1 - For array index compatible types (low bounds are same),
        2 - Assignement compatible with possibility of underflow (no same lower bounds),
        3 - Not assignement compatible (no common range),
        4 - For incompatible type.
}

var
  t: integer;
  re_min, re_max, rf_min, rf_max: double;

begin { COMP_SCALAR }
  t := 4;               { Assume incompatible until showed otherwise }
  if te = tf then t := 0 { Same Type } else
    if (te <> nil) and (tf <> nil) then
      with te^ do
      if typ_form = tf^.typ_form then
        if (typ_parent = tf) or (te = tf^.typ_parent) or
          ((typ_parent <> nil) and (typ_parent = tf^.typ_parent)) then
        begin
          if typ_unsigned then
          begin  re_min := typ_umin; re_max := typ_umax  end
          else
          begin  re_min := typ_min; re_max := typ_max  end;
          with tf^ do
            if typ_unsigned then
            begin  rf_min := typ_umin; rf_max := typ_umax  end
            else
            begin  rf_min := typ_min; rf_max := typ_max  end;

          if (rf_min > re_min) or (rf_max < re_max) then enm_range := true;

          if (re_min <= rf_max) and (re_max >= rf_min) then
            { When te and tf overlap }
            if re_min = rf_min then
              if re_max = rf_max then t := 0   { Same Limits }
                                 else t := 1   { Last index Array Compatible - Same Low bound }
            else t := 2                        { Assignement compatible with possibility of error (Over or Under Range Reached) }
          else t := 3                          { Not assignement compatible }
        end
        else enm_range := true;
  COMP_SCALAR := t
end COMP_SCALAR;



[global]
function COMP_TYPE( eff, frm: typ_ptr; exact: boolean ): boolean;
{ To compare the type definition t1 and t2 }

type
  test = ( bad, ver, str, cha, ok );

var

 comp_table: [static] array[form_char..form_wild,form_char..form_wild] of test := (

 {eff\frm  char, lit, int, flt,dble, ptr,file, arr,conf, rec, set,lset,fent, nil,wlit,ennu,wfil,wset,wlse,wwse,wrec,wild }
 { char } ( ver, bad, bad, bad, bad, bad, bad, bad, bad, cha, bad, bad, bad, bad,  ok,  ok, bad, bad, bad, bad, bad,  ok ),
 {  lit } ( bad, ver, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok,  ok, bad, bad, bad, bad, bad,  ok ),
 {  int } ( bad, bad, ver, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad, bad,  ok ),
 {single} ( bad, bad, bad, ver, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok ),
 {double} ( bad, bad, bad, bad, ver, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok ),
 {  ptr } ( bad, bad, bad, bad, bad, ver, bad, bad, bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad, bad, bad, bad,  ok ),
 { file } ( bad, bad, bad, bad, bad, bad, ver, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad,  ok ),
 {  arr } ( bad, bad, bad, bad, bad, bad, bad, ver, ver, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok ),
 { conf } ( bad, bad, bad, bad, bad, bad, bad, bad, ver, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok ),
 {record} ( bad, bad, bad, bad, bad, bad, bad, str, str, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok,  ok ),
 {  set } ( bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, ver, ver, bad, bad, bad, bad, bad,  ok,  ok,  ok, bad,  ok ),
 { lset } ( bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, ver, bad, bad, bad, bad, bad, bad,  ok,  ok, bad,  ok ),
 { fent } ( bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, ver, bad, bad, bad, bad, bad, bad, bad, bad,  ok ),
 {  nil } ( bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad, bad, bad,  ok,  ok, bad, bad, bad, bad, bad, bad, bad,  ok ),
 { wlit } (  ok,  ok, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok,  ok, bad, bad, bad, bad, bad,  ok ),
 {ennum } (  ok,  ok,  ok, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok,  ok, bad, bad, bad, bad, bad,  ok ),
 {wfile } ( bad, bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad,  ok ),
 { wset } ( bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad, bad, bad,  ok, bad,  ok, bad,  ok ),
 {wlset } ( bad, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad, bad, bad,  ok,  ok, bad,  ok ),
 {wwset } ( bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok,  ok, bad, bad, bad, bad, bad,  ok,  ok,  ok, bad,  ok ),
 { wrec } ( bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok, bad, bad, bad, bad, bad, bad, bad, bad, bad, bad,  ok,  ok ),
 { wild } (  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok,  ok )
 );

 bstp, b1:   boolean;
 t:             test;
 peff, pfrm: typ_ptr;

begin { COMP_TYPE }
  enm_range := false;   { Assume no range check until shown otherwise }
  { OK when the types are sames }
  b1 :=  ( eff = frm );
  if (eff <> nil) and (frm <> nil) then
    { We look for formal parent of effective }
    if not b1 then
    begin
      peff := eff^.typ_parent;
      repeat
        if peff <> nil then
        with peff^ do
        begin
          b1 := ( frm = peff );
          peff := typ_parent
        end
      until b1 or (peff = nil);

      if not b1 then
      with frm^ do
      begin
        { Test for formal is a range of a effective type }
        if typ_form = form_range then
          b1 := COMP_TYPE( typ_parent, eff, exact );   { In this case, it is ok. }

        if not b1 then
          { Other cases }
          if (eff^.typ_form <= form_wild) and (typ_form <= form_wild) then
          case comp_table[eff^.typ_form, typ_form] of
            ok: b1 := true;

            ver: case typ_form of { Case on Formal typ_form }
                   form_lit,
                   form_int,
                   form_char:    { * For ennumerated types we must verify the range compatibility }
                     if typ_fxdrange then
                       if not exact then b1 := (COMP_SCALAR( eff, frm ) <= 2)
                                    else b1 := (COMP_SCALAR( eff, frm ) =  0) and (typ_size = eff^.typ_size);

                   form_set,
                   form_lset:    { * For the set (small or large), the element types must be compatibles }
                     b1 := COMP_TYPE( eff^.typ_seltype, typ_seltype, exact );

                   form_array:   { * For Array, the element type must be sames and the index type must be compatibles }
                     b1 := (eff^.typ_aeltype = typ_aeltype) and
                           COMP_TYPE( eff^.typ_indtype, typ_indtype, true );

                   form_conf:    { * For conformant formal type, we must check the compatibilities of elements and indexies }
                     b1 := COMP_TYPE( eff^.typ_aeltype, typ_aeltype, true ) and
                           COMP_TYPE( eff^.typ_indtype, typ_indtype^.typ_parent, true );

                   form_pointer: { * For pointer the pointed types must be compatibles }
                     b1 := COMP_TYPE( eff^.typ_eltype, typ_eltype, true );

                   form_fentry:  { * For formal/pointer_of procedure/function, we must verify the proc./funct. compatibility }
                     b1 := COMP_PROC_ARG( eff^.typ_entry, typ_entry );

                 otherwise  { Always bad }
                 end { case typ_form };

            cha: { When the Formal parameter is a standard string }
                 b1 := COMP_TYPE( frm, typ_std[form_record], false );

            str: { When the Effective parameter is a standard string }
                 if COMP_TYPE( eff, typ_std[form_record], false ) then
                   { Effective Standard string used as array of char }
                   b1 := COMP_TYPE( eff^.typ_lastfield^.ide_typ, frm, false );


          otherwise { always bad }
          end { case comp_table ... }
      end
    end;
  COMP_TYPE := b1
end COMP_TYPE;



[global]
function COMP_PROC_ARG( epr, fpr: pro_ptr ): boolean;
{ Check the call compatibility of effective entry epr^ with the formal entry fpr^.
}
var
  eid, fid:  ide_ptr;
  goodparam: boolean;

begin { COMP_PROC_ARG }
  goodparam := true;                                   { Until showed otherwise }
  if epr <> fpr then
    if (epr <> nil) and (fpr <> nil) then              { Both rec.ord pro_rec must be existing }
    begin
      if epr^.pro_typ <> fpr^.pro_typ then
        goodparam := false                             { The returned type must be same }
      else
      begin
        eid := epr^.pro_parmlst;                       { Get the arguments list heads }
        fid := fpr^.pro_parmlst;
        if epr^.pro_typ <> nil then                    { For functions, skip returned value }
        begin  eid := eid^.ide_nxt; fid := fid^.ide_nxt  end;
        while (eid <> nil) and (fid <> nil) and goodparam do
        begin                                          { Argument(s) Loop }
          if fid^.ide_class <> eid^.ide_class then goodparam := false
          else
          case fid^.ide_class of
            cla_varbl:  { * Each argument must have compatible type for by_value argument and exact matching type otherwise }
              goodparam := COMP_TYPE( eid^.ide_typ, fid^.ide_typ, fid^.ide_vkind <> var_vformal );

            cla_fentry: { * Formal Entry must be compatible }
              if COMP_TYPE( eid^.ide_typ, fid^.ide_typ, true ) then goodparam := COMP_PROC_ARG( eid^.ide_entry, fid^.ide_entry )
                                                               else goodparam := false;

          otherwise
            { Usually due to previously detected Error }
          end;
          eid := eid^.ide_nxt;
          fid := fid^.ide_nxt
        end
      end;
      if (eid <> nil) or (fid <> nil) then goodparam := false  { No compatibility if the argument list length are not same }
    end
    else goodparam := false;                           { Same Entry model (rec: pro_rec) type }
  COMP_PROC_ARG := goodparam
end COMP_PROC_ARG;



[global]
procedure TYPE_PARM_CTE_INIT( ty: typ_ptr; var lghf, lghl: lgt_ptr; var count: integer );
{ Evaluate all formal arguments of a specified type record and form a list of
  lgt_const record with the determined values.
}
const
  mdnam = 'TYC1';

var
  ipf: ide_ptr;
  lgc, lgl: lgt_ptr;

begin
  if ty <> nil then
  with ty^ do
  begin
    ipf := typ_parmlst;
    lgl :=  typ_actual;
    while ipf <> nil do
    with ipf^ do
    begin
      lgc := LGT_TYPE_EVAL( lgl, nil );
      with lgc^ do
      begin
        lgt_typ := ide_typ;
        if lgt_kind <> lgt_const then SRC_ERROR( mdnam, 132, e_severe )
        else
        with lgt_cte^ do
        begin  val_size := ide_typ^.typ_size; val_typ := ide_typ end;
        lgt_disp := ide_toffset;     { Set the node offset }
      end;
      ide_tlink2 := lgc;
      ide_tkind  := tpa_eval;
      if lghf = nil then lghf := lgc    { Append each node to the expression List (a queue) }
                    else lghl^.lgt_nxt := lgc;
      lghl := lgc;
      count := count + 1;               { Update the Value list count }
      lgl := lgl^.lgt_nxt;              { Skip to the next type parameter }
      ipf := ide_nxt
    end
  end
end TYPE_PARM_CTE_INIT;



[global]
procedure TYPE_PARM_CTE_RELEASE( ty: typ_ptr );
{ Set the tpa_sub flag for all formal arguments of a specified type record.
}
var
  ipf: ide_ptr;

begin
  ipf := ty^.typ_parmlst;
  while ipf <> nil do
  with ipf^ do
  begin
    ide_tkind := tpa_sub;
    ide_tlink2 := nil;
    ipf := ide_nxt
  end
end TYPE_PARM_CTE_RELEASE;



[global]
procedure STRING_IN_ARRAY( lgt: lgt_ptr; ty: typ_ptr );
{ Convert a Constant String to the specified array of char.
}
var
  ph, pl, pc:          val_ptr;
  ps:                  str_ptr;
  i, dim, len, dcp:    integer;
  lgt1, lghf, lghl:    lgt_ptr;

begin
  if lgt^.lgt_cte <> nil then
  with lgt^, ty^ do
  begin
    pl  :=      nil;
    dim := typ_size;
    lghf := nil;
    lghl := nil;
    dcp  :=   0;
    if typ_parmlst <> nil then
    begin { * Management of Type Parameters as front values in the Agregat * }
(*
with typ_parmlst^, ide_name^ do
WRITELN( lst_current^.lst_file, ' Id cla_tparam n = "', s:l,
                                '" offset = ', ide_toffset:0 );
*)
      TYPE_PARM_CTE_INIT( ty, lghf, lghl, dcp );
      while lghf <> nil do
      begin
        lghl := lghf;
        lghf := lghf^.lgt_nxt;
        with lghl^ do
        begin
          pc := nil;
          VAL_COPY( lgt_cte, pc, true );
          if pl = nil then ph := pc
                      else pl^.val_next := pc;
          pl := pc
        end;
        LGT_FREE( lghl )
      end;
      dim := dim - typ_descr_size
    end;

    if dim <= 0 then
      if typ_actual <> nil then
        dim := typ_actual^.lgt_cte^.val_ival;

    case lgt_cte^.val_kind of
      form_char:
        begin { To fill in space the array behind the first char }
          if dim <= 0 then dim := 1;            { *** The expected size is not known *** }
          if pl = nil then ph := lgt_cte        { Append the given character to the list of agregat }
                      else pl^.val_next := lgt_cte;
          pl := lgt_cte;                        { Set the given character as the first of the character list }
          lgt_cte := nil;                       { The character value record must be preserved as the first array element }
          for i := 2 to dim do                  { Loop to complete the array with spaces }
          begin
            pc := nil;
            VAL_NEW( pc, typ_std[form_char] );
            pc^.val_ival := ORD( ' ' );
            pl^.val_next := pc;
            pl := pc
          end
        end;

      form_string:
        begin
          ps := lgt_cte^.val_str;
          if ps = nil then len := 0
                      else len := ps^.length;
          if dim <= 0 then
            if typ_comp_size <> nil then
            begin
              lgt1 := LGT_TYPE_EVAL( typ_comp_size, nil );
              if lgt1 <> nil then
              with lgt1^ do
                if lgt_kind = lgt_const then
                  if lgt_cte <> nil then dim := lgt_cte^.val_ival
            end;

          if dim <= 0 then dim := len;          { *** The expected size is not known *** }
          for i := 1 to dim do                  { Loop to fill the array with the string characters ... }
          begin                                 { ... and by required trailing spaces }
            pc := nil;
            VAL_NEW( pc, typ_std[form_char] );
            if i <= len then pc^.val_ival := ORD( ps^[i] )
                        else pc^.val_ival := ORD( ' ' );
            if pl = nil then ph := pc
                        else pl^.val_next := pc;
            pl := pc
          end
        end;
    otherwise
    end;
    if lgt_cte <> nil then VAL_FREE( lgt_cte ); { Destroy the old value record when required }
    VAL_NEW( lgt_cte, ty );                     { Create the new (array of char) value record }
    with lgt_cte^ do
    begin
      val_lst   :=  ph;                         { Set the array value list }
      val_size  := dim;                         { Set the array size (in element) }
      val_descr := dcp                          { Set the array value count as potential descriptor value }
    end;

    if typ_parmlst <> nil then  TYPE_PARM_CTE_RELEASE( ty )
  end;
  lgt^.lgt_typ := ty
end STRING_IN_ARRAY;



[global]
procedure STRING_IN_SUBSTRING( lgt: lgt_ptr; ty: typ_ptr );
{ Convert a constant string to the specified subtype of string }
var
  pv:          val_ptr;
  ps:          str_ptr;
  i, dim, len: integer;

begin
  if lgt^.lgt_cte <> nil then
  with lgt^, ty^ do
  begin
    pv := lgt_cte;                                     { Keep the old val record }
    lgt_cte := nil;                                    { And build the new one }
    VAL_COPY( pv, lgt_cte, true );
    with lgt_cte^ do
    begin
      val_size := typ_size - stri_stroffset;
      val_typ  := ty
    end
  end;
  lgt^.lgt_typ := ty
end STRING_IN_SUBSTRING;



[global]
procedure INITIALIZE_VARBL( ip: ide_ptr );
{ Init all parametrised or inited single variable before first use }
var
  lgt: lgt_ptr;

begin
  with ip^, ide_owner^ do
  begin { Parameter initialization }
    ide_vacc := ide_vacc + [var_initialized];
    { Generate the constant reference for initialization }
    LGT_NEW( lgt, ide_typ, lgt_const, nil );
    with lgt^ do
    begin
      lgt_cte := ide_inival;
      VAL_NEW( lgt_cte, nil {unused} )
    end;
    lgt := LGT_NEW_IDREF( ip, lgt );                   { Generate the variable reference }

    { Generate the assignement statement }
    if (ide_typ^.typ_form = form_file) or (ide_typ^.typ_form = form_wfile) then
      lgt := LGT_NEW_CODE( pcod_istore, lgt )
    else
      lgt := EXP_GENOP( ass_op, lgt );

    { Link to init node list of the owner procedure/function }
    case pro_pkind of
      pro_main, pro_package, pro_forward, pro_decl, pro_inline, pro_global:
        begin
          if pro_init_hde = nil then pro_init_hde := lgt
                                else pro_lst^.lgt_nxt := lgt;
          pro_lst := lgt
        end;

    otherwise
    end
  end
end INITIALIZE_VARBL;



[global]
procedure TYPE_CHECK_PARM( lgt: lgt_ptr );
{ Procedure to check the type argument expression legality }
const
  mdnam = 'TYCH';

var
  p: lgt_ptr;

begin
  with lgt^ do
    case lgt_kind of
      lgt_varbl:
        with lgt_ide^ do
          if ide_class <> cla_tparam then
            { Not a legal type definition expression }
            SRC_ERROR_S( mdnam, 201, e_severe, ide_name^ );

      lgt_const: { Nothing to do } ;

      lgt_codep:
        begin
          p := lgt_parmlst;
          while p <> nil do
          begin
            TYPE_CHECK_PARM( p );
            p := p^.lgt_nxt
          end;
          case lgt_pcode of
             pcod_ineg, pcod_succ, pcod_pred, pcod_not, pcod_iabs,
             pcod_iadd, pcod_isub, pcod_and, pcod_imul, pcod_idiv,
             pcod_imod, pcod_ipow, pcod_bic, pcod_eq, pcod_ne,
             pcod_ult, pcod_ule, pcod_uge, pcod_ugt,
             pcod_ilt, pcod_ile, pcod_ige, pcod_igt,
             pcod_range: { ok };
          otherwise
            SRC_ERROR( mdnam, 202, e_severe )
          end
        end;

      lgt_null:
        { The effective type must be a defined type }
        if lgt_typ = nil then SRC_ERROR( mdnam, 203, e_severe );

    otherwise
      { Not a legal type definition expression }
      SRC_ERROR( mdnam, 204, e_severe )
    end
end TYPE_CHECK_PARM;



[global]
function TYPE_PARM_SET( ip: ide_ptr; lgt: lgt_ptr ): typ_ptr;
{ Look for conformance of type parameters }
{ Set all parameter values in a lgt_rec list }
const
  mdnam = 'TPRM';

var
  lgt1, lgti, lgta: lgt_ptr;
  p1:               typ_ptr;
  iq:               ide_ptr;
  ivn, imi, ima, n: integer;


  procedure SUBTYPE_SET_VALUE( var lgr: lgt_ptr; var irv: integer; lgp: lgt_ptr );
  { To set a Sub-Type Related Value from the computed lgr expression }
  begin
    if lgp = nil then lgr := nil
    else
    begin
      lgr := LGT_TYPE_EVAL( lgp, nil );
      if lgr <> nil then
        { The irv parameter is update when its original value was dynamic (< 0) }
        if (irv < 0) and (lgr^.lgt_kind = lgt_const) then
        begin
          if lgr^.lgt_cte <> nil then irv := lgr^.lgt_cte^.val_ival;
          LGT_FREE( lgr )
        end
    end
  end SUBTYPE_SET_VALUE;



begin { TYPE_PARM_SET }
  ivn        :=          0;
  lgt1       :=        lgt;
  with ip^ do
  begin
    iq := ide_typ^.typ_parmlst;
    while (iq <> nil) and (lgt1 <> nil) do
    begin { Loop on all type parameters to check the expression
            and set the dynamic constant state }
      with iq^, lgt1^ do
        if COMP_TYPE( lgt_typ, ide_typ, false ) then
        begin
          { Const and Type Parameter only allowed }
          TYPE_CHECK_PARM( lgt1 );             { Check for legal expr }
          ide_tkind  := tpa_dycte;             { Set to flag as usable }
          ide_tlink2 := lgt1                   { Link to current }
        end
        else { Not compatible types }
          SRC_ERROR_S( mdnam, 201, e_severe, ide_name^ );

      lgt1 := lgt1^.lgt_nxt;  { Go to Next One }
      iq := iq^.ide_nxt
    end;
    { This error (incompatible effective and formal list) would not be exist }
    if (lgt1 <> nil) or (iq <> nil) then SRC_ERROR( mdnam, 998, e_severe );

    if ide_typ^.typ_form = form_generic then
    begin { We must get the valide type definition part }
      lgt1 := LGT_TYPE_EVAL( ide_typ^.typ_comp_size, nil );
      { Get the associated type }
      if lgt1^.lgt_kind = lgt_const then p1 := comp_typ_ptr
                                    else SRC_ERROR( mdnam, 222, e_severe )
    end
    else
    begin { We must create a subtype of the Specified Parametrized type }
      IDE_NEW_TYP( ide_typ^.typ_form, p1 );
      with p1^ do
      begin
        typ_subtype    := true;
        typ_parent     := ide_typ;
        typ_parmlst    := ide_typ^.typ_parmlst;
        typ_size       := ide_typ^.typ_size;
        typ_descr_size := ide_typ^.typ_descr_size;
        typ_align      := ide_typ^.typ_align;
        typ_inival     := ide_typ^.typ_inival;
        typ_hasidsc    := ide_typ^.typ_hasidsc;
        { Get all parent conversions def. }
        sy_type_gfirst := ide_gfirst;
        typ_actual     := lgt;

        SUBTYPE_SET_VALUE( typ_comp_size, typ_size, ide_typ^.typ_comp_size );

        case typ_form of
          form_char, form_lit, form_int:
            begin
              typ_min := typ_parent^.typ_min;
              typ_max := typ_parent^.typ_max;
              typ_unsigned := typ_parent^.typ_unsigned;
              typ_idelist := typ_parent^.typ_idelist
            end;

          form_range:
            begin { The values are keep in the lgt_ptr - ivn = 0 }
              SUBTYPE_SET_VALUE( typ_nvalue, ivn, ide_typ^.typ_nvalue );
              SUBTYPE_SET_VALUE( typ_high,   ivn, ide_typ^.typ_high   );
              SUBTYPE_SET_VALUE( typ_low,    ivn, ide_typ^.typ_low    )
            end;

          form_single,form_double: ;           { Nothing to do }

          form_private, form_organization, form_pointer: 
            typ_eltype  := typ_parent^.typ_eltype;

          form_set, form_lset:
            typ_seltype := typ_parent^.typ_seltype;

          form_array:
            begin
(*
with typ_parent^ do
begin
WRITELN( ' TYPE_PARM_SET Parent el_sz = ', typ_el_size:0, ', sz = ', typ_size );
LGT_WRITE_TREE( 8, typ_el_comp_size );
end;
*)
              typ_el_size := typ_parent^.typ_el_size;
              SUBTYPE_SET_VALUE( typ_el_comp_size, typ_el_size,
                                 ide_typ^.typ_el_comp_size );
              typ_aeltype := typ_parent^.typ_aeltype;
              typ_indtype := typ_parent^.typ_indtype
(*
;WRITELN( ' TYPE_PARM_SET Sub el_sz = ', typ_el_size:0, ', sz = ', typ_size );
LGT_WRITE_TREE( 8, typ_el_comp_size );
*)
            end;

          form_record:
            begin
              typ_firstfield := typ_parent^.typ_firstfield;
              typ_lastfield  := typ_parent^.typ_lastfield;
              if typ_parent^.typ_recvar <> nil then
                typ_recvar   := LGT_LINK( typ_parent^.typ_recvar )
              else
                typ_recvar := nil
            end;

        otherwise
          { Other Are Illegal }
          SRC_ERROR( mdnam, 998, e_severe )
        end
      end
    end;


    iq := ide_typ^.typ_parmlst;
    { Loop on all type parameter to reset to tpa_sub state }
    while iq <> nil do
    with iq^ do
    begin
      ide_tlink2 := nil;
      ide_tkind := tpa_sub;
      iq := ide_nxt
    end

  end;
  TYPE_PARM_SET := p1
end TYPE_PARM_SET;



[global]
procedure INIT_D_DYN(     ty:         typ_ptr;
                          trg:        lgt_ptr;
                      var lgth, lgtl: lgt_ptr;
                          bindir:     boolean;
                          ide:        ide_ptr := nil );
const
  mdnam = 'IDDY';


  procedure INIT_DYN_D(     ty:       typ_ptr;
                            trg:      lgt_ptr;
                        var lgh, lgl: lgt_ptr ); forward;



  procedure INIT_DYN_TAB(     ty:       typ_ptr;
                              trg:      lgt_ptr;
                          var lgh, lgl: lgt_ptr );
  const
    mdnam = 'IDYT';

  var
    ival: integer;
    lgti, lgtn, lgts, lgtv, lghh, lgll:   lgt_ptr;
    bscte: boolean;

  begin
    with ty^ do
    if (typ_indtype <> nil) and (typ_aeltype <> nil) then
    begin
      { Create the For Index Temporary Variable and init it to Zero }
      lgti := ALL_NEW_TMP( int_typ, ide );
(*    LGT_NEW( lgti, int_typ, lgt_varbl, nil );
      ALL_NEW( lgti^.lgt_alloc, int_typ, nil, var_tmp ); *)
      lgti^.lgt_nxt := LGT_NEW_ECONST( int_typ, 0 );
      lgtv := LGT_NEW_CODE( pcod_istore, lgti );

      { Append it in the external list }
      if lgh = nil then lgh := lgtv
                   else lgl^.lgt_nxt := lgtv;
      lgl := lgtv;

      { Link it the size of one array element (expression) }
      bscte := true;
      if typ_el_comp_size <> nil then
      begin
        lgts := LGT_TYPE_EVAL( typ_el_comp_size, nil );
        if (lgts^.lgt_kind <> lgt_const) and
           (lgts^.lgt_kind <> lgt_varbl) then
        begin { For expression object size we store it in a temporary }
          lgtv := ALL_NEW_TMP( int_typ, ide );
(*        LGT_NEW( lgtv, int_typ, lgt_varbl, nil );
          ALL_NEW( lgtv^.lgt_alloc, int_typ, nil, var_tmp ); *)
          lgtv^.lgt_nxt := lgts; lgts := LGT_LINK( lgtv );
          lgtv := LGT_NEW_CODE( pcod_istore, lgtv );
          { Append it in the external list }
          if lgh = nil then lgh := lgtv
                       else lgl^.lgt_nxt := lgtv;
          lgl := lgtv;
          bscte := false
        end
      end
      else lgts := LGT_NEW_ECONST( int_typ, typ_el_size );

      { Create the array reference node and link it the link to index }
      if bindir then
      begin
        LGT_NEW( lgtv, ty, lgt_indir, LGT_LINK( trg ) );
        lgtv^.lgt_disp := lgtv^.lgt_disp + typ_descr_size
      end
      else LGT_NEW_COPY( trg, lgtv );
      { Make Link : <array>, <index>, <element_size>, and Prepare the Index Increment }
      lgtn := LGT_LINK( lgti ); lgtn^.lgt_nxt := lgts; lgtv^.lgt_nxt := lgtn;

      { Create lgtv -> <index_op> ( <array>, <index>, <element_size> ) }
      with lgtv^ do lgt_status := lgt_status + [lgt_add];
      LGT_NEW( lgtv, typ_aeltype, lgt_index, lgtv );
      with typ_aeltype^, lgtv^ do
      begin
        lgt_typlnk := ty;                      { Set the array type }
        if (typ_form <> form_record) and (typ_form <> form_variant) then
          lgt_disp := lgt_disp + typ_descr_size;
        lgt_status := lgt_status + [lgt_add]
      end;
(*
WRITELN( ' INI_D_TAB 1 Index Node' );
LGT_WRITE_TREE( 8, lgtv );
WRITELN( ' INI_D_TAB 1 End' );
*)

      { Get the Number of element(s) of the array (expression) }
      if typ_indtype^.typ_form <> form_range then
      begin
        with typ_indtype^ do
          if typ_unsigned then ival := typ_umax - typ_umin + 1  { Fixed array index limits }
                          else ival := typ_max  - typ_min  + 1;
        lghh := LGT_NEW_ECONST( typ_indtype, ival ) 
      end
      else lghh := LGT_TYPE_EVAL( typ_indtype^.typ_nvalue, nil );       { Parametrized Array }

      lgll := lghh;
      INIT_DYN_D( typ_aeltype, lgtv, lghh, lgll );

      { Append the index increment to the list of statement in the for loop }
      lgll^.lgt_nxt := LGT_NEW_CODE( pcod_inc, LGT_LINK( lgti ) );
(*
WRITELN( ' INI_D_TAB 2 For Loop Body' );
LGT_WRITE_TREE( 8, lghh );
WRITELN( ' INI_D_TAB 2 End' );
*)

      { Create the For Loop Statement }
      LGT_NEW( lgtn, typ_std[form_int], lgt_ctlflow, lghh );
      lgtn^.lgt_stm := stm_for;

      { Put it in the more external list }
      if lgh = nil then lgh := lgtn
                   else lgl^.lgt_nxt := lgtn;
      lgl := lgtn;
    end
  end INIT_DYN_TAB;



  procedure INIT_DYN_REC(     ty:       typ_ptr;
                              trg:      lgt_ptr;
                          var lgh, lgl: lgt_ptr );
  { trg is the target reference of object,
    ty is its type, lgh, lgl the statement sequence header }
  const
    mdnam = 'IDRD';

  var
    lgtc, lgth, lgtl, lgtv, lgtw: lgt_ptr;
    ipf:                          ide_ptr;


    function DYN_REC_GSL( ty: typ_ptr; lgtw: lgt_ptr ): lgt_ptr;
    var
      lgh, lgl: lgt_ptr;

    begin
      lgh := nil;
      lgl := nil;
      INIT_DYN_REC( ty, trg, lgh, lgl );
      if lgh <> nil then
      begin
        if lgl <> lgh then
        begin
          LGT_NEW( lgh, nil, lgt_ctlflow, lgh );
          lgh^.lgt_stm := stm_sequence
        end
      end;
      DYN_REC_GSL := lgh
    end DYN_REC_GSL;



  begin { INIT_DYN_REC }
    with ty^ do
    begin
      ipf  := typ_firstfield;
      { Get the main part of the record }
      while ipf <> nil do
      with ipf^ do
      begin { Scan on all fields of the record }
        if ide_typ <> nil then
        with ide_typ^ do
        begin
          if (typ_parmlst <> nil) or typ_hasidsc then
          begin { When the field type is parametrized or as itself some sub-object with parametrized type  }
            { Create a reference node of this field }
            if bindir then LGT_NEW( lgtv, ide_typ, lgt_indir, LGT_LINK( trg ) )
                      else LGT_NEW_COPY( trg, lgtv );
            with lgtv^ do
            begin
              lgt_lide := ipf;
              { Set the exact offset }
              lgt_disp := lgt_disp + ide_offset;               {+ lgt_typ^.typ_descr_size,...
                                                               {... descriptor included in offset }
              { Add the descriptor size of field type eccept for record (descriptor included in the field list) }
              if (typ_form <> form_record) and (typ_form <> form_variant) then
                lgt_disp := lgt_disp + ide_typ^.typ_descr_size
            end;
            INIT_DYN_D( ide_typ, lgtv, lgh, lgl )              { Do for the Sub-Object  }
          end;
          if ipf = typ_lastfield then ipf := nil
                                 else ipf := ide_nxt
        end
      end;

      if (typ_recvar <> nil) and (typ_parmlst <> nil) then
      begin { We have some variants to manage }
        { Copy the case statement Node }
        LGT_NEW_COPY( typ_recvar, lgtc );
        { and append it to more external execution list }
        if lgh = nil then lgh := lgtc
                     else lgl^.lgt_nxt := lgtc;
        lgl := lgtc;
        lgtw := typ_recvar^.lgt_parmlst;

        { Copy the Case table Cte Node }
        LGT_NEW_COPY( lgtw, lgtv );
        lgtc^.lgt_parmlst := lgtv;
        lgtw := lgtw^.lgt_nxt;

        { Create the other case node statement }
        lgtc := DYN_REC_GSL( lgtw^.lgt_typ, lgtw );
        lgtv^.lgt_nxt := lgtc;
        lgtw := lgtw^.lgt_nxt;

        { Build the case selector expression }
        lgtv := LGT_TYPE_EVAL( lgtw, nil );
        lgtc^.lgt_nxt := lgtv;
        lgtw := lgtw^.lgt_nxt;
        while lgtw <> nil do
        begin
          lgtc := DYN_REC_GSL( lgtw^.lgt_typ, lgtw );
          lgtv^.lgt_nxt := lgtc;
          lgtv := lgtc; lgtw := lgtw^.lgt_nxt
        end
      end
    end
  end INIT_DYN_REC;



  function INIT_DYN_D {(     ty:       typ_ptr;
                             trg:      lgt_ptr;
                         var lgh, lgl: lgt_ptr ): lgt_ptr; was forward };
  { To generate all statements to init a parametrized variable }
  const
    mdnam = 'IDYN';

  var
    lgtt, lgtv: lgt_ptr;
    ipf:        ide_ptr;

  begin { INIT_DYN_D }
(*
WRITELN( ' INI_DYN 0' );
LGT_WRITE_TREE( 8, trg );
WRITELN;
LGT_WRITE_TREE( 8, lgh );
WRITELN( ' INI_DYN 0 end' );
*)
    bindir := false;    { Cancel the indirection mode for the internal part of the object }

    with ty^ do
    begin
      if typ_parmlst <> nil then
      begin { * Management of Type Parameters as front values in the Agregat * }
        ipf  := typ_parmlst;                                   { Prepare the loop on all type formal parameters }
        lgtt := typ_actual;                                    { ... and get the head of actual expression list }
        while (ipf <> nil) and (lgtt <> nil) do
        with ipf^ do
        begin                                                  { Loop on all actual parameters }
          { Get the target of the descriptor element pcod_istore }
          LGT_NEW_COPY( trg, lgtv );
          { Prepare the Type Formal Reference and set the Dynamic Link for the subsequent access }
          with lgtv^, ty^ do
          begin
            lgt_typ    := ide_typ;
            lgt_disp   := lgt_disp + ide_toffset;
            if (typ_form <> form_record) and (typ_form <> form_variant) then
              lgt_disp := lgt_disp - typ_descr_size;
            lgt_nxt    := LGT_TYPE_EVAL( lgtt, nil, ide_typ );
            ide_tlink2 := lgt_nxt
          end;
          ide_tkind := tpa_eval;
          { Build the istore lgt node }
          LGT_NEW( lgtv, ide_typ, lgt_codep, lgtv );
          lgtv^.lgt_pcode := pcod_istore;

          { Now put istore in the descriptor init list }
          if lgh = nil then lgh := lgtv
                       else lgl^.lgt_nxt := lgtv;
          lgl := lgtv;
          lgtt := lgtt^.lgt_nxt;                               { Continue to the next }
          ipf  := ide_nxt
        end
      end;

      
      if typ_hasidsc then
      case typ_form of
        form_variant, form_record:
          INIT_DYN_REC( ty, trg, lgh, lgl );

        form_conf, form_array:
          INIT_DYN_TAB( ty, trg, lgh, lgl );

      otherwise
        SRC_ERROR( mdnam, 131, e_severe )
      end;

      ipf := ty^.typ_parmlst;
      while ipf <> nil do
      with ipf^ do
      begin
        ide_tlink2 := nil;
        ide_tkind  := tpa_sub;
        ipf := ide_nxt
      end
    end
  end INIT_DYN_D;


begin { INIT_D_DYN }
  if ty^.typ_hasidsc then
  begin
    case ty^.typ_form of
      form_variant, form_record:
        INIT_DYN_REC( ty, trg, lgth, lgtl );

      form_conf, form_array:
        INIT_DYN_TAB( ty, trg, lgth, lgtl );

    otherwise
      SRC_ERROR( mdnam, 131, e_severe )
    end;

  end;
end INIT_D_DYN;



function INIT_D_STATIC( ty: typ_ptr; szw: integer := 0 ): val_ptr;
{ To generate any Agregat (Structured object value constructor) }
const
  mdnam = 'IDST';

var
  iad, dim_descr, size, i: integer;
  ipf:                     ide_ptr;
  lgtc, lgtt, lgth, lgtl:  lgt_ptr;
  pv, pvl, vph, vpl, vpc:  val_ptr;


procedure INIT_D_TAB( ty: typ_ptr; var iadr: integer );
const
  mdnam = 'IDTB';

var
  dim, els, min: integer;
  lgt:           lgt_ptr;
  vpm, vpn, vpe: val_ptr;

begin
  with ty^ do
  begin
    if typ_indtype <>  nil then
    with typ_indtype^ do
      if typ_form <> form_range then
        if typ_unsigned then                   { Fixed array index limits }
          dim := typ_umax - typ_umin + 1
        else
          dim := typ_max  - typ_min  + 1
      else
      begin { Parametrized Array }
        lgt := LGT_TYPE_EVAL( typ_nvalue, nil );
        if lgt^.lgt_kind = lgt_const then
        begin
          dim := lgt^.lgt_cte^.val_ival;
          LGT_FREE( lgt )
        end
        else SRC_ERROR( mdnam, 142, e_fatal );
      end
    else dim := 0;

    if typ_el_comp_size <> nil then
    begin
      lgt := LGT_TYPE_EVAL( typ_el_comp_size, nil );
      if lgt^.lgt_kind = lgt_const then
      begin { Get the array element size }
        els := lgt^.lgt_cte^.val_ival;
        LGT_FREE( lgt )
      end
      else SRC_ERROR( mdnam, 142, e_fatal )
    end
    else els := typ_el_size;

    if typ_aeltype = nil then dim := 0;

    vpm := INIT_D_STATIC( typ_aeltype, els );

    for ii := 1 to dim do
    begin { Generate the required copy of Value for each element }
      if ii = 1 then vpe := vpm
                else begin  vpe := nil; VAL_COPY( vpm, vpe, false )  end;
      if vph = nil then vph := vpe
                   else vpl^.val_next := vpe;
      vpl := vpe
    end;
    iadr := iadr + els*dim
  end
end INIT_D_TAB;



procedure INIT_D_REC( ty: typ_ptr; var iadr: integer );
const
  mdnam = 'IDRD';

var
  asiz, isel, imin, imax:           integer;
  lgtc, lgtab, lgtoth, lgtsel, lgt: lgt_ptr;
  ipf:                              ide_ptr;
  tab:                              tab_ptr;
  vpc:                              val_ptr;

begin
(* WRITELN( ' --> INIT_D_REC' ); *)
  with ty^ do
  begin
    ipf  := typ_firstfield;
    { Get the main part of the record }
    while ipf <> nil do
    with ipf^ do
    begin
      if ide_typ <> nil then
      with ide_typ^ do
      begin
        if (typ_parmlst <> nil) or typ_hasidsc then
        begin
          vpc := INIT_D_STATIC( ide_typ );     { Sub_Agregat }
          asiz := vpc^.val_size
        end
        else
        if typ_size > 0 then
        begin
          vpc := nil;
          VAL_NEW( vpc, typ_std[form_char] );
          with vpc^ do
          begin
            asiz := typ_size;
            val_kind := form_null;
            val_size := typ_size;
            val_ival := 0
          end
        end
        else asiz := 0;
        if asiz > 0 then
        begin
          iadr := iadr + asiz;
          if vph = nil then vph := vpc
                       else vpl^.val_next := vpc;
          vpl := vpc
        end;
        if ipf = typ_lastfield then ipf := nil
                               else ipf := ide_nxt
      end
    end;

    if (typ_recvar <> nil) and (typ_parmlst <> nil) then
    with typ_recvar^ do
    begin { We have some variants to manage }
      lgtab  := lgt_parmlst;                   { Get the case table lgt node }
      lgtoth := lgtab^.lgt_nxt;                { Get the other node }
      lgtsel := lgtoth^.lgt_nxt;               { Get the selector node }
      with lgtab^ do
      begin
        imin := lgt_disp;                      { Get the minimum value of the selector }
        if lgt_cte <> nil then
        with lgt_cte^ do
        begin
          { Get the number of table entry }
          imax := val_size + imin - 1;
          tab  := val_tab                      { Get the table address }
        end
        else tab := nil
      end;
      if typ_parmlst <> nil then               { Record with type_parameter(s) }
      begin
        lgtc := LGT_TYPE_EVAL( lgtsel, nil );
        with lgtc^ do
          if lgt_kind <> lgt_const then SRC_ERROR( mdnam, 142, e_severe )
          else
          if lgt_cte <> nil then isel := lgt_cte^.val_ival
                            else isel := imin - 1;
        LGT_FREE( lgtc )
      end;
      { Now isel is the selector value and the selector field id initialized }
      lgt := lgtsel^.lgt_nxt; { Assume the first variant }
      if (isel < imin) or (isel > imax) then { othercase }
        lgt := lgtoth
      else
      begin
        isel := ORD( tab^.lw[isel-imin] );
        if isel < 0 then lgt := lgtoth
        else
        begin
          while (isel > 0) and (lgt <> nil) do
          begin
            lgt := lgt^.lgt_nxt; isel := isel - 1
          end;
          if lgt = nil then lgt := lgtoth
        end
      end;
      if lgt <> nil then
        if lgt^.lgt_typ <> nil then INIT_D_REC( lgt^.lgt_typ, iadr )
    end
  end
(* ;WRITELN( ' <-- INIT_D_REC' ) *)
end INIT_D_REC;



begin { INIT_D_STATIC }
(* WRITELN( ' --> INIT_D_STATIC' ); *)
  with ty^ do
  begin
    iad  :=   0;
    vph  := nil;
    vpl  := nil;
    lgth := nil;
    lgtl := nil;
    size := typ_size;
    dim_descr := 0;                            { Initialize the Descriptor size (in elem.) }

    if typ_parmlst <> nil then
    begin { * Management of Type Parameters as front values in the Agregat * }
      ipf  := typ_parmlst;                     { Prepare the loop on all type formal parameters }
      lgtt := typ_actual;                      { ... and get the head of actual expression list }
      while (ipf <> nil) and (lgtt <> nil) do
      with ipf^ do
      begin                                    { Loop on all actual parameters }
        lgtc := LGT_TYPE_EVAL( lgtt, nil, ide_typ );
        lgtc^.lgt_disp := ide_toffset;
        if lgth = nil then lgth := lgtc
                      else lgtl^.lgt_nxt := lgtc;
        lgtl := lgtc;
        vpc := lgtc^.lgt_cte;
        VAL_NEW( vpc, ide_typ );
        vpc^.val_typ := ide_typ;               { Force the (formal) parameter type }
        vpc^.val_size := ide_typ^.typ_size;
        if vph = nil then vph := vpc
                     else vpl^.val_next := vpc;
        vpl := vpc;
        { Set the dynamic link for the type parameter identifier(s) }
        ide_tlink2 := lgtc;
        ide_tkind  := tpa_eval;
        lgtt := lgtt^.lgt_nxt;                 { Continue to the next }
        ipf  := ide_nxt;
        if ide_typ <> nil then iad := iad + ide_typ^.typ_size;
        dim_descr := dim_descr + 1             { Update the Descriptor Element Count }
      end
    end;

    { Now we compute the object size }
    if (typ_parmlst <> nil) and (typ_comp_size <> nil) then
    begin
      lgtt := LGT_TYPE_EVAL( typ_comp_size, nil );
      if lgtt^.lgt_kind = lgt_const then
      begin { Get the size in bytes and free the lgt record }
        size := lgtt^.lgt_cte^.val_ival;
        LGT_FREE( lgtt )
      end else SRC_ERROR( mdnam, 147, e_fatal )
    end;

    if szw > size then size := szw;            { The required size is prioritary }

    if typ_hasidsc then
    case typ_form of
      form_variant, form_record:
        INIT_D_REC( ty, iad );

      form_conf, form_array:
        INIT_D_TAB( ty, iad );

    otherwise
      SRC_ERROR( mdnam, 131, e_severe )
    end;

    { Unlink the descriptor identifiers }
    if typ_parmlst <> nil then
    begin
      { Loop on all type parameter to reset to tpa_sub state }
      ipf := typ_parmlst;
      while ipf <> nil do
      begin
        ipf^.ide_tkind := tpa_sub;
        ipf^.ide_tlink2 := nil;
        ipf := ipf^.ide_nxt
      end
    end;
    LGT_FREE_TREE( lgth );

    { Complete the data by the Pad Bytes when required }
    if size > iad then
    begin
      vpc := nil;
      VAL_NEW( vpc, nil );
      if vph = nil then vph := vpc
                   else vpl^.val_next := vpc;
      vpl := vpc;
      with vpc^ do
      begin
        val_kind := form_null;
        val_typ  := typ_std[form_char];        { Without type alignement }
        val_ival := 0;
        val_size := size - iad
      end
    end;
(*
{ Output for Debugging }
vpc := vph;
i := 0;
while vpc <> nil do
with vpc^ do
begin
  i := i + 1;
  WRITE( ' INI_D ', i:0, ' ', val_kind );
  case val_kind of
    form_char, form_int, form_lit:
      WRITE( ' sz=', val_size:0, ' v=', val_ival );
  otherwise
  end;
  WRITELN;
  vpc := val_next
end;
*)

    { Now we Generate the Agregate val_rec List }
    vpc := nil;
    VAL_NEW( vpc, ty );
    with vpc^ do
    begin { This value record used the PAD Filling by the code generator module }
      val_descr := typ_descr_size;
      val_size  := size;
      val_lst   := vph;
      val_descr := dim_descr
    end
  end;
(*
with vpc^ do
WRITELN( ' <-- INIT_D_STATIC( ', val_kind, ', dd=', val_descr:0, ', sz=', val_size:0, ')' );
*)
  INIT_D_STATIC := vpc
end INIT_D_STATIC;




[global]
procedure INIT_D_VARBL( ip: ide_ptr );
{ Init a type-parametrized variable before first use }
{ We must manage the following case :
    1/ The variable types without parameter but including type(s) with parameter list as :
         example: type fixtst = array[1..10] of string( 20 ); var tst1: fixtst;
       Caracteristics:  typ_hasidsc = true, typ_fdescr_size = 0 with a typ_parent that can be nil.


    2/ The variable types with parameter but without including type(s) with parameter list as :
         example: type svrtst(d: integer) = array[1..d] of real; var tst3: svrtst( 30 );
       Caracteristics:  typ_hasidsc = false, typ_fdescr_size > 0 with typ_parent <> nil. 

    3/ The variable types with parameter including type(s) with parameter list as :
         example: type lvrtst1(d: integer) = array[1..d] of string( 20 ); var tst3: lvrtst1( 8 );
         example: type lvrtst2(d, cap: integer) = array[1..d] of string( cap ); var tst3: lvrtst2( 6, 32 );
       Caracteristics:  typ_hasidsc = true, typ_fdescr_size > 0 with typ_parent <> nil.

}
var
  lg, lgv, lgc, lgh, lgl: lgt_ptr;
  iq, iqc:                ide_ptr;
  ty:                     typ_ptr;

begin { INIT_D_VARBL }
  ty := ip^.ide_typ;                           { Get the type of variable }

  if not ty^.typ_subtype and (ty^.typ_attsub <> nil) then ty := ty^.typ_attsub;

  with ip^, ty^, ide_owner^ do
  begin { Parameter initialization }
    ide_vacc := ide_vacc + [var_inited];
    if ((ide_vkind = var_result) or            { For Large Function return or }
        (ide_vkind = var_decl)) and            { ... automatic variable }
        (ide_lex > 1) then                     { ... of a local procedure/function }
    begin
      if typ_parent <> nil then iq := typ_parent^.typ_parmlst
                           else iq := typ_parmlst;
      lgh := nil;
      lgl := nil;
      lg  := typ_actual;
      iqc := iq;
      { Loop on formal parameter to set it in the descriptor }
      while lg <> nil do
      begin
        { Create a descriptor parameter reference }
        LGT_NEW( lgv, iq^.ide_typ, lgt_varbl, nil );
        with lgv^, iqc^ do
        begin
          lgt_ide    := ip; lgt_alloc := nil;
          lgt_disp   := ide_toffset;
          ide_tlink2 := lgv;
          ide_tkind  := tpa_eval
        end;
        { Create value cte. ref. }
        LGT_NEW_COPY( lg, lgc ); lgv^.lgt_nxt := lgc;
        { Skip to next parameter and actual }
        lg := lg^.lgt_nxt;
        iqc := iqc^.ide_nxt;
        lgc := LGT_NEW_CODE( pcod_istore, lgv );       { Create the load node }
        if lgh = nil then lgh := lgc
                     else lgl^.lgt_nxt := lgc;
        lgl := lgc
      end;
      { *** This following part must set the internal descriptors when typ_hasidsc = true *** }
      if typ_hasidsc then
      begin
        lgv := LGT_NEW_IDREF( ip, nil );       { Generate a variable reference }
        INIT_D_DYN( ty, lgv, lgh, lgl, false, ip );
        LGT_FREE( lgv )
      end;
      { Link to init node list of the owner procedure/function }
      if lgh <> nil then
        case pro_pkind of
          pro_main, pro_package, pro_forward, pro_decl, pro_inline, pro_global:
            begin
              if pro_init_hde = nil then pro_init_hde := lgh
                                    else pro_lst^.lgt_nxt := lgh;
              pro_lst := lgl
            end;
        otherwise
        end;
      while iq <> nil do
      with iq^ do
      begin
        ide_tlink2 := nil;
        ide_tkind  := tpa_sub;
        iq := ide_nxt
      end
    end
    else
    begin { For static or global variable }
      if ide_inival = nil then
      begin
        ide_vacc := ide_vacc + [var_initialized];      { Set as initialized }
        ide_inival := INIT_D_STATIC( ty )
      end
      { else the initialization is implicite (done by INITIALIZE_VARBL) }
    end
  end
end INIT_D_VARBL;



[global]
function EXP_VAL_UNA( puna: lgt_ptr; p: gen_ptr ): lgt_ptr;
const
  mdnam = 'ECUN';

var
  r:   double;
  lgt: lgt_ptr;

begin
  with p^ do
  begin
    { At begin do the conversion }
    if gen_pc_cv1 <> nil then puna := EXP_VAL_UNA( puna, gen_pc_cv1 );
    with puna^ do
    if lgt_kind = lgt_const then
    with lgt_cte^ do
    begin
      lgt_status := [lgt_in];
      case gen_pcode of
        pcod_not:    val_ival := ORD( val_ival <= 0 );

        pcod_succ:   val_ival := val_ival + 1;

        pcod_pred:   val_ival := val_ival - 1;

        pcod_iodd:   val_ival := ORD( ODD( val_ival ) );

        pcod_com:    if (val_kind = form_set) or (val_kind = form_wset) then
                       if val_set.siv >= 0
                       then val_set.siv := -1 - val_set.siv
                       else val_set.siv := -(1 + val_set.siv);

        pcod_ineg:   val_ival := - val_ival;
        pcod_fneg,
        pcod_gneg:   val_rval := - val_rval;

        pcod_iabs:   val_ival := ABS( val_ival );
        pcod_fabs,
        pcod_gabs:   val_rval := ABS( val_rval );

        pcod_isqr:   val_ival := SQR( val_ival );
        pcod_fsqr,
        pcod_gsqr:   val_rval := SQR( val_rval );

        pcod_cvif,
        pcod_cvig:   val_rval := val_ival;
        pcod_cvfi,
        pcod_cvgi:   val_ival := ROUND( val_rval );
        pcod_ftrunc,
        pcod_gtrunc:  val_ival := TRUNC( val_rval );

        pcod_sqrt,
        pcod_gsqrt: if val_rval < 0.0 then SRC_ERROR( mdnam, 801, e_error )
                                      else val_rval := SQRT(val_rval);

        pcod_sin,
        pcod_gsin:  val_rval := SIN( val_rval );
        pcod_cos,
        pcod_gcos:  val_rval := COS( val_rval );
        pcod_tan,
        pcod_gtan:  val_rval := TAN( val_rval );

        pcod_asin,
        pcod_gasin:
            if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 802, e_error )
                                     else val_rval := ARCSIN( val_rval );
        pcod_acos,
        pcod_gacos:
            if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 803, e_error )
                                     else val_rval := ARCCOS( val_rval );
        pcod_atan,
        pcod_gatan:  val_rval := ARCTAN( val_rval );

        pcod_sinh,
        pcod_gsinh: val_rval := SINH( val_rval );
        pcod_cosh,
        pcod_gcosh: val_rval := COSH( val_rval );
        pcod_tanh,
        pcod_gtanh: val_rval := TANH( val_rval );

        pcod_asinh,
        pcod_gasinh: val_rval := ARGSINH( val_rval );
        pcod_acosh,
        pcod_gacosh:
            if val_rval < 1.0 then SRC_ERROR( mdnam, 805, e_error )
                              else val_rval := ARGCOSH( val_rval );
        pcod_atanh,
        pcod_gatanh:
            if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 806, e_error )
                                     else val_rval := ARGTANH( val_rval );

        pcod_exp,
        pcod_gexp: val_rval := EXP( val_rval );
        pcod_log,
        pcod_glog:
            if val_rval <= 0.0 then SRC_ERROR( mdnam, 804, e_error ) else
              val_rval := LN(val_rval);
      otherwise { no op in compile time }
        { no operation }
      end;
      lgt_lide := nil;                         { Delete all previous link to a const identifier }
      { update the type }
      if (gen_result = typ_std[form_equv]) or
         (gen_result = typ_std[form_eqst]) then lgt_typ := puna^.lgt_typ
                                           else lgt_typ := gen_result;
      val_typ  := lgt_typ;
      val_kind := lgt_typ^.typ_form
    end
    else                                       { Not a constante }
    begin
      if not (lgt_in in puna^.lgt_status) then SRC_ERROR( mdnam, 851, e_error );
      if (gen_pcode <> pcod_noop) or
         (puna^.lgt_typ^.typ_size <> gen_result^.typ_size) then
      begin { Create an unary node to link with present object }
        LGT_NEW( lgt, gen_result, lgt_codep, puna );
        with lgt^ do
        begin
          if (lgt_typ = typ_std[form_equv]) or
             (lgt_typ = typ_std[form_eqst]) then lgt_typ := puna^.lgt_typ;

          lgt_nxt := puna^.lgt_nxt;            { Copy the old next link }
          lgt_pcode := gen_pcode;
          lgt_status := puna^.lgt_status - [lgt_out]
        end;
        lgt_nxt := nil;                        { Clear the old next link }
        puna := lgt
      end
      else puna^.lgt_typ := gen_result         { Set the new type }
    end
  end;
  EXP_VAL_UNA := puna
end EXP_VAL_UNA;



[global]
function EXP_VAL_BIN( ob1: lgt_ptr; p: gen_ptr ): lgt_ptr;
const
  mdnam = 'EXPB';

type
  wenm = 0..max_setw - 1;

var
  iby:        wenm;
  ic, jc:     integer;
  rc:         double;
  ob2:        lgt_ptr;
  nod_create: boolean;

begin 
  ob2 := ob1^.lgt_nxt;
  with p^ do
  begin
    { At begin do the conversions }
    if gen_pc_cv1 <> nil then ob1 := EXP_VAL_UNA( ob1, gen_pc_cv1 );
    if gen_pc_cv2 <> nil then ob2 := EXP_VAL_UNA( ob2, gen_pc_cv2 );
    ob1^.lgt_nxt := ob2;                       { Set the new link }
    if (ob1^.lgt_kind = lgt_const) and
       (ob2^.lgt_kind = lgt_const) then
    begin
      with ob1^.lgt_cte^, ob2^ do
      case gen_pcode of
        pcod_ipow: val_ival := val_ival ** lgt_cte^.val_ival;
        pcod_fpow,
        pcod_gpow: val_rval := val_rval ** lgt_cte^.val_rval;
        pcod_fipw,
        pcod_gipw: val_rval := val_rval ** lgt_cte^.val_ival;

        pcod_iadd: val_ival := val_ival + lgt_cte^.val_ival;
        pcod_isub: val_ival := val_ival - lgt_cte^.val_ival;
        pcod_imul: val_ival := val_ival * lgt_cte^.val_ival;
        pcod_idiv: val_ival := val_ival div lgt_cte^.val_ival;
        pcod_imod: val_ival := val_ival mod lgt_cte^.val_ival;
        pcod_irem: val_ival := val_ival rem lgt_cte^.val_ival;

        pcod_fadd,
        pcod_gadd: val_rval := val_rval + lgt_cte^.val_rval;
        pcod_fsub,
        pcod_gsub: val_rval := val_rval - lgt_cte^.val_rval;
        pcod_fmul,
        pcod_gmul: val_rval := val_rval * lgt_cte^.val_rval;
        pcod_fdiv,
        pcod_gdiv: val_rval := val_rval / lgt_cte^.val_rval;

        pcod_and:  val_ival := ORD((val_ival > 0) and (lgt_cte^.val_ival > 0));
        pcod_or:   val_ival := ORD((val_ival > 0) or  (lgt_cte^.val_ival > 0));
        pcod_xor:  val_ival := ORD((val_ival > 0) <>  (lgt_cte^.val_ival > 0));

        { Set Operators }
        pcod_band: val_set.ssv := val_set.ssv * lgt_cte^.val_set.ssv;
        pcod_bxor: val_set.ssv := (val_set.ssv + lgt_cte^.val_set.ssv)
                                 -(val_set.ssv * lgt_cte^.val_set.ssv);
        pcod_bic:  val_set.ssv := val_set.ssv - lgt_cte^.val_set.ssv;
        pcod_bis:  val_set.ssv := val_set.ssv + lgt_cte^.val_set.ssv;
        pcod_bit:  val_ival := ORD((val_set.ssv * lgt_cte^.val_set.ssv)<>[]);

        pcod_setgen:                           { Never called here };
        pcod_lsetgen:                          { Never called here };
        pcod_lsetaddel:                        { Never called here };

        pcod_setlt, pcod_setle, pcod_setge,
        pcod_setgt, pcod_seteq, pcod_setne:
          begin
            case gen_pcode of
              pcod_setlt,
              pcod_setle: ic := ORD( val_set.ssv <= lgt_cte^.val_set.ssv );
              pcod_setge,
              pcod_setgt: ic := ORD( val_set.ssv >= lgt_cte^.val_set.ssv );
              pcod_seteq: ic := ORD( val_set.ssv <> lgt_cte^.val_set.ssv );
              pcod_setne: ic := ORD( val_set.ssv =  lgt_cte^.val_set.ssv );
            otherwise
            end;
            val_kind := form_lit;
            val_size := 0;
            val_ival := ic
          end;

        pcod_inset: ic := ORD( val_ival in lgt_cte^.val_set.ssv );

        pcod_ult, pcod_ule, pcod_uge, pcod_ugt, pcod_ne, pcod_eq,
        pcod_ilt, pcod_ile, pcod_ige, pcod_igt:
          begin { Unsigned and Signed are same (does not it ?) }
            ic := val_ival - lgt_cte^.val_ival;
            case gen_pcode of
              pcod_ult, pcod_ilt: val_ival := ORD( ic < 0 );
              pcod_ule, pcod_ile: val_ival := ORD( ic <= 0 );
              pcod_uge, pcod_ige: val_ival := ORD( ic >= 0 );
              pcod_ugt, pcod_igt: val_ival := ORD( ic > 0 );
                        pcod_ne:  val_ival := ORD( ic <> 0 );
                        pcod_eq:  val_ival := ORD( ic = 0 )
            end
          end;
        pcod_flt, pcod_fle, pcod_fge, pcod_fgt, pcod_fne, pcod_feq,
        pcod_glt, pcod_gle, pcod_gge, pcod_ggt, pcod_gne, pcod_geq:
          begin
            rc := val_rval - lgt_cte^.val_rval;
            case gen_pcode of
              pcod_flt, pcod_glt: val_ival := ORD( rc < 0 );
              pcod_fle, pcod_gle: val_ival := ORD( rc <= 0 );
              pcod_fge, pcod_gge: val_ival := ORD( rc >= 0 );
              pcod_fgt, pcod_ggt: val_ival := ORD( rc > 0 );
              pcod_fne, pcod_gne: val_ival := ORD( rc <> 0 );
              pcod_feq, pcod_geq: val_ival := ORD( rc = 0 )
            end
          end;

        pcod__ne, pcod__eq:
          begin
            { /// block compare }
          end; 

        pcod_gphas,
        pcod_phas:  val_rval := ARCTAN( val_rval, lgt_cte^.val_rval )

      otherwise
      end;
      with ob1^, lgt_cte^ do
      begin { Set the result type }
        lgt_lide := nil;                       { Delete all previous link to a const identifier }
        { Update the type }
        if (gen_result = typ_std[form_equv]) or
           (gen_result = typ_std[form_eqst]) then lgt_typ := ob1^.lgt_typ
                                             else lgt_typ := gen_result;
        val_typ  := lgt_typ;
        val_kind := lgt_typ^.typ_form
      end;
      ob1^.lgt_nxt := nil;                     { Supress the parameter link }
      LGT_FREE( ob2 )                          { Free the old second const node }
    end
    else
    begin { The two operands are not constant }
      nod_create := true;                      { Assume node create until showed otherwise }
      case gen_pcode of
        pcod_inset:
          if ob1^.lgt_kind = lgt_const then
          begin
            with ob1^ do
            begin
              iby := lgt_cte^.val_ival;
              lgt_typ := ob2^.lgt_typ;
              VAL_FREE( lgt_cte );
              VAL_NEW( lgt_cte, lgt_typ );
              with lgt_cte^ do
              begin
                val_size := (iby + 7) div 8;
                val_set.ssv := [iby] 
              end
            end;
            LGT_NEW( ob2, gen_result, lgt_codep, ob1 );
            with ob2^ do
            begin
              lgt_status := [lgt_in];
              lgt_pcode :=  pcod_bit
            end;
            nod_create := false
          end;

        pcod_and:
          if ob1^.lgt_kind = lgt_const then
          with ob1^ do
          begin { "<cte> and <exp>" }
            ob1^.lgt_nxt := nil;
            nod_create := false;
            if lgt_cte^.val_ival <= 0 then
            begin { "false and <exp>" => false }
              LGT_FREE_TREE( ob2 );
              ob2 := ob1
            end
            else
              LGT_FREE( ob1 )                  { "true and <exp>" => <exp> }
          end
          else
            if ob2^.lgt_kind = lgt_const then
            with ob2^ do
            begin { "<exp> and <cte>" }
              ob1^.lgt_nxt := nil;
              nod_create := false;
              if lgt_cte^.val_ival <= 0 then
                LGT_FREE_TREE( ob1 )           { "<exp> and false" => false }
              else
              begin { "<exp> and true" => <exp> }
                LGT_FREE( ob2 );
                ob2 := ob1
              end
            end;

        pcod_or:
          if ob1^.lgt_kind = lgt_const then
          with ob1^ do
          begin { "<cte> or <exp>" }
            ob1^.lgt_nxt := nil;
            nod_create := false;
            if lgt_cte^.val_ival > 0 then
            begin { "true or <exp>" => true }
              LGT_FREE_TREE( ob2 );
              ob2 := ob1
            end
            else
              LGT_FREE( ob1 )                  { "false or <exp>" => <exp> }
          end
          else
            if ob2^.lgt_kind = lgt_const then
            with ob2^ do
            begin { "<exp> or <cte>" }
              ob1^.lgt_nxt := nil;
              nod_create := false;
              if lgt_cte^.val_ival > 0 then
                LGT_FREE_TREE( ob1 )           { "<exp> or true" => true }
              else
              begin { "<exp> or false" => <exp> }
                LGT_FREE( ob2 );
                ob2 := ob1
              end
            end;

        pcod_istore, pcod_fstore, pcod_gstore, pcod_store:
          begin
            with ob1^ do
            begin
              lgt_status := lgt_status + [lgt_wrt];
              if not (lgt_out in lgt_status) then SRC_ERROR( mdnam, 852, e_error )
            end;
            with ob2^ do
            begin
              if not (lgt_in in lgt_status) then
                SRC_ERROR( mdnam, 851, e_warning);
              if (gen_pcode <> pcod_store) and
                 (lgt_kind = lgt_call) and                     { Call of ... }
                 (lgt_typ <> nil) then                         { ... a function }
                with lgt_pro^ do
                if pro_parmlst <> nil then
                  if pro_parmlst^.ide_vkind = var_result then
                  begin { * We can supress any temporary location for result }
                    ob1^.lgt_nxt := lgt_parmlst^.lgt_nxt;      { Set link to true parm }
                    LGT_FREE( lgt_parmlst );                   { Free this node }
                    lgt_status := lgt_status + [lgt_cas];
                    lgt_parmlst := ob1                         { ob1 is the new result target };
                    nod_create := false
                  end
            end
          end
      otherwise
        if not ((lgt_in in ob1^.lgt_status) and (lgt_in in ob2^.lgt_status))
          then SRC_ERROR( mdnam, 851, e_warning )
      end;
      if nod_create then
      begin
        LGT_NEW( ob2, gen_result, lgt_codep, ob1 );
        with ob2^ do
        begin
          if (lgt_typ = typ_std[form_equv]) or
             (lgt_typ = typ_std[form_eqst]) then lgt_typ := ob1^.lgt_typ;
          lgt_status := [lgt_in];
          lgt_pcode :=  gen_pcode
        end
      end;
      ob1 := ob2
    end
  end;
  EXP_VAL_BIN := ob1
end EXP_VAL_BIN;




[global]
function  LOOK_FOR_DESCRIPTOR( lgt: lgt_ptr; ty: typ_ptr ): lgt_ptr;
{ Used to Find the descriptor where the ty (a form_range) is defined.
  The search start from the node lst.
}
var
  lgr: lgt_ptr;

begin
  lgr := lgt;
  while (lgr <> nil) and (lgr^.lgt_typ <> nil) do
    with lgr^, lgt_typ^ do
    begin
  exit if (typ_descr_size > 0);
      if (lgt_kind = lgt_offset) or
         (lgt_kind = lgt_index)  or
         (lgt_kind = lgt_refer)  or
         (lgt_kind = lgt_null)   then lgr := lgt_parmlst
                                 else lgr := nil;
    end;
    if lgr = nil then lgr := lgt;
(*
WRITELN( lst_current^.lst_file, ' Find Descr stop of kind ', lgr^.lgt_kind, ', disp = ', lgr^.lgt_disp );
if lgr^.lgt_typ <> nil then
WRITELN( lst_current^.lst_file, ' type form is ', lgr^.lgt_typ^.typ_form );
*)
  LOOK_FOR_DESCRIPTOR := lgr
end LOOK_FOR_DESCRIPTOR;



[global]
procedure CALL_SETTING( var lgt: lgt_ptr );
{ To verify the IN OUT setting of each parameter and select the
  default value for the ungiven parm. }
{ this procedure can be change the LoGical Tree configuration }
const
  mdnam = 'CALL';
var
  b_def, b_sa, b_ch:                   boolean;
  ch:                                     char;
  pr:                                  pro_ptr;
  pf:                                  ide_ptr;
  pe, pre, lgi, lgj, lgc, objb, descr: lgt_ptr;
  et, ft, it, iti, rty:                typ_ptr;

begin
  b_def := false;
  pr    :=   nil;
  if lgt <> nil then                                    { Existing node }
  with lgt^ do
  begin
    if lgt_pro <> nil then  pr := lgt_pro;              { Existing procedure }
    pe := lgt_parmlst;                                  { Get the first effective parameter pointer }
    if lgt_kind = lgt_icall then pe := pe^.lgt_nxt      { for indirect call, skip the entry expression }
  end;

  if pr <> nil then
  with pr^ do
  begin
    pre := nil;                                         { No return TMP variable }
    rty := nil;                                         { Equivalent type pointer init }
    pf := pro_parmlst;                                  { Get the first formal parameter pointer }
    if pro_typ <> nil then                              { For a function, we create the return value identifier }
    with pro_typ^ do
      if not typ_simple then
      begin { Note: the simple types are only the following:
              form_wlit,    form_ennum,   form_nil,     form_eqse,
              form_char,    form_lit,     form_int,     form_single,  form_double,
              form_set,     form_wset,    form_wwset,   form_pointer, form_range,
              form_file,    form_wfile,   form_fpro. }
        { Temporary return function var_result }
        { Set by procdecl/parmlist }
        pre := LGT_NEW_IDREF( wildtmp_ide, pe );        { Create an identifier to keep the returned value }
        pre^.lgt_typ  := pro_typ;                       { Set the return type }
        pre^.lgt_lide := pro_geneide;                   { Set the related ide (as rec. field) }
        lgt^.lgt_parmlst := pre;
        pf := pf^.ide_nxt                               { Skip to true formal parameter }
      end;

    while pf <> nil do { * Loop on all formal parameters }
    begin
      ft   :=   nil;                                    { Assume that it is not a conformant model }
      b_sa := false;
      b_ch := false;
      objb :=    pe;                                    { Set head of effective argument object base }
      with pf^ do
      begin
        if pe <> nil then                               { If effective parameter list is not finished }
        begin
          if pe^.lgt_kind = lgt_empty then b_def := true
          else
          begin                                         { Effective parameter is present }
            if ide_typ <> nil then
            begin
              with ide_typ^ do                          { With the effective parameter type }
              case typ_form { Form of formal type } of
                form_record: { * Effective is a character and formal is a string }
                  if COMP_TYPE( ide_typ, typ_std[form_record], false ) and
                     COMP_TYPE( pe^.lgt_typ, typ_std[form_char], true ) then
                    if pe^.lgt_kind = lgt_const then
                    begin                               { Change the Cte char to a Cte string }
                      ch := CHR( pe^.lgt_cte^.val_ival );
                      VAL_FREE( pe^.lgt_cte );
                      VAL_NEW( pe^.lgt_cte, typ_std[form_record] );
                      pe^.lgt_typ := typ_std[form_record];
                      with pe^.lgt_cte^ do
                      begin
                        val_kind := form_string;
                        val_size := 1;
                        NEW( val_str, 1);
                        val_str^ := ch
                      end
                    end
                    else
                    begin                               { Generate a conversion from character to string }
                      lgc := pe^.lgt_nxt; pe^.lgt_nxt := nil;
                      pe := GENERATE_CALL( gen_std_string1, pe,, true );
                      pe^.lgt_nxt := lgc;
                      pe^.lgt_status := [lgt_add,lgt_in];
                      if pre = nil then lgt^.lgt_parmlst := pe
                                   else pre^.lgt_nxt := pe
                    end;

                form_array,
                form_conf:
                  begin  { * Formal is an array or a conformant array }
                    if COMP_TYPE( pe^.lgt_typ, typ_std[form_record], false ) then
                    { The effective parameter is a string }
                    begin                               { Pass the <string>.body as the effective parameter }
                      b_sa := true;
                      lgc := pe^.lgt_nxt; pe^.lgt_nxt := nil;
                      LGT_NEW( pe, typ_std[form_record]^.typ_lastfield^.ide_typ, lgt_offset, pe );
                      if pre = nil then lgt^.lgt_parmlst := pe
                                   else pre^.lgt_nxt := pe;
                      pe^.lgt_disp := typ_std[form_record]^.typ_lastfield^.ide_offset;
                      pe^.lgt_nxt  := lgc
                    end
                    else
                    if COMP_TYPE( pe^.lgt_typ, typ_std[form_char], false ) then
                    begin  b_sa := true; b_ch := true  end;
                    if typ_form = form_conf then ft  := ide_typ                      { Keep the conformant schema typ_rec }
                  end;

                form_nil,    form_wlit,   form_ennum,
                form_wset,   form_wlset,  form_wwset,
                form_wrecord,form_wild,   form_equv:
                  begin { * For a wild type equivalence keep type pointer }
                    if rty = nil then rty := pe^.lgt_typ
                    else                                { Update when no same category }
                      if (rty^.typ_simple and not pe^.lgt_typ^.typ_simple) or
                         (rty^.typ_size < pe^.lgt_typ^.typ_size) then rty := pe^.lgt_typ
                  end;

              otherwise
              end;

              { Now we check the access right }
              case ide_vkind of
                var_formal: { * By Reference }
                  begin { For copy in a memory for register/immediat value }
                    if not (lgt_add in pe^.lgt_status) then
                    begin
                      with pe^ do { * Flag the possible write/modification of value }
                        if var_out in ide_vacc then lgt_status := lgt_status + [lgt_wrt];
                      lgc := pe^.lgt_nxt; pe^.lgt_nxt := nil;
                      LGT_NEW( pe, pe^.lgt_typ, lgt_refer, pe );
                      pe^.lgt_nxt := lgc;               { Rebuilt the normal param link }
                      { ... and link to previous are call node }
                      if pre = nil then lgt^.lgt_parmlst := pe
                                   else pre^.lgt_nxt := pe
                    end
                  end;

                var_refer: { * By access reference (address is keep as the effective parm. }
                  begin
                    lgc := pe^.lgt_nxt; pe^.lgt_nxt := nil;
                    LGT_NEW( pe, pe^.lgt_typ, lgt_refer, pe );
                    pe^.lgt_status := pe^.lgt_status + [lgt_add];
                    pe^.lgt_nxt := lgc;                 { Rebuilt the normal parm. link }
                    { ... and link to previous are call node }
                    if pre = nil then lgt^.lgt_parmlst := pe
                                 else pre^.lgt_nxt := pe
                  end;

              otherwise
              end;
              b_def := false
            end
          end
        end
        else
        begin { No lgt node }
          LGT_NEW( pe, ide_typ, lgt_const, nil );
          { Link the added default parameter }
          if pre = nil then lgt^.lgt_parmlst := pe
                       else pre^.lgt_nxt := pe;
          b_def := true
        end;

        if b_def then                                   { The default parameter must be specified }
          if var_optional in ide_vacc then
          with pe^ do
          begin
            lgt_kind := lgt_empty;
            lgt_typ  := ide_typ;
            lgt_lide := nil
          end
          else
          if ide_inival <> nil then
          with pe^ do
          begin                                         { Set the default parameter value }
            lgt_kind := lgt_const;
            lgt_typ  := ide_typ;
            lgt_cte  := ide_inival;                     { Set the default value }
            VAL_NEW( lgt_cte, ide_typ );
            lgt_lide := nil
          end
          else SRC_ERROR_S( mdnam, 854, e_error, ide_name^ );   { Default value was not specified }

        pre := pe
      end;

      if ft <> nil then
      if ft^.typ_indtype <> nil then                    { For a defined index type }
      with ft^.typ_indtype^ do
      if (typ_low <> nil) and (typ_high <> nil) then    { For legal conformant type only }
      begin                                             { Get the conformant array bounds as extra parameters }
        with objb^ do
          if lgt_kind = lgt_call then lgt_status := lgt_status + [lgt_car];

        iti := ft^.typ_indtype;                         { Get the formal index type }
        lgi := nil; lgj := nil;                         { Set the special effective argument list to empty }

        if b_sa then                                    { String given as an array of char (it is a special case) }
        begin
(*   ?????????? *)
          repeat
            if iti^.typ_parent <> nil then iti := iti^.typ_parent
          until (iti^.typ_parent = nil) or (iti^.typ_form <> form_range);

          if b_ch then
          begin { Form single char 'c' in a packed array[...] of char }
            lgi := LGT_NEW_ECONST( iti, 1 );
            pf := pf^.ide_nxt;                          { Skip special formal in the list }
            if typ_low^.lgt_kind <> lgt_const then      { Two parameters conformant model }
            begin
              lgj := LGT_NEW_ECONST( iti, 1 ); lgi^.lgt_nxt := lgj;
              pf := pf^.ide_nxt;                        { Skip special formal in the list }
            end
            else lgj := lgi                             { One parameter conformant model }
          end
          else
          begin { Form string as a packed array[...] of char }
            if typ_low^.lgt_kind <> lgt_const then
            begin { Two parameters conformant model }
              lgi := LGT_NEW_ECONST( iti, 1 );          { Low index bound is always 1 }
              lgj := lgi;
              pf := pf^.ide_nxt;                        { Skip special formal in the list }
            end;
            if objb^.lgt_kind = lgt_const then
              lgc := LGT_NEW_ECONST( iti, objb^.lgt_cte^.val_size )
            else
            begin
              LGT_NEW( lgc, typ_std[form_record]^.typ_parmlst^.ide_typ, lgt_offset, LGT_LINK( objb ) );
              { Give the length for in_var formal and the capacity for out_var and var formal }
              if not (var_out in pf^.ide_vacc) then lgc^.lgt_disp := typ_std[form_record]^.typ_firstfield^.ide_offset;
              { Adjust the special argument as required }
              if lgc^.lgt_typ <> iti then
              begin
                lgc := LGT_NEW_CODE( pcod_noop, lgc );
                lgc^.lgt_typ := iti
              end
            end;
            pf := pf^.ide_nxt;                          { Skip special formal in the list }
            if lgj = nil then lgi := lgc
                         else lgj^.lgt_nxt := lgc;
            lgj := lgc
          end
        end { if b_sa then }
        else
        begin { Insert the extra parameter(s) for standard conformant array }
          et := pe^.lgt_typ;
          if et <> nil then
          while (ft <> nil) and (et <> nil) do
            if (ft^.typ_form = form_conf) and
               ((et^.typ_form = form_conf) or
                (et^.typ_form = form_array)) then
            begin
              it  := et^.typ_indtype;                   { Get the effective index array type }
              iti := ft^.typ_indtype;                   { Get the formal index array type }
(* ????????????? *)
              repeat
                if iti^.typ_parent <> nil then iti := iti^.typ_parent
              until (iti^.typ_parent = nil) or (iti^.typ_form <> form_range);

              if it^.typ_form = form_range then descr := LOOK_FOR_DESCRIPTOR( objb, it )
                                           else descr := objb;
(*
WRITELN( lst_current^.lst_file, ' Used Descritor found :' ); LGT_WRITE_TREE( 8, descr );
*)
              if typ_low^.lgt_kind <> lgt_const then
              begin { Two special arguments conformant schema }
                if it^.typ_form = form_range then
                begin
                  lgc := LGT_TYPE_EVAL( it^.typ_low, descr );
                  if it^.typ_size <> iti^.typ_size then
                  begin
                    lgc := LGT_NEW_CODE( pcod_noop, lgc );
                    lgc^.lgt_typ := iti
                  end
                end
                else lgc := LGT_NEW_ECONST( iti, it^.typ_min );
                if lgj = nil then lgi := lgc
                             else lgj^.lgt_nxt := lgc;
                lgj := lgc;
                pf := pf^.ide_nxt;                      { Skip special formal in the list }
              end;

              if it^.typ_form = form_range then
              begin
                lgc := LGT_TYPE_EVAL( it^.typ_high, descr );
                if it <> iti then
                begin
                  lgc := LGT_NEW_CODE( pcod_noop, lgc );
                  lgc^.lgt_typ := iti
                end
              end
              else lgc := LGT_NEW_ECONST( iti, it^.typ_max );
              if lgj = nil then lgi := lgc
                           else lgj^.lgt_nxt := lgc;
              lgj := lgc;
              pf := pf^.ide_nxt;                        { Skip special formal in the list }
              et  := et^.typ_aeltype;
              ft  := ft^.typ_aeltype
            end else ft := nil;                         { while ... do  if ... }

          with pe^ do                                   { Adjust the conformant array base address }
            if lgt_typ^.typ_descr_size > 0 then
              lgt_disp := lgt_disp + lgt_typ^.typ_descr_size
        end { if b_sa then ... : else code };

        { Attach the special arguments to the user's one }
        if lgi <> nil then
        begin
          lgj^.lgt_nxt := pe^.lgt_nxt;          { Link the last special parg to the next user's one }
          pe^.lgt_nxt := lgi;                   { Link the current user arg. to the first special one }
          pe := lgj                             { pe -> the last actual arg. ... }
        end;
        pre := pe                               { ... that is also the future previous arg. }
      end { if ft <> nil then };

      if pe <> nil then pe := pe^.lgt_nxt;
      pf := pf^.ide_nxt
    end { End loop on formal };

    if pro_typ <> nil then
    with lgt^ do
    begin  { For any function: Management of Equv and eqst special types }
      if (pro_typ^.typ_form = form_equv) or
         (pro_typ^.typ_form = form_eqst) then
      begin { Equivalent type to largest effective parameter }
        lgt_typ := rty;
        if (not rty^.typ_simple) and (lgt_parmlst <> nil) then
          lgt_parmlst^.lgt_typ := rty
      end;

      { Allocate the space for returned value }
      if not pro_typ^.typ_simple then
        TMPSTK_ALLOCATE( lgt_parmlst, lgt_parmlst^.lgt_typ )
    end
  end
end CALL_SETTING;



[global]
procedure GENERIC_SEARCH( var id:   id_name;
                              npa:  integer;
                          var pg:   gen_ptr;
                          parm_lst: lgt_ptr );
{ Procedure to find the procedure to choice in a generic list }
{ npa is the given parameter number }    
{ pg ins in/out pointer in the generic list }
{ On a success the procedure CALL_SETTING is called just before return
  if the selected action is a procedure/function ( not a builtin operator ) }
const
  mdnam = 'GENS';

var
  found, comp, bequ, bset: boolean;
  p1:                      ide_ptr;
  is, iconf:               integer;
  lgt1, lgte:              lgt_ptr;
  ty:                      typ_ptr;
nn: [static] integer := 0;

(*
procedure WRITEADDR( p: $wild_pointer );
var
 eq: record case boolean of
       false:( pp: $wild_pointer );
       true:(  iv: integer )
     end;
begin
  eq.pp := p;
  WRITE( eq.iv:-10 )
end;
*)


begin
  found := false;
  while not found and (pg <> nil) do
  begin
    lgt1 := parm_lst;                          { Get effective parameter list }
    with pg^ do
      if gen_blt and (npa <= 2) then { *** Builtin Operator Definition *** }
        with lgt1^ do
        case npa of
          0: found := (gen_p1 = nil) and (gen_p2 = nil);
          1: found := (gen_p2 = nil) and COMP_TYPE( lgt_typ, gen_p1, false );
          2:
             if (lgt_typ^.typ_size > 0) and
                (lgt_nxt^.lgt_typ^.typ_size > 0) then
             begin
               found := COMP_TYPE( lgt_typ, gen_p1, false )
                    and COMP_TYPE( lgt_nxt^.lgt_typ, gen_p2, false );
               if not found then
               case gen_p1^.typ_form of
                 form_eqst: { * The first arg. type must be the same or child of second arg. type and not schemas (or child of) type  }
                   found := ((lgt_nxt^.lgt_typ = lgt_typ) or
                             (lgt_nxt^.lgt_typ = lgt_typ^.typ_parent)) and
                            (lgt_typ^.typ_descr_size = 0) and
                            COMP_TYPE( lgt_typ, gen_p2, false );

                 form_equv: { * The two arg. types must be same }
                   found := (COMP_TYPE( lgt_nxt^.lgt_typ, lgt_typ, false ) or
                             COMP_TYPE( lgt_typ, lgt_nxt^.lgt_typ, false )) and
                            COMP_TYPE( lgt_typ, gen_p2, false ) and
                            COMP_TYPE( lgt_nxt^.lgt_typ, gen_p2, false );

                 form_eqse: { * The type of second element must be a set of the type of the first element }
                   if COMP_TYPE( lgt_nxt^.lgt_typ, typ_std[form_wwset], false )
                   then
                     found := COMP_TYPE( lgt_typ,
                                         lgt_nxt^.lgt_typ^.typ_seltype, false )
                          and COMP_TYPE( lgt_nxt^.lgt_typ, gen_p2, false );
               otherwise
               end
             end;
        end
      else { *** User Defined *** }
        with gen_proc^ do
        if pro_nparm >= npa then
        begin                                  { The number of Formal is >= than the Effective parameter number }
          p1 := pro_parmlst;
          if pro_parmlst <> nil then
            if pro_parmlst^.ide_vkind = var_result then
              p1 := p1^.ide_nxt                { Skip function result when used };
          { Special function/procedure }
          if (npa = 2) and (pro_nparm = 2) and
             ((pro_pkind = pro_standard) or (pro_pkind = pro_external)) then
          with lgt1^ do
          begin                                { For Special Standard Procedure/Function model }
            case p1^.ide_typ^.typ_form of
              form_eqst: { * Type exactly same and without (type) parameter }
                found := (lgt_nxt^.lgt_typ = lgt_typ) and
                         (lgt_typ^.typ_descr_size = 0) and  
                         COMP_TYPE( lgt_typ, p1^.ide_nxt^.ide_typ, false );

              form_equv: { * Force binary op to have same type and result to be same }
                found := (COMP_TYPE( lgt_nxt^.lgt_typ, lgt_typ, false ) or
                          COMP_TYPE( lgt_typ, lgt_nxt^.lgt_typ, false )) and
                         COMP_TYPE( lgt_typ, p1^.ide_nxt^.ide_typ, false ) and
                         COMP_TYPE( lgt_nxt^.lgt_typ, p1^.ide_nxt^.ide_typ, false );

              form_eqse: { * Type of equivalent set element }
                if COMP_TYPE( lgt_nxt^.lgt_typ, typ_std[form_wwset], false )
                then
                  found := COMP_TYPE( lgt_typ,
                                      lgt_nxt^.lgt_typ^.typ_seltype, false )
                       and COMP_TYPE( lgt_nxt^.lgt_typ,
                                      p1^.ide_nxt^.ide_typ, false );
            otherwise
              found := false
            end
          end;
          if not found then
          begin
            found := true;                     { Until shown otherwise }
            while found and (p1 <> nil) do     { Formal/Effective parameter loop }
            begin
              iconf := 0;
              with p1^ do                      { With this formal parameter }
                if lgt1 <> nil then            { User list not finished }
                with lgt1^ do
                begin
                  if lgt_kind = lgt_empty then { Empty parameter given }
                    if (ide_inival = nil) and not (var_optional in ide_vacc) then
                      { Default value does not exist } found := false
                    else
                    begin                      { Empty parameter is allowed }
                      p1 := ide_nxt; lgt1 := lgt_nxt
                    end
                  else { Parameter is provided }
                  begin
                    comp := COMP_TYPE( lgt_typ, ide_typ, ide_vkind <> var_vformal );

                    { Some special opportunities for Cte effective parameters }
                    if (not comp) and (lgt_kind = lgt_const) then
                    { When the effective parameter is a constant }
                    with ide_typ^ do
                    case typ_form of           { case on formal parameter type kind }
                      form_single: { * The constant must be converted to single }
                        if lgt_typ^.typ_form = form_double then
                        begin
                          lgt_typ := typ_std[form_single]; comp := true
                        end;

                      form_double: { * The constant must be converted to double }
                        if lgt_typ^.typ_form = form_single then
                        begin
                          lgt_typ := typ_std[form_double]; comp := true
                        end;

(*
                      form_record:
                        if COMP_TYPE( ide_typ, typ_std[form_record], false )
                        then
                          { The Standard String are always compatible with
                            any Character constant ... }
                          if COMP_TYPE( lgt_typ, typ_std[form_char], false )
                          then comp := true
                          else
                          { ... and any Constant Array[<integer>] of char }
                          with lgt_typ^ do
                          if (typ_form = form_array) and
                            COMP_TYPE( typ_aeltype, typ_std[form_char], false)
                            and (typ_indtype^.typ_form = form_int)
                          then comp := true;
*)

                      form_array,
                      form_conf: { * Conformant array of char is compatible with any Cte string or char }
                        if COMP_TYPE( typ_aeltype, typ_std[form_char], true )
                           and (typ_indtype^.typ_form = form_int) and (typ_descr_size = 0) then
                          { When the formal is an array[] of char (without descriptor) }
                          if COMP_TYPE( lgt_typ, typ_std[form_record], false )
                          then                 { It must be compatible with a Cte string
                                                 (passed as fixed array size) when sizes match }
                            if typ_form = form_array then
                              with typ_indtype^ do
                                comp := ((typ_max - typ_min + 1) =
                                                lgt_cte^.val_size)
                            else
                              comp := true
                          else                 { OR with a Cte char }
                            if COMP_TYPE( lgt_typ, typ_std[form_char], false )
                            then
                              if typ_form = form_conf then comp := true
                              else comp := (typ_max = typ_min);

                    otherwise
                    end;
                    { Set conformant supplementary parameter count }
                    if comp then
                    begin
                      if ide_typ <> nil then
                        if ide_typ^.typ_form = form_conf then
                          iconf := ide_typ^.typ_idim;
                      p1 := ide_nxt; lgt1 := lgt_nxt
                    end else found := false;

                    { Verify also the access code matching * * * Patch 1.9 L * * * }
                    if found then
                    begin
                      if ide_vkind = var_vformal then
                      begin                    { Formal By Value }
                        if not (lgt_in in lgt_status) then found := false
                      end
                      else                     { Formal By Reference }
                        if lgt_add in lgt_status then
                        begin
                          if var_in in ide_vacc then
                            if not (lgt_in in lgt_status) then found := false;
                          if var_out in ide_vacc then
                            if not (lgt_out in lgt_status) then found := false
                        end
                        else { The in_var formal parameter must be accept any expression - can be copied ina memory location }
                          if var_out in ide_vacc then found := false
                    end
                  end
                end
                else                           { End of caller parameter list reached }
                  if (ide_inival = nil) and not (var_optional in ide_vacc) then
                    found := false             { Default value not exists }
                  else                         { Empty parameter is allowed }
                    p1 := ide_nxt;

              if iconf > 0 then                { Skip formal supplementary parameter count (for Form_conf) }
              repeat
                p1 := p1^.ide_nxt; iconf := iconf - 1
              until iconf = 0
            end
          end
        end;
    if not found then  pg := pg^.gen_link      { Skip to next definition }
  end;
  if not found then                            { We have not found the procedure/function to use }
    SRC_ERROR_S( mdnam, 113, e_severe, id );
end GENERIC_SEARCH;



[global]
function EXP_GENOPER( var id: id_name; p: gen_ptr; oblst: lgt_ptr ): lgt_ptr;
{ Procedure to handle any unary and binary operator as defined with :
  - id      the identifier name of ,
  - p       the head entry pointer of the Generic Search List,
  - oblst   the list of effective parameters (1 or 2 parameters only). }
var
  n:   integer;
  lgt: lgt_ptr;

begin
  n := 1 + ORD( oblst^.lgt_nxt <> nil );
  GENERIC_SEARCH( id, n, p, oblst );                   { Look for the generic call }
  if p <> nil then
  with p^ do
  begin
    if gen_blt then                                    { For built-in operator, ... }
    begin                                              { if pcod definition exist }
      if n = 1 then lgt := EXP_VAL_UNA( oblst, p )     { Unary operator }
               else lgt := EXP_VAL_BIN( oblst, p );    { Binary operator }
      if lgt^.lgt_typ = typ_std[form_equv] then lgt^.lgt_typ := oblst^.lgt_typ
    end
    else
    begin { For any user definition }
      with gen_proc^ do
      begin
        lgt := LGT_NEW_CALL( pro_typ, gen_proc, oblst );       { Create a new node }
        if pro_typ = typ_std[form_equv] then lgt^.lgt_typ := oblst^.lgt_typ
      end;
      CALL_SETTING( lgt )                              { Complete the call }
    end;
    EXP_GENOPER := lgt
  end else EXP_GENOPER := oblst                        { No procedure/function/operator founded }
end EXP_GENOPER;



[global]
function GENERATE_CALL( ip: ide_ptr; lgp: lgt_ptr;
                        np: integer := 0; bsnsea: boolean := false ): lgt_ptr;
{ Generate a complet call Sequence of generic name specified by the ip identifier,
  and with the lgp effective parameter list. When bsnsea is true, a previous IDE_SEARCH
  is performed to locate any possible redefinition of generic. }
var
  pg:     gen_ptr;
  lg, re: lgt_ptr;

begin
  if bsnsea then IDE_SEARCH_FROM_NAMEID( ip );
  pg := ip^.ide_gfirst;                                { Get generic list head }
  if np <= 0 then
  begin
    lg := lgp;
    while lg <> nil do
    begin  lg := lg^.lgt_nxt; np := np + 1  end
  end;
  re := nil;
  if (np = 1) or (np = 2) then
    re := EXP_GENOPER( ip^.ide_name^, pg, lgp )
  else
  begin                                                { Other case }
    { Look for matched procedure/function }
    GENERIC_SEARCH( ip^.ide_name^, np, pg, lgp );
    if pg <> nil then with pg^ do                      { We have found a good gen_rec user definition }
      if gen_proc <> nil then
      begin                                            { Allocated a node for the call }
        re := LGT_NEW_CALL( gen_proc^.pro_typ, gen_proc, lgp );
        CALL_SETTING( re );                            { Complete the call }
        if gen_proc^.pro_typ = typ_std[form_equv] then re^.lgt_typ := lgp^.lgt_typ
      end
  end;
  GENERATE_CALL := re
end GENERATE_CALL;



[global]
function EXP_GENOP( op: operator; oblst: lgt_ptr ): lgt_ptr;
begin
  EXP_GENOP := EXP_GENOPER( opname[op], ope_table[op]^.ope_gfirst, oblst );
end EXP_GENOP;



[global]
function  LGT_GEN_STORE( prm: lgt_ptr; bstd, bovr: boolean ): lgt_ptr;
{ To generate a Builtin Store of any object }
{ Any possible Read Protection is By-Passed }
var
  lgr, pr2: lgt_ptr;
  pgf:      gen_ptr;
  s1, s2:   lgt_states;

begin
  if bstd then pgf := std_store_dgf                    { Use Standard Env. Only }
          else pgf := ope_table[ass_op]^.ope_gfirst;   { Use Current Environment }
  pr2 := prm^.lgt_nxt;
  s1 := prm^.lgt_status;
  s2 := pr2^.lgt_status;
  if bovr then
  begin
    prm^.lgt_status := s1 + [lgt_out,lgt_in];
    pr2^.lgt_status := s2 + [lgt_in]
  end;
  lgr := EXP_GENOPER( opname[ass_op], pgf, prm );
  if bovr then
  begin
    prm^.lgt_status := s1;
    pr2^.lgt_status := s2
  end;
  return lgr
end LGT_GEN_STORE;


end.
