{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*     ---   COMMON   BASIC  PASCAL  RUN  ENVIRONMENT  MODULE    ---     *
*                                                                       *
*              ---  Version  3.0-0 -- 30/11/2013 ---                    *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////



}


{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                        ----

                       nothing

                        ----

}

module PAS_BASIC_DEF;


%include 'passrc:pcmp_env';                            { *** Include the CPAS definitions }



procedure IDECTE_CREATE_NAME(     len: integer;
                              var  nm: [readonly]
                                   packed array[$sz: integer] of char );
begin
  sy_ident.l := len;
  for i := 1 to len do
    sy_ident.s[i] := nm[i]
end IDECTE_CREATE_NAME;



procedure IDE_CREATE_BUILTIN;
type
  conv_kind = ( nocv, cvif, cvfi, cvig, cvgi, cvgf, cvfg);

var
  conv_tab: array[conv_kind] of gen_ptr;



procedure CREATE_STD_CONVERSION;
const
  nent =  16;

type
  ope_entry = record
    f1,                                                { Parameter type }
    fr: typ_forms;                                     { Result type }
    cop: pcod_codes;                                   { Pcode operator }
    cvcd: conv_kind                                    { Result index }
  end;

var
  i: integer;
  tp: typ_ptr;
  pg: gen_ptr;

  { Warning: The next order is used for the standard operator }

  std_cv_tab: [static] array[1..nent] of ope_entry := (
  {       f1           fr           cop    cvcd  }
  { 1..10 }
  (   form_int,   form_single,  pcod_cvif, cvif  ),    { integer -> single }
  (form_single,      form_int,  pcod_cvfi, cvfi  ),    { single -> integer }
  (   form_lit,      form_int,  pcod_noop, nocv  ),    { boolean  -> integer }
  (  form_wlit,      form_int,  pcod_noop, nocv  ),    { wlit -> integer }
  (   form_int,     form_char,  pcod_noop, nocv  ),    { integer -> char }
  (  form_char,      form_int,  pcod_noop, nocv  ),    { char -> integer }
  (   form_lit,      form_int,  pcod_noop, nocv  ),    { boolean -> integer }
  (  form_wset,      form_int,  pcod_noop, nocv  ),    { set -> integer }
  (   form_int,     form_wset,  pcod_noop, nocv  ),    { integer -> set }
  (   form_nil,      form_int,  pcod_noop, nocv  ),    { pointer -> integer }
  {11..16 }
  (   form_int,   form_double,  pcod_cvig, cvig  ),    { integer -> double }
  (form_double,      form_int,  pcod_cvgi, cvgi  ),    { double -> integer }
  (form_double,   form_single,  pcod_cvgf, cvgf  ),    { double -> single }
  (form_double,   form_double,  pcod_noop, nocv  ),    { double -> double }
  (form_single,   form_double,  pcod_cvfg, cvfg  ),    { single -> double }
  (form_single,   form_single,  pcod_noop, nocv  )     { single -> single }
  );


begin { CREATE_STD_CONVERSION }
  conv_tab[nocv] := nil;
  for i := 1 to nent do
  with std_cv_tab[i] do
  begin
    pg := nil;
    NEW( pg, true );
    tp := typ_std[fr];
    with pg^, tp^ do
    begin
      gen_link :=  nil;
      gen_blt  := true;
      gen_p1 := typ_std[f1]; gen_p2 := nil; gen_result := tp;
      gen_pc_cv1 := nil; gen_pc_cv2 := nil; gen_pcode := cop;
      conv_tab[cvcd] := pg;
      with typ_ide^ do
      begin
        if ide_gfirst = nil then ide_gfirst := pg
                            else ide_glast^.gen_link := pg;
        ide_glast := pg
      end
    end;
  end;
  conv_tab[nocv] := nil
end CREATE_STD_CONVERSION;



procedure CREATE_STD_OPERATOR;
const
  nent = 149;

type
  ope_entry = record
    ope:     operator;                                 { Related operator }
    f1, f2,                                            { Parameter(s) type(s) }
    fr:      typ_forms;                                { Result type }
    cv1,cv2: conv_kind;                                { Conversion for parameters }
    cop:     pcod_codes                                { pcode Operator }
  end;

var
  i:  integer;
  op: operator;
  po: ope_ptr;
  pg: gen_ptr;

  { *** Warning: This table is sorted from the specific to general *** }
  std_ope_tab: [static] array[1..nent] of ope_entry := (
  {  ope         f1         f2           fr     cv1   cv2     cop   }
  {  1.. 1 }
  (not_op,   form_lit,  form_null,   form_lit, nocv, nocv,  pcod_not),
  {  2.. 5 }
  (pow_op,  form_int,    form_int,   form_int, nocv, nocv, pcod_ipow),
  (pow_op,form_single,   form_int,form_single, nocv, nocv, pcod_fipw),
  (pow_op,   form_int,form_single,form_single, cvif, nocv, pcod_fpow),
  (pow_op,form_single,form_single,form_single, nocv, nocv, pcod_fpow),
  {  6.. 9 }
  (mul_op,   form_int,   form_int,   form_int, nocv, nocv, pcod_imul),
  (mul_op,form_single,   form_int,form_single, nocv, cvif, pcod_fmul),
  (mul_op,   form_int,form_single,form_single, cvif, nocv, pcod_fmul),
  (mul_op,form_single,form_single,form_single, nocv, nocv, pcod_fmul),
  { 10..13 }
  (div_op,   form_int,   form_int,form_single, cvif, cvif, pcod_fdiv),
  (div_op,form_single,   form_int,form_single, nocv, cvif, pcod_fdiv),
  (div_op,   form_int,form_single,form_single, cvif, nocv, pcod_fdiv),
  (div_op,form_single,form_single,form_single, nocv, nocv, pcod_fdiv),
  { 14..16 }
  (idiv_op,  form_int,   form_int,   form_int, nocv, nocv, pcod_idiv),
  (imod_op,  form_int,   form_int,   form_int, nocv, nocv, pcod_imod),
  (irem_op,  form_int,   form_int,   form_int, nocv, nocv, pcod_irem),
  { 17..20 }
  (add_op,   form_int,   form_int,   form_int, nocv, nocv, pcod_iadd),
  (add_op,form_single,   form_int,form_single, nocv, cvif, pcod_fadd),
  (add_op,   form_int,form_single,form_single, cvif, nocv, pcod_fadd),
  (add_op,form_single,form_single,form_single, nocv, nocv, pcod_fadd),
  { 22..26 }
  (sub_op,   form_int,  form_null,   form_int, nocv, nocv, pcod_ineg),
  (sub_op,form_single,  form_null,form_single, nocv, nocv, pcod_fneg),
  (sub_op,   form_int,   form_int,   form_int, nocv, nocv, pcod_isub),
  (sub_op,form_single,   form_int,form_single, nocv, cvif, pcod_fsub),
  (sub_op,   form_int,form_single,form_single, cvif, nocv, pcod_fsub),
  (sub_op,form_single,form_single,form_single, nocv, nocv, pcod_fsub),
  { 27..33 }
  ( lt_op,   form_int,   form_int,   form_lit, nocv, nocv,  pcod_ilt),
  ( lt_op,  form_char,  form_char,   form_lit, nocv, nocv,  pcod_ult),
  ( lt_op,   form_lit,   form_lit,   form_lit, nocv, nocv,  pcod_ult),
  ( lt_op,form_single,   form_int,   form_lit, nocv, cvif,  pcod_flt),
  ( lt_op,   form_int,form_single,   form_lit, cvif, nocv,  pcod_flt),
  ( lt_op,form_single,form_single,   form_lit, nocv, nocv,  pcod_flt),
  ( lt_op,  form_equv,  form_wlit,   form_lit, nocv, nocv,  pcod_ult),
  { 34..40 }
  ( le_op,   form_int,   form_int,   form_lit, nocv, nocv,  pcod_ile),
  ( le_op,  form_char,  form_char,   form_lit, nocv, nocv,  pcod_ule),
  ( le_op,   form_lit,   form_lit,   form_lit, nocv, nocv,  pcod_ule),
  ( le_op,form_single,   form_int,   form_lit, nocv, cvif,  pcod_fle),
  ( le_op,   form_int,form_single,   form_lit, cvif, nocv,  pcod_fle),
  ( le_op,form_single,form_single,   form_lit, nocv, nocv,  pcod_fle),
  ( le_op,  form_equv,  form_wlit,   form_lit, nocv, nocv,  pcod_ule),
  { 41..47 }
  ( ge_op,   form_int,   form_int,   form_lit, nocv, nocv,  pcod_ige),
  ( ge_op,  form_char,  form_char,   form_lit, nocv, nocv,  pcod_uge),
  ( ge_op,   form_lit,   form_lit,   form_lit, nocv, nocv,  pcod_uge),
  ( ge_op,form_single,   form_int,   form_lit, nocv, cvif,  pcod_fge),
  ( ge_op,   form_int,form_single,   form_lit, cvif, nocv,  pcod_fge),
  ( ge_op,form_single,form_single,   form_lit, nocv, nocv,  pcod_fge),
  ( ge_op,  form_equv,  form_wlit,   form_lit, nocv, nocv,  pcod_uge),
  { 48..54 }
  ( gt_op,   form_int,   form_int,   form_lit, nocv, nocv,  pcod_igt),
  ( gt_op,  form_char,  form_char,   form_lit, nocv, nocv,  pcod_ugt),
  ( gt_op,   form_lit,   form_lit,   form_lit, nocv, nocv,  pcod_ugt),
  ( gt_op,form_single,   form_int,   form_lit, nocv, cvif,  pcod_fgt),
  ( gt_op,   form_int,form_single,   form_lit, cvif, nocv,  pcod_fgt),
  ( gt_op,form_single,form_single,   form_lit, nocv, nocv,  pcod_fgt),
  ( gt_op,  form_equv,  form_wlit,   form_lit, nocv, nocv,  pcod_ugt),
  { 55..59 }
  ( ne_op,  form_equv, form_ennum,   form_lit, nocv, nocv,   pcod_ne),
  ( ne_op,form_single,   form_int,   form_lit, nocv, cvif,  pcod_fne),
  ( ne_op,   form_int,form_single,   form_lit, cvif, nocv,  pcod_fne),
  ( ne_op,form_single,form_single,   form_lit, nocv, nocv,  pcod_fne),
  ( ne_op,   form_nil,   form_nil,   form_lit, nocv, nocv,   pcod_ne),
  { 60..64 }
  ( eq_op,  form_equv, form_ennum,   form_lit, nocv, nocv,   pcod_eq),
  ( eq_op,form_single,   form_int,   form_lit, nocv, cvif,  pcod_feq),
  ( eq_op,   form_int,form_single,   form_lit, cvif, nocv,  pcod_feq),
  ( eq_op,form_single,form_single,   form_lit, nocv, nocv,  pcod_feq),
  ( eq_op,   form_nil,   form_nil,   form_lit, nocv, nocv,   pcod_eq),
  { 65..67 }
  (and_op,   form_lit,   form_lit,   form_lit, nocv, nocv,  pcod_and),
  ( or_op,   form_lit,   form_lit,   form_lit, nocv, nocv,  pcod_or),
  (xor_op,   form_lit,   form_lit,   form_lit, nocv, nocv,  pcod_xor),
  { 68..68  := for pointer }
  (ass_op,   form_nil,   form_nil,  form_null, nocv, nocv, pcod_istore),
  { 69..72  := for char, boolean, literal, integer, single }
  (ass_op,  form_equv, form_ennum,  form_null, nocv, nocv, pcod_istore),
  (ass_op,form_single,   form_int,  form_null, nocv, cvif, pcod_fstore),
  (ass_op,   form_int,form_single,  form_null, nocv, cvfi, pcod_istore),
  (ass_op,form_single,form_single,  form_null, nocv, nocv, pcod_fstore),
  { *** Definitions for double use *** }
  { 73..77   ** for double }
  (pow_op,form_double,   form_int,form_double, nocv, nocv, pcod_gipw),
  (pow_op,   form_int,form_double,form_double, cvig, nocv, pcod_gpow),
  (pow_op,form_double,form_double,form_double, nocv, nocv, pcod_gpow),
  (pow_op,form_single,form_double,form_double, cvfg, nocv, pcod_gpow),
  (pow_op,form_double,form_single,form_double, nocv, cvfg, pcod_gpow),
  { 78..82   * for double }
  (mul_op,form_double,   form_int,form_double, nocv, cvig, pcod_gmul),
  (mul_op,   form_int,form_double,form_double, cvig, nocv, pcod_gmul),
  (mul_op,form_double,form_double,form_double, nocv, nocv, pcod_gmul),
  (mul_op,form_single,form_double,form_double, cvfg, nocv, pcod_gmul),
  (mul_op,form_double,form_single,form_double, nocv, cvfg, pcod_gmul),
  { 83..87   / for double }
  (div_op,form_double,   form_int,form_double, nocv, cvig, pcod_gdiv),
  (div_op,   form_int,form_double,form_double, cvig, nocv, pcod_gdiv),
  (div_op,form_double,form_double,form_double, nocv, nocv, pcod_gdiv),
  (div_op,form_single,form_double,form_double, cvfg, nocv, pcod_gdiv),
  (div_op,form_double,form_single,form_double, nocv, cvfg, pcod_gdiv),
  { 88..92   + for double }
  (add_op,form_double,   form_int,form_double, nocv, cvig, pcod_gadd),
  (add_op,   form_int,form_double,form_double, cvig, nocv, pcod_gadd),
  (add_op,form_double,form_double,form_double, nocv, nocv, pcod_gadd),
  (add_op,form_single,form_double,form_double, cvfg, nocv, pcod_gadd),
  (add_op,form_double,form_single,form_double, nocv, cvfg, pcod_gadd),
  { 93..98   - for double }
  (sub_op,form_double,  form_null,form_double, nocv, nocv, pcod_gneg),
  (sub_op,form_double,   form_int,form_double, nocv, cvig, pcod_gsub),
  (sub_op,   form_int,form_double,form_double, cvig, nocv, pcod_gsub),
  (sub_op,form_double,form_double,form_double, nocv, nocv, pcod_gsub),
  (sub_op,form_single,form_double,form_double, cvfg, nocv, pcod_gsub),
  (sub_op,form_double,form_single,form_double, nocv, cvfg, pcod_gsub),
  {  99..103  < with double }
  ( lt_op,form_double,   form_int,   form_lit, nocv, cvig,  pcod_glt),
  ( lt_op,   form_int,form_double,   form_lit, cvig, nocv,  pcod_glt),
  ( lt_op,form_single,form_double,   form_lit, cvfg, nocv,  pcod_glt),
  ( lt_op,form_double,form_single,   form_lit, nocv, cvfg,  pcod_glt),
  ( lt_op,form_double,form_double,   form_lit, nocv, nocv,  pcod_glt),
  {104..108  <= with double }
  ( le_op,form_double,   form_int,   form_lit, nocv, cvig,  pcod_gle),
  ( le_op,   form_int,form_double,   form_lit, cvig, nocv,  pcod_gle),
  ( le_op,form_single,form_double,   form_lit, cvfg, nocv,  pcod_gle),
  ( le_op,form_double,form_single,   form_lit, nocv, cvfg,  pcod_gle),
  ( le_op,form_double,form_double,   form_lit, nocv, nocv,  pcod_gle),
  {109..113  >= with double }
  ( ge_op,form_double,   form_int,   form_lit, nocv, cvig,  pcod_gge),
  ( ge_op,   form_int,form_double,   form_lit, cvig, nocv,  pcod_gge),
  ( ge_op,form_single,form_double,   form_lit, cvfg, nocv,  pcod_gge),
  ( ge_op,form_double,form_single,   form_lit, nocv, cvfg,  pcod_gge),
  ( ge_op,form_double,form_double,   form_lit, nocv, nocv,  pcod_gge),
  {114..118  > with double }
  ( gt_op,form_double,   form_int,   form_lit, nocv, cvig,  pcod_ggt),
  ( gt_op,   form_int,form_double,   form_lit, cvig, nocv,  pcod_ggt),
  ( gt_op,form_single,form_double,   form_lit, cvfg, nocv,  pcod_ggt),
  ( gt_op,form_double,form_single,   form_lit, nocv, cvfg,  pcod_ggt),
  ( gt_op,form_double,form_double,   form_lit, nocv, nocv,  pcod_ggt),
  {119..123  compare with double }
  ( eq_op,form_double,   form_int,   form_lit, nocv, cvig,  pcod_geq),
  ( eq_op,   form_int,form_double,   form_lit, cvig, nocv,  pcod_geq),
  ( eq_op,form_single,form_double,   form_lit, cvfg, nocv,  pcod_geq),
  ( eq_op,form_double,form_single,   form_lit, nocv, cvfg,  pcod_geq),
  ( eq_op,form_double,form_double,   form_lit, nocv, nocv,  pcod_geq),
  {124..128  compare with double }
  ( ne_op,form_double,   form_int,   form_lit, nocv, cvig,  pcod_gne),
  ( ne_op,   form_int,form_double,   form_lit, cvig, nocv,  pcod_gne),
  ( ne_op,form_single,form_double,   form_lit, cvfg, nocv,  pcod_gne),
  ( ne_op,form_double,form_single,   form_lit, nocv, cvfg,  pcod_gne),
  ( ne_op,form_double,form_double,   form_lit, nocv, nocv,  pcod_gne),
  { 129..133  := for double }
  (ass_op,form_double,   form_int,  form_null, nocv, cvig, pcod_gstore),
  (ass_op,form_double,form_single,  form_null, nocv, cvfg, pcod_gstore),
  (ass_op,   form_int,form_double,  form_null, nocv, cvgi, pcod_istore),
  (ass_op,form_single,form_double,  form_null, nocv, cvgf, pcod_fstore),
  (ass_op,form_double,form_double,  form_null, nocv, nocv, pcod_gstore),
  {  not set now for string }
  { 134..145 for short set operation }
  (mul_op,  form_equv,  form_wset,  form_equv, nocv, nocv, pcod_band),
  (add_op,  form_equv,  form_wset,  form_equv, nocv, nocv, pcod_bis),
  (sub_op,  form_wset,  form_null,  form_equv, nocv, nocv, pcod_com),
  (sub_op,  form_equv,  form_wset,  form_equv, nocv, nocv, pcod_bic),
  (xor_op,  form_equv,  form_wset,  form_equv, nocv, nocv, pcod_bxor),
  ( in_op,  form_eqse,  form_wset,   form_lit, nocv, nocv, pcod_inset),
  ( lt_op,  form_equv,  form_wset,   form_lit, nocv, nocv, pcod_setlt),
  ( le_op,  form_equv,  form_wset,   form_lit, nocv, nocv, pcod_setle),
  ( ge_op,  form_equv,  form_wset,   form_lit, nocv, nocv, pcod_setge),
  ( gt_op,  form_equv,  form_wset,   form_lit, nocv, nocv, pcod_setgt),
  ( eq_op,  form_equv,  form_wset,   form_lit, nocv, nocv, pcod_seteq),
  ( ne_op,  form_equv,  form_wset,   form_lit, nocv, nocv, pcod_setne),
  { 146..149  := for structured }
  ( ne_op,  form_eqst,  form_wild,   form_lit, nocv, nocv,  pcod__ne),
  ( eq_op,  form_eqst,  form_wild,   form_lit, nocv, nocv,  pcod__eq),
  (ass_op,  form_equv,  form_wset,  form_null, nocv, nocv, pcod_istore),
  (ass_op,  form_eqst,  form_wild,  form_null, nocv, nocv, pcod_store)
  );

begin { CREATE_STD_OPERATOR }
  for op := not_op to no_op do  ope_table[op] := nil;  { Init table }
  for i := 1 to nent do
  with std_ope_tab[i] do
  begin
    if ope_table[ope] = nil then
    begin
      po := nil;
      NEW( po ); ope_table[ope] := po;
      with po^ do
      begin
        ope_operator := ope;
        ope_lex      :=   0;                           { Lex 0 for standard }
        ope_nxt      := nil;                           { Unused for standard }
        ope_llnk     := nil;                           { For standard operator definitions }
        ope_gfirst   := nil;
        ope_glast    := nil
      end
    end
    else po := ope_table[ope];
    pg := nil;
    NEW( pg, true );
    with pg^, po^ do
    begin
      gen_link := nil;
      gen_blt := true;
      gen_p1 := typ_std[f1];
      if f2 = form_null then gen_p2 := nil
                        else gen_p2 := typ_std[f2];
      if fr = form_null then gen_result := nil
                        else gen_result := typ_std[fr];
      gen_pc_cv1 := conv_tab[cv1];
      gen_pc_cv2 := conv_tab[cv2];
      gen_pcode := cop;
      if ope_gfirst = nil then ope_gfirst := pg
                          else ope_glast^.gen_link := pg;
      ope_glast := pg
    end;
  end
end CREATE_STD_OPERATOR;



procedure CREATE_BLT_FUNCTION;
const
  nent  = 69;                                          { Number of builtin generic entry }
  nentg = 24;                                          { Number of builtin generic name }

type
  proc_entry = record
    length: byte;                                      { Length of the builtin procedure/function name }
    nam:    packed array[1..id_maxsize] of char;
    ndef:   byte                                       { Number of related entry (operator) definitions }
  end;

  gen_entry = record
    f1,f2,fr: typ_forms;                               { p1, p2 and result types }
    cv1,cv2: conv_kind;
    cr: pcod_codes;                                    { Operators }
    p_nb: byte                                         { Builtin number (for builtin identification) }
  end;

var
  codtab: [static] array[1..nent] of gen_entry := (
  {  1.. 2  SUCC, PRED }
  ( form_ennum,   form_null,   form_equv, nocv, nocv,    pcod_succ, 101),
  ( form_ennum,   form_null,   form_equv, nocv, nocv,    pcod_pred, 102),
  {  3.. 5  ORD,  CHR, ODD  }
  ( form_ennum,   form_null,    form_int, nocv, nocv,    pcod_noop, 103),
  (   form_int,   form_null,   form_char, nocv, nocv,    pcod_noop, 104),
  ( form_ennum,   form_null,    form_lit, nocv, nocv,    pcod_iodd, 105),
  {  6.. 9 ROUND, TRUNC }
  (form_single,   form_null,    form_int, nocv, nocv,    pcod_cvfi, 106),
  (form_double,   form_null,    form_int, nocv, nocv,    pcod_cvgi, 107),
  (form_single,   form_null,    form_int, nocv, nocv,  pcod_ftrunc, 108),
  (form_double,   form_null,    form_int, nocv, nocv,  pcod_gtrunc, 109),
  { 10..18 ABS, SQR, SQRT }
  (   form_int,   form_null,    form_int, nocv, nocv,    pcod_iabs, 110),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_fabs, 111),
  (form_double,   form_null, form_double, nocv, nocv,    pcod_gabs, 112),
  (   form_int,   form_null,    form_int, nocv, nocv,    pcod_isqr, 113),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_fsqr, 114),
  (form_double,   form_null, form_double, nocv, nocv,    pcod_gsqr, 115),
  (   form_int,   form_null, form_single, cvif, nocv,    pcod_sqrt, 116),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_sqrt, 117),
  (form_double,   form_null, form_double, nocv, nocv,   pcod_gsqrt, 118),
  { 19..27 SIN, COS, TAN }
  (   form_int,   form_null, form_single, cvif, nocv,     pcod_sin, 119),
  (form_single,   form_null, form_single, nocv, nocv,     pcod_sin, 120),
  (form_double,   form_null, form_double, nocv, nocv,    pcod_gsin, 121),
  (   form_int,   form_null, form_single, cvif, nocv,     pcod_cos, 122),
  (form_single,   form_null, form_single, nocv, nocv,     pcod_cos, 123),
  (form_double,   form_null, form_double, nocv, nocv,    pcod_gcos, 124),
  (   form_int,   form_null, form_single, cvif, nocv,     pcod_tan, 125),
  (form_single,   form_null, form_single, nocv, nocv,     pcod_tan, 126),
  (form_double,   form_null, form_double, nocv, nocv,    pcod_gtan, 127),
  { 28..36 ARCSIN, ARCCOS, ARCTAN }
  (   form_int,   form_null, form_single, cvif, nocv,    pcod_asin, 128),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_asin, 129),
  (form_double,   form_null, form_double, nocv, nocv,   pcod_gasin, 130),
  (   form_int,   form_null, form_single, cvif, nocv,    pcod_acos, 131),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_acos, 132),
  (form_double,   form_null, form_double, nocv, nocv,   pcod_gacos, 133),
  (   form_int,   form_null, form_single, cvif, nocv,    pcod_atan, 134),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_atan, 135),
  (form_double,   form_null, form_double, nocv, nocv,   pcod_gatan, 136),
  { 37..45 ARCTAN (2 parameters) }
  (   form_int,    form_int, form_single, cvif, cvif,    pcod_phas, 137),
  (form_single,    form_int, form_single, nocv, cvif,    pcod_phas, 138),
  (   form_int, form_single, form_single, cvif, nocv,    pcod_phas, 139),
  (form_single, form_single, form_single, nocv, nocv,    pcod_phas, 140),
  (   form_int, form_double, form_double, cvig, nocv,   pcod_gphas, 141),
  (form_single, form_double, form_double, cvfg, nocv,   pcod_gphas, 142),
  (form_double,    form_int, form_double, nocv, cvig,   pcod_gphas, 143),
  (form_double, form_single, form_double, nocv, cvfg,   pcod_gphas, 144),
  (form_double, form_double, form_double, nocv, nocv,   pcod_gphas, 145),
  { 46..51 EXP, LOG }
  (   form_int,   form_null, form_single, nocv, cvif,     pcod_exp, 146),
  (form_single,   form_null, form_single, nocv, nocv,     pcod_exp, 147),
  (form_double,   form_null, form_double, nocv, nocv,    pcod_gexp, 148),
  (   form_int,   form_null, form_single, nocv, cvif,     pcod_log, 149),
  (form_single,   form_null, form_single, nocv, nocv,     pcod_log, 150),
  (form_double,   form_null, form_double, nocv, nocv,    pcod_glog, 151),
  { 52..60 SINH, COSH, TANH }
  (   form_int,   form_null, form_single, cvif, nocv,    pcod_sinh, 152),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_sinh, 153),
  (form_double,   form_null, form_double, nocv, nocv,   pcod_gsinh, 154),
  (   form_int,   form_null, form_single, cvif, nocv,    pcod_cosh, 155),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_cosh, 156),
  (form_double,   form_null, form_double, nocv, nocv,   pcod_gcosh, 157),
  (   form_int,   form_null, form_single, cvif, nocv,    pcod_tanh, 158),
  (form_single,   form_null, form_single, nocv, nocv,    pcod_tanh, 159),
  (form_double,   form_null, form_double, nocv, nocv,   pcod_gtanh, 160),
  { 61..69 ARGSINH, ARGCOSH, ARGTANH }
  (   form_int,   form_null, form_single, cvif, nocv,   pcod_asinh, 161),
  (form_single,   form_null, form_single, nocv, nocv,   pcod_asinh, 162),
  (form_double,   form_null, form_double, nocv, nocv,  pcod_gasinh, 163),
  (   form_int,   form_null, form_single, cvif, nocv,   pcod_acosh, 164),
  (form_single,   form_null, form_single, nocv, nocv,   pcod_acosh, 165),
  (form_double,   form_null, form_double, nocv, nocv,  pcod_gacosh, 166),
  (   form_int,   form_null, form_single, cvif, nocv,   pcod_atanh, 167),
  (form_single,   form_null, form_single, nocv, nocv,   pcod_atanh, 168),
  (form_double,   form_null, form_double, nocv, nocv,  pcod_gatanh, 169)
  );

  { Waring: The pro_entry order is related to the codtab order } 
  blttab: [static] array[1..nentg] of proc_entry := (
   ( 4, 'succ',    1 ),        { SUCC(<ennum>) }
   ( 4, 'pred',    1 ),        { PRED(<ennum>) }
   ( 3, 'ord',     1 ),        { ORD(<ennum>) }
   ( 3, 'chr',     1 ),        { CHR(<ennum>) }
   ( 3, 'odd',     1 ),        { IODD(<ennum>) }
   ( 5, 'round',   2 ),        { ROUND(<real>) }
   ( 5, 'trunc',   2 ),        { TRUNC(<real>) }
   ( 3, 'abs',     3 ),        { ABS(<number>) }
   ( 3, 'sqr',     3 ),        { SQR(<number>) }
   ( 4, 'sqrt',    3 ),        {  SQRT(<real>) }
   ( 3, 'sin',     3 ),        {   SIN(<real>) }
   ( 3, 'cos',     3 ),        {   COS(<real>) }
   ( 3, 'tan',     3 ),        {   TAN(<real>) }
   ( 6, 'arcsin',  3 ),        {  ARCSIN(<real>) }
   ( 6, 'arccos',  3 ),        {  ARCCOS(<real>) }
   ( 6, 'arctan', 12 ),        {  ARCTAN( <real> [, <real> ] ) }
   ( 3, 'exp',     3 ),        {   EXP(<real>) }
   ( 2, 'ln',      3 ),        {    LN(<real>) }
   ( 4, 'sinh',    3 ),        {   SINH(<real>) }
   ( 4, 'cosh',    3 ),        {   COSH(<real>) }
   ( 4, 'tanh',    3 ),        {   TANH(<real>) }
   ( 7, 'argsinh', 3 ),        {  ARGSINH(<real>) }
   ( 7, 'argcosh', 3 ),        {  ARGCOSH(<real>) }
   ( 7, 'argtanh', 3 )         {  ARGTANH(<real>) }
    );

  i, j, ncount, pnb: integer;
  ip, ip1:           ide_ptr;
  pg:                gen_ptr;

begin
  ncount := 1;
  for i := 1 to nentg do
  with blttab[i] do
  begin
    IDECTE_CREATE_NAME( length, nam );                 { Set the identifier name }
    IDE_NEW( cla_generic, nil, ip);                    { Creates the identifier }
    with ip^ do
    begin
      ide_gproc := nil;
      ide_gfirst := nil; ide_glast := nil;
      for j := 1 to ndef do
      with codtab[ncount] do
      begin
        pg := nil;
        NEW( pg, true );
        with pg^ do
        begin
          gen_link := nil; gen_blt := true;
          gen_p1 := typ_std[f1];
          if f2 = form_null then gen_p2 := nil else gen_p2 := typ_std[f2];
          if fr = form_null then gen_result := nil
          else gen_result := typ_std[fr];
          gen_pc_cv1 := conv_tab[cv1];
          gen_pc_cv2 := conv_tab[cv2];
          gen_pcode := cr
        end;
        if ide_gfirst = nil then ide_gfirst := pg
        else ide_glast^.gen_link := pg;
        ide_glast := pg;
        ncount := ncount + 1
      end
    end
  end
end CREATE_BLT_FUNCTION;


begin { IDE_CREATE_BUILTIN }
  { Create all Standard Conversions }
  CREATE_STD_CONVERSION;

  { Create all Standard Operators }
  CREATE_STD_OPERATOR;

  { Create all Standard Procedures and Functions }
  CREATE_BLT_FUNCTION

end IDE_CREATE_BUILTIN;



procedure IDE_CREATE_ATTRIBUT;
const
  n_attr = 18;
  s_attr = 12;

type
  attr_rec = record
    length: byte;
    nam: packed array[1..id_maxsize] of char;
    val: attr_kinds
  end;

var
  ideattr_tab: [static] array[1..n_attr] of attr_rec := (
  ( 7,    'address',   attr_addr  ),                   { Address of object }
  ( 4,       'size',   attr_size  ),                   { Size in byte of tyep/object }
  ( 5,      'first',   attr_first ),                   { First value {min) }
  ( 4,       'last',   attr_last  ),                   { Last value (max) }
  ( 4,       'pred',   attr_pred  ),                   { Previous Value PRD( ) }
  ( 4,       'succ',   attr_succ  ),                   { Next value SUCC( ) }
  ( 5,      'image',   attr_image ),                   { Image of ennumerated type }
  ( 8,   'fobjsize', attr_fobjsize),                   { File Object size in Byte }
  (11,'arr_i_first', attr_arrimin ),                   { Array index minimum value }
  (10, 'arr_i_last', attr_arrimax ),                   { Array index maximum value }
  ( 6,     'digits',   attr_digits),                   { Number of valide digits }
  ( 7,    'max_exp',   attr_emax  ),                   { More larger exponante }
  ( 5,      'small',   attr_small ),                   { Smaller number > 0 }
  ( 7,    'epsilon',  attr_epsilon),                   { Smaller number > 1.0 - 1.0 }
  ( 5,      'large',   attr_large ),                   { More larger float number }
  ( 8,   'mantissa', attr_mantissa),                   { Number of bits in the mantissa }
  (11,'cardinality',   attr_card  ),                   { Set cardinality }
  ( 7,    'id_name',   attr_name  )                    { Identifier name to specify } 
  );

  spcattr_tab: [static] array[1..s_attr] of attr_rec := (
  ( 7,    'inherit', atts_inherit     ),               { Inherit an environment }
  (11,'environment', atts_environment ),               { Create an environment }
  ( 6,     'global', atts_global      ),               { Specify global object }
  ( 8,   'external', atts_external    ),               { Specify external object }
  ( 6,     'hidden', atts_hidden      ),               { Specify hidden object }
  ( 8,   'readonly', atts_readonly    ),               { Specify readonly object }
  ( 8,   'optional', atts_optional    ),               { Specify optional var formal }
  ( 8,   'volatile', atts_volatil     ),               { Specify volatil variable }
  ( 6,     'static', atts_static      ),               { Specify static variable }
  ( 4,       'byte', atts_byte        ),               { Specify a byte allocation }
  ( 4,       'word', atts_word        ),               { Specify a word allocation }
  ( 4,       'long', atts_long        )                { Specify a long allocation }
  );


  i:  integer;
  ip: ide_ptr;

begin
  { For all ennumerated types }
  NEW_DISP_LEVEL( nil, dsp_record );                   { Create an empty standard display }
  for i := 1 to n_attr do
    with ideattr_tab[i] do
    begin
      IDECTE_CREATE_NAME( length, nam );               { Set the identifier name }
      IDE_NEW( cla_attr, nil, ip );
      ip^.ide_attr := val
    end;
  { Set ennumerated attr. list }
  attr_list := lex_ident_tree[curr_disp].disp_tree;
  curr_disp := curr_disp - 1;
  { for all special attributs }
  NEW_DISP_LEVEL( nil, dsp_record );                   { Create an empty standard display }
  for i := 1 to s_attr do
    with spcattr_tab[i] do
    begin
      IDECTE_CREATE_NAME( length, nam );
      IDE_NEW( cla_attr, nil, ip );
      ip^.ide_attr := val
    end;
  { Set Ennumerated Attr. List }
  atts_list := lex_ident_tree[curr_disp].disp_tree;
  curr_disp := curr_disp - 1
end IDE_CREATE_ATTRIBUT;



[global]
procedure GEN_CONV_ENTRY( tsrc, tdst: typ_ptr; pcd: pcod_codes );
{ Use to create a generic built-in entry for a new defined type }
var
  pg: gen_ptr;

begin
  NEW( pg, true );
  with pg^ do
  begin
    gen_link   :=  nil;                                { No next generic def. }
    gen_blt    := true;                                { Builtin statement }
    gen_result := tdst;                                { Conversion to this type }
    gen_p1     := tsrc;                                { Form any ennumerate }
    gen_p2     :=  nil;                                { No second parameter }
    gen_pc_cv1 :=  nil;
    gen_pc_cv2 :=  nil;                                { No previous conv. }
    gen_pcode  :=  pcd;
  end;
  with tdst^.typ_ide^ do
  begin
    if ide_gfirst = nil then ide_gfirst := pg          { Fifo mode only }
                        else ide_gfirst^.gen_link := pg;
    ide_glast := pg
  end
end GEN_CONV_ENTRY;


[global]
procedure IDE_INIT;
{ To initialize the identifier data base and define all the basic objects }

var
  lgt1, lgt2:          lgt_ptr;
  cur_form:          typ_forms;
  pr:                  pro_ptr;
  tp, tp1, tp2:        typ_ptr;
  ip, ip1, ip2:        ide_ptr;

begin { IDE_INIT }
  curr_lex  :=  0;                              { Init current lex }
  curr_disp := -1;                              { Init the display identifier level }
  cprc_disp :=  0;                              { Init the current procedure display to standard display }
  lex_ident_level[0] := 0;                      { Init lex index list }
  pr := nil;
  NEW( pr );                                    { Creates a standard procedure record }
  NEW_DISP_LEVEL( pr, dsp_package );            { Creates an empty Standard Display }
  { Define a virtual Procedure as Owner of Standard def. }
  pro_current := pr;
  with pr^ do
  begin
    IDE_CREATE_NAME( '.standard.' );
    NEW( pro_stdname );
    pro_next            :=         nil;
    pro_link            :=         nil;
    pro_flags           :=          [];
    pro_stdname^        :=    sy_ident;         { Set the standard name }
    pro_operator        :=       no_op;
    pro_geneide         :=         nil;
    pro_idetree         :=         nil;
    pro_idelast         :=         nil;
    pro_parmlst         :=         nil;
    pro_lex             :=           0;
    pro_parmsize        :=           0;
    pro_nparm           :=           0;
    pro_typ             :=         nil;
    pro_prmtyls         :=         nil;
    pro_pkind           := pro_standard         { We are creating the standard package record }
  end;

  { Init for none standard types }

  IDE_NEW_TYP( form_wild , tp );                { Create the wild type }
  tp^.typ_size := 1;                            { Give a none dynamique size to wild type }

  for cur_form := form_pointer to form_free do
    typ_std[cur_form] := tp;

  { Define standard type integer }

  IDE_NEW_TYP_RANGE( -maxint, maxint, nil, int_typ );
  int_typ^.typ_fxdrange := false;               { Integer is The father of all Number types }
  int_typ^.typ_min := int_typ^.typ_min - 1;
  IDE_CREATE_NAME( 'integer' );                 { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, int_typ, ip );
  int_typ^.typ_ide := ip;                       { Set the reverse pointer }
  typ_std[form_int] := int_typ;

  { Define standard type unsigned }

  IDE_NEW_TYP_RANGE( 0, -1, nil, uns_typ );
  uns_typ^.typ_fxdrange := false;               { Unsigned is not a range in Integer types }
  IDE_CREATE_NAME( 'unsigned' );                { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, uns_typ, ip );
  uns_typ^.typ_ide := ip;                       { Set the reverse pointer }
  uns_typ^.typ_parent := int_typ;
  uns_typ^.typ_unsigned := true;

  { Partial Define Standard type boolean }
  IDE_NEW_TYP_RANGE( 0, 0, nil, tp );
  int_typ^.typ_fxdrange := false;               { Boolean is an Independant types }
  tp^.typ_form := form_lit;
  tp^.typ_size := 1;
  typ_std[form_lit] := tp;

  { Define standard type character }
  IDE_NEW_TYP_RANGE( 0, 255, nil, tp );
  int_typ^.typ_fxdrange := false;               { Char is an Independant types }
  with tp^ do
  begin
    typ_comp_size := LGT_NEW_ECONST( typ_std[form_int], 256 );
    typ_size := 1; typ_form := form_char
  end;
  IDE_CREATE_NAME( 'char' );                    { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_ide := ip;
  typ_std[form_char] := tp;


  { Set the single type ... }
  IDE_NEW_TYP( form_single, tp );
  tp^.typ_size := 4;
  IDE_CREATE_NAME( 'single');                   { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_ide := ip;
  typ_std[form_single] := tp;


  { ... and the double type }
  IDE_NEW_TYP( form_double, tp );
  tp^.typ_size := 8;
  IDE_CREATE_NAME( 'double');                   { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_ide := ip;
  typ_std[form_double] := tp;


  typ_std[form_record] := nil;                  { Set for pas_xxx.std definition of string }
  typ_std[form_array]  := nil;
  typ_std[form_file]   := nil;


  { Create all wild types }
  {***********************}

  { Create nil type }
  IDE_CREATE_NAME( '$wild_pointer' );
  IDE_NEW_TYP( form_nil, tp );
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 4;
  tp^.typ_ide := ip;
  tp^.typ_eltype := typ_std[form_wild];
  typ_std[form_nil] := tp;

  { Create wlit type }
  IDE_CREATE_NAME( '$wild_literal' );
  IDE_NEW_TYP( form_wlit, tp );
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 1; tp^.typ_ide := ip;
  typ_std[form_wlit] := tp;

  { Create ennum type }
  IDE_CREATE_NAME( '$wild_ennum' );
  IDE_NEW_TYP( form_ennum, tp );
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 4; tp^.typ_ide := ip;
  typ_std[form_ennum] := tp;

  { Create wild type }
  IDE_CREATE_NAME( '$wild_thing' );
  tp := typ_std[form_wild];
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  typ_std[form_wild] := tp;

  { Create equv type }
  IDE_CREATE_NAME( '$wild_equivalent' );
  IDE_NEW_TYP( form_equv, tp );
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  typ_std[form_equv] := tp;

  { Create eqst type }
  IDE_CREATE_NAME( '$wild_same' );
  IDE_NEW_TYP( form_eqst, tp );
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  typ_std[form_eqst] := tp;

  { Create eqse type }
  IDE_CREATE_NAME( '$wild_set_element' );
  IDE_NEW_TYP( form_eqse, tp );
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  typ_std[form_eqse] := tp;

  IDE_CREATE_NAME( '$wild_file' );
  IDE_NEW_TYP( form_wfile, tp );                { Define wild set }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  VAL_NEW( tp^.typ_inival, typ_std[form_nil] );
  tp^.typ_inival^.val_ival := 0;
  typ_std[form_wfile] := tp;

  dst_seta := max_seta;                         { Maximum size of a dst set in bits }
  dst_setw := max_setw;                         { Maximum size of a dst word set in bits }
  dst_seti := max_seti;                         { Maximum size of a dst set in word set }

  IDE_CREATE_NAME( '$wild_simple_set' );
  IDE_NEW_TYP( form_wset, tp );                 { Define wild small set }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size        := dst_setw div 8;
  tp^.typ_ide         := ip;
  tp^.typ_cardinality := dst_setw;
  tp^.typ_seltype     := int_typ;
  typ_std[form_wset]  := tp;

  IDE_CREATE_NAME( '$wild_large_set' );
  IDE_NEW_TYP( form_wlset, tp );                { Define wild large set }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size        := (dst_setw*dst_seti + 7) div 8;
  tp^.typ_ide         := ip;
  tp^.typ_cardinality := dst_seta;
  tp^.typ_seltype     := int_typ;
  typ_std[form_wlset] := tp;

  IDE_CREATE_NAME( '$wild_set' );
  IDE_NEW_TYP( form_wwset, tp );                { Define wild set }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size        := dst_setw div 8;
  tp^.typ_ide         := ip;
  tp^.typ_cardinality :=  0;
  typ_std[form_wwset] := tp;

  IDE_CREATE_NAME( '$wild_record' );
  IDE_NEW_TYP( form_wrecord, tp );              { Define wild record }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  typ_std[form_wrecord] := tp;

  IDE_NEW_TYP( form_null, tp );                 { define a null type for indirect procedure return type }
  tp^.typ_size := 0;
  typ_std[form_null] := tp;

  inte_size := typ_std[form_int]^.typ_size;     { Size of an Integer in Bytes }
  fptr_size := typ_std[form_nil]^.typ_size;     { Size of a Pointer in Bytes }


  IDE_CREATE_ATTRIBUT;

  IDE_CREATE_BUILTIN;

  GEN_CONV_ENTRY( typ_std[form_ennum],            int_typ, pcod_noop );
  GEN_CONV_ENTRY(   typ_std[form_nil],            uns_typ, pcod_noop );
  GEN_CONV_ENTRY( typ_std[form_ennum],            uns_typ, pcod_noop );
  GEN_CONV_ENTRY( typ_std[form_ennum], typ_std[form_char], pcod_noop );


  { Enter undeclared identifiers }
  IDE_CREATE_NAME( '.ul');
  IDE_NEW( cla_label,  typ_std[form_wild], ide_udptr[cla_label]  );
  IDE_CREATE_NAME( '.uu');
  IDE_NEW( cla_tparam, typ_std[form_wild], ide_udptr[cla_tparam] );
  IDE_CREATE_NAME( '.ut' );
  IDE_NEW( cla_type,   typ_std[form_wild], ide_udptr[cla_type]   );
  IDE_CREATE_NAME( '.uc' );
  IDE_NEW( cla_konst,  typ_std[form_wild], ide_udptr[cla_konst]  );
  with ide_udptr[cla_konst]^ do
  begin
    VAL_NEW( ide_value, typ_std[form_wild] );
    ide_value^.val_kind := form_null
  end;
  IDE_CREATE_NAME( '.uv' );
  IDE_NEW( cla_varbl, typ_std[form_wild], ide_udptr[cla_varbl] );
  IDE_CREATE_NAME( '.uf' );
  IDE_NEW( cla_field, typ_std[form_wild], ide_udptr[cla_field] );
  IDE_CREATE_NAME( '.ug' );
  IDE_NEW( cla_generic, typ_std[form_wild], ide_udptr[cla_generic] );
  IDE_CREATE_NAME( '.uw' );
  IDE_NEW( cla_genwfent, typ_std[form_wild], ide_udptr[cla_genwfent] );
  IDE_CREATE_NAME( '.up' );
  IDE_NEW( cla_fentry, typ_std[form_wild], ide_udptr[cla_fentry] );
  IDE_CREATE_NAME( '.us' );
  IDE_NEW( cla_statement, typ_std[form_wild], ide_udptr[cla_statement] );

  { Keep the Standard kind of store definitions for Store Operation }
  std_store_dgf := ope_table[ass_op]^.ope_gfirst;
  std_store_dgl := ope_table[ass_op]^.ope_glast;

  err_prt := true                               { Enable Undeclared Identifier Management }
end IDE_INIT;

end.
