{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                    ---  RUN-TIME KERNEL  ---                          *
*                ---  String management Library  ---                    *
*              ---  Version  2.0--0 -- 31/03/2006 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}
module cpas__dyn_string;

%include 'PASSRC:std__define.pas'{, list_on};


const
  dstr_maxsize   =     word_natural"last;      { Define the maximum size of a long string }
  dstr_capacity  =  2*$wild_pointer"size;      { Define the Capacity when the string is in the lstring descriptor }

type
  dstr_array = packed array[word_natural] of char;

  dstr_rec( cap: word_natural ) = record       { * dstring container record definition * }
                 nuse: word_unsigned;          { Number of string reference }
                 chtb: packed array[1..cap] of char    { The charactere table }
               end;

  { Define the local string body array (for string length <= dstr_capacity) }
  dstr_locstr = packed array[1..dstr_capacity] of char;

  dstr_aptr   =   ^dstr_array;                 { Define the Acces Pointer type of Character Array }

  dstr_rptr   =     ^dstr_rec;                 { Define the Acces Pointer type of String Container }

  dstr_flgty  = (    dstr_loc,                 { String is Local (for length <= dstr_capacity) }
                     dstr_fix,                 { String container has a fixed size (and should not be freed) }
                     dstr_tmp,                 { String is temporary }
                     dstr_srf,                 { String is a sub-reference }
                     dstr_nfr,                 { String is link to not free-able array of char (it is not necessarly a container) }
                     dstr_ovr,                 { String Reference Overflow flag }
                     dstr_ovs                  { String Size Overflow flag }
                );

  dstr_sflags = set of dstr_flgty use 16,16;   { Flags set type (forced to use two bytes /one word/) }

  dstr = record                                { * Large String Descriptor Definition Record * }
    length:        word_unsigned;              { Length of the string }
    flags:     set of dstr_flgty;              { String Flags }
    case boolean of
      false:( body:  dstr_locstr);             { Local (For Short String) string body }
      true: ( arr:     dstr_aptr;              { Table of character Access Pointer }
              rec:     dstr_rptr)              { String Container Access Pointer }
  end
      := [0,[], true, nil, nil];               { Initiale value of this kind of object }


var
  dstr_empty: [global] dstr := [ 0, [], true, nil, nil ];

  rd_idx, wr_idx:         integer;             { Index for READV/WRITEV operations }


  lstr_dscr: fild_rec := ( nil, nil, nil, nil, nil, nil,
                           nil,        { Filename pointer (string pointer) }
                          -1,          { string READV/WRITEV descriptor }
                           1,          { File of char (text) }
                           0,          { Size of the buffer }
                           0,          { Buffer count (Buffer is empty) }
                           0,          { Buffer decount for update read }
                           0,          { Index for update write }
                           0,          { Position in BUFFER UNIT for Map Buffer }
[lio_vir,lio_txt,lio_std,lio_est]      { File status }
                         );

  spc_arr: [static] packed array[1..4] of char := '    ';      { Cte. Character table for file^ access not undefined }



function  MAJOR_CHAR( ch: char ): char; external 'PAS__MAJOR_CHAR';

function  MINOR_CHAR( ch: char ): char; external 'PAS__MINOR_CHAR';

function  READ_CHAR_ARRAY( var chtb: packed array[len: integer] of char;
                               fld: integer := 0; bsep: boolean := false ): integer;
external 'READ_CHAR_ARRAY';




[global 'PAS_DSTR__CREATE']
procedure DSTR_CREATE( var str: dstr; len: integer := 0; btmp, bfix: boolean := false );
begin
  with str do
  begin
    if len > 0 then length := len;
    if length > dstr_capacity then
    begin
      NEW( rec, length );
      rec^.nuse := 1;
      arr := rec^.chtb[1]"address;
      if bfix then flags := [dstr_fix]
              else flags := []
    end
    else flags := [dstr_loc];
    if btmp and not bfix then flags := flags + [dstr_tmp]
  end
end DSTR_CREATE;



procedure NEW_REFERENCE( var str: dstr );
begin
  with str do
    if not (dstr_loc in flags) then
    with rec^ do
(*    if nuse > word_unsigned"last then flags := flags + [dstr_ovr]
                                   else *)
      nuse := SUCC( nuse )
end NEW_REFERENCE;



[global 'PAS_DSTR__FREE']
procedure DSTR_FREE( var str: dstr );
begin
  with str do
  begin
    if not (dstr_loc in flags) then
      if dstr_fix in flags then
      begin
        arr    := rec^.chtb[1]"address;
        length := 0
      end
      else
      begin
        if not (dstr_nfr in flags) and (rec <> nil) then
        with rec^ do
        begin
          nuse := PRED( nuse );
          if nuse = 0 then DISPOSE( rec );
        end;
       length :=     0;
       flags  := flags*[dstr_tmp];
       arr    := nil;
       rec    := nil
     end
  end
end DSTR_FREE;



[global 'PAS_DSTR__STRING_C']
function  DSTR_STRING_C( ch: char; btmp: boolean := false ): dstr;
{ Get a char to build a lstring }
var
  res: dstr;

begin
  with res do
  begin
    length := 1;
    flags  := [dstr_loc];
    if btmp then flags := flags + [dstr_tmp];
    body[] := ch
  end;
  DSTR_STRING_C := res
end DSTR_STRING_C;



[global 'PAS_DSTR__STRING_S']
function  DSTR_STRING_S( in_var strg: string; i, j: integer := 0; btmp: boolean := false ): dstr;
{ Get a string (or a sub-string) to build a lstring reference }
var
  res: dstr;

begin
  res := dstr_empty;
  if (strg.length > 0) and (i <= strg.length) then
  with res do
  begin
    if i < 1 then i := 1;
    flags := [dstr_srf,dstr_nfr,dstr_fix];
    arr   := strg[i]"address;
    rec   :=             nil;
    if (j <= 0) or (j + i - 1 > strg.length) then length := strg.length - i + 1
                                             else length := j;
    if btmp then flags := flags + [dstr_tmp];
  end;
  DSTR_STRING_S := res
end DSTR_STRING_S;



[global 'PAS_DSTR__STRING_A']
function  DSTR_STRING_A( in_var strg: packed array[sz: integer] of char;
                                i, j:                      integer := 0;
                                btmp:                  boolean := false
                       ): dstr;
{ Get a string or an array of char to build a lstring reference }
var
  res: dstr;

begin
  res := dstr_empty;
  if i <= sz then
  with res do
  begin
    if i < 1 then i := 1;
    flags := [dstr_srf,dstr_nfr,dstr_fix];
    arr   := strg[i]"address;
    rec   :=             nil;
    if (j <= 0) or (j + i - 1 > sz) then length := sz - i + 1
                                    else length := j;
    if btmp then flags := flags + [dstr_tmp];
  end;
  DSTR_STRING_A := res
end DSTR_STRING_A;




[global 'PAS_DSTR__SUBSTR']
function  DSTR_SUBSTR( str: dstr; i, j: integer := 0 ): dstr;
{ The dstring SUBSTR function }
begin
  with str do
    if (length <= 0) or (i > length) then
      str := dstr_empty
    else
    begin
      if i <= 0 then i := 1;
      if (j <= 0) or (j + i - 1 > length) then length := length - i + 1
                                          else length := j;
      if dstr_loc in flags then
        { The string is local, we perform a local SUBSTR in memory }
        for ii := 1 to length do  body[ii] := body[ii + i - 1]
      else
      begin { The string is in a container/ or is a reference }
        arr := arr^[i]"address;
        if rec <> nil then NEW_REFERENCE( str )
      end;
      flags := flags + [dstr_srf]
    end;
  DSTR_SUBSTR := str
end DSTR_SUBSTR;



[global  'PAS_DSTR__COPY']
procedure DSTR_COPY( var dst, src: dstr );
var
  res: dstr;
  p, q: dstr_aptr;
  len: integer;

begin
  with dst do
  begin
    flags := flags - [dstr_ovs,dstr_ovr];      { Elliminate any Error flags }
    if dstr_fix in dst.flags then
    begin
      length := src.length;
      if dstr_loc in dst.flags then
        if dstr_loc in src.flags then body := src.body { Local src -> Local dst }
        else
        begin { Not local src -> Local dst }
          if length > dstr_capacity then begin  length := dstr_capacity; flags := flags + [dstr_ovs]  end;
          for ii := 1 to length do  body[ii] := src.arr^[ii]
        end
      else
        if dstr_loc in src.flags then
          for ii := 1 to length do  arr^[ii] := src.body[ii] { Local src -> Not local dst }
        else
        begin { Not Local src -> Not local dst }
          if length > rec^.cap then begin length := rec^.cap; flags := flags + [dstr_ovs]  end;
          for ii := 1 to length do  arr^[ii] := src.arr^[ii]
        end;
      if dstr_tmp in src.flags then DSTR_FREE( src )
    end
    else
    begin { Not fixed == pre allocated target }
      DSTR_FREE( dst );                        { Free the previous Target Location }
      length := src.length;
      if dstr_loc in src.flags then
      begin
        flags := flags + [dstr_loc]; body := src.body
      end
      else
        if src.flags*[dstr_srf,dstr_nfr,dstr_tmp,dstr_fix] = [dstr_tmp] then
        begin { We can do a copy of the descriptor ... }
          rec := src.rec; arr := src.arr; flags := flags - [dstr_loc];
          src := dstr_empty { and destroy the source that was temporary }
        end
        else
        begin { The original string can be a substr of an other string }
          DSTR_CREATE( dst,, dstr_tmp in flags );
          if dstr_loc in flags then
            { When the original string was a short substr of an other string }
            for ii := 1 to length do  body[ii] := src.arr^[ii]
          else
            for ii := 1 to length do  arr^[ii] := src.arr^[ii];
          if dstr_tmp in src.flags then DSTR_FREE( src )
        end
    end
  end
end DSTR_COPY;



procedure DSTR_VRD_END( fp: fild_ptr );
var
  veq: record case boolean of
    false:( pr: $wild_pointer );
    true:(  pi: ^integer )
  end;

begin
  with lstr_dscr do
  begin
    veq.pr := fild_rel;
    if fild_bufcnt > 0 then                    { String (File Buffer) Empty ? }
      { No just adjust the pointer when specified }
      if fild_rel <> nil then veq.pi^ := fild_bufsize - fild_bufcnt + 1
    else
    begin                                      { Set the end of string => that can be rise error }
      fild_bufcnt := 0;                        { Set eof reached }
      fild_curr   := spc_arr"address;
      fild_state  := fild_state + [lio_eof,lio_eol,lio_est];
      veq.pi^ := -1
    end
  end
end DSTR_VRD_END;




[global 'PAS_DSTR__SEL_INPUT']
procedure DSTR_SELECT_INPUT( var st: dstr; var ip: [optional] integer );
var
  ic: integer;

begin
  with st, lstr_dscr do
    if length > 0 then
    begin
      if ip"address <> nil then ic := ip       { Get the start index to use }
                           else ic :=  1;
      fild_curr    := arr^[ic]"address;        { Init the current character ptr. }
      fild_buf     := arr^[1]"address;         { Set the string body address }
      fild_rel     := ip"address;              { Set the index pointer }
      fild_pfname  := st"address;              { Set the string address }
      PAS__INS_PROC( fild_pro, DSTR_VRD_END ); { Install the end string procedure }
      fild_bufsize := length;                  { Set the buffer length to string the length }
      fild_bufcnt  := length - ic + 1;         { Init the character count down }
      fild_state   := [lio_inp,lio_vir,lio_txt,lio_std]        { Set the init state }
    end
end DSTR_SELECT_INPUT;




procedure DSTR_VWR_END( fp: fild_ptr );
var
  veq: record case boolean of
    false:( pr: $wild_pointer );
    true:(  pw: ^word_unsigned )
  end;

begin
  with lstr_dscr do
  begin
    veq.pr  := fild_rel;
    veq.pw^ := fild_bufcnt;                    { Update the User Byte Count Variable( <string>.length }
    if lio_est in fild_state then PAS__ERROR( 54 )
                             else fild_state := fild_state + [lio_eof,lio_est]
  end
end DSTR_VWR_END;



[global 'PAS_DSTR__SEL_OUTPUT']
procedure DSTR_SELECT_OUTPUT( var st: dstr; bini: boolean := true );
var
  ic: integer;

begin
  with st, lstr_dscr do
    if dstr_fix in flags then
    begin
      if bini then length := 0;
      arr := rec^.chtb[1]"address;             { Reset any SUBSTR effect }
      fild_buf      := rec^.chtb[1]"address;   { Set the Character Array address }
      fild_rel      := length"address;         { Set the index pointer }
      fild_pfname   := st"address;             { Set the string address }
      PAS__INS_PROC( fild_pro, DSTR_VWR_END ); { Install the end string proc }
      fild_bufsize  := rec^.cap;               { Init the buffer/string size ... }
      if bini then
      begin
        fild_curr   := rec^.chtb[1]"address;   { Set the current pointer }
        fild_bufcnt := 0
      end
      else
      begin
        fild_curr   := rec^.chtb[length+1]"address;
        fild_bufcnt := length;                 { ... and continue on the same string }
      end;
      fild_state   := [lio_out,lio_vir,lio_txt,lio_std]        { Set the init state }
    end
end DSTR_SELECT_OUTPUT;




[global 'PAS_DSTR__READ']
procedure DSTR_READ( var st: dstr; fld: integer := 0; bsep: boolean := false );
begin
  with st do
    if dstr_fix in flags then
    begin
      arr := rec^.chtb[1]"address;
      length := READ_CHAR_ARRAY( rec^.chtb, fld, bsep ) - 1
    end
end DSTR_READ;



[global 'PAS_DSTR__WRITE']
procedure DSTR_WRITE( var st: dstr; f, p: integer := -1; sp: char := ' ' );
begin
  if st.length > 0 then
    WRITE$OBJECT( st.arr, st.length, f, p, sp )
end DSTR_WRITE;




[global 'PAS_DSTR__CONCAT_LL']
function  DSTR_CONCAT_LL( var s1, s2: dstr ): dstr;
var
  res:           dstr;
  len, shf:   integer;
  p1, p2:   dstr_aptr;

begin
  with res do
  begin
    if s1.length = 0 then
      if s2.length = 0 then res := dstr_empty
                       else begin  res := s2; NEW_REFERENCE( res )  end
    else
    if s2.length = 0 then begin res := s1; NEW_REFERENCE( res )  end
    else
    begin
      len := s1.length + s2.length;
      flags := [dstr_tmp];
      if dstr_loc in s1.flags then p1 := s1.body[1]"address else p1 := s1.arr;
      if dstr_loc in s2.flags then p2 := s2.body[1]"address else p2 := s1.arr;
      shf := s1.length;
      if len <= dstr_capacity then
      begin
        length := len;
        flags := [dstr_loc];
        for ii := 1 to s1.length do  body[ii] := p1^[ii];
        for ii := 1 to s2.length do  body[ii + shf] := p2^[ii]
      end
      else
      begin
        if len > dstr_maxsize then
        begin
          len := dstr_maxsize;
          flags := flags + [dstr_ovr]
        end;
        length := len;
        DSTR_CREATE( res );
        for ii := 1 to s1.length do  arr^[ii] := p1^[ii];
        for ii := 1 to s2.length do  arr^[ii + shf] := p2^[ii]
      end;
      if s1.flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( s1 );
      if s2.flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( s2 )
    end
  end;
  DSTR_CONCAT_LL := res
end DSTR_CONCAT_LL;




[global 'PAS_DSTR__CONCAT_LC']
function  DSTR_CONCAT_LC( var s1: dstr; c2: char ): dstr;
var
  s2:      dstr;
  l, i: integer;

begin
  s2 := DSTR_STRING_C( c2, true );
  DSTR_CONCAT_LC := DSTR_CONCAT_LL( s1, s2 )
end DSTR_CONCAT_LC;



[global 'PAS_DSTR__CONCAT_LS']
function  DSTR_CONCAT_LS( var s1: dstr; in_var st: string ): dstr;
var
  s2:  dstr;

begin
  s2 := DSTR_STRING_S( st,,, true );
  DSTR_CONCAT_LS := DSTR_CONCAT_LL( s1, s2 )
end DSTR_CONCAT_LS;



[global 'PAS_DSTR__CONCAT_LA']
function  DSTR_CONCAT_LA( var s1: dstr; in_var a2: packed array[sz: integer] of char ): dstr;
var
  s2:  dstr;

begin
  s2 := DSTR_STRING_A( a2,,, true );
  DSTR_CONCAT_LA := DSTR_CONCAT_LL( s1, s2 )
end DSTR_CONCAT_LA;



[global 'PAS_DSTR__CONCAT_CL']
function  DSTR_CONCAT_CL( c1: char; var s2: dstr ): dstr;
var
  s1:  dstr;

begin
  s1 := DSTR_STRING_C( c1, true );
  DSTR_CONCAT_CL := DSTR_CONCAT_LL( s1, s2 )
end DSTR_CONCAT_CL;



[global 'PAS_DSTR__CONCAT_SL']
function  DSTR_CONCAT_SL( in_var st: string; var s2: dstr ): dstr;
var
  s1:  dstr;

begin
  s1 := DSTR_STRING_S( st,,, true );
  DSTR_CONCAT_SL := DSTR_CONCAT_LL( s1, s2 )
end DSTR_CONCAT_SL;



[global 'PAS_DSTR__CONCAT_AL']
function  DSTR_CONCAT_AL( in_var a1: packed array[sz: integer] of char; var s2: dstr ): dstr;
var
  s1:  dstr;

begin
  s1 := DSTR_STRING_A( a1,,, true );
  DSTR_CONCAT_AL := DSTR_CONCAT_LL( s1, s2 )
end DSTR_CONCAT_AL;



[global 'PAS_DSTR__GET_CHAR']
function  DSTR_GET_CHAR( in_var src: dstr; i: integer ): char;
var
  ch:     char;
  l:   integer;
  p: dstr_aptr;

begin
  with src do
    if (i > 0) and (i <= length) then
      if dstr_loc in flags then DSTR_GET_CHAR := body[i]
                           else DSTR_GET_CHAR := arr^[i]
    else
      DSTR_GET_CHAR := CHR( 0 )
end DSTR_GET_CHAR;



[global 'PAS_DSTR__INDEX_LC']
function  DSTR_INDEX_LC( var st: dstr; ch: char ): integer;  { Main string and char to find }
var
  i: integer;
  p: dstr_aptr;

begin
  with st do
  begin
    if length > 0 then
    begin
      if dstr_loc in flags then p := body[1]"address
                           else p := arr;
      i :=      1;
      while (i <= length) and (p^[i] <> ch) do  i := SUCC( i );
      if i > length then i := 0
    end
    else i := 0;
    if flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( st )
  end;
  DSTR_INDEX_LC := i
end DSTR_INDEX_LC;



[global 'PAS_DSTR__INDEX_LL']
function  DSTR_INDEX_LL( var s1, s2: dstr ): integer;        { Main string and sub-string to find }
var
  find:                       boolean;
  ch:                            char;
  i1, i2, j1, l1, l2, r, s:   integer;
  p1, p2:                   dstr_aptr;

begin
  r := 0;
  if (s1.length > 0) and (s2.length > 0) then
  begin
    s := s1.length - s2.length;
    if s > 0 then
    begin
      if dstr_loc in s1.flags then p1 := s1.body[1]"address else p1 := s1.arr;
      if dstr_loc in s2.flags then p2 := s2.body[1]"address else p2 := s2.arr;

      l1 := s + 1;
      l2 := s2.length;
      i1 := 1;
      ch := p2^[1];
      find := false;
      while (i1 <= l1) and not find do
      begin
        if p1^[i1] = ch then
        begin
          j1 := i1 + 1; i2 := 2;
          while (i2 <= l2) and (p1^[j1] = p2^[i2]) do
          begin  j1 := j1 + 1; i2 := i2 + 1  end;
          find := i2 > l2
        end;
        i1 := i1 + 1
      end;
      if find then r := i1
    end;
    if s1.flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( s1 );
    if s2.flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( s2 )
  end;
  DSTR_INDEX_LL := r
end DSTR_INDEX_LL;



[global 'PAS_DSTR__INDEX_LA']
function  DSTR_INDEX_LA( var    s1: dstr;              { Main string and sub-string to find }
                         in_var sa: packed array[sz: integer] of char ): integer;
var
  s2: dstr;

begin
  s2 := DSTR_STRING_A( sa,,, true );
  DSTR_INDEX_LA := DSTR_INDEX_LL( s1, s2 )
end DSTR_INDEX_LA;



[global 'PAS_DSTR__NINDEX_LC']
function  DSTR_NINDEX_LC( var st:            dstr;     { String where search ch }
                              ch:            char;     { Character to find }
                              nb:         integer;     { Number of Occurence }
                              ip:   integer := -1;     { Start point in s }
                              nc: boolean := true      { Case Yes/No Sensitive [Yes] }
                        ): integer;
var
  c1:       char;
  fnd:   boolean;
  p:   dstr_aptr;

begin
  if not nc then ch := MAJOR_CHAR( ch );
  fnd := false;
  with st do
    if length <= 0 then ip := 0
    else
    begin
      if dstr_loc in st.flags then p := st.body[1]"address else p := st.arr;
      if nb >= 0 then
      begin    { Positive Scan }
        if nb = 0 then nb := 1;
        if ip < 1 then ip := 1;
        while (ip <= length) and not fnd do
        begin
          c1 := p^[ip];
          if not nc then c1 := MAJOR_CHAR( c1 );
          if ch = c1 then
          begin  nb := PRED( nb ); fnd := (nb = 0)  end;
          if not fnd then ip := ip + 1
        end
      end
      else
      begin    { Negative Scan }
        if (ip > length) or (ip < 0) then ip := length;
        while (ip > 0) and not fnd do
        begin
          c1 := p^[ip];
          if not nc then c1 := MAJOR_CHAR( c1 );
          if ch = c1 then
          begin  nb := PRED( nb ); fnd := (nb = 0)  end;
          if not fnd then ip := ip - 1
        end
      end;
      if flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( st )
    end;
  if not fnd then ip := 0;
  DSTR_NINDEX_LC := ip
end DSTR_NINDEX_LC;



[global 'PAS_DSTR__NINDEX_LL']
function  DSTR_NINDEX_LL( var s1, s2:        dstr;     { Main string and sub-string to find }
                              nb:         integer;     { Number of Occurence }
                              ip:   integer := -1;     { Start point in s }
                              nc: boolean := true      { Case  Yes/No Sensitive [yes] }
                        ): integer;
var
  ie, i1, i2, j, l1, l2, sd: integer;
  c1, c2:        char;
  fnd:        boolean;
  p1, p2:   dstr_aptr;

begin { DSTR_NINDEX_L }
  fnd := false;
  if (s1.length = 0) and (s2.length = 0) then
  begin
    sd := s1.length - s2.length;
    if sd > 0 then
    begin
      if dstr_loc in s1.flags then p1 := s1.body[1]"address else p1 := s1.arr;
      if dstr_loc in s2.flags then p2 := s2.body[1]"address else p2 := s2.arr;
      l1 := sd + 1;
      l2 := s2.length;
      c2 := p2^[1];
      if not nc then c2 := MAJOR_CHAR( c2 );
      if nb >= 0 then
      begin { Positive Scan }
        if nb = 0 then nb := 1;
        if ip < 1 then ip := 1;
        while (ip <= l1) and not fnd do
        begin
          c1 := p1^[ip];
          if not nc then c1 := MAJOR_CHAR( c1 );
          if c1 = c2 then
          begin
            i1 := ip + 1;
            i2 := 2;
            fnd := true;
            while (i2 <= l2) and fnd do
            begin
              if nc then fnd := (p1^[i1] = p2^[i2])
                    else fnd := (MAJOR_CHAR( p1^[i1] ) = MAJOR_CHAR( p2^[i2] ));
              i1 := SUCC( i1 ); i2 := SUCC( i2 )
            end;
            if fnd then begin  nb := PRED( nb ); fnd := (nb = 0)  end
          end;
          if not fnd then ip := SUCC( ip )
        end
      end
      else
      begin { Negative Scan }
        if (ip > l1) or (ip < 0) then ip := l1;
        while (ip > 0) and not fnd do
        begin
          c1 := p1^[ip];
          if not nc then c1 := MAJOR_CHAR( c1 );
          if c1 = c2 then
          begin
            i1 := ip + 1;
            i2 := 2;
            fnd := true;
            while (i2 <= l2) and fnd do
            begin
              if nc then fnd := (p1^[i1] = p2^[i2])
                    else fnd := (MAJOR_CHAR( p1^[i1] ) = MAJOR_CHAR( p2^[i2] ));
              i1 := SUCC( i1 ); i2 := SUCC( i2 )
            end;
            if fnd then begin  nb := PRED( nb ); fnd := (nb = 0)  end
          end;
          if not fnd then ip := PRED( ip )
        end
      end
    end
  end;
  if s1.flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( s1 );
  if s2.flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( s2 );
  if not fnd then ip := 0;
  DSTR_NINDEX_LL := ip
end DSTR_NINDEX_LL;



[global 'PAS_DSTR__NINDEX_LA']
function  DSTR_NINDEX_LA(        s1:            dstr;  { Main string and sub-string to find }
                          in_var sa: packed array[sz: integer] of char;
                                 nb:         integer;  { Number of Occurence }
                                 ip:   integer := -1;  { Start point in s }
                                 nc: boolean := true   { Case  Yes/No Sensitive [yes] }
                        ): integer;
var
  s2: dstr;

begin
  s2 := DSTR_STRING_A( sa,,, true );
  DSTR_NINDEX_LA := DSTR_NINDEX_LL( s1, s2, nb, ip, nc )
end DSTR_NINDEX_LA;



[global 'PAS__DSTR_LENGTH']
function DSTR_LENGTH( in_var s: dstr ): integer;
begin
  DSTR_LENGTH := s.length
end DSTR_LENGTH;



[global 'PAS__DSTR_MATCH_LL']
function DSTR_MATCH_LL( var s1, s2: dstr ): integer;
var
  i1, i2, n, m:   integer;
  p1, p2:       dstr_aptr;

begin { DSTR_MATCH_LL }
  if s1.length = 0 then
    if s2.length = 0 then DSTR_MATCH_LL :=  0
                     else DSTR_MATCH_LL := -1
  else
  begin
    if s2.length = 0 then DSTR_MATCH_LL :=  1
    else
    begin
      if dstr_loc in s1.flags then p1 := s1.body[1]"address else p1 := s1.arr;
      if dstr_loc in s2.flags then p2 := s2.body[1]"address else p2 := s2.arr;
      if s1.length < s2.length then n := s1.length
                               else n := s2.length;
      i1 := 1; i2 := 1;
      while (i1 <= n) and (p1^[i1] = p2^[i2]) do
      begin  i1 := SUCC( i1 ); i2 := SUCC( i2 )  end;
      if i1 > n then m := s1.length - s2.length
                else m := ORD( p1^[i1] ) - ORD( p2^[i2] )
    end;
    DSTR_MATCH_LL := m
  end;
  if s1.flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( s1 );
  if s2.flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( s2 )
end DSTR_MATCH_LL;


[global 'PAS__DSTR_MATCH_LA']
function DSTR_MATCH_LA( var    s1: dstr;
                        in_var sa: packed array[sz: integer] of char
                      ): integer;
var
  s2: dstr;

begin
  s2 := DSTR_STRING_A( sa,,, true );
  DSTR_MATCH_LA := DSTR_MATCH_LL( s1, s2 )
end DSTR_MATCH_LA;



[global 'PAS__DSTR_MATCH_AL']
function DSTR_MATCH_AL( in_var sa: packed array[sz: integer] of char;
                        var    s2: dstr
                      ): integer;
var
  s1: dstr;

begin
  s1 := DSTR_STRING_A( sa,,, true );
  DSTR_MATCH_AL := DSTR_MATCH_LL( s1, s2 )
end DSTR_MATCH_AL;


[global 'PAS__DSTR_MATCH_LS']
function DSTR_MATCH_LS( var s1: dstr; in_var st: string ): integer;
var
  s2: dstr;

begin
  s2 := DSTR_STRING_S( st,,, true );
  DSTR_MATCH_LS := DSTR_MATCH_LL( s1, s2 )
end DSTR_MATCH_LS;



[global 'PAS__DSTR_MATCH_SL']
function DSTR_MATCH_SL( in_var st: string; var s2: dstr ): integer;
var
  s1: dstr;

begin
  s1 := DSTR_STRING_A( st,,, true );
  DSTR_MATCH_SL := DSTR_MATCH_LL( s1, s2 )
end DSTR_MATCH_SL;





[global 'PAS_DSTR__LSEP_LA']
procedure DSTR_STRING_LOCATE_SEP( var st: dstr;
                                  var sp: packed array[sz: integer] of char;
                                  var tp: array[nsp:integer] of byte;
                                  var ie: integer
                                );
var
  i, j:   integer;
  p:    dstr_aptr;

begin
  ie := 0;
  with st do
  if length > 0 then
  begin
    if dstr_loc in flags then p := body[1]"address else p := arr;
    for i := 1 to length do
    begin
      j := 1;
      while (j <= sz) and (sp[j] <> p^[i]) do  j := j + 1;
      if j <= sz then
      begin { Separator found }
        ie := SUCC( ie );
        if ie >= nsp then begin  ie := -PRED( ie ); goto Et_End  end;
        tp[ie] := j; ie := SUCC( ie ); tp[ie] := i
      end
    end
  end;
Et_End:
end DSTR_STRING_LOCATE_SEP;



[global 'PAS_DSTR__LT_CHLL']
function DSTR__LT_LL ( var s1, s2: dstr ): boolean;
begin
  DSTR__LT_LL := DSTR_MATCH_LL( s1, s2 ) < 0
end DSTR__LT_LL;

[global 'PAS_DSTR__LE_CHLL']
function DSTR__LE_LL ( var s1, s2: dstr ): boolean;
begin
  DSTR__LE_LL := DSTR_MATCH_LL( s1, s2 ) <= 0
end DSTR__LE_LL;

[global 'PAS_DSTR__GE_CHLL']
function DSTR__GE_LL ( var s1, s2: dstr ): boolean;
begin
  DSTR__GE_LL := DSTR_MATCH_LL( s1, s2 ) >= 0
end DSTR__GE_LL;

[global 'PAS_DSTR__GT_CHLL']
function DSTR__GT_LL ( var s1, s2: dstr ): boolean;
begin
  DSTR__GT_LL := DSTR_MATCH_LL( s1, s2 ) > 0
end DSTR__GT_LL;

[global 'PAS_DSTR__EQ_CHLL']
function DSTR__EQ_LL ( var s1, s2: dstr ): boolean;
begin
  DSTR__EQ_LL := DSTR_MATCH_LL( s1, s2 ) = 0
end DSTR__EQ_LL;

[global 'PAS_DSTR__NE_CHLL']
function DSTR__NE_LL ( var s1, s2: dstr ): boolean;
begin
  DSTR__NE_LL := DSTR_MATCH_LL( s1, s2 ) <> 0
end DSTR__NE_LL;




type
  lstring = new dstr;



[global 'PAS_DSTR__ASSIGN_LC']
procedure DSTR_ASSIGN_LC( var trg: dstr; src: char );
begin
  if not (dstr_fix in trg.flags) and (trg.length <> 0) then DSTR_FREE( trg );
  trg := DSTR_STRING_C( src, dstr_tmp in trg.flags )
end DSTR_ASSIGN_LC;


[global 'PAS_DSTR__ASSIGN_LA']
procedure DSTR_ASSIGN_LA( var trg: lstring; in_var src: packed array[sz: integer] of char );
begin
  if not (dstr_fix in trg.flags) and (trg.length <> 0) then DSTR_FREE( trg );
  DSTR_COPY( trg, DSTR_STRING_A( src,,, true ) )
end DSTR_ASSIGN_LA;



[global 'PAS_DSTR__ASSIGN_LS']
procedure DSTR_ASSIGN_LS( var trg: lstring; in_var src: string );
begin
  if not (dstr_fix in trg.flags) and (trg.length <> 0) then DSTR_FREE( trg );
  DSTR_COPY( trg, DSTR_STRING_S( src,,, true ) )
end DSTR_ASSIGN_LS;



[global 'PAS_DSTR__ASSIGN_LL']
procedure DSTR_ASSIGN_LL( var trg: lstring; var src: lstring );
begin
  if not (dstr_fix in trg.flags) and (trg.length <> 0) then DSTR_FREE( trg );
  DSTR_COPY( trg, src )
end DSTR_ASSIGN_LL;


[global 'PAS_DSTR__ASSIGN_SL']
procedure DSTR_ASSIGN_SL( var trg: string; src: lstring );
var
  i, l:   integer;
  p:    dstr_aptr;

begin
  with src do
    if length > 0 then
    begin
      if dstr_loc in flags then p := body[1]"address
                           else p := arr;
      l := length;
      if l > trg.capacity then l := trg.capacity;
      trg.length := l;
      for ii := 1 to l do  trg[ii] := p^[ii];
      if flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( src )
    end
    else trg.length := 0
end DSTR_ASSIGN_SL;



[global 'PAS_DSTR__ASSIGN_AL']
procedure DSTR_ASSIGN_AL( var trg: packed array[sz: integer] of char; src: lstring );
var
  l:   integer;
  p: dstr_aptr;

begin
  with src do
    if length > 0 then
    begin
      if dstr_loc in flags then p := body[1]"address
                           else p := arr;
      l := length;
      if l > sz then l := sz;
      for ii := 1 to l do  trg[ii] := p^[ii];
      for ii := l + 1 to sz do  trg[ii] := ' ';
      if flags*[dstr_tmp,dstr_fix] = [dstr_tmp] then DSTR_FREE( src )
    end
    else for ii := l to sz do  trg[ii] := ' '
end DSTR_ASSIGN_AL;



end.
