{

*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                    ---  RUN-TIME KERNEL  ---                          *
*      ---  Routines to scan a directory with a filter LVL-1 ---        *
*              ---  Version  2.0--0 -- 31/03/2006 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

{%pragma trace 0;}
module PAS__SCAN_DIR_1;
type
  flt_ptr = ^flt_rec;                  { Define a Filtre Profil Entry Pointer }

  set_cha = set of char;               { Definition of a set of char }

  flt_rec = record                     { * Record Definition for string filtre profile }
              flt_nxt,                 { Link to next filtre element }
              flt_grp: flt_ptr;        { Link to first group filtre element }
              flt_pos: short_integer;  { Position in analyse string }
              flt_siz,                 { Total size of the entry (in char) }
              flt_pnch,                { Prefix size }
              flt_snch: byte;          { Suffix size }
              case flt_fst: boolean of         { To flag the string_entry/meta_character_entry }
                true:( flt_str: ^string );     { The related string }
                false:( flt_mch: set_cha )     { The set of available meta character }
            end;





[global]

function FSPC_CREATE_FILTER( in_var filtre: string ): flt_ptr;
var
  ph, pl, pp, pq: [static] flt_ptr;
  nc, il, ip, sz: [static] integer;
  bflt, bcom: [static] boolean;
  ch, c1, c2:    char;
  buf: string;

  function FSPC_NEW_ENTRY( bstr: boolean ): flt_ptr;
  var
    p: flt_ptr;

  begin
    if bstr then NEW( p, true )     { Create a string entry record }
            else NEW( p, false );   { Create a meta-char. entry record }
    with p^ do
    begin
      { Include the new entry in the filter entry list }
      flt_nxt := pl;                { Link with the other group element }
      pl := p;
      if ip = 0 then flt_grp := nil { Set to nil for the first floatting entry }
                else flt_grp := pq; { ... and set the link to first for the next. }
      flt_pos   :=       0;         { Init the Position }
      flt_fst   :=    bstr;         { Set the Entry kind }
      flt_pnch  :=      nc;         { Init the Prefix character count }
      flt_snch  :=       0;         { Init the Suffix character count }
      flt_siz   :=      nc;         { Init the entry character size }
      if bstr then flt_str := nil   { Init the specific entry part }
              else flt_mch := []
    end;
    FSPC_NEW_ENTRY := p
  end FSPC_NEW_ENTRY;

begin { FSPC_CREATE_FILTER }
  ph    :=   nil;
  pl    :=   nil;
  nc    :=     0;
  pp    :=   nil;
  pq    :=   nil;
  ip    :=     1;
  il    :=     1;
  bflt  := false;

  loop
  exit if il > filtre.length;
    ch := filtre[il];
    il := il + 1;
    case ch of
      '[': if il < filtre.length then
           begin
             { Create the meta_character entry }
             pp := FSPC_NEW_ENTRY( false );
             with pp^ do
             begin
               nc := nc + 1;        { set the character count }
               flt_siz  := nc;
               flt_pos  :=  ip;     { Set the position of string }
               { Get the first class character }
               c1 := filtre[il]; il := il + 1;
               if c1 = '!' then     { for a complement class }
               begin { ... Get first class char. }
                 bcom := true;      { Set the complement flag ... }
                 { ... and get the first class character }
                 c1 := filtre[il]; il := il + 1
               end else bcom := false;
               { Loop on the characters of class }
               loop
               exit if il > filtre.length;
                 ch := filtre[il]; il := il + 1;
                 if ch = '-' then
                 begin
                   { For a character range, put them in the char. class set }
               exit if il > filtre.length;
                   c2 := filtre[il]; il := il + 1;
                   for ch := c1 to c2 do
                     flt_mch := flt_mch + [ch];
               exit if il >= filtre.length;
                   ch := filtre[il]; il := il + 1
                 end
                 else
                   { For a single character, put it in the char. class set }
                   flt_mch := flt_mch + [c1];
               exit if (ch = ']') or (il > filtre.length);
                 c1 := filtre[il]; il := il + 1
               end;
               { Complement the set when required }
               if bcom then flt_mch := -flt_mch;
               if ip = 0 then
               begin { For floatting entry, set the position index for next entry }
                 pq := pp; ip := 1  { ... and keep the begin group pointer }
               end
             end;
             ip := ip + nc;         { Set the position for next entry }
             nc := 0                { Clear the wild character count for suffix }
           end;

      '?': if pp = nil then
             nc := nc + 1 { Count for next entry prefix }
           else
           begin { Update previous entry for suffix and total size }
             pp^.flt_snch := pp^.flt_snch  + 1;
             pp^.flt_siz  := pp^.flt_siz   + 1;
             ip := ip + 1
           end;

      '*': begin
             if nc <> 0 then        { The count of wild character was not zero }
               { We must create a new string entry with string }
               pp := FSPC_NEW_ENTRY( true );
             pp     :=   nil;       { Force the prefix count starting from zero }
             nc     :=     0;
             ip     :=     0        { Force the Floatting mode for the next entry }
           end;

    otherwise
      { Create the string entry }
      pp := FSPC_NEW_ENTRY( true );
      { Get the string }
      sz := 0;
      loop
        sz := sz + 1;
        buf[sz] := ch;
      exit if (il > filtre.length);
        ch := filtre[il];
      exit if (ch = '*') or (ch = '?') or (ch = '[');
        il := il + 1;
      end;
      buf.length := sz;
      nc := nc + sz;
      with pp^ do
      begin
        flt_pos  :=  ip;            { Set the position of string }
        flt_siz  :=  nc;            { Init the entry character size }
        if pq <> nil then flt_grp := pq;
        NEW( flt_str, sz );         { Allocate the related String }
        flt_str^ := buf;            { ... and set it }
        if ip = 0 then
        begin { For floatting entry, set the position index for next entry }
          pq := pp; ip := 1         { ... and keep the begin group pointer }
        end
      end;
      ip := ip + nc;                { Set the position for next entry }
      nc := 0                       { Clear the wild character count for suffix }
    end
  end;

  { The final specification is not a '*' when pp <> nil }
  ip :=   0;
  ph := nil;                        { Loop to reverse the entry order }
  bflt := (pp <> nil);
  while pl <> nil do
  with pl^ do
  begin
    if bflt then
    begin                           { Last specification was not a floatting entry }
      if flt_pos = 0 then bflt := false;
      ip := ip - flt_siz;
      flt_grp := nil;               { Do not loop for fixed entry }
      flt_pos := ip
    end;
    pp := pl;                       { Set the entry list in good order }
    pl := flt_nxt;
    flt_nxt := ph;
    ph := pp
  end;

(*
  pp := ph;
  WRITELN( ' *** For Filter = "', filtre, '" :' );
  while pp <> nil do
  with pp^ do
  begin
    WRITE( ' Entry : ' );
    if flt_fst then WRITELN( 'String' )
               else WRITELN( 'Meta' );
    WRITELN( ' Ipos = ', flt_pos:4, ', Linked in group = ', flt_grp <> nil );
    WRITELN( ' Prefix = ', flt_pnch:3, ', Suffix = ', flt_snch:3, ', Size = ', flt_siz:3 );
    if flt_fst then
    begin
      if flt_str <> nil then WRITELN( ' String = "', flt_str^, '".' )
    end
    else
    begin
      sz := 0;
      WRITE( ' Meta_Char = [');
      for cc := ' ' to CHR( 126 ) do
        if cc in flt_mch then
        begin
          if sz > 0 then WRITE( ',' );
          WRITE( '''', cc, '''' ); sz := sz + 1;
        end;
      WRITELN( '].' )
    end;
    WRITELN;
    pp := flt_nxt
  end;
*)

  FSPC_CREATE_FILTER := ph
end FSPC_CREATE_FILTER;


[global]
procedure FSPC_FREE_FILTER( var hp: flt_ptr );
var
  p1, p2: flt_ptr;

begin
  p1 := hp;
  hp := nil;
  while p1 <> nil do
  begin
    with p1^ do
    begin
      if flt_fst then
        if flt_str <> nil then DISPOSE( flt_str );
      p2 := flt_nxt
    end;
    DISPOSE( p1 );
    p1 := p2
  end
end FSPC_FREE_FILTER;



[global]
function FSPC_MATCH( pf: flt_ptr; in_var spc: string ): boolean;
{ Function to evaluate the matching between the
  given filter list (pf) and the given specification (spc) }
var
  ips, jps, lps: integer;
  bc: boolean;

begin
  bc  := true;
  lps := spc.length + 1;
  ips := 1;

(* WRITELN( ' Match "', spc, '"' ); *)

MAIN_LOOP:
  while (pf <> nil) and bc do
  with pf^ do
  begin
    bc := false;                    { Assume do not match until shown otherwise }
  exit if ips + flt_siz > lps;
    { There are enough characters to perform the matching test }
    ips := ips + flt_pnch;          { Skip the prefix character(s) }
    jps := lps - flt_snch;          { Set the float string field limit }
    if flt_fst then
    begin { string entry }
      if flt_str <> nil then        { A string is specified }
        { String Matching Request }
        if flt_pos = 0 then
        begin { Floating position }
          ips := INDEX( spc, flt_str^, 1, ips, true );
          exit MAIN_LOOP if ips = 0;
(* WRITELN( ' STR FLOAT FND in ', ips:4 ); *)
          ips := ips + flt_str^.length;
          exit MAIN_LOOP if ips >= jps 
        end
        else
        begin { Fixed position mode }
          if flt_pos < 0 then ips := lps + flt_pos;
          { Fixed Position from the begin (flt_pos < 0) or end of string }
          for k := 1 to flt_str^.length do
            if flt_str^.body[k] <> spc[ips] then
              if flt_grp <> nil then begin  pf := flt_grp; bc := true; goto ET_LOOP  end
                                else exit MAIN_LOOP
              else ips := ips + 1
(* ;WRITELN( ' STR FIX FND in ', ips-flt_str^.length:4 ) *)
        end
    end
    else
    begin { Meta Character }
      if flt_pos = 0 then
      begin { Floating position }
        repeat
        exit if spc[ips] in flt_mch;
          ips := ips + 1
        until ips >= jps;
        exit MAIN_LOOP if ips >= jps;
(* WRITELN( ' META FLOAT FND in ', ips:4 ); *)
       ips := ips + 1
      end
      else
      begin
        if flt_pos < 0 then ips := lps + flt_pos;
        { Fixed Position from the begin (if flt_pos < 0) else end of string }
        if spc[ips] in flt_mch then
          ips := ips + 1
        else
          if flt_grp <> nil then begin  pf := flt_grp; bc := true; goto ET_LOOP  end
                            else exit MAIN_LOOP
(* ;WRITELN( ' META FIX FND in ', ips-1:4 ); *)
      end
    end { if flt_str then };
    ips := ips + flt_snch;          { Skip the suffix character(s) }
    bc := true;
    pf := flt_nxt;
  ET_LOOP:
  end;
  FSPC_MATCH := bc
end FSPC_MATCH;



end PAS__SCAN_DIR_1.
