{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                      ---  RUN-TIME KERNEL  ---                        *
*                 ---  Run Time Error Management  ---                   *
*   Last revision of 31-Mar-2007 for cpas_lib V2.0-A (by P. wolfers)    *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

%pragma trace 0;
module PAS__ERROR;
const
  maxerrline  =  80;   { size of one error message line }
  msgfilespc  = 'PASENV:cpas_rtl.err';

type
  cntx_ptr = ^cntx_rec;

  cntx_rec = record
    cntx_prv: cntx_rec;
    cntx_pro,
    cntx_src: ^string;
    cntx_lng: integer
  end;

  errline = packed array[1..maxerrline] of char; { error line type }

var
  [global 'PAS__curr_cntx'] cntx_root: cntx_ptr := nil;

  errmsg: file of errline; { error messages random access file }



[global 'PAS__ERROR_GETMSG']
procedure PAS__ERROR_GETMSG(          n:               integer;
                             var msgstr:                string;
                             var msgfil:     [readonly] string );
{ to display an information line related to an error }
type
  keytyp = word_unsigned;

const
  maxerrkey = maxerrline div keytyp"size;


type
  filespc = string( 128 );

  err_rec = record case boolean of
    false:( msg:packed array[1..maxerrline] of char);   { Message line }
    true:(  key:packed array[1..maxerrkey] of keytyp);  { Array of key }
  end;


var
  maxdir, i, j, nt, rc: integer;
  cline:                err_rec;

begin { PAS__ERROR_GETMSG }
  msgstr.length := 0;
  OPEN( errmsg, msgfil, [read_file,direct_file,error_file] );
  if iostatus = 0 then
  begin { Success on OPEN }
    READ( errmsg, cline );      { Get the first directory record }
    maxdir := cline.key[1];     { Get the size of directory in record }
    rc     := maxdir;           { and initialize the message record count }
    i  :=  1;                   { Initialize the directory record count }
    j  :=  2;                   { start from the 2th key (first one is maxdir) }
main_loop:                      { *** Loop on the directory record *** }
    loop
      repeat                    { *** Loop on the directory record entry *** }
        rc := rc + 1;
        nt := cline.key[j];     { Get the error number for the directory entry }
      { Stop the search if found or end of directory }
      exit main_loop if (n = nt) or (nt <= 0);
        j  :=  j + 1            { scan the directory record }
      until (j > maxerrkey);
      j := 1; i := i + 1;       { Skip to next directory record }
    if i > maxdir then goto ET_Close;
      READ( errmsg, cline );    { and read the next directory record }
    end;

    if nt > 0 then
    begin { Message found }
      { Here the message must be found }
      SEEK( errmsg, rc );       { Get the rc'th record }
      READ( errmsg, cline );

      i := maxerrline;          { Size the message }
      while cline.msg[i] <= ' ' do i := i - 1;

      { Copy the selected message in the user string }
      if i > 0 then
      begin
        msgstr.length := i;
        while i > 0 do
        begin
          msgstr[i] := cline.msg[i]; i := i - 1
        end
      end
    end;
ET_Close:
    CLOSE( errmsg )             { Close the message file }
  end
end PAS__ERROR_GETMSG;



[global 'PAS__GET_RTLMSG']
procedure PAS__GET_RTLMSG( n: integer; var msg: string );
begin
  PAS__ERROR_GETMSG( n, msg, msgfilespc )
end PAS__GET_RTLMSG;




[global 'PAS__ERROR_OUTMSG']
procedure PAS__ERROR_OUTMSG( var      f:                  text;
                                      n:               integer;
                             var msgfil:     [readonly] string );
{ to display an information line related to an error }
var
  msgstr: string( maxerrline );

begin { PAS__ERROR_OUTMSG }
  PAS__ERROR_GETMSG( n, msgstr, msgfil );
  if msgstr.length > 0 then WRITELN( f, ' *** ', msgstr )
end PAS__ERROR_OUTMSG;




[global 'PAS__BACK_TRACING']
procedure PAS__BACK_TRACING( var f: text );
var
  bfirst: boolean := true;
  curr_cntx: cntx_ptr;

begin
  curr_cntx := cntx_root;
  while curr_cntx <> nil do
    with curr_cntx^ do
    begin
      if bfirst then WRITE( f, ' Detected' )
                else WRITE( f, '   called' );
      bfirst := false;
      WRITELN( f, ' at line # ', cntx_lng:6, ' of ', cntx_pro^:18,
                                             ' in file ', cntx_src^ );
      if curr_cntx = cntx_prv then
      begin
         WRITELN( f, ' Stop on Bad BACK_TRACING STACK ****' );
         PASCAL_EXIT( 4 )
      end;
      curr_cntx := cntx_prv
    end
end PAS__BACK_TRACING;


[global 'PAS__GEN_ERROR_MSG']
procedure PAS__GEN_ERROR_MSG( nerr: integer );
begin
  { Should be error file }
  WRITELN( err );
  WRITELN( err, ' *** CPAS Run Time Error # ', nerr:4 );
  PAS__ERROR_OUTMSG( err, nerr, msgfilespc );
  PAS__BACK_TRACING( err );
  WRITELN( err )
end { PAS__GEN_ERROR_MSG };

end.
