{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*            ---   Source INSYMBOL Lexical parsing   ---                *
*               ---  Version  2.3-A -- 31/01/2013 ---                   *
*                                                                       *
*           by :                                                        *
*                                                                       *
*              P. Wolfers                                               *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////


}


{************     CPAS  version    *************}


{
        *** modification(s) from major version ***


                        ----

                       nothing

                        ----

}

 
  {**************************************************}
  {*******            Program  Head            ******}
  {**************************************************}


(*
[inherit(    'lib:cpas_b__src',       { Use Basiclib Definitions }
             'lib:pas_env')]          { Use tree definitions }

*)

module PAS_INSYMBOL( Input, Output ); { input and output for user terminal }


{ *** Include basic compiler environment *** }
%include 'passrc:pcmp_env';



     {*********************************}
     { Source file specification saver }
     {*********************************}



[global]
procedure SET_SRCFILESPC( icd: integer );
var
  sp:  srf_ptr;
  str: string( 255 );

begin
  if icd >= 0 then
  begin
    str := FILE_SPECIFICATION( src_control^.src_file );
    if str.length = 0 then str := 'TT:';
    if (icd > 0) or (srf_list = nil) { Include Mode } then
    begin
      if srf_free = nil then
        NEW( sp ) { when no free record exist, create one source ref. record ... }
      else { ... else take it from the free list. }
      begin  sp := srf_free; srf_free := sp^.srf_previous  end;
      with sp^ do
      begin
        srf_previous := srf_list;
        srf_value    := nil;
        VAL_NEW( srf_value, nil )
      end;
      srf_list := sp
    end
    else { Chaine Mode }
      with srf_list^ do
      begin
        VAL_FREE( srf_value );
        VAL_NEW( srf_value, nil )
      end;
    with srf_list^.srf_value^ do
    begin
      val_kind := form_string;
      val_size := str.length;
      NEW( val_str, str.length );
      val_str^ := str
    end
  end
  else
  begin { eof Mode }
    sp := srf_list;
    with sp^ do
    begin
      srf_list := srf_previous;
      VAL_FREE( srf_value );
      srf_previous := srf_free
    end;
    srf_free := sp
  end;
  cntx_srinf := true
end SET_SRCFILESPC;





     {************************************************}
     { Title and Subtitle Listing of source managment }
     {************************************************}


[global]
procedure COMPILE_SET_TITLE;
var
  st: string( 255 );

begin 
  { Create a title string - temporary }
  with lst_current^ do
  begin
    if lst_title <> nil then DISPOSE( lst_title );
    st := FILE_SPECIFICATION( src_control^.src_file );
    if st.length = 0 then st := 'TT:';
    st := def_title||st||'".';
    NEW( lst_title, st.length );
    lst_title^ := st
  end
end COMPILE_SET_TITLE;



[global]
procedure COMPILE_SET_SBTTL( prc: pro_ptr );
var
  st: string( 255 );

begin
  { Create a title string - temporary }
  with lst_current^ do
  begin
    if lst_sbttl <> nil then DISPOSE( lst_sbttl );
    if prc^.pro_stdname <> nil then
      with prc^.pro_stdname^ do
      begin
        st := SUBSTR( s, 1, l );
        st := def_sbttl||st||'".';
        NEW( lst_sbttl, st.length );
        lst_sbttl^ := st
      end
  end
end COMPILE_SET_SBTTL;





     { INSYMBOL group functions and procedures }
     {*****************************************}


procedure SET_KEYWORD_TREE;

  procedure SETKEYWORD( in_var kname: string; skw: symbol; opkw: operator );
  var
    m, i: integer;
    p, p1, p2: keyword_ptr;


  begin { SETKEYWORD }
    NEW(p);
    with p^ do
    begin
      name.l := kname.length;
      for i := 1 to name.l do  name.s[i] := kname.body[i];
      leftp := nil; rightp := nil;
      symb.sy := skw; symb.op := opkw
    end;
    p1 := keyword_tree;
    if p1 <> nil then
    begin
      repeat
        p2 := p1 { keep the memory of the last p1 };
        with p1^ do
        begin
          m := MATCH( p^.name, name );
          if m > 0 then  p1 := rightp
                   else p1 := leftp
        end;
      until p1 = nil;
      if m > 0 then p2^.rightp := p
               else p2^.leftp := p
    end
    else keyword_tree := p
  end SETKEYWORD;

begin { SET_KEYWORD_TREE }
  keyword_tree := nil;

        {**** set keywords symbol operators ****}

  SETKEYWORD(        'or',     lgorop,     or_op );
  SETKEYWORD(       'xor',     lgorop,    xor_op );
  SETKEYWORD(       'and',    lgandop,    and_op );
  SETKEYWORD(       'not',      unaop,    not_op );
  SETKEYWORD(       'div',      mulop,   idiv_op );
  SETKEYWORD(       'mod',      mulop,   imod_op );
  SETKEYWORD(       'rem',      mulop,   irem_op );
  SETKEYWORD(        'in',      relop,     in_op );

        {**** set keywords symbol ****}

  SETKEYWORD(       'nil',      nilsy,     no_op );
  SETKEYWORD(     'label', labeldclsy,     no_op );
  SETKEYWORD(      'goto',     gotosy,     no_op );
  SETKEYWORD(      'type',     typesy,     no_op );
  SETKEYWORD(     'const',    constsy,     no_op );
  SETKEYWORD( 'user_statement',
                          statementsy,     no_op );
  SETKEYWORD(       'var',      varsy,     no_op );
  SETKEYWORD(    'in_var',    invarsy,     no_op );
  SETKEYWORD(   'out_var',   outvarsy,     no_op );
  SETKEYWORD(   'private',  privatesy,     no_op );
  SETKEYWORD(    'access',  pointersy,     no_op ); {tmp?}
  SETKEYWORD(      'file',     filesy,     no_op );
  SETKEYWORD(     'array',    arraysy,     no_op );
  SETKEYWORD(    'record',   recordsy,     no_op );
  SETKEYWORD(       'set',      setsy,     no_op );
  SETKEYWORD(       'use',      usesy,     no_op );
  SETKEYWORD(       'new',      newsy,     no_op );
  SETKEYWORD(      'open',     opensy,     no_op );
  SETKEYWORD(     'reset',    resetsy,     no_op );
  SETKEYWORD(   'rewrite',  rewritesy,     no_op );
  SETKEYWORD(    'append',   appendsy,     no_op );

  SETKEYWORD(      'read',     readsy,     no_op );
  SETKEYWORD(    'readln',   readlnsy,     no_op );
  SETKEYWORD(     'readv',    readvsy,     no_op );
  SETKEYWORD(     'write',    writesy,     no_op );
  SETKEYWORD(   'writeln',  writelnsy,     no_op );
  SETKEYWORD(    'writev',   writevsy,     no_op );

  SETKEYWORD(   'program',   programsy,    no_op );
  SETKEYWORD(    'module',    modulesy,    no_op );
  SETKEYWORD( 'procedure', proceduresy,    no_op );
  SETKEYWORD(  'function',  functionsy,    no_op );
  SETKEYWORD(    'return',    returnsy,    no_op );
  SETKEYWORD(   'forward',   forwardsy,    no_op );
  SETKEYWORD(    'static',    staticsy,    no_op );
  SETKEYWORD(    'global',    globalsy,    no_op );
  SETKEYWORD(    'packed',    packedsy,    no_op );
  SETKEYWORD(  'external',  externalsy,    no_op );
  SETKEYWORD(  'standard',  standardsy,    no_op );
  SETKEYWORD(    'inline',    inlinesy,    no_op );
  SETKEYWORD(     'begin',     beginsy,    no_op );
  SETKEYWORD(        'if',        ifsy,    no_op );
  SETKEYWORD(      'then',      thensy,    no_op );
  SETKEYWORD(      'else',      elsesy,    no_op );
  SETKEYWORD(     'while',     whilesy,    no_op );
  SETKEYWORD(    'repeat',    repeatsy,    no_op );
  SETKEYWORD(     'until',     untilsy,    no_op );
  SETKEYWORD(       'for',       forsy,    no_op );
  SETKEYWORD(      'loop',      loopsy,    no_op );
  SETKEYWORD(      'exit',      exitsy,    no_op );
  SETKEYWORD(      'case',      casesy,    no_op );
  SETKEYWORD(      'with',      withsy,    no_op );
  SETKEYWORD(       'end',       endsy,    no_op );
  SETKEYWORD( 'otherwise',     othersy,    no_op );
  SETKEYWORD(        'of',        ofsy,    no_op );
  SETKEYWORD(        'do',        dosy,    no_op );
  SETKEYWORD(        'to',        tosy,    no_op );
  SETKEYWORD(    'downto',    downtosy,    no_op );

  SETKEYWORD(   '%define',   mdefinesy,    no_op );
  SETKEYWORD(       '%if',       mifsy,    no_op );
  SETKEYWORD(    '%ifdef',    mifdefsy,    no_op );
  SETKEYWORD(  '%ifundef',  mifundefsy,    no_op );
  SETKEYWORD(     '%else',     melsesy,    no_op );
  SETKEYWORD(    '%endif',    mendifsy,    no_op );
  SETKEYWORD(   '%chaine',    chainesy,    no_op );
  SETKEYWORD(  '%include',   includesy,    no_op );
  SETKEYWORD(   '%pragma',    pragmasy,    no_op );


        {**** set micellious symbol ****}

  SETKEYWORD(      '%eof',      peofsy,    no_op );

	{**** end of the keyword list ****}

end SET_KEYWORD_TREE;



[global]
procedure INSYMBOL_SRC;
const    
  mdnam = 'INSY';
  ten = 10.0; one = 1.0;


type
  chartype = (ctl, oth, dig, let, quo,
              db0, db1, db2, db3,
              eos, eol,
              s00, s01, s02, s03, s04, s05, s06, s07,
              s08, s09, s10, s11, s12, s13, s14, s15, s16);

  chartabtype = array[CHR(0)..CHR(127)] of chartype;

  chartoktab = array[s00..s15] of sym_rec;

var
  chartab: [static] chartabtype := (
         { 0    1    2    3    4    5    6    7 }
  { 000 } eos, eol, ctl, ctl, ctl, ctl, ctl, ctl,
  { 010 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,
  { 020 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,
  { 030 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,
  { 040 } oth, s00, s01, let, let, let, s02, quo,
  { 050 } s03, s04, s05, s06, s07, s08, db3, s09,
  { 060 } dig, dig, dig, dig, dig, dig, dig, dig,
  { 070 } dig, dig, db0, s10, db1, s11, db2, oth,
  { 100 } let, let, let, let, let, let, let, let,
  { 110 } let, let, let, let, let, let, let, let,
  { 120 } let, let, let, let, let, let, let, let,
  { 130 } let, let, let, s12, s13, s14, s15, let,
  { 140 } oth, let, let, let, let, let, let, let,
  { 150 } let, let, let, let, let, let, let, let,
  { 160 } let, let, let, let, let, let, let, let,
  { 170 } let, let, let, oth, s00, oth, oth, ctl);

  chartok: [static] chartoktab := (
    (lgorop,    or_op ), {s00: '!' = '|'}
    (attrsign,  no_op ), {s01: '"'}
    (lgandop,   and_op), {s02: '&'}
    (lparen,    no_op ), {s03: '('}
    (rparen,    no_op ), {s04: ')'}
    (mulop,     mul_op), {s05: '*'}
    (addop,     add_op), {s06: '+'}
    (comma,     no_op ), {s07: ','}
    (addop,     sub_op), {s08: '-'}
    (mulop,     div_op), {s09: '/'}
    (semicolon, no_op ), {s10: ';'}
    (relop,     eq_op ), {s11: '='}
    (lbrack,    no_op ), {s12: '['}
    (unaop,     not_op), {s13: '\'}
    (rbrack,    no_op ), {s14: ']'}
    (indirsign, no_op )  {s15: '^'}
    );


var
  ivl, i, iprec, j, k, n, scale, i_radix: integer;
  radix, rdig, rexp, rfac, rval: double;
  pch: char;
  getnuchar, maxstr, found, sign, bint, bbase, bline_enabled: boolean;
  pkw: keyword_ptr;
 

procedure NEXTCH;
begin { NEXTCH }
  sy_ch := SRC_INCHAR;
  sy_cmin := sy_ch;
  if (sy_ch >= 'A') and (sy_ch <= 'Z') then sy_cmin := CHR( ORD( sy_ch ) + 32);
  if sy_cmin > CHR( 127) then sy_cmin := '?'
end NEXTCH;


procedure PUT_CHAR;
begin { PUT_CHAR }
  if not maxstr then
  if k < sy_string.capacity then
  begin
    sy_string.body[k] := sy_ch;
    k := SUCC(k)
  end
  else
  begin
    SRC_ERROR( mdnam, 12, e_error );
    maxstr := true
  end
end PUT_CHAR;
 

function TEST_FIGURES( ch: char ): integer;
var
  va: integer;

begin
  if (ch >= '0') and (ch <= '9') then va := ORD( ch ) - ORD( '0' )
  else
    if bbase and (ch >= 'a') and (ch <= 'f') then va := 10 + ORD( ch ) - ORD( 'a' )
    else va := -1;
  if va >= radix then va := -2;
  TEST_FIGURES := va
end TEST_FIGURES;



function FIGURES( ch: char ): integer;
var
  va: integer;
  be: boolean

begin
  va := TEST_FIGURES( ch );
  if va = -2 then
  begin
    va := 0; SRC_ERROR( 'FIGU', 16, e_error )
  end;
  FIGURES := va
end FIGURES;



begin { INSYMBOL_SRC }
  while sy_ch = ' ' do NEXTCH;
  getnuchar := true;
  with src_control^ do  src_wchpt := src_chidx;
  with sy_sym do
  case chartab[sy_cmin] of
    dig,db3: { number can be begin by digit or period }
      begin
        sy := period; { Assume '.' until shown otherwise}
        op := no_op;
        iprec := 0;
        rval := 0.0; rexp := ten; rfac := one; radix := ten;
        bbase := false;
        while chartab[sy_cmin] = dig do
        begin
          sy := intconst; { it is a number }
          rdig := ORD( sy_cmin ) - ORD( '0' );
          NEXTCH;
          rval := rval*ten + rdig;
          iprec := iprec + 1
        end;

        if (sy = intconst) and (sy_ch = '#') then
        begin { base specification  }
          NEXTCH;
          i_radix := ROUND( rval );
          rval := 0.0;
          if (i_radix < 2) or (i_radix > 16) then
          begin
            SRC_ERROR( mdnam, 14, e_error );
            i_radix := 10
          end
          else radix := i_radix;
          bbase := true;
          loop
            rdig := FIGURES( sy_cmin );
          exit if rdig < 0.0;
            rval := rval*radix + rdig;
            NEXTCH
          end
        end;

        if sy_ch = '.' then
        begin
          if SRC_NEXT_CHAR = '.' then { ".." is following }
            if sy = period then
            begin { Our syntax unit }
              NEXTCH;
              sy := twodot
            end
            else getnuchar := false { For the next syntax unit }
          else
          begin { Decimal/Fractional Period }
            NEXTCH;
            if TEST_FIGURES( sy_cmin ) < 0 then
              getnuchar := false
            else
            begin
              sy := doubleconst;
              loop
                rdig := FIGURES( sy_cmin );
              exit if rdig < 0.0;
                NEXTCH;
                rfac := rfac / radix;
                rval := rval + rfac*rdig;
                iprec := iprec + 1
              end
            end
          end
        end;

        if (sy <> period) and (sy <> twodot) then
        begin
          if (sy_cmin = 'e') or (bbase and (sy_cmin = '$')) then
          begin
            sy := doubleconst;
            NEXTCH;
            if (sy_ch = '+') or (sy_ch = '-') then
            begin
              if sy_ch = '-' then rexp := one/rexp;
              NEXTCH
            end;
            ivl := 0;
            while chartab[sy_cmin] = dig do
            begin
              ivl := ivl*10 + (ORD( sy_ch ) - ORD( '0' ));
              NEXTCH
            end;
            if ivl > max_dblpow then
            begin
              SRC_ERROR( mdnam, 11, e_error );
              ivl := max_dblpow; rval := one
            end
            else
              { For two large exponante we force the double precision }
              if ivl > max_fltpow then iprec := max_single + 1;
            rfac := one;
            while ivl <> 0 do
            begin
              if ODD( ivl ) then
              begin
                ivl := ivl - 1;
                rfac := rfac*rexp
              end
              else
              begin
                ivl := ivl div 2;
                rexp := SQR( rexp )
              end
            end;
            rval := rval*rfac
          end;

          if sy = intconst then
            if (rval <= unsmax) and (rval >= intmin) then
            begin                                      { Set unsigned value in integer equivalent }
              if rval > intmax then sy_ival := TRUNC( unsmax - rval ) + 1
                               else sy_ival := TRUNC( rval );
              sy_rval := sy_ival;
              if sy_label_flag and (chartab[sy_cmin] = db0) and
                 (SRC_NEXT_CHAR <> '=') then { a single ":" is following }
              begin
                NEXTCH;                                { Skip the colon character }
                IDE_INT_LABEL;
                sy := labelsy
              end
            end
            else
            begin
              sy_ival := 0;
              if iprec > max_single then sy := doubleconst
                                    else sy := singleconst
            end
          else
            if iprec <= max_single then sy := singleconst;

          sy_rval := rval;
          getnuchar := false
        end
      end;

    let: { keyword or identifier }
      with sy_ident do
      begin
        l := 0;
        repeat
          if l < id_maxsize then
          begin
            { Map to lower case in keywords and identifiers }
            l := SUCC( l );
            s[l] := sy_cmin
          end;
          NEXTCH
        until (chartab[sy_cmin] <> let) and (chartab[sy_cmin] <> dig);
        { now search for known keyword }
        pkw := keyword_tree;
        repeat
          with pkw^ do
          begin
            i := MATCH( sy_ident, name );
            if i <> 0 then
              if i > 0 then pkw := rightp else pkw := leftp
          end
        until (i = 0) or (pkw = nil);
        if pkw = nil then { it is an identifier }
        begin
          if sy_label_flag and (chartab[sy_cmin] = db0) and
             (SRC_NEXT_CHAR <> '=') then { a single ":" is following }
          begin
            NEXTCH;   { skip the colon character }
            sy := labelsy
          end
          else
            sy := identsy;
          op := no_op
        end
        else { it is a known keyword }
          sy_sym := pkw^.symb;
        getnuchar := false
      end;

    quo: { quote }
      begin
        op := no_op;
        { set line mode to ignore any end of line or comment mark }
        with src_control^ do
        begin
          bline_enabled := (src_linemode in src_flags);
          src_commentty := src_nocomment;
          src_flags := src_flags + [src_linemode]
        end;
        sy := stringconst;
        k := 1; maxstr := false;
        bint := true;
        while bint do
        begin
          NEXTCH;
          while chartab[sy_cmin] = eol do NEXTCH; { skip the end of line }
          if chartab[sy_cmin] = eos then bint := false;
          if sy_ch = '''' then
          begin
            src_control^.src_commentty := src_pascomment;
            NEXTCH;
            if sy_ch = '''' then
            begin
              src_control^.src_commentty := src_nocomment;
              PUT_CHAR
            end
            else bint := false
          end
          else PUT_CHAR
        end;
        sy_string.length := PRED( k );
        getnuchar := false;
        with src_control^ do
          if not bline_enabled then
          begin
            src_flags := src_flags - [src_linemode];
            if chartab[sy_cmin] = eol then sy_ch := ' '
          end
      end;

    db0: {':' or ':='}
      begin
        NEXTCH;     
        op := no_op;
        if sy_ch = '=' then sy := becomes
        else
        begin
          sy :=colon;
          getnuchar := false
        end
      end;

    db1: {'<' or '<=' or '<>'}
      begin
        NEXTCH;
        sy := relop;
        if sy_ch = '=' then op := le_op
        else
        if sy_ch = '>' then op := ne_op
        else
        begin
          op := lt_op;
          getnuchar := false
        end
      end;

    db2: {'>' or '>='}
      begin
        NEXTCH;
        sy := relop;
        if sy_ch = '=' then op := ge_op
        else
        begin
          op := gt_op;
          getnuchar := false
        end
      end;

    s00: { '!','|' = "logical or" or '!!','||' = "concatenation" }
      begin
        pch := sy_ch;
        NEXTCH;
        if sy_ch = pch then
        begin
          sy := addop;
          op := concat_op
        end
        else
        begin
          sy := lgorop;
          op := or_op;
          getnuchar := false
        end
      end;

    s01,s02,s03,s04,s06,s07,s08,s09,s10,s12,s13,s14,s15:
      sy_sym := chartok[chartab[sy_cmin]];

    s05: { '*' look at power '**' }
      begin
        NEXTCH;
        if sy_ch = '*' then
        begin
          sy_sym.sy := powop;
          sy_sym.op := pow_op
        end
        else
        begin
          sy_sym := chartok[s05];
          getnuchar := false
        end
      end;

    s11: { '=>' = "implicate" }
      begin
        NEXTCH;
        if sy_ch = '>' then
        begin
          sy := implic;
          op := no_op
        end
        else
        begin
          sy_sym := chartok[s11];
          getnuchar := false
        end
      end;

    eos: { end_of_file }
      begin
        sy := peofsy;
        op := no_op
      end;

    eol: { end_of_line }
      begin
        sy := eolnsy;
        op := no_op;
        getnuchar := false;
        sy_ch := ' '
      end;

    otherwise
      sy := nothing;
      op := no_op;
      getnuchar := false;
      if sy_ch <> ' ' then SRC_ERROR( mdnam, 13, e_error );
      sy_ch := ' '

  end { case chartab };

  if getnuchar then NEXTCH
end INSYMBOL_SRC;



procedure M_EXPRESSION;
begin
end M_EXPRESSION;



[global]
procedure INSYMBOL;

{ handle directly all the following STATEMENTs :
        includesy,	- include a source file,
        chainesy,	- chaine a source file,
        pragmasy,	- pragma to compiler option setting,
        peofsy		- end of file seen or %endfile symbol }

const
  mdnam = 'MASY';

var
  mac_symbol: symbol;



procedure PRAGMA_MSTATE( p_src: src_ptr );
const
  mdnam = 'PRAG';
  nopt  =     26;

type
  pragmatyps = ( { * Definitions of pragma options }
                 prgm_list_on,         { Enable/Disable listing 01 }
                 prgm_list_off,
                 prgm_echo_on,         { Enable/Disable input echo 03 }
                 prgm_echo_off,
                 prgm_listlvl,         { Change the Source Listing Level 07 }
                 prgm_format,          { Change the line source format 08 }
                 prgm_cp_list_on,      { Enable/Disable Tree P Code listing 09 }
                 prgm_cp_list_off,
                 prgm_cp_bin_exe_on,   { Create an executable file 11 }
                 prgm_cp_bin_exe_off,  { Does not create an executable file 12 }
                 prgm_cp_bin_on,       { Enable/Disable object file creation 13 }
                 prgm_cp_bin_off,
                 prgm_cp_exe_on,       { Enable/disable executable file creation 15 }
                 prgm_cp_exe_off,
                 prgm_trace,           { Modify the trace mode/accuracy 19 }
                 prgm_debug_on,        { Enable/Disable the debug mode 20 }
                 prgm_debug_off,
                 prgm_range_on,        { Enable/Disable Pascal Range check 22 }
                 prgm_range_off,
                 prgm_code_option,     { C code option 24 }
                 prgm_pcmp_debug_on,   { Enable/Disable the compiler debug mode 25 }
                 prgm_pcmp_debug_off
               );

var
  { warning this table must be modified when the identifier size is changed }
  optnam: [static] array[pragmatyps] of id_name := (
  ( 7,'list_on        '),  { 1--list on }
  ( 8,'list_off       '),  { 2--list off }
  ( 7,'echo_on        '),  { 3--echo on }
  ( 8,'echo_off       '),  { 4--no echo }
  ( 7,'listlvl        '),  { 5--listing source level (-L<n>) }
  ( 6,'format         '),  { 6--listing source format }
  (10,'cp_list_on     '),  { 7--listing object P code (-C) } 
  (11,'cp_list_off    '),  { 8--no listing object P code } 
  (13,'cp_bin_exe_on  '),  { 9--object P code bin. file et/ou exec. tree  }
  (14,'cp_bin_exe_off '),  {10--no object P code bin. file et/ou exec. tree }
  ( 9,'cp_bin_on      '),  {11--object P code bin. file }
  (10,'cp_bin_off     '),  {12--no object P code bin. file (-N) }
  ( 9,'cp_exe_on      '),  {13--create an executable file (no-effect) }
  (10,'cp_exe_off     '),  {14--no executable file created (no-effect) }
  ( 5,'trace          '),  {15--Pascal error tracing (-T<n>) }
  ( 8,'debug_on       '),  {16--Pascal debuging on (-D) }
  ( 9,'debug_off      '),  {17--Pascal debuging off }
  ( 8,'range_on       '),  {18--Pascal range check on (-R) }
  ( 9,'range_off      '),  {19--Pascal range check off }
  (11,'code_option    '),  {20--Code generator pragma }
  (13,'pcmp_debug_on  '),  {21--Compiler Debug activation }
  (14,'pcmp_debug_off ')   {22--Compiler Debug unactivation }
  );

  opt:                      pragmatyps;
  i, j, k, ierr:            integer;
  s1, s2, s3, fname:        string( 255 ) := '';
  plist:                    lst_ptr := nil;
  save_status:              src_flagw;
  sav_label_flg, swflg, bf: boolean;

begin { PRAGMA_MSTATE }
  sav_label_flg := sy_label_flag;
  sy_label_flag := false;
  with sy_sym, p_src^ do
  begin
    save_status := src_flags;
    while sy = identsy do
    begin
      bf := false;
      opt := pragmatyps"first;
      loop
        bf := MATCH( sy_ident, optnam[opt] ) = 0;
      exit if bf or opt = pragmatyps"last;
        opt := SUCC( opt )
      end;
      INSYMBOL_SRC;                                    { Gobble up the option name }
      case opt of
        prgm_list_on:
          begin                                        { Enable listing (with optional listing file specification) }
            if sy = stringconst then
              if sy_ident.l > 0 then
              with lst_current^ do
              begin
                { Flush output if some output line is begining }
                if lst_currline^.length > 0 then LST_EOLN;
                { For logical get the translation }
                fname := sy_string;
                INSYMBOL_SRC;                          { Gobble up the object file name }
                if lst_heading <> nil then s1 := lst_heading^;
                if lst_title   <> nil then s2 := lst_title^;
                if lst_sbttl   <> nil then s3 := lst_sbttl^;

                LST_OPEN( lst_current,
                          fname,
                          s1,
                          s2,
                          s3,
                          132,                         { 132 char. / line }
                          -1,                          { tty/no => dis./ena. page managment }
                          false,                       { New version mode }
                          false,                       { No print on close time }
                          false,                       { No append }
                          ierr );

                if ierr <> 0 then
                  if not sy_init_mod then
                    { If error lst -> terminal }
                    SRC_ERROR( mdnam, 905, e_error )
                  else
                    save_status := save_status - [src_blist]
                else
                begin
                  if src_lstmxlev < src_level then src_lstmxlev := src_level;
                  save_status := save_status + [src_blist]
                end
              end
              else                                     { No file specification => no listing }
                save_status := save_status - [src_blist]
            else
            begin
              if src_lstmxlev < src_level then src_lstmxlev := src_level;
              save_status := save_status + [src_blist]
            end
          end;

        prgm_list_off: save_status := save_status - [src_blist];       { Disable the source listing }

        prgm_echo_on:  save_status := save_status + [src_becho];       { Enable the echo mode }
        prgm_echo_off: save_status := save_status - [src_becho];       { Disable the echo mode }

        prgm_listlvl:
           begin                                       { Change the Source Listing Level (same effect that the -l<n> option) }
             if sy = colon then INSYMBOL_SRC;
             if sy = intconst then
             begin
               src_lstmxlev := sy_ival;
               INSYMBOL_SRC
             end
             else src_lstmxlev := 1
           end;

        prgm_format:
           begin                                       { Change the line source format }
             if sy = colon then INSYMBOL_SRC;
             if sy = intconst then
             begin
               src_frspos := sy_ival;
               INSYMBOL_SRC
             end
             else src_frspos := 1;
             if sy = colon then INSYMBOL_SRC;
             if sy = intconst then
             begin  src_lstpos := sy_ival; INSYMBOL_SRC  end
             else src_lstpos := 255
           end;

        prgm_cp_list_on:     cmp_macf :=  true;        { Enable the P code tree Listing (same effect that the -c option) } {  9 }
        prgm_cp_list_off:    cmp_macf := false;        { Disable the P code tree Listing } { 10 }

        prgm_cp_bin_exe_on:  cmp_cobj :=  true;        { Enable the creation of executable (presently no-effect) } { 11 }
        prgm_cp_bin_exe_off: cmp_cobj := false;        { Disable the creation of executable (presently no-effect) } { 12 }

        prgm_cp_bin_on:                                { Enable object file Creation } { 13 }
          if sy = stringconst then
            if sy_ident.l > 0 then
            begin
              if pas_obj <> nil then BINARY_OBJF_CLOSE;
              NEW( pas_obj, sy_string.length );
              pas_obj^ := sy_string;
              INSYMBOL_SRC;  cmp_objf := true          { Gobble up the object file name }
            end
            else SRC_ERROR( mdnam, 904, e_fatal )
          else
          begin
            if cmp_objf then BINARY_OBJF_CLOSE; cmp_objf := false
          end;

        prgm_cp_bin_off:                               { Disable object file Creation (same effect that the -N option)} { 14 }
          if cmp_objf then
          begin
            BINARY_OBJF_CLOSE; cmp_objf := false
          end;

        prgm_cp_exe_on:      cmp_bltt :=  true;        { Enable the in-line build tree (presently no-effect) } { 15 }
        prgm_cp_exe_off:     cmp_bltt := false;        { Disable the in-line build tree (presently no-effect) } { 16 }

        prgm_trace:
          if sy = intconst then
          begin                                        { PASCAL line tracing  accuracy  (same effect that the -T<n> option) }
            { cmp_traceopt > 0 => trace precision cmp_line }
            { cmp_traceopt = 0 => No PASCAL RTL ERROR tracing }
            cmp_traceopt := sy_ival;
            INSYMBOL_SRC;                              { Gobble up the trace value }
          end
          else SRC_ERROR( mdnam, 906, e_severe );

        prgm_debug_on:   cmp_debugopt :=  true;        { Enable the Debug mode (same effect that the -D option) }
        prgm_debug_off:  cmp_debugopt := false;        { Disable the debug mode }

        prgm_range_on:   cmp_range    :=  true;        { Enable Pascal Range Check (same effect that the -R option) }
        prgm_range_off:  cmp_range    := false;        { Disable Pascal Range Check }

        prgm_code_option:    GENERATION_PRAGMA;        { Code generator options }

        prgm_pcmp_debug_on:    cmp_cmpdbg :=  true;    { Enable compiler debug mode - for compiler dev. }
        prgm_pcmp_debug_off:   cmp_cmpdbg := false;    { Disable compiler debug mode - for compiler dev. }

      otherwise { No legal option warning }
        SRC_ERROR_S( mdnam, 901, e_warning, sy_ident )
      end { * case };
      if sy = comma then INSYMBOL_SRC
    end;
    if sy <> semicolon then SRC_ERROR( mdnam, 21, e_error );
    src_flags := save_status
  end;
  sy_label_flag := sav_label_flg
end PRAGMA_MSTATE;



procedure INCLUDE_MSTATE( bincl, bnsferr: boolean);
const
  mdnam = 'INCL';

var
  src_p: src_ptr;
  fext:  str_ptr;
  i, ierr: integer;
  fname: string(255);

begin { INCLUDE_MSTATE }
  with sy_sym do
    if sy = stringconst then
    begin
      src_p := nil;                                    { To force allocation by src_open }
      fname := sy_string;
      i := INDEX( fname, '.', -1 );
      if i = 0 then fname := fname||'.pas';
      INSYMBOL_SRC;
      SRC_OPEN( src_p, fname, false, ierr );           { Open this file }
      if ierr = 0 { no open error } then
      begin
        with src_p^ do
        begin
          src_previous := src_control;                 { Link the file to the previous src. }
          src_level  := src_control^.src_level;
          if bincl then src_level := src_level + 1;
          src_lstmxlev := src_control^.src_lstmxlev;
          src_insnb  := src_control^.src_insnb;
          src_frspos := src_control^.src_frspos;
          src_lstpos := src_control^.src_lstpos;
          src_flags  := src_flags +
            src_control^.src_flags * [src_blist,src_bmacroex,src_bphys,
                                      src_becho,src_echerr]
        end;
        if sy = comma then                             { Look for %PRAGMA options }
        begin
          INSYMBOL_SRC;
          PRAGMA_MSTATE( src_p )
        end
        else
        if sy <> semicolon then SRC_ERROR( mdnam, 21, e_error );
        if not bincl then SRC_END_OF_LINE;
        src_control := src_p;                          { Switch to new source file }
        if cmp_trace > 0 then cmp_tracecount := 0;     { Force the backtracing }
        COMPILE_SET_TITLE;
        SET_SRCFILESPC( ORD( bincl ) );
        sy_ch := ' ';                                  { Init the read character }
        sy := chainesy;                                { Force to unsignificant value }
        if not bincl then                              { Chaine macro STATEMENT }
        begin
          with src_control^ do
          begin
            src_p := src_previous;
            src_previous := src_p^.src_previous        { Get the true previous src}
          end;
          SRC_CLOSE( src_p, true )                     { Elliminate the old source file context }
        end
      end else
      begin
        LST_NEWLINE;
        WRITELN( ' Open Error (RTL) # ', ierr:3 );
        LST_NEWLINE;
        WRITELN( ' for the Source file "', fname, '".' );
        GET_RTL_MESSAGE( ierr, fname );
        LST_NEWLINE;
        WRITELN( ' RTL message : ', fname );
        while (sy <> semicolon)
          and (sy <> eofsy)
          and (sy <> peofsy) do INSYMBOL_SRC;
        if bnsferr then
          SRC_ERROR( mdnam, 902, e_fatal )             { Cannot open the file }
        else
          SRC_ERROR( mdnam, 902, e_severe )
      end
    end
    else SRC_ERROR( mdnam, 903, e_fatal )              { Filename is not a lit. string }
end INCLUDE_MSTATE;


procedure ENDFILE_MSTATE;
var
  src_p: src_ptr;

begin { ENDFILE_MSTATE }
  SET_SRCFILESPC( -1 );
  with src_control^ do
  begin
    if src_previous = nil then sy_sym.sy := eofsy
    else                                               { return to a previous source file }
    begin
      src_p := src_control; src_control := src_p^.src_previous;
      SRC_CLOSE( src_p, true );                        { close end elliminate old src context }
      sy_ch := ' ';
      COMPILE_SET_TITLE
    end
  end;
  if cmp_trace > 0 then cmp_tracecount := 0;           { Force the backtracing }
  if sy_sym.sy = eofsy then
    pas_compile := false
end ENDFILE_MSTATE;


(*
procedure DEFINE_MACRO_SYMBOL;
{ To define or re-define a macro symbol }
begin
end DEFINE_MACRO_SYMBOL;


procedure UNDEFINE_MACRO_SYMBOL;
{ To purge a macro symbol }
begin
end UNDEFINE_MACRO_SYMBOL;


procedure IF_MSTATE( mc: symbol );
{ To manage mifsy, mifdefsy, mifundefsy copnditionnal compilation }
begin
end IF_MSTATE;
*)


begin { INSYMBOL }
  INSYMBOL_SRC;
  with sy_sym do
  while sy >= includesy do
  begin
    mac_symbol := sy; if sy <> peofsy then
      INSYMBOL_SRC;                                    { gobble up the macro symbol }
    case mac_symbol of
      includesy,chainesy:
        INCLUDE_MSTATE( mac_symbol = includesy, sy_init_mod );
      peofsy:
        ENDFILE_MSTATE;
      pragmasy:
        PRAGMA_MSTATE(src_control);
(*
      mdefinesy:
        DEFINE_MACRO_SYMBOL;

      mundefsy:
        UNDEFINE_MACRO_SYMBOL;

      mifsy, mifdefsy, mifundefsy:
        IF_MSTATE( mac_symbol );
*)
    otherwise
      SRC_ERROR( mdnam, 997, e_severe )
    end;
    if sy <> eofsy then INSYMBOL_SRC                   { Skip any trailing semicolon }
  end
end INSYMBOL;


[global]
procedure SKIP_SYMBOL( tosymbol: symbol; errflg: boolean := false );
begin { * SKIP_SYMBOL }
  with sy_sym do
  while (sy <> tosymbol) and (sy <> eofsy) do
  begin
    INSYMBOL;
    case sy of
      beginsy, loopsy, casesy, recordsy:
        begin
          SKIP_SYMBOL( endsy ); INSYMBOL
        end;
      lparen:
        begin
          SKIP_SYMBOL( rparen ); INSYMBOL
        end;
      lbrack:
        begin
          SKIP_SYMBOL( rbrack ); INSYMBOL
        end;
      repeatsy:
        begin
          SKIP_SYMBOL( untilsy ); INSYMBOL
        end;
      endsy:
        exit if (tosymbol = elsesy) or errflg;
    otherwise
    end
  end
end SKIP_SYMBOL;


[global]
procedure INSY_INIT;
var
  ierr: integer;

begin
  { Initialize string, file and listing sub-systems }
  LST_G_INIT( pas_deflst, pas_page_head, ierr );

  if ierr = 0 then
  begin
    { Initialize the error message system }
    ERR_INIT( pas_errfilespc );

    { Initialize source input system }
    SRC_INIT( pas_prompt, pas_defstd );

    if src_control = nil then
    begin
      error_result := e_fatal; emergency_stop := true;
      WRITELN( ' PAS CANNOT OPEN THE "', pas_defstd, '" INITIAL FILE.' )
    end
    else
    begin
      { We can set standard definition source listing mode for debug }
      { with src_control^ do  src_flags := src_flags + [src_blist]; }

      { Built the keyword tree }
      SET_KEYWORD_TREE;

      proc_seq := 0;                                   { Initialize the procedure number }
      srf_free := nil;
      srf_list := nil;

      { Init the standard identifier environment }
      IDE_INIT;

      { Initialize the Source file info for back-tracing }
      SET_SRCFILESPC( 1 );

      { Init sy_ch for INSYMBOL }
      sy_ch := ' ';

      { Init label flag knowledge to disable state }
      sy_label_flag := false
    end
  end
  else
  begin
    error_result := e_fatal; emergency_stop := true;
    WRITELN( ' PAS CANNOT OPEN THE "', pas_deflst, '" OUTPUT MSG/LIST FILE.' )
  end
end INSY_INIT;

end.
