{
*************************************************************************
*                                                                       *
*                                                                       *
*                     *  C P A S  *  S Y S T E M  *                     *
*                                                                       *
*                                                                       *
*      * * *   C o m p i l a t i o n  - D i p a t c h e r   * * *       *
*                                                                       *
*                                                                       *
*                 ---  Version  2.3-A -- 31/01/2013 ---                 *
*                                                                       *
*                (first version for the cpas dispatcher)                *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire de Cristallographie                     *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////


}

{************     CPAS  version  V3.0  *************}

{
        *** Modification(s) from major version **** 


			----

		       nothing

			----

}

program CPAS_DISPATCHER;

const
  max_fref      =                          255; { Maximum sise of one source file reference }


  unix_setup_path = './;HOME:/etc/;/usr/local/etc/';            { Path to search the setup file on Unix Like system }
  win_setup_path  = './;HOME:/etc/;LOCAL:/etc/;/usr/local/etc'; { Path to search the setup file on windows system }

  cpas_dispatch_setup = 'cpasd_setup.cpasd_data';               { Default name for setup file }



type
         { *** arguments Definitions *** }

  arg_tsk   =   ( tsk_cpas_cmp,                 { Code for CPAS Compiler }
                    tsk_cc_cmp                  { Code for C Compiler }
                );

  str_ptr   =                          ^string; { String Pointer }
  arg_ptr   =                         ^arg_rec; { Pointer to an argument (of command line) }

  lab_type  =                     string( 18 ); { String use as entry name in the setup file }
  
  arg_rec( sz: byte ) = record                  { * Identifier Name Definition }
    next:                              arg_ptr; { Link to the next file name }
    sarg:                         string( sz )  { Name parameter pointer }
  end;


  { Define the managed options of the CC Compiler }
  mopt_type = ( mopt_cpas,                      { To specify the cpas command name }
                mopt_ccmp,                      { To specify the CC command name }
                mopt_comp,                      { To specify the -c option form }
                mopt_libs,                      { To specify the -l<lib> option form }
                mopt_ldir,                      { To specify the -L<dir> option form }
                mopt_idir,                      { To specify the -I<dir> option form }
                mopt_defc,                      { To specify the -D<symbol> option form (for C Compiler only }
                mopt_opti,                      { To specify an optimization level form }
                mopt_exec,                      { To specify the name of executable file form }
                mopt_debs                       { To specify the debug form }
              );

  { Define the kind of option specifier forms }
  moptf_knd = ( moptf_nul,                      { Specify no variable argument }
                moptf_str,                      { Specified variable argument is a string }
                moptf_int,                      { Specified variable argument is an integer }
                moptf_enm                       { Specified variable argument is a literal enum }
               );

  sp_string = record
    l: byte;
    s: array[1..19] of char
  end;

  moptf_rec = record                            { * Define the  }
    moptf_name,                                 { The option identifier }
    moptf_prefix,                               { The prefix string }
    moptf_suffix:     lab_type;                 { The suffix string } { /// Type use to turn out a bug in pcmp task /// }
    moptf_type:      moptf_knd;                 { The format specifier }
    moptf_ennum:       arg_ptr                  { The ennum option string pointer (as '<f1>,<f2>,<f3> ... ) }
  end;

  moptf_tab = array[mopt_type]  of   moptf_rec; { The table of setup field format }



var
  setup_tab:  moptf_tab := [    { * Define the setup identiers table with related default format field }
               [   'CPAS_cmd', 'pcmp', '', moptf_nul, nil  ],   { mopt_cpas, }
               [     'CC_cmd',  'gcc', '', moptf_nul, nil  ],   { mopt_ccmp, }
               [  'C_Compile',   '-c', '', moptf_nul, nil  ],   { mopt_comp, }
               [      'C_Lib',   '-l', '', moptf_str, nil  ],   { mopt_libs, }
               [   'C_LibDir',   '-L', '', moptf_str, nil  ],   { mopt_ldir, }
               [   'C_IncDir',   '-I', '', moptf_str, nil  ],   { mopt_idir, }
               [  'C_DefSymb',   '-D', '', moptf_str, nil  ],   { mopt_defc, }
               [ 'C_Optimize',   '-O', '', moptf_str, nil  ],   { mopt_opti, }
               [     'C_Exec',  '-o ', '', moptf_str, nil  ],   { mopt_exec, }
               [    'C_Debug',   '-g', '', moptf_nul, nil  ]    { mopt_debs  }
             ];

  setup_fspc:           string( 255 ) :=    ''; { Cpas Dispatcher setup file specification }
  
  pas_arg_last,                                 { Last argument pointer in the CPAS Compiler argument list }
  pas_arg_list,                                 { List for CPAS Compiler arguments (a FIFO Queue) }
  cc__arg_last,                                 { Last argument pointer in the C Compiler argument list }
  cc__arg_list:         arg_ptr     :=     nil; { List for C Compiler arguments (a FIFO Queue) }

  main_name:            string( 48 )  :=    ''; { Main name }

  cmp_verbose,                                  { Flag for the dispatcher verbose option }
  cmp_ccopt,                                    { Flag to signal option as -l, -L, -I, -o,  }
  cmp_no_paslib,                                { Flag to do not specify to C compiler the options -lcpas and -lm }
  cmp_ccmp,                                     { Transmit option to the C compiler }
  cmp_noccmp,                                   { Do not execute the C Compiler }
  cmp_optspc,                                   { A optimization is specified when true }
  cmp_range,                                    { Index/Value out of range check flag }
  cmp_rsfchk,                                   { Record Selector and Field Matching check flag }
  cmp_debugopt,                                 { Debug flag }
  cmp_macf,                                     { P code Listing output (For any compiler debug purpose) }
  cmp_noobjf:           boolean     :=   false; { No object (and C code) output - just check Pascal syntax }

  cmp_optlvl:           integer     :=       2; { Compilation optimization level (-O2 the default is generally a good choice) }
  cmp_listlvl:          integer     :=      -1; { Lcmp_ccoptisting level output (level of nesting source insert), (default is no listing) }
  cmp_traceopt:         integer     :=      -1; { Trace level (0 => No tracing) }
  cmp_verblvl:          integer     :=       1; { Verbose Level for CPAS-Dispatcher Debugging } 

  cpas_name:            lab_type    :=  'pcmp'; { Cpascal Compiler command name (default pcmp) } 
  ccmp_name:            lab_type    :=   'gcc'; { C Compiler command name (default gcc) }
  exsp_name:            lab_type    :=   '-o '; { Format of executable name option }

  inp:                                    text; { File variable to use for read }



procedure LOCATE_EXTENSION( var fnm: [readonly] string; var ie, ip: integer );
{ Look for the extension and directory position in a file specification.
  fnm is the file specification,
  ie is the returned position of the dot mark befaore the extension or 0,
  ij is the returned position of the end of directory (or device) specification or 0.
  The meaning of a 0 result is not found.
}
var
  i: integer;

begin
  i := fnm.length;
  ie := 0;
  ip := 0;
  while i > 0 do
  begin
    case fnm.body[i] of
      '.':                ie := i;
      '/', '\', ']', ':': begin  ip := i; i := 0  end;
    otherwise
    end;
    i := i - 1;
    if ip > ie then ie := 0
  end
end LOCATE_EXTENSION;



procedure ARGUMENT_APPEND( in_var arg: string; tsk: arg_tsk );
var
  parg:        arg_ptr;

begin
(*
WRITELN( ' ARGUMENT_APPEND( "', arg, '", ', tsk, ' );' );
*)
  NEW( parg, arg.length );
  with parg^ do
  begin
    next := nil;
    sarg := arg
  end;
  case tsk of
    tsk_cpas_cmp:
      begin
        if pas_arg_list = nil then pas_arg_list := parg
                              else pas_arg_last^.next := parg;
        pas_arg_last := parg
      end;
    tsk_cc_cmp:
      begin
        if cc__arg_list = nil then cc__arg_list := parg
                              else cc__arg_last^.next := parg;
        cc__arg_last := parg
      end
  end
end ARGUMENT_APPEND;



procedure TRANSLATE_OPTION( copt: mopt_type; sv: string := ''; iv: integer := 0 );
var
  topt:  string;
  pelm: arg_ptr;

begin
(*
WRITE( ' * TRANSLATE_OPTION( ', copt, ', "', sv, '", ', iv:0, ' );' );
*)
  with setup_tab[copt] do
  begin
    WRITEV( topt, moptf_prefix );
    case moptf_type of
      moptf_str: WRITEV( topt:false, SUBSTR( sv, iv + 1 ) );
      moptf_int: WRITEV( topt:false, iv:0 );
      moptf_enm:
        begin
          pelm := moptf_ennum;
          while (pelm <> nil) and (iv >= 0) do
          with pelm^ do
          begin
            if iv = 0 then WRITEV( topt:false, sarg );
            iv := iv - 1;
            pelm := next
          end;
        end;
    otherwise
    end;
    WRITEV( topt:false, moptf_suffix );
  end;
  ARGUMENT_APPEND( topt, tsk_cc_cmp )
end TRANSLATE_OPTION;



procedure SET_OPTIONS_AND_PARM;
{ Procedure to set the compiler options and file specifications }
type
  opt_codes = ( opt_ccmp,       { -ccmp (Option to send option to the C compiler) }
                opt_noccmp,     { -nccmp (To do not invoke the C Compiler) }
                opt_c_opt,      { -c (Create object file and stop, it is the default for module file) }
                opt_lib_opt,    { -l<library_file> (to specify a library to link, -lm and -lcpas are assumed) }
                opt_ldir_opt,   { -L<directory> (to specify a new library directory) }
                opt_idir_opt,   { -I<directory> (to specify a new insert source file directory) }
                opt_defc_opt,   { -D<symbol> (to define a macro symbol for C compiler) }
                opt_opt_opt,    { -O<n> to specy an optimization level to the C compiler }
                opt_npl_opt,    { -npl option to do not generate the -lcpas and -lm option of the C compiler }
                opt_exec_fsp,   { -o <exec_file> to specify a particular exec file specification (defaulted with source name) }
                opt_range,      { -r (To generate the range check for range type assignation and arry index) }
                opt_rsfchk,     { -rs Record Selector field check }
                opt_trace,      { -t<n> (To generate the execution line trace on error) }
                opt_debug,      { -g or --debugf (old option -d) }
                opt_listn,      { --list (old option -l) }
                opt_cptree,     { -cp or --tree (old option -c) }
                opt_check,      { -ch (old -n option) }
                opt_verbose,    { Long output for CPAS-D debug }
                opt_help,       { -h or --help }
                opt_undef       { Unknown option }
              );

  { Define the table of short form of option names }
  opt_tabty = array[opt_codes] of string( 6 );


var
  ierr, i, j, ii, jj, ll, md:  integer;
  arg:                   string( 255 );
  ext:                     string( 8 );
  optcd:                     opt_codes;


const
                       { 123456789, 12345678, 12345678, 12345678,   123456789ABC, 123456789ABC, 123456789ABC, 123456789ABC  }
  opt_table = opt_tabty[    '-cc(',  '-nocc',     '-c',    '-l*', {     opt_ccmp,   opt_noccmp,    opt_c_opt,  opt_lib_opt, }
                             '-L*',    '-I*',    '-D*',    '-O*', { opt_ldir_opt, opt_idir_opt, opt_defs_opt,  opt_opt_opt, }
                           'nplib',     '-o',     '-r',   '-sfc', { opt_npl_opt,  opt_exec_fsp,    opt_range,   opt_rsfchk, }
                             '-t*',     '-g',   '-sl*',    '-cp', {   opt_trace,     opt_debug,    opt_listn,   opt_cptree, }
                             '-ch', '-verb*',     '-h',  '*ERR*'  {   opt_check,   opt_verbose,     opt_help, (Undef=Error) }
                        ];



begin { SET_OPTIONS_AND_PARM }
  i  := 1;                                              { Skip the # 0 parameter }
  md := 0;                                              { Begining with the source file }
  while i < argc do
  begin
    if argv[i] <> nil then
    begin
      arg := argv[i]^;
      if arg.length > 1 then                            { It is a real parameter }
      with arg do
      begin
        if arg[1] = '-' then
          if cmp_ccmp then                              { Take all concecutice C Compiler options }
          begin
            if arg[2] = ')' then cmp_ccmp := false      { Finish the direct C compiler option list }
            else
              ARGUMENT_APPEND( arg, tsk_cc_cmp )        {  Put all C compiler option directly in the opt_list }
          end
          else
          begin
            optcd := opt_codes"first;
            repeat
              ii := 2;
              with opt_table[optcd] do
              begin
                ll := length;
                if body[ll] = '*' then ll := ll - 1;
                repeat                                  { loop to compare the option name with its model }
                exit if body[ii] <> arg[ii];
                  ii := ii + 1;
                until ii > ll                           { Loop on all option name characters }
              end;
              if ii <= ll then optcd := SUCC( optcd );
            until (ii > ll) or (optcd > opt_help);      { stop search when Names matchs or unknown option }

            { Option dispatching }
            case optcd of
              opt_ccmp:   cmp_ccmp    :=    true;               { Put all C compiler option directly in the opt_list }

              opt_noccmp: cmp_noccmp  :=    true;               { Do not execute the C compiler (to work as the old versions <= V2.2 pcmp) }

              opt_c_opt:    TRANSLATE_OPTION( mopt_comp );              { -c }

              opt_lib_opt:  TRANSLATE_OPTION( mopt_libs, arg, ll );     { -l<lib> }

              opt_ldir_opt: TRANSLATE_OPTION( mopt_ldir, arg, ll );     { -L<dir> }

              opt_idir_opt: TRANSLATE_OPTION( mopt_idir, arg, ll );     { -I<dir> }

              opt_defc_opt:                                     { -D<symbol> (Option to define a macro symbol for C Compiler). }
                begin
                  if optcd = opt_c_opt then cmp_no_paslib := true;
                  TRANSLATE_OPTION( mopt_defc, arg, ll );       { Send to the C Compiler. } 
                  cmp_ccopt := true
                end;

              opt_opt_opt:
                begin                                           { Get option for CPAS compiler and ... }
                  ll := ll + 1;
                  if length >= ll then
                    case body[ll] of
                      '0', '1', '2', '3': cmp_optlvl := ORD( body[ll] ) - ORD( '0' );
                    otherwise
                      cmp_optlvl := 2
                    end
                  else cmp_optlvl := 2;
                  cmp_optspc := true;
                  TRANSLATE_OPTION( mopt_opti,,cmp_optlvl )     { Send to the C Compiler. }        
                end;

              opt_exec_fsp:
                begin                                           { Get the requested file specification for the executable file }
                  i := i + 1;
                  TRANSLATE_OPTION( mopt_exec, argv[i]^ );      { Send it as a unique option on the C Compiler formatform -o:<exec_filepath> }
                  cmp_ccopt := true
                end;

              opt_npl_opt:  cmp_no_paslib   :=    true;         { Set the flag to suppress the automatic -lcpas and -lm options for C Compiler }

              opt_range:    cmp_range       :=    true;         { Option for Check range statements Generation }

              opt_rsfchk:   cmp_rsfchk      :=    true;         { Record Selector field check statements Generation }

              opt_trace:
                begin
                  ll := ll + 1;
                  if length >= ll then                          { Option to set the line updating number for the Error tracing output. }
                    case body[ll] of                            { A level of 0 suppress the line and source file error tracing output. }
                      '+': j := 1;
                      '-': j := 0;
                      '0'..'9': j := ORD( body[ll] ) - ORD( '0' );
                    otherwise
                    end
                  else j := 1;
                  cmp_traceopt := j;
                  if cmp_debugopt then cmp_traceopt := 1
                end;

              opt_debug:                                        { Set the debug option  }
                begin
                  cmp_debugopt := true;
                  TRANSLATE_OPTION( mopt_debs );                { ... also for the C Compiler and ... }
                  cmp_traceopt := 1                             { ... and force the line error trace for each line. }
                end;

              opt_listn:                                        { Option to enable or disable listing of source and ... }
                begin
                  ll := ll + 1;
                  if length >= ll then
                  case body[ll] of
                    '+': j :=  9;                               { ...and to set maximum listing output level. }
                    '-': j :=  1;
                    '0'..'9': j := ORD( body[ll] ) - ORD( '0' );
                  otherwise
                    j := -1                                     { No listing default }
                  end else j := 1;
                  cmp_listlvl := j
                end;

              opt_cptree: cmp_macf     :=   true;               { Option to enable the Tree Output Code (for CPAS compiler debugging) }

              opt_check:  cmp_noobjf   :=   true;               { No code Generation option - cpas is call only for syntax checking. }

              opt_verbose:                                      { Option to set the mode verbose od CPAS-D }
                begin
                  ll := ll + 1;
                  cmp_verbose := true;
                  if length >= ll then
                    case body[ll] of
                      '1',
                      '2',
                      '3': cmp_verblvl := ORD( body[ll] ) - ORD( '0' );
                      '+': cmp_verblvl := 3;
                    otherwise
                    end
                end;

              opt_help:                                         { Option to output the help message and exit }
                begin
                  WRITELN;
                  WRITELN( ' The general form of a cpas command is:' );
                  WRITELN( '    cpas [<option(s)>] <pascal_file> [<listing_file> [<c_file>]]' );
                  WRITELN;
                  WRITELN( '    When the <listing_file> is specified the Listing mode is Enabled.' );
                  WRITELN( '    The default <listing_file> is TT: with listing disable and' );
                  WRITELN( '    string( 62 the default <c_file> is the <pascal_file> with the ".c" type.' );
                  WRITELN;
                  WRITELN;
                  WRITELN( ' The cpas <option(s)> are (major or minor letter) :' );
                  WRITELN;
                  WRITELN( '    -cc(     To specify special C compiler options (given after this option and before "-)" option).' );
                  WRITELN( '             Example: -cc( -ansi -Wall -).' );
                  WRITELN( '    -nocc    To do not call the C compiler after the cpas compiler completion.' );
                  WRITELN( '    -c       To do not performe a link (transmit to C compiler - default for module source).' );
                  WRITELN( '    -l<lib>  To specify a library for the link (transmit to C compiler).' );
                  WRITELN( '    -L<dir>  To specify a library search directory for the link (transmit to C compiler).' );
                  WRITELN( '    -nplib   To suprescmp_no_paslibs implicite -lcpas -lm option for main module (transmit to C compiler).' );
                  WRITELN( '    -O<n>    To specify the optimizationb level for the C compiler (default is implementation dependant).' );
                  WRITELN( '    -o <f>   To specify the binary executable file to generate (default is <main_file> without ".pas").' );
                  WRITELN( '    -r       To enable the value or index range error detection' );
                  WRITELN( '             (usefull to detect the out of array index range).' );
                  WRITELN( '    -rsf     To detect when a record field access don''t matching with record selector value' );
                  WRITELN( '             (usefull to detect an illegal access to a record field.).' );
                  WRITELN( '    -t<n>    To set the error tracing precision to n lines,' );
                  WRITELN( '             where n is a single digit 0 to 9 and + or - .' );
                  WRITELN( '             -t0 and -t- disable the error tracing,' );
                  WRITELN( '             -t+ is equivalent to -t1 and the default is -t5,' );
                  WRITELN( '             this options is equivalent to "%pragma trace:<n>;" .' );
                  WRITELN( '    -g       To enable the future debug generation mode;' );
                  WRITELN( '             this opts options induces the -t1 tracing mode.' );
                  WRITELN( '    -sl<n>   To set the source listing output level to list the included' );
                  WRITELN( '             source listing with n in the range 1..9 (default is -l1).' );
                  WRITELN( '    -cp      To enable the logical tree output. The effect is' );
                  WRITELN( '             equivalent to the macro statement "%pragma cp_list_on;" .' );
                  WRITELN( '    -ch      To disable the code generation for checking code purpose.' );
                  WRITELN;
                  WRITELN( '    -verb<n> To force the debugging output of the Cpascal Dispatcher itself.' );
                  WRITELN( '             To debug the setup process, put this option in first argument.' );
                  WRITELN;
                  WRITELN( '    -h       To output this help text.' );
                  WRITELN;
                  PASCAL_EXIT( 0 )
                end;
       
            otherwise { Ignore Unknown Options }
              WRITELN( ' CPAS-DISPATCHER Ignore unknown Command Option "', arg, '".' )
            end;
          end
        else
        begin { Get a file specification and put it in the appropriate argument list }
          LOCATE_EXTENSION( arg, ii, jj );
          if ii > 0 then
          begin
            ext := SUBSTR( arg, ii );
            if (ext = '.p') or (ext = '.P') or (ext = '.pas') or (ext = '.PAS') then
            begin
              ARGUMENT_APPEND( arg, tsk_cpas_cmp );
              arg := SUBSTR( arg, 1, ii-1 )||'.c' 
            end
          end
          else
          begin
            ARGUMENT_APPEND( arg||'.pas', tsk_cpas_cmp );
            arg := arg||'.c';
          end;
          ARGUMENT_APPEND( arg, tsk_cc_cmp )
        end
      end
    end;
    i := i + 1
  end;
  if not (cmp_noccmp or cmp_no_paslib) then
  begin
    TRANSLATE_OPTION( mopt_libs, 'cpas' );
    TRANSLATE_OPTION( mopt_libs, 'm' )
  end
end SET_OPTIONS_AND_PARM;




procedure SETUP_PATH_SEARCH;
{ Procedure to locate the setup file }
var
  upath, dir, nam:      string;
  ib, ie, n:           integer;
  fnd:                 boolean;

begin
  if sys_unix <> 0 then upath := unix_setup_path        {  Select the appropriate setup path to search the setup file }
                   else upath := win_setup_path;
  ib  :=     1;
  n   :=     1;
  fnd := false;
  nam := cpas_dispatch_setup;
  while not fnd and (ib <> 0) do                        { Loop on all PATH entries }
  begin
    ie := INDEX( upath, ';', n ); n := n + 1;
    if ie = 0 then
    begin  dir := SUBSTR( upath, ib ); ib := 0  end                 { Get one path entry except the last one }
    else
    begin  dir := SUBSTR( upath, ib, ie - ib ); ib := ie + 1  end;  { To get the last path entryt }
    if dir[dir.length] <> '/' then begin  dir.length := dir.length + 1; dir[dir.length] := '/'  end;
    setup_fspc := dir||nam;                                         { Build a possible complete setup file specification }
    fnd := FILE_ACCESS_CHECK( setup_fspc, 4 {Read access} )         { Test it for free access to read }
  end;                                                  { End of search loop }
  if not fnd then                                       { When the setup is not found, signal it and stop }
  begin
    WRITELN( ' *** CPAS-DISPATCHER cannot find or open the setup file "', cpas_dispatch_setup, '"' );
    PASCAL_EXIT( 2 )
  end
end SETUP_PATH_SEARCH;



procedure READ_SETUP_FILE;
{ Read the setup file if found }
const
  mdnam     =   'RSFL';         { Module code name for setup file syntax error }

type
  symbol = ( sy_ident,          { An identifier was found }
             sy_string,         { A string was found }
             sy_integer,        { An integer value was found }
             sy_float,          { An floating value was found }
             sy_comma,          { "," was found }
             sy_colon,          { ":" was found }
             sy_semicolon,      { ";" was found }
             sy_lpar,           { "(" was found }
             sy_rpar,           { ")" was found }
             sy_lbra,           { "[" was found }
             sy_rbra,           { "]" was found }
             sy_equal,          { "=" was found }
             sy_eoln,           { End Of Line found }
             sy_eof,            { End Of File Reached }
             sy_illegal         { Illegal syntax found }
           );

[static]
var
  sy_nchar,                                             { Current setup file character index }
  sy_nline:             integer :=   0;                 { Current setup file line number }

  sy_cline,                                             { Current line of setup file }
  sy_str:                       string;                 { The current string or identifier }
  sy_ide:                     lab_type;                 { The current identifier }
  sy_int:                      integer;                 { The current integer value }
  sy_flt:                       double;                 { The current float value }
  sy:                           symbol;                 { Readden (by INSYMBOL) symbol type }
  sy_noeol:            boolean := true;                 { By default ignore any EOLN }

  pide, plast:                 arg_ptr;                 { Current and last pointer to build indentifier list }
  mopt:                      mopt_type;                 { The managed option form specification }
  fnd:                         boolean;


  procedure INSYMBOL;
  type
    ch_type = ( eos, eol, spc, ctl,                     {  EOF, EOLN, Space (= " " or TAB), <all other control character> }
                oth, dig, let, quo,                     { other char, digit, letter and assim., "'"  '"' }
                dif, lpa, rpa, lbr, rbr,                { '#', '(', ')', '[', ']', }
                lac, rac,                               (* '{', '}' *)
                oor, oan, oad, osu, omu, odi, opw,      { '!' or '|', '&', '+', '-', '*', '/', '^' }
                oeq, olt, ogt,                          { '=', '<', '>' }
                scm, spe, s2p, ssc, sas                 { ',', '.', ':', '\' }
              );

    ch_tab_ty  = array[CHR(0)..CHR(127)] of ch_type;    { Kind of character table }


  const
    ch_tab = ch_tab_ty[
             { 0    1    2    3    4    5    6    7 }     {  Meaning with XON=DC1, XOFF=DC3, SP=' '  }
      { 000 } eos, eol, ctl, ctl, ctl, ctl, ctl, ctl,     {  NUL, SOH, STX, ETX, EOT, ENQ, ACK, BEL  } 
      { 010 } ctl, spc, ctl, ctl, ctl, ctl, ctl, ctl,     {   BS,  HT,  LF,  VT,  FF,  CR,  SO,  SI  } 
      { 020 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {  DLE, DC1, DC2, DC3, DC4, NAK, SYN, ETB  } 
      { 030 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {  CAN,  EM, SUB, ESC,  FS,  GS,  RS,  US  } 
      { 040 } spc, oor, quo, dif, let, let, oan, quo,     {  ' ', '!', '"', '#', '$', '%', '&', "'"  } 
      { 050 } lpa, rpa, omu, oad, scm, osu, spe, odi,     {  '(', ')', '*', '+', ',', '-', '.', '/'  } 
      { 060 } dig, dig, dig, dig, dig, dig, dig, dig,     {  '0', '1', '2', '3', '4', '5', '6', '7'  }
      { 070 } dig, dig, s2p, ssc, olt, oeq, ogt, oth,     {  '8', '9', ':', ';', '<', '=', '>', '?'  }
      { 100 } let, let, let, let, let, let, let, let,     {  '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G'  }
      { 110 } let, let, let, let, let, let, let, let,     {  'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O'  }
      { 120 } let, let, let, let, let, let, let, let,     {  'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W'  }
      { 130 } let, let, let, lbr, sas, rbr, opw, let,     {  'X', 'Y', 'Z', '[', '\', ']', '^', '_'  }
      { 140 } oth, let, let, let, let, let, let, let,     {  '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g'  }
      { 150 } let, let, let, let, let, let, let, let,     {  'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o'  }
      { 160 } let, let, let, let, let, let, let, let,     {  'p', 'q', 'r', 's', 't', 'u', 'v', 'w'  }
      { 170 } let, let, let, lac, oor, rac, oth, ctl      (* 'x', 'y', 'z', '{', '|', '}', '~', DEL *)
    ];

    C_EOS = CHR( 0 );
    C_EOL = CHR( 1 );

  
  [static]
  var
    quote,
    inp_cm,
    inp_ch:   char :=    C_EOL;
    ch_knd: ch_type   :=   eol;
    iv, id, nd, sz:    integer;
    rd, rf, rv:         double;
    bok, bnc:  boolean := true;

    procedure NEXTCH;
    {Procedure to get One character from the input stream }
    const
      in_major = ORD( 'A' ) - ORD( 'a' );

    begin
      if EOF( inp ) then
      begin
        inp_ch := C_EOS;
        sy_cline.length := sy_nchar;
        sy_nline := sy_nline + 1
      end
      else
      if EOLN( inp ) then
      begin
        GET( inp ); inp_ch := C_EOL;
        sy_nline := sy_nline + 1;
        sy_cline.length := sy_nchar;
        sy_nchar := 0
      end
      else
      begin
        inp_ch := inp^; GET( inp );
        if inp_ch <= ' ' then inp_ch := ' ';
        sy_nchar := sy_nchar + 1; sy_cline[sy_nchar] := inp_ch
      end;
      if (inp_ch >= 'A') and (inp_ch <= 'Z') then
        inp_cm := CHR( ORD( inp_ch ) - in_major )
      else
        inp_cm := inp_ch;
      ch_knd := ch_tab[inp_cm]
(*
;WRITELN( ' NEXTCH : ch = ', ORD( inp_ch ), ' ', inp_ch, ' ', ch_knd );
*)
    end NEXTCH;


  begin { INSYMBOL }
    while ch_knd = spc do NEXTCH;               { Skip any space character }
    repeat
      bnc := true;
      bok := true;
      case ch_knd of
        dif: { "#" Other mark of end of line comment }
          begin
            while (ch_knd <> eos) and (ch_knd <> eol) do NEXTCH;
            bok := false; bnc := false          { The next syntax unit (EOLN or EOF) is already readden }
          end;

        quo: { String }
          begin
            sz := 0;                            { Clear the string variable }
            quote := inp_ch;                    { Keep the memory of quote character }
            repeat
              NEXTCH;
            exit if ch_knd = eos;               { Stop on end of file }
              if ch_knd = eol then NEXTCH;      { Ignore any eoln }
              if inp_ch = quote then            { On a Quote character }
              begin
                NEXTCH;                         { Get the next one }
                { Double quote => Insert one quote in string }
            exit if inp_ch <> quote;            { Unique Quote => End of String }
              end;
              if sz < sy_str.capacity then sz := sz + 1; { Check for string overflow }
              sy_str[sz] := inp_ch              { Put the character in the string }
            until false;
            sy_str.length := sz;
            sy := sy_string;                    { We have found a string }
            bnc := false                        { The next character is already readden }
          end;

        let: { Alpha character => Identifier }
         begin
            sz := 0;                            { Clear the current identifier name }
            repeat
              if sz < sy_ide.capacity then      { Check for string overflow }
              if sz < sy_ide.capacity then sz := sz + 1;
              sy_ide[sz] := inp_ch;
              NEXTCH;                           { Get the next character }
            until (ch_knd <> let) and (ch_knd <> dig);
            sy_ide.length := sz;
            sy := sy_ident;
            bnc := false;                       { The next character is already got }
          end;

        dig, spe: { Figures character => Numeric value }
          begin
            rv := 0.0; rf := 1.0; nd := 0;
            sy := sy_integer;                   { Assume to be an integer }
            while ch_knd = dig do
            begin
              id := ORD( inp_ch ) - ORD( '0' ); { Get the figure value }
              if id = 0 then nd := nd + 1       { Count of zero at left of decimal period }
                        else nd := 0;           { ... to allow to use the integer exponentiel form }
              rv := rv*10.0 + id;               { Form the integer part of the number }
              NEXTCH                            { Get the next character }
            end;
            if ch_knd = spe then
            begin
              nd := 0;                          { Eliminate the integer kind of number }
              NEXTCH;
              sy := sy_float;                   { Set to be a floatting number }
              while ch_knd = dig do
              begin
                id := ORD( inp_ch )-ORD( '0' ); { Get the figure value }
                rf := rf*0.1;
                rv := rv + id*rf;               { Form the decimal part of the number }
                NEXTCH                          { Get the next character }
              end
            end;
            if inp_cm = 'e' then
            begin
              NEXTCH;                           { Gobble up the Exponant character }
              iv := 0;                          { Prepare the exponant read }
              rd := 10.0;
              if (inp_ch = '+') or (inp_ch = '-') then
              begin                             { Manage the exponant signe }
                if inp_ch = '-' then rd := 0.1;
                NEXTCH
              end;
              while ch_knd = dig do
              begin
                id := ORD( inp_ch )-ORD( '0' ); { Get the figure value }
                iv := iv*10 + id;               { Form the exponant value }
                NEXTCH                          { Get the next character }
              end;
              rf := 1.0;
              while iv <> 0 do                  { Form rf = rd**iv }
                if ODD( iv ) then
                begin  iv := iv - 1; rf := rf*rd  end
                else
                begin  iv := iv div 2; rd := SQR( rd )  end;

              { Set as impossible value for integer when exponent is < -nd }
              if nd - iv < 0 then sy := sy_float;
              rv := rv*rf                       { Finish to form the Real Number }
            end;
            { Set the integer value when it is possible }
            if (rv <= double( integer"last )) and
               (rv >= double( integer"first )) then sy_int := ROUND( rv )
            else begin  iv := 0; sy := sy_float  end;
            sy_flt := rv; sy_int := iv;
            bnc := false                        { The next character is already got }
          end;

        oeq: sy := sy_equal;

        
        lbr: sy := sy_lbra;
        rbr: sy := sy_rbra;
        lpa: sy := sy_lpar;
        rpa: sy := sy_rpar;
        scm: sy := sy_comma;
        s2p: sy := sy_colon;
        ssc: sy := sy_semicolon;

        eol:
          begin
            NEXTCH;
            if sy_noeol then bok := false
                        else sy := sy_eoln;
          end;

        eos: sy := sy_eof;

        spc: begin  bok := false; NEXTCH  end;

      otherwise
        { oor, oan, oad, osu, omu, odi, opw (operators characters) are not supported }
        sy := sy_illegal
      end
    until bok or (ch_knd = eos);
    if cmp_verblvl > 2 then
    begin
      WRITE( '    * INSYMBOL Read ', sy );
      case sy of
        sy_ident:   WRITE( ' (', sy_ide.length:0, ') "', sy_ide, '"' );
        sy_string:  WRITE( ' (', sy_str.length:0, ') "', sy_str, '"' );
        sy_integer: WRITE( ' = ', sy_int:0 );
        sy_float:   WRITE( ' = ', sy_flt:12:7 );
      otherwise
      end;
      WRITELN
    end;
    if bnc then NEXTCH
  end INSYMBOL;


  procedure SKIP_SYMBOL( stp: symbol := sy_eoln );
  begin
    while (sy <> stp) and (sy <> sy_eof) do INSYMBOL
  end SKIP_SYMBOL;



  procedure SETUP_ERROR( mdnam: string; nerr: integer );
  var
    ip: integer;
    msg: string( 92 ) := 'Undefined syntax error.';
  
  begin
    ip := sy_nchar;                                     { Keep the Read index in the current line }
    sy_noeol := false; SKIP_SYMBOL( sy_eoln );          { Skip to the end of line }
    WRITELN;
    WRITELN( ' *** CPAS-Dispatcher Setup File Syntax Error : ', mdnam, ' # ', nerr:0 );
    WRITELN( ' Line # ', sy_nline:3, '  ', sy_cline );
    WRITELN( ' ':ip+11, '^' );
    case nerr of
       1: msg := 'An identifer was expected';
       2: msg := 'Unknown identifier';
       3: msg := 'A string value was expected';
       4: msg := 'An integer value was expected';
       6: msg := 'A left parenthesys "(" was expected';
       7: msg := 'A left braket "[" was expected';
       8: msg := 'A right parenthesys ")" was expected';
       9: msg := 'A right braket "]" was expected';
      10: msg := '"=" was expected';
      11: msg := '"," was expected';
      12: msg := '":" was expected';
      13: msg := '";" was expected';
      14: msg := '"," or ";" was expected';
      15: msg := '"," or ")" was expected';
      16: msg := '":" or ")" was expected';
      21: msg := 'Unknown format specifier for variable field (known %s, %i, %f or %e)';
      22: msg := ' Element of enum (%e) is not a string or identifier';
    otherwise
    end;
    WRITELN( ' *** ', msg, '. ***' );
    PASCAL_EXIT( 2 )
  end SETUP_ERROR;

  
begin { READ_SETUP_FILE }
  if (argc > 1) and (SUBSTR( argv[1]^, 1, 5 ) = '-verb') then
  with argv[1]^ do
  begin
    cmp_verbose := true;
    if length > 5 then
    case body[6] of
      '1', '2', '3':
          cmp_verblvl := ORD( body[6] ) - ORD( '0' );
      '+':
          cmp_verblvl := 3;
    otherwise
    end
  end;

  if cmp_verbose then WRITELN( ' Read Setup file "', setup_fspc, '"' );

  OPEN( inp, setup_fspc, [read_file, error_file] );     { Open the setup file (with error tolerance) }
  if iostatus = 0 then
  begin { OK to read the setup file }
    if cmp_verblvl > 2 then WRITELN( ' * The setup File is opened. *' );
    sy := sy_eoln;
    INSYMBOL;
    while sy <> sy_eof do                               { Loop to read all the setup file }
    begin
      if sy <> sy_ident then SETUP_ERROR( mdnam, 1 );   { An identifier was expected }
    exit if sy_ide = 'End';
      for cmopt := mopt_type"first to mopt_type"last do { Loop to find he identifier in the setup possible identifiers }
        if setup_tab[cmopt].moptf_name = sy_ide then   { When the identifier is find ... }
        begin  mopt := cmopt; fnd := true; exit  end;

      if not fnd then SETUP_ERROR( mdnam, 2 );          { If the identifier ois not found => ERROR }
      with setup_tab[mopt] do
      begin
        INSYMBOL;
        if sy <> sy_equal then SETUP_ERROR( mdnam, 2 ); { An "=" operator was expected }
        INSYMBOL;                                       { Get the suffix string }
        if sy <> sy_string then SETUP_ERROR( mdnam, 3 );{ Not a string ERRROR }
        moptf_prefix := sy_str;                         { Load the suffix string }
        INSYMBOL;
        if sy = sy_comma then                           { When some other field are specified ... }
        begin
          INSYMBOL;                                     { Gobble up the comma }
          if sy = sy_ident then                         { When a format was specified }
          begin
            if sy_ide = '%s' then moptf_type := moptf_str
            else
            if sy_ide = '%i' then moptf_type := moptf_int
            else
            if sy_ide = '%e' then moptf_type := moptf_enm
            else SETUP_ERROR( mdnam, 21 );
            INSYMBOL;
            if moptf_type = moptf_enm then
            begin { Gte the various literal value of enum }
              if sy <> sy_colon then SETUP_ERROR( mdnam, 21 );
              INSYMBOL;
              if sy <> sy_lpar then SETUP_ERROR( mdnam, 21 );
              sy := sy_comma;
              while sy = sy_comma do
              begin
                INSYMBOL;                               { Gobble up "(" or "," }
                case sy of
                  sy_ident:  begin  NEW( pide, sy_ide.length ); pide^.sarg := sy_ide  end;
                  sy_string: begin  NEW( pide, sy_str.length ); pide^.sarg := sy_str  end;
                otherwise
                  SETUP_ERROR( mdnam, 22 )              { The field must be an identifier }
                end;
                pide^.next := nil;
                if moptf_ennum = nil then moptf_ennum := pide   { ... and Queue it in the enum list }
                                     else plast^.next := pide;  { N.B.: the list must be empty  befor }
                plast := pide;
                INSYMBOL                                        { Gobble the literal identifier }
              end;
              if sy <> sy_rpar then SETUP_ERROR( mdnam, 8 );
              INSYMBOL                                  { Gobble ")" }
            end { End of get enum literals }
            else moptf_ennum := nil
          end { End of Variable part of option descriptor }
          else moptf_type := moptf_nul
        end;
        if sy = sy_comma then
        begin
          INSYMBOL;                                     { Gobble "," }
          if sy <> sy_string then SETUP_ERROR( mdnam, 3 );
          moptf_suffix := sy_str;
          INSYMBOL                                      { Gobble up the suffix }
        end;
        if sy <> sy_semicolon then SETUP_ERROR( mdnam, 12 );
        INSYMBOL;                                       { Gobble up ";" }
        if cmp_verblvl > 1 then
        begin
          WRITE( '    Setup ', moptf_name:16, ' = ''', moptf_prefix, ''', ', moptf_type );
          if moptf_ennum <> nil then
          begin
            WRITE( ':(' );
            pide := moptf_ennum;
            while pide <> nil do
              with pide^ do
              begin
                if pide <> moptf_ennum then WRITE( ',' );
                WRITE( sarg );
                pide := next
              end;
            WRITE( ')' )
          end;
          WRITELN( ', ''', moptf_suffix, ''';' )
        end
      end
    end { while sy <> sy_eof do };
    CLOSE( inp )                                        { Close the setup file }
  end
  else
  begin { Cannot open the setup file }
    WRITELN( ' *** CPAS-DISPATCHER Error: Cannot open the Setup file "', setup_fspc,
             '" for input with err # ', iostatus:0, '. ***' );
    PASCAL_EXIT( 2 )
  end
end READ_SETUP_FILE;




function RUN_COMPILER( in_var tsk, cmd: string ): boolean;
var
  ipro, iusr, stat:    integer;
  emsg:           string := '';
  bok:                 boolean;

begin
  if cmp_verbose then WRITELN( ' EXEC "', tsk, '" commande "', cmd, '".' );
  bok := false;
  ipro := CREATE_PROCESS( tsk, cmd );
  if ipro > 0 then
  begin
    iusr := WAIT_PROCESS( stat, ipro );
    if stat <> 0 then WRITEV( emsg, 'Create_Process "', tsk, '" Error # ', stat:0, ' => Stop.' )
                 else bok := true
  end
  else
    WRITEV( emsg, 'Process "', tsk, '" signal an Error # ', ipro:0, ' => Stop.' );
  if not bok then WRITELN( ' CPAS-DISPATCHER: ** ', emsg );
  if bok and cmp_verbose then WRITELN( ' EXEC "', tsk, '" resulting status = ', stat:0 );
  RUN_COMPILER := bok
end RUN_COMPILER;




procedure PAS_SOURCES_MANAGER;
var
  cmd:           string( 255 );
  iext, ip, lensv:     integer;
  carg:                arg_ptr;
  bok:                 boolean;

begin
  if cmp_verblvl > 2 then
  begin
    carg := pas_arg_list;
    ip := 1;
    WRITELN;
    WRITELN( '    *** CPAS Argument list ***' );
    while carg <> nil do
    with carg^ do
    begin
      WRITELN( ' ', ip:3, '/  "', sarg, '"' );
      ip := ip + 1;
      carg := next
    end;
    WRITELN
  end;

  WRITEV( cmd, cpas_name );
  if cmp_traceopt >= 0 then WRITEV( cmd:false, ' -t', cmp_traceopt:0 );
  if cmp_optspc then WRITEV( cmd:false, ' -O', cmp_optlvl:0 );
  if cmp_range then WRITEV( cmd:false, ' -r' );
  if cmp_rsfchk then WRITEV( cmd:false, ' -f' );
(* Until Debug support is OK.
  if cmp_debugopt then  WRITEV( cmd:false, ' -d' );
*)
  if cmp_macf then WRITEV( cmd:false, ' -c' );
  if cmp_listlvl > 0 then WRITEV( cmd:false, ' -l', cmp_listlvl:0 );
  lensv := cmd.length;
  carg := pas_arg_list;
  bok := true;
  while bok and (carg <> nil) do
  with carg^ do
  begin
    if sarg.length > 0 then
    begin
      if not FILE_ACCESS_CHECK( sarg, 4 ) then
      begin
        WRITELN( ' CPAS-Dispatcher Error :  Cannot open or find the Pascal source file "', sarg.length:0, ':',sarg, '" => stop.' );
        PASCAL_EXIT( 2 )
      end;
      cmd.length := lensv;
      WRITEV( cmd:false, ' ', sarg );
      LOCATE_EXTENSION( sarg, iext, ip );
      if cmp_listlvl > 0 then WRITEV( cmd:false, ' ', sarg:iext-1, '.list' );
      bok := RUN_COMPILER( cpas_name, cmd )
    end;
    cmd.length := lensv;
    carg := next
  end;
  if not bok then
  begin
    WRITELN( ' PASCAL COMPILATION: Stop on Error.' );
    PASCAL_EXIT( 2 )
  end
end PAS_SOURCES_MANAGER;



procedure CC_SOURCES_MANAGER;
var
  cmd:           string( 255 );
  carg:                arg_ptr;
  ip:                  integer;
  bok:                 boolean;

begin
  if cmp_verblvl > 2 then
  begin
    carg := cc__arg_list;
    ip := 1;
    WRITELN;
    WRITELN( '    *** CC Argument list ***' );
    while carg <> nil do
    with carg^ do
    begin
      WRITELN( ' ', ip:3, '/  "', sarg, '"' );
      ip := ip + 1;
      carg := next
    end;
    WRITELN
  end;

  WRITEV( cmd, ccmp_name );
  carg := cc__arg_list;
  while carg <> nil do
  with carg^ do
  begin
    if sarg.length > 1 then
      if sarg[1] = '-' then
        WRITEV( cmd:false, ' ', sarg )
      else
      begin
        if not FILE_ACCESS_CHECK( sarg, 4 ) then
        begin
          WRITELN( ' CPAS-Dispatcher Error :  Cannot open the C source file "', sarg, '" => stop.' );
          PASCAL_EXIT( 2 )
        end;
        WRITEV( cmd:false, ' ', sarg )
      end;
    carg := next
  end;

  if main_name.length > 0 then WRITEV( cmd:false, ' -o ', main_name );
  
  bok := RUN_COMPILER( ccmp_name, cmd );

(*  WRITEV( cmd:false, ' ', scc ); *)


  if not bok then
  begin
    WRITELN( ' C COMPILATION: Stop on Error.' );
    PASCAL_EXIT( 2 )
  end
end CC_SOURCES_MANAGER;


begin { Main: CPAS_DISPATCHER }
  SETUP_PATH_SEARCH;                    { Locate the CPAS-DISPATCHER setup file }
  READ_SETUP_FILE;                      { Read the setup to define all the C and CPAS usefull options and exec files }
(*
for copt := mopt_cpas to mopt_debs do
with setup_tab[copt] do
begin
WRITELN( ' From setup_tab : ', copt, '/ [ "', moptf_name, '", "', moptf_prefix, '", ', moptf_type, ', "', moptf_suffix, '" ]' );
end;
*)
  SET_OPTIONS_AND_PARM;                 { Analyse the CPAS command awith these various arguments }

  PAS_SOURCES_MANAGER;                  { Perform all calls to CPAS Compiler }
  
  if not cmp_noccmp then CC_SOURCES_MANAGER;    { Perform the call of C Compiler } 

end CPAS_DISPATCHER.
