{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*               ---   USE/INHERIT  PASCAL  MODULE   ---                 *
*                                                                       *
*              ---  Version  2.2-B -- 15/12/2010 ---                    *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire de Cristallographie                     *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////



}


{************     CPAS  version    *************}


{
        *** modification(s) from major version ***


			----

		       nothing

			----

}
 
  {**************************************************}
  {*******            program  head            ******}
  {**************************************************}


(*
[inherit(    'lib:basic_env_str',     { use string management definitions }
             'lib:basic_env_txf',     { use text file management definitions }
             'lib:basic_env_lst',     { use listing management definitions }
             'lib:basic_env_src',     { use source management definitions }

             'lib:pas_env')]          { use tree definitions }
*)
module PAS_ENV_INH( Input, Output );  { input and output for user terminal }

{ *** Include basic compiler environment *** }
%include 'passrc:pcmp_env';


var
  iecnt: integer := 0;                { Environment file count }
  envf:  text;                        { Environment file }



procedure ENV_BLOCK;
begin
end ENV_BLOCK;




procedure INHERIT_ENV( env: env_ptr ); forward;


procedure INHERIT_RECUR( env: env_ptr );
var
  sv_ch, sv_cmin: char;

begin
  SET_ENV_FILE_SPC( env );
  sv_ch   := sy_ch;
  sv_cmin := sy_cmin;
  INHERIT_ENV( env );
  sy_ch   := sv_ch;
  sy_cmin := sv_cmin
end INHERIT_RECUR;



procedure INHERIT_ENV { ( env: env_ptr ) was forward };
const
  mdnam = 'ENHE';

var
  ierr, i:        integer;
  str:            string( 255 );
  nsrc, osrc:     src_ptr;
  ip:             ide_ptr;
  efrirst, elast: env_ptr;
  envflg:         boolean;

begin
  envflg := false;
  efrirst := nil;
  elast   := nil;
  osrc := src_control;
  nsrc := nil;
  with env^ do
  begin { * Set the environment file specification }
    str := env_spc^;
    i := INDEX( str, '.', -1 );
    if i <> 0 then
      if str[i] = '.' then str := str||'.pas'
  end;

  SRC_OPEN( nsrc, str, false, ierr );
  if ierr = 0 then { No open error }
  begin { * Set up of inherited source file }
    with nsrc^ do
    begin
      src_previous := src_control;             { Link to the prevoius source file }
      src_level    := src_control^.src_level + 1;
      src_lstmxlev := src_control^.src_lstmxlev;
      src_insnb    := src_control^.src_insnb;
      src_flags    := src_flags *
                        [src_bmacroex, src_bphys, src_becho, src_echerr]
    end;
    COMPILE_SET_TITLE;
    SET_SRCFILESPC( 1 );
    sy_ch := ' ';                              { Init the read operations }
    sy_sym.sy := chainesy;                     { Force to unsignificant value }
    src_control := nsrc;
    INSYMBOL;                                  { Get the first syntax unit }

    with sy_sym do
    begin
      if sy = usesy then
      begin { * Form use '<env_file>', ... }
        sy := comma;
        repeat
          INSYMBOL;
          if (sy = stringconst) and (sy_string.length > 0) then
            INHERIT_RECUR( env )
          else
            SRC_ERROR( mdnam, 58, e_severe );
          INSYMBOL
        until sy <> comma;
        if sy = semicolon then INSYMBOL
                          else SRC_ERROR( mdnam, 21, e_error )
      end
      else if sy = lbrack then
      begin { * form [inherit('<env_file>', ...)] and/or
                    [environment('<env_file>', ...)] }
        sy := comma;
        repeat
          INSYMBOL;
          if sy = identsy then
          begin
            ip := LEVEL_SEARCH( atts_list );
            if ip <> nil then
              repeat
                INSYMBOL;
                case ip^.ide_attr of
                  atts_inherit:
                    begin
                      if sy <> lparen then SRC_ERROR( mdnam, 22, e_error );
                      sy := comma;
                      repeat
                        INSYMBOL;
                        if (sy = stringconst) and (sy_string.length > 0) then
                          INHERIT_RECUR( env )
                        else
                          SRC_ERROR( mdnam, 58, e_severe );
                        INSYMBOL
                      until sy <> comma;
                      if sy = rparen then INSYMBOL
                      else SRC_ERROR( mdnam, 23, e_error )
                    end;

                  atts_environment:
                    begin
                      if sy = lparen then INSYMBOL
                      else SRC_ERROR( mdnam, 22, e_error );
                      if (sy = stringconst) and (sy_string.length > 0) then
                      begin
                        envflg := true;
                        INSYMBOL
                      end;
                      if sy = rparen then INSYMBOL
                      else SRC_ERROR( mdnam, 23, e_error )
                    end;
                otherwise
                  SRC_ERROR_S( mdnam, 3, e_warning, sy_ident )
                end
              until (sy = eofsy) or (sy = comma) or (sy = rbrack)
          end
          else SRC_ERROR( mdnam, 2, e_severe )
        until sy <> comma;
        if sy = rbrack then INSYMBOL
                       else SRC_ERROR( mdnam, 26, e_error )
      end;

      if sy = modulesy then                    { A package definition is begining }
      begin
        INSYMBOL;                              { Get the package identifier }
        if sy <> identsy then SRC_ERROR( mdnam, 93, e_fatal )
      end
      else SRC_ERROR( mdnam, 999, e_fatal );
    end;

    if error_result > e_warning then emergency_stop := true;

    if not emergency_stop then ENV_BLOCK;      { Get the environement }

    if src_control <> nsrc then
    begin                                      { We have reached the EOF of env file => error }
      SRC_ERROR( mdnam, 5, e_fatal );
      emergency_stop := true
    end
    else
    begin                                      { OK for file }
      src_control := osrc;
      SRC_CLOSE( nsrc, true );                 { Close the env file }
      SET_SRCFILESPC( -1 );
      if error_result > e_warning then emergency_stop := true
    end
  end
  else
    SRC_ERROR( mdnam, 4, e_fatal )
end INHERIT_ENV;



[global]
procedure PAS_READ_ENV_FILE;
var
  cur_env:   env_ptr;

  sv_cmin, sv_ch:     char;
  sv_sym:    sym_rec;
  sv_lsym:   symbol;
  sv_string: string( 255 );
  sv_ival:   integer;
  sv_rval:   double;

begin
  sv_ch     := sy_ch;
  sv_cmin   := sy_cmin;
  sv_lsym   := lastsymb;
  sv_sym    := sy_sym;
  sv_string := sy_string;
  sv_ival   := sy_ival;
  sv_rval   := sy_rval;

  { Loop on all environment }
  cur_env   := env_first;
  while cur_env <> nil do
  with cur_env^ do
  begin
    INHERIT_ENV( cur_env );
    cur_env := cur_env^.env_nxt
  end;

  { Restore the previous context }
  sy_ch     := sv_ch;
  sy_cmin   := sv_cmin;
  lastsymb  := sv_lsym;
  sy_sym    := sv_sym;
  sy_ival   := sv_ival;
  sy_rval   := sv_rval
end PAS_READ_ENV_FILE;


[global]
procedure PAS_WRITE_ENV_FILE;
begin
end PAS_WRITE_ENV_FILE;


end.
