{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*     ---  Routines to scan a directory with a filter LVL-2 ---         *
*                                                                       *
*   Last revision of 15-Dec-2005 for cpas_lib V1.9S (by P. wolfers)     *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

{%pragma trace 0;}
module PAS__SCAN_DIR_2;
const
  cdi = '/';                                   { Directory Separator }
  cdt = '///';                                 { Undefined Tree Separator }
  cdv = ':';                                   { Logical/Physical Device Separator }

type
  flt_ptr = ^flt_rec;                          { Define a Filtre Profil Entry Pointer }

  set_cha = set of char;                       { Definition of a set of char }

  flt_rec = record                             { * Record Definition for string filtre profile }
              flt_nxt,                         { Link to next filtre element }
              flt_grp: flt_ptr;                { Link to first group filtre element }
              flt_pos: short_integer;          { Position in analyse string }
              flt_siz,                         { Total size of the entry (in char) }
              flt_pnch,                        { Prefix size }
              flt_snch: byte;                  { Suffix size }
              case flt_fst: boolean of         { To flag the string_entry/meta_character_entry }
                true:( flt_str: ^string );     { The related string }
                false:( flt_mch: set_cha )     { The set of available meta character }
            end;


  efl_ptr = ^efl_rec;                          { Define a Filtre (entry List) pointer }

  efl_rec = record                             { * Record Definition for Element Filtre Entry List }
              efl_nxt,                         { Pointer to next one }
              efl_prv:   efl_ptr;              { Pointer to previous one }
              efl_flt:   flt_ptr;              { Header of Element Filtre entry list }
              efl_wild:  boolean;              { Wild element if true }
              efl_name:  ^string;              { Related Fix part of name when not wild }
              efl_dir: $wild_pointer           { Pointer to opened directory }
            end;

  efl_blk = record                             { * Record to keep the user scan point }
              efb_head,                        { Head of efl_rec record }
              efb_stk:  efl_ptr                { ... and current stack pointer }
            end;

  efb_ptr = ^efl_blk;                          { Pointer for user reference }


  file_chtab = array[1..28] of cc__int;        { File charac. table (for GET_FILE_INFO) }


var
  [external 'PAS__file_info']
  tbfch:    file_chtab;                        { Current File Characteristics reference table (in cpas__std module) }
  efl_hde,                                     { List Header for Complete reference }
  efl_lst:  efl_ptr := nil;





function FSPC_CREATE_FILTER( in_var filtre: string ): flt_ptr; external;


procedure FSPC_FREE_FILTER( var hp: flt_ptr ); external;


function FSPC_MATCH( pf: flt_ptr; in_var spc: string ): boolean; external;



[global]
function FSPC_OPEN( in_var spc: string ): efb_ptr;
var
       p, pw: efl_ptr;
           u: efb_ptr;
  i, j, k, n: integer;
  elem, root:  string;
  bw, bi:     boolean;


procedure FSPC_NEW_ELEMENT( in_var str: string; bw: boolean );
{ Create a Profil Segment Descriptor }
var
  p: efl_ptr;

begin
  NEW( p );                                                        { Allocate a segment descriptor. }
  with p^ do
  begin
    efl_nxt  := nil;
    if bw then efl_flt := FSPC_CREATE_FILTER( str )                { For a wild segment, Create a Filter and link it, }
          else efl_flt := nil;                                     { ... else set the link to nil. }
    efl_wild := bw;                                                { Initialise all other segment decsriptor fields }
    efl_dir  := nil;
    if bw then                                                     { For a wild segment, }
    begin
      efl_prv  := pw; pw := p;                                     { ... we establish the link with the previous segment ... }
      efl_name := nil                                              { ... and clear the fixed string link. }
    end
    else                                                           { For a fixed segment, }
    begin
      NEW( efl_name, str.length );                                 { ... we establish the link with a fixed string copy. }
      efl_name^ := str
    end
  end;
  if efl_hde = nil then efl_hde := p                               { Append this descriptor to the Profil descriptor list ... }
                   else efl_lst^.efl_nxt := p;
  efl_lst := p;
  n := n + 1                                                       { ... and update the segment count. }
end FSPC_NEW_ELEMENT;



begin { FSPC_OPEN }
  efl_hde     := nil;                                              { Set the Profile Descriptor list as empty }
  pw          := nil;
  root.length :=   0;                                              { Init the initial first part of profile to empty }
  bi := true;                                                      { Set the Profile Scan begining Flag }
  i :=  1;
  n :=  0;                                                         { Initialise the segment count }
  while i <= spc.length do                                         { Main loop to Scan the wild profile string }
  begin
    k := INDEX( spc, cdi, 1, i, true );                            { Locate the first directory separator starting from the i position }
    if bi then                                                     { When we are at the begining of the scan }
    begin
      j := INDEX( spc, cdv );                                      { Locate a Device (physical/logical) Separator }
      if (j > 0) and ((j < k) or (k = 0)) then
      begin                                                        { OK., A Device is specified }
        root := SUBSTR( spc, 1, j );                               { Put the device name in the initial first part of profile }
        i := j + 1                                                 { Update the Scan index }
      end;
      bi := false                                                  { Clear the Scan Begining flag }
    end;
    if k = 0 then                                                  { When no directory separator was found, }
    begin
      elem := SUBSTR( spc, i );                                    { ... get all the end of profile as segment ... }
      i := spc.length + 1                                          { ... and flags index to the scan end value }
    end
    else
    begin                                                          { ... else ... }
      elem := SUBSTR( spc, i, k - i + 1 );                         { ... get the current segment (between to directory separator) ... }
      i := k + 1;                                                  { ... and update the scan index }
      { Elliminate the // in the specification }
      if (elem = cdi) and (k > 1) then elem := ''                  { When the element is a single directory separator, we clear it }
    end;

    if elem.length > 0 then                                        { With a true segment }
    begin                                                          { Search if any wild character is present }
      bw := (INDEX( elem, '*' ) <> 0) or (INDEX( elem, '?' ) <> 0) or
            (INDEX( elem, '[' ) <> 0);
      if bw then
      begin                                                        { For a Wild segment }
        { Directly wild mode => relatif to current directory }
        { / ./ or ../ should be in a separate element }
        if root.length > 0 then FSPC_NEW_ELEMENT( root, false )    { If a fixed segment is existing, put its Profil Descriptor before, }
        else                                                       { ... else, when we are working on the first segment, }
          if n = 0 then FSPC_NEW_ELEMENT( './', false );           { ... insert './' as root segment ... }
        root.length := 0;                                          { ... and clear the fixed segment string. }
        { We suppress any trailing '/' of wild reference }
        if elem[elem.length] = '/' then elem.length := elem.length - 1;
        FSPC_NEW_ELEMENT( elem, true )                             { Create the wild segment descriptor. }
      end
      else
      begin { Static mode : The '/' are always kept }
        if root.length = 0 then root := elem                       { Append the new fixed segment part to the previous one }
                           else root := root||elem;
        if i > spc.length then FSPC_NEW_ELEMENT( root, false )     { When it is the last segment, we put its Fixed Segment Descriptor. }
      end
    end
  end;

(*
  p := efl_hde;
  while p <> nil do
  with p^ do
  begin
    if efl_wild then WRITE( ' Wild Entry   ' )
                else WRITE( ' Static Entry ' );
    if efl_name <> nil then WRITE( '"', efl_name^,'"' );
    WRITELN;
    WRITELN;
    p := efl_nxt
  end;
*)

  NEW( u );                                                        { Allocate the header of segment descriptor list, }
  u^.efb_head := efl_hde;                                          { ... and fills and initialises it. }
  u^.efb_stk  := nil;
  FSPC_OPEN := u                                                   { Return the Scan descriptor list header Pointer }
end FSPC_OPEN;



[global]
procedure FSPC_CLOSE( u: efb_ptr );
{ Close the Profil descriptor and free its }
var
  p, pp: efl_ptr;

begin
  if u <> nil then                                                 { Work only for an allocated Profil. }
  begin
    p := u^.efb_head;
    while p <> nil do                                              { Loop on all segment descriptors }
    begin
      with p^ do
      begin
        pp := efl_nxt;                                             { Save the next link. }
        FSPC_FREE_FILTER( efl_flt );                               { Free the Filter descriptor when it is existing. }
        if efl_dir <> nil then CLOSE_DIR( efl_dir );               { if the related directory is opened, Close it. }
        if efl_name <> nil then DISPOSE( efl_name )                { When it exist, free the fixed name string location. }
      end;
      DISPOSE( p );                                                { Free theSegment descriptor ... }
      p := pp                                                      { ... and skip to next one. }
    end;
    DISPOSE( u )                                                   { Free the Descriptor header. }
  end
end FSPC_CLOSE;



[global]
procedure FSPC_SCAN( u: efb_ptr; var fname: string; var categ: integer );
{ Routine to scan an opened Profil }
var
  ierr: integer;


  function FSPC_SCAN_ITER: integer;
  var
    p:         efl_ptr;
    cat:       integer;
    spc, tmp:  string;
    bcnt:      boolean;

  begin
    p := u^.efb_stk;                                               { Get the scan pointer (nil at scan start time). }
    { On first call, efl_name is the (static) reference root
      on the other call (always a wild one)  p^.efl_name is
      the current reference to read a directory. }
    if p <> nil then spc := p^.efl_name^                           { When the scan was already started, we Get the partial File Ref. }
                else
                begin                                              { At the Scan start time, }
                  spc.length := 0;                                 { ... we clear the partial File Ref. and ... }
                  p := u^.efb_head                                 { ... get the first segment descriptor pointer. }
                end;

    loop                                                           { Segment Loop }
    with p^ do
      if efl_wild then                                             { *** For a wild segment *** }
      begin
        if efl_dir = nil then
        begin                                                      { There is no opened directory. }
          OPEN_DIR( efl_dir, spc, [case_ena_file] );               { Try to Open as a directory. }
          if efl_dir = nil then
          begin                                                    { Open Error - We have not the directory Access }
            p := u^.efb_stk;                                       { We return to previous wild directory (by following dynamic link). }
            if p = nil then                                        { If we have not previous wild, ... }
              return -1;                                           { ... we return the End Of List Value (=> End of Profil Scan) }
            spc := p^.efl_name^;                                   { else, Back to the previous context ... }
            goto ET_CONT                                           { ... and continue the Loop on segments. }
          end;
          { Now we put the spc string in the node for following call }
          if spc.length > 0 then                                   { Append a '/' when required : }
            if (spc[spc.length] <> cdi) and                        { ... To end ddirectory separator, }
               (spc[spc.length] <> cdv) then spc := spc||cdi;      { ... or no device separator. }
          NEW( efl_name, spc.length ); efl_name^ := spc;           { Make a copy of partial object ref. to save it. }
          { Set at the top opened directory }
          efl_prv := u^.efb_stk; u^.efb_stk := p                   { Push in stack (dynamic link stack: "last in, first out"). }
        end;

        { Now we can read the Directory Entries }
        repeat                                                     { Loop on directory Entries. }
          repeat
            READ_DIR( efl_dir, tmp, ierr );                        { Read a directory entry (put it in tmp). }
            if ierr <> 0 then                                      { End of Directory  ? }
            begin
              CLOSE_DIR( efl_dir );                                { Close the directory. }
              efl_dir := nil;
              DISPOSE( efl_name );                                 { Free the related Dir. spc. }
              efl_name := nil;
              p := efl_prv; u^.efb_stk := p;                       { Return for back call: Pop of dynamic stack. }
              if p = nil then return -1;                           { When not exist (empty stack), return End Of List Value }
              spc := p^.efl_name^;                                 { Otherwise, Back to the previous context }
              goto ET_CONT                                         { Stop the Read Loop }
            end
          until (tmp <> '.') and (tmp <> '..')                     { Always skip current and previous directory reference. }
               and FSPC_MATCH( efl_flt, tmp );                     { Continue to find a matching entry. }
          { We have find a matching entry: Insert a '/' when required }
          if (tmp[1] <> cdi) and (spc[spc.length] <> cdi)
                             and (spc[spc.length] <> cdv) then tmp := cdi||tmp;
          spc := spc||tmp;                                         { Build the new object reference. }
          cat := FSPC_GET_KIND( spc, false, false, [case_ena_file] );  { Get the object kind }
          { For not final reference we look only the directory ref. }
          if (cat < 0) or                                          { When this reference does not exist or ... }
            ((cat > 0) and (efl_nxt <> nil)) then                  { ... if the current segment is not the last, a valid ... }
          begin  spc := p^.efl_name^; cat := -1 end                { ... ref. must be a directory. }
        until (cat >= 0);                                          { Loop until new matching entry or End of Dir. }
        { Now the new reference spc is existing }

        if efl_nxt = nil then                                      { When we are in the top of ref. }
        begin
          fname := spc;  return cat                                { Set the resulting specification and return, }
        end;
        p := efl_nxt;                                              { ... else, goto next segment. }
      ET_CONT:
      end
      else
      begin                                                        { *** For fixed segment *** }
        if (spc.length > 0) and (spc[spc.length] <> '/') then spc := spc||'/'; { Force a '/' at end of old current directory ref. ... }
        spc := spc||efl_name^;                                     { ... and append it the fixed segment to set the new one. }
        cat := FSPC_GET_KIND( spc, false, false,[case_ena_file] ); { Get the kind of reference. }
        if efl_nxt <> nil then                                     { If it is not the last segment ... }
        begin                                                      { ... pass to next one, the name is always ended by ':' or '/' }
          if cat = 0 then p := efl_nxt                             { For a directory, we continue to next directory level, }
          else
          begin                                                    { ... else, we must return to the scan of previous directory }
            p := u^.efb_stk;                                       { We return to previous directory (wild) }
            if p = nil then                                        { If we have not previous one, ... }
              return -1;                                           { ... we return the End Of List Value (End of Scan Profil), }
            spc := p^.efl_name^                                    { else, back to the previous segment }
          end
        end
        else                                                       { We are on the last segment. }
        begin                                                      { Do not use for Init else undef. loop }
          if cat >= 0 then                                         { For an existing object (directory, file ... ), }
          begin                                                    { ...we must return it to caller. }
            fname := spc;                                          { Set it the complete object reference and ... }
            return cat                                             { ... return the object kind. }
          end;
          { The Object does not exist, we pop to previous segment or stop }
          p := u^.efb_stk;                                         { We return to previous directory (wild). }
          if p = nil then                                          { If we have not previous segment, ... }
              return -1;                                           { ... we return the End Of List Value }
          spc := p^.efl_name^                                      { else, we back to the previous segment }
        end
      end { with ... if efl_wild then ... else ... }
    end { loop }
  end FSPC_SCAN_ITER;


begin { FSPC_SCAN }
  if u <> nil then                                                 { We work only with a not nil pointer of profil descriptor. }
  with u^, efb_head^ do
  begin
    if efl_nxt = nil then                                          { Only one descriptor => Single reference without wild character. }
      if efb_stk = nil then                                        { On init, the Scan pointer is nil }
      begin
        categ := FSPC_GET_KIND( efl_name^, false, false, [case_ena_file] );    { We get the kind of this single reference. }
        if categ >= 0 then
        begin                                                      { If ref. OK, we set the result and flag for the next End Of List. }
          fname := efl_name^;
          efb_stk := efb_head
        end
      end
      else
      begin                                                        { On second call, we must return End of List }
        categ := -1;
        efb_stk := nil
      end
    else                                                           { For the Standard mode with some wild elements, }
      categ := FSPC_SCAN_ITER                                      { ... we call the Scan Profil routine. }
  end
  else categ := -20                                                { FSPC_OPEN was not done! }
end FSPC_SCAN;


end PAS__SCAN_DIR_2.
