{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*           * * *   S t a n d a r d   L i b r a r y   * * *             *
*                                                                       *
*                                                                       *
*                ---  Logical Name Manager Routine ---                  *
*                                                                       *
*                ---  Version  2.1-E -  03/11/2009 ---                  *
*       by :                                                            *
*                                                                       *
*             P. Wolfers                                                *
*                 C.N.R.S.                                              *
*                 Institut Neel                                         *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
%pragma trace 0; { Always here: called by PAS__ERROR to don not loop }
module CPAS__PHYSIC;


[external 'PAS__ERROR'] procedure ERROR( nerr: integer ); external;




[global 'PAS__GETPHYSIC']
function GET_PHYSIC_FSPC( var trg: string; in_var spc: string ): integer;
var
  err: integer;

{***********************************************************************}



  function GET_PHY_FSPC( in_var  fsp: string;
                                irep: integer;
                            var ierr: integer ): string;
  const
    sep = ':/]\';

  var
    c1, c2,
    llog, len, dnam:   integer;
    tmp, src:           string;

  begin
    if irep <= 10 then                  { Check for Circular definitions }
    begin
      src  := fsp;                      { Copy the string }
      len  := src.length;               { Save the Source Length }
      llog := INDEX( src, ':' );        { Extract the "Device Name" }
      { When no ":" the whole can be a logical }
      if llog > 0 then                  { When a device is specified ... }
        src.length := llog - 1          { ... simule SUBSTR( src, 1, llog ) }
      else
        llog := src.length;             { We try to get the whole of fspc }
      ierr := GET_LOGICAL( tmp, src );  { GET logical translation if it exist }
      src.length := len;                { Restore the source length }
      if ierr <> 0 then tmp.length := 0;{ Ignore too long translation }
      if ierr = -1 then ierr := 0;      { Ignore Not Found Error }
      if tmp.length = 0 then            { If we have no translation ... }
        GET_PHY_FSPC := src             { ... Return the original string }
      else
      begin { We have got a Logical Translation }
        c1 := INDEX( sep, src[llog+1] );
        c2 := INDEX( sep, tmp[tmp.length] );
        if (c1 > 0) or (c2 > 0) then
        begin { The logical was a logical file device specification }
          { Compute the length of the trailing file specification }
          if c1 = c2 then llog := llog + 1; { same directory separator to elliminate }
          len := src.length - llog;
          if function.capacity < tmp.length + len then ierr := -2;
          if len > 0 then src := tmp !! substr( src, llog + 1 )
                     else src := tmp
        end
        else src := tmp;

        { Try a Recursive call on success }
        if ierr = 0 then { If no error try to translate sub-logicals }
          GET_PHY_FSPC := GET_PHY_FSPC( src, irep + 1, ierr )
        else
          GET_PHY_FSPC := src
      end
    end
    else ierr := -100 { Circular definitions Error }
  end GET_PHY_FSPC;

{***********************************************************************}



begin
  trg := GET_PHY_FSPC( spc, 1, err );
  GET_PHYSIC_FSPC := err
end GET_PHYSIC_FSPC;

end CPAS__PHYSIC.
