{    **************************************************************
     *                                                            *
     *                                                            *
     *              *  C P A S  *  S Y S T E M  *                 *
     *                                                            *
     *                                                            *
     *      * * *   S t a n d a r d   L i b r a r y   * * *       *
     *                                                            *
     *                                                            *
     *            ---  Ennumerated I/O Library  ---               *
     *                                                            *
     *   by :                                                     *
     *                                                            *
     *       P. Wolfers                                           *
     *         c.n.r.s.                                           *
     *         Laboratoire de Cristallographie                    *
     *         B.P.  166 X   38042  Grenoble Cedex                *
     *                           FRANCE.                          *
     *                                                            *
     **************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}
%pragma trace 0;
module CPAS__IOENM;



(************   Ennumrated type input/ouput procedures  **************)

type
  eqv = record case integer of
    1:(ib: short_unsigned);
    2:(iw: word_unsigned);
    4:(il: unsigned)
  end;

  ennum_ptr = ^eqv;

[external 'PAS__ERROR'] procedure ERROR( nerr: integer ); external;

[global 'PAS__READ_ENM']
procedure READ_ENNUM(          pen: ennum_ptr;          { Address of ennum }
                              ensz: integer;            { its size in byte }
                      in_var  imtb: $wild_ennum_image;  { related table }
                               fld: integer := 0 );     { field to use }
const
  inmin = ORD( 'a' ) - ORD( 'A' );

var
  i, j: integer;
  sid: string( 64 );

begin
  if not CURRENT_EOF then
  begin
    READ$OBJECT( sid, fld, true );
    for i := 1 to sid.length do
      if (sid[i] >= 'A') and (sid[i] <= 'Z') then
        sid[i] := CHR( ORD( sid[i] ) + inmin );
    if not CURRENT_EOF then
    begin
      i := 0;
    ET_LOOP:
      repeat
        if ORD( imtb[i,0] ) = sid.length then
        begin
          j := 1;
          while (j <= sid.length) and (imtb[i,j] = sid[j]) do j := j + 1;
          exit ET_LOOP if j > sid.length;
        end;
        i := i + 1
      until i > imtb.nen;
      if i > imtb.nen then ERROR( 52 )
      else
      with pen^ do
      case ensz of
        1: ib := i;
        2: iw := i;
        4: il := i;
      otherwise
        ERROR( 53 );
      end
    end
  end
end READ_ENNUM;


[global 'PAS__WRITE_ENM']
procedure WRITE_ENNUM(        en:   unsigned;
                       in_var imtb: $wild_ennum_image;
                              f, p: integer := 0;
                              sp: char := ' ' );
var
  i, j:   integer;
  sid: string(32);
  bl, el, len: integer;

begin
  j := en;
  sid.length := ORD( imtb[j,0] );
  for i := 1 to sid.length do sid[i] := imtb[j,i];
  WRITE$OBJECT( sid, f, p, sp )
end WRITE_ENNUM;



end.
