{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*                     ---   MAIN PASCAL MODULE   ---                    *
*                                                                       *
*                 ---  Version  2.2-B -- 15/12/2010 ---                 *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire de Cristallographie                     *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


			----

		       nothing

			----

}

(*
[inherit( 'lib:cpas_b__src',           { Use basic string definitions }
          'lib:pas_env' )]             { Use PAS definitions }
*)
program PAS( input, output );

  { Import the global type/variable definitions, and
    the main entry external definitions }
  %include 'passrc:pcmp_global_def';



function SYS_ERROR_HANDLER( ierr: cc__int ): cc__int;
begin
  SRC_END_OF_LINE;                     { Stop the Source Parsing with error message editing }
  WRITELN;
  WRITELN( err, 'Compiler Fatal Error => Stop Compiler.' );
  WRITELN;
  SYS_ERROR_HANDLER := 0               { Continue Standard Error Process }
end SYS_ERROR_HANDLER;



procedure SEARCH_EXTENSION( var fnm: [readonly] string;
                            var ie, ij: integer );
var
  i: integer;

begin
  i := fnm.length;
  ie := 0;
  ij := 0;
  while i > 0 do
  begin
    case fnm.body[i] of
      '.':                ie := i;
      '/', '\', ']', ':': begin  ij := i; i := 0  end;
    otherwise
    end;
    i := i - 1
  end
end SEARCH_EXTENSION;



procedure SET_COMPILER_PARM;
{ Procedure to set the compiler options and file specifications }
var
  sp:                           srf_ptr;
  ierr, i, j, md:               integer;
  pcurr, src, lst, obj:  str_ptr := nil;
  str, sjob, s1, s2, s3:  string( 255 );

begin
  cmp_objf := true;
  pas_compile := true;                 { Set the To Compile flag }
  i  := 1;                             { Skip the # 0 parameter }
  md := 0;                             { Begining with the source file }
  cmp_traceopt := 5;                   { Set the default tracing to 5 lines }
  cmp_listlvl  := 1;                   { set the default listing level to one }
  while i < argc do
  begin
    if argv[i] <> nil then
    with argv[i]^ do
    if length > 0 then                 { It is a real parameter }
    begin
      pcurr := argv[i];
      if pcurr^[1] = '-' then
      begin
        with pcurr^ do
        if length > 1 then
        case body[2] of { * Get an Option }
          'T', 't': { * Error Tracing }
             begin
               if length > 2 then
               case body[3] of
                 '+': j := 1;
                 '-': j := 0;
                 '0','1','2','3','4','5','6','7','8','9':
                    j := ORD( body[3] ) - ORD( '0' );
               otherwise
               end
               else j := 1;
               cmp_traceopt := j
             end;
          'L', 'l': { * Listing Level Setting }
             begin
               if length > 2 then
               case body[3] of
                 '+': j := 10;
                 '-': j :=  1;
                 '0','1','2','3','4','5','6','7','8','9':
                    j := ORD( body[3] ) - ORD( '0' );
               otherwise
               end
               else j := 1;
               cmp_listlvl := j
            end;
          'D', 'd': { * Debug Generation }
             begin
               cmp_debugopt := true;
               cmp_traceopt := 1
             end;
          'N', 'n': { * No  code Generation }
             begin
               cmp_traceopt := 0;
               cmp_objf     := true
             end;
          'R', 'r': { * Check range Generation }
               cmp_range    := true;
          'C', 'c': { * Tree Output Code Enable }
               cmp_macf     := true;
          'H', 'h': { * The Help Information }
             begin
               WRITELN;
               WRITELN( ' The general form of a cpas command is:' );
               WRITELN( '    cpas [<option(s)>] <pascal_file> [<listing_file> [<c_file>]]' );
               WRITELN( '    When the <listing_file> is specified the Listing mode is Enabled.' );
               WRITELN( '    The default <listing_file> is TT: with listing disable and' );
               WRITELN( '    the default <c_file> is the <pascal_file> with the ".c" type.' );
               WRITELN;
               WRITELN( ' The cpas <option(s)> are (major or minor letter) :' );
               WRITELN( '    -tn To set the error tracing precision to n lines,' );
               WRITELN( '        where n is a single digit 0 to 9 and + or - .' );
               WRITELN( '        -t0 and -t- disable the error tracing,' );
               WRITELN( '        -t+ is equivalent to -t1 and the default is -t5,' );
               WRITELN( '        this options is equivalent to "%pragma trace:<n>;" .' );
               WRITELN( '    -ln To set the listing output level to list the included' );
               WRITELN( '        source listing with n in the range 1..9 (default is -l1).' );
               WRITELN( '    -r  To enable the value out of range error detection' );
               WRITELN( '        (usefull to detect the out of array index range).' );
               WRITELN( '    -n  To disable the code generation for checking code purpose.' );
               WRITELN( '    -d  To enable the future debug generation mode;' );
               WRITELN( '        this options induces the -t1 tracing mode.' );
               WRITELN( '    -c  To enable the logical tree output. The effect is' );
               WRITELN( '        equivalent to the macro statement "%pragma cp_list_on;" .' );
               WRITELN;
               WRITELN( '    -h  To output this help text.' );
               WRITELN
             end;
        otherwise
          { Ignore Unknown Options }
          WRITELN( ' Pascal Ignore unknown Command Option.' )
        end
      end
      else
      begin { * Get a filename }
        case md of
          0: { Source File Specification }
            begin  md := 1; src := pcurr  end;
          1: { Listing File Specification }
            begin  md := 2; lst := pcurr  end;
          2: { Object File Specification }
            begin  md := 3; obj := pcurr  end;
        otherwise
          { Ignore other extra parameters }
          WRITELN( ' Pascal Ignore all Extra Command Parameter(s).' )
        end
      end
    end;
    i := i + 1
  end;

  { Now Open the specified Source, Listing, and object File }
  if src = nil then
  begin
    WRITELN( ' No Specified Pascal Source => Stop.' );
    emergency_stop := true
  end
  else
  begin
    str := src^;
    SEARCH_EXTENSION( str, i, j );
    if i = 0 then
    begin
      sjob := SUBSTR( str, j + 1 );    { Keep the file name without type }
      str  := str||'.pas'              { Set the Pascal filetype }
    end
    else sjob := SUBSTR( str, j + 1, i - j - 1 );
    SRC_OPEN( src_control, str, false, ierr );
    if ierr = 0 then
    begin { Source is open }
      SET_SRCFILESPC( 0 );             { Set the tracing structure }
      { Define and set The Listing File Specification }
      with src_control^, lst_current^ do
        if lst = nil then
          src_flags := src_flags - [src_blist]
        else
        begin
          str := lst^;
          if str.length = 3 then
            if ((str[1] = 't') or (str[1] = 'T')) and
               ((str[2] = 't') or (str[2] = 'T')) and
               (str[3] = ':') then str.length := 0;
          if str.length > 0 then
          begin
            SEARCH_EXTENSION( str, i, j );
            if i = 0 then
            begin
              if j = str.length then str := str||sjob;
              str := str||'.lis'
            end
          end;
          if lst_heading <> nil then s1 := lst_heading^ else s1 := '';
          if lst_title   <> nil then s2 := lst_title^   else s2 := '';
          if lst_sbttl   <> nil then s3 := lst_sbttl^   else s3 := '';
          LST_OPEN( lst_current, str, s1, s2, s3,
                    132,               { 132 char. / line }
                    -1,                { tty/no => dis./ena. page managment }
                    false,             { New version mode }
                    false,             { No print on close time }
                    false,             { No append }
                    ierr );
          if ierr = 0 then
          begin
            src_flags := src_flags + [src_blist];
            if src_lstmxlev < src_level then src_lstmxlev := src_level;
          end else src_flags := src_flags - [src_blist]
        end;

      { Define and set The Object File Specification }
      if obj = nil then
        if sjob.length > 0 then str := sjob
                           else
                           begin
                             WRITELN( ' Pascal Creates the "pascal.c" file.' );
                             str := 'pascal.c'
                           end
      else str := obj^;
      SEARCH_EXTENSION( str, i, j );
      if i = 0 then
      begin
        if j = str.length then str := str||sjob;
        str := str||'.c'
      end;
      NEW( pas_obj, str.length );
      pas_obj^ := str
    end
    else
    begin                              { Cannot Open a Source File }
      WRITELN( ' Pascal Cannot Open The Pascal Source File.' );
      emergency_stop := true
    end
  end
end SET_COMPILER_PARM;



begin { PAS main }
  CMP_INIT;                            { Initialize the PAS compiler }

  if not emergency_stop then
    SET_COMPILER_PARM;                 { Set the Compiler Parameters and Options }

  { EXE_INIT;                          { Initialize the PAS processor }

  if not emergency_stop then           { if no initialize error then }
  begin
    { Set the System Error Handler }
    ESTABLISH( SYS_ERROR_HANDLER );

    CMP_COMPILE( true );               { Compile pas.ini and linked source(s) }

    if pas_main <> nil then
      if pas_main^.pro_pkind = pro_main then
        GENERATE_START                 { Set the start addess when specified }
  end
end PAS { The main }.
