{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*          ---   COMMON   PASCAL   ENVIRONMENT   MODULE    ---          *
*                                                                       *
*              ---  Version  2.1-H -- 30/03/2010 ---                    *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire de Cristallographie                     *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

{  Version 2.1-E   of    P - A - S      system  }
{************     CPAS  version    *************}

{
        *** modification(s) from major version ***


			----

		       nothing

			----

}

  {**************************************************}
  {*******            program  head            ******}
  {**************************************************}


(*
[inherit(     'lib:basic_env_str',
              'lib:basic_env_txf',
              'lib:basic_env_lst',
              'lib:basic_env_src',

              'lib:pas_env')]       { use kernel tree definitions }
*)
module PAS_DUMP_TREE( input, output ); { input and output for user terminal }

%include 'PASSRC:pcmp_env'; { Get the PASCAL environment definitions }


var
  in_int: record case integer of
    0:( i: integer );
    1:( p: lgt_ptr );
    2:( v: val_ptr );
    3:( t: typ_ptr );
    4:( s: str_ptr );
    5:( e: pro_ptr )
  end;

  lin: string( 255 );
  ich:       integer;


procedure DUMP_PRO_FLAGS( pr: pro_ptr; var ln: string; bini: boolean );
var
  bf: boolean;

begin
  if pr <> nil then
  begin
    WRITEV( ln:false, ',f=[' );
    bf := false;
    for flg := pro_flagstyp"first to pro_flagstyp"last do
      if flg in pr^.pro_flags then
      begin
        if bf then WRITEV( ln:false, ',' );
        WRITEV( ln:false, flg );
        bf := true
      end;
    WRITEV( ln:false, ']' )
  end
end DUMP_PRO_FLAGS;



[global]
function IN_UNSIGNED( p: $wild_pointer ): unsigned;
begin
  in_int.p := p;
  IN_UNSIGNED := in_int.i
end IN_UNSIGNED;


[global]
procedure LGT_WRITE_TREE( icol: integer; p: lgt_ptr );
var
  bnx: boolean;
  is: integer;

begin { LGT_WRITE_TREE }
  is := 0;
  while p <> nil do
  begin
    LGT_WRITE( icol, is, p );
    is := is + 1;
    p := p^.lgt_nxt
  end
end LGT_WRITE_TREE;


[global]
procedure LGT_WRITE( icol, is: integer; p1: lgt_ptr );
var
  bnx, b1:        boolean;
  i, j:           integer;

begin { LGT_WRITE }
  if p1 <> nil then
  with p1^, lst_current^ do
  begin
    if (lgt_lbl in lgt_status) and (lgt_lide <> nil) then
    with lgt_lide^ do
      if ide_name <> nil then
      with ide_name^ do
      begin
        LST_NEWLINE; WRITELN( lst_file, 'Label ', s:l, ':' )
      end;

    in_int.p := p1;
    LST_NEWLINE; WRITE( lst_file, in_int.i:10, '/', ' ':icol, is:1, ' ',
                                           lgt_kind, ' d:', lgt_disp:0 );

    WRITE( lst_file, ' [' ); i := 0;
    for sf := lgt_state_flags"first to lgt_state_flags"last do
      if sf in lgt_status then
      begin
        if i > 0 then  WRITE( lst_file, ',' );
        i := i + 1; WRITE( lst_file, sf )
      end;
    WRITE( lst_file, ']' );

    if lgt_typ <> nil then
    with lgt_typ^ do
    begin
      WRITE( lst_file, ' ', typ_form );
      begin
        if typ_form = form_int then
          if typ_unsigned then WRITE( lst_file, '/U' )
                          else WRITE( lst_file, '/S' );
        WRITE( lst_file, ':', typ_size:0 )
      end
    end
    else
      WRITE( lst_file, ' nil_type');
    case lgt_kind of
      lgt_ctlflow:
        begin
          WRITE( lst_file, ' ', lgt_stm );
          if ((lgt_stm = stm_goto) or (lgt_stm = stm_jump)) and
              (lgt_lab <> nil) then
            with lgt_lab^, ide_name^ do
            begin
              WRITE( lst_file, ' "', s:l, '"', '(Lex=', ide_lex:1, ')' )
            end
        end;

      lgt_codep:
          WRITE( lst_file, ' ', lgt_pcode );

      lgt_srcinfo:
          WRITE( lst_file, ' line#: ', lgt_disp, ' ', lgt_icode );

      lgt_srvcall:
          WRITE( lst_file, ' Srv_', lgt_srvfunc^.srv_ide:0 );

      lgt_srvref:
          if lgt_icode >= 0 then WRITE( lst_file, ' Ref_V',   lgt_icode:0 )
                            else WRITE( lst_file, ' Ref_P', - lgt_icode:0 );

      lgt_specific:
          WRITE( lst_file, ' ', lgt_icode );

      lgt_call,
      lgt_result,
      lgt_iproref,
      lgt_proref:
          if lgt_pro <> nil then
          with lgt_pro^ do
          begin
            in_int.e := lgt_pro;
            WRITEV( lin, ' ', in_int.i:-10, '/' );
            if pro_stdname <> nil then with pro_stdname^ do WRITEV( lin:false, '"', s:l, '"' )
                                  else WRITEV( lin:false, '<No_name>' );
            WRITEV( lin:false, pro_pkind );
            DUMP_PRO_FLAGS( lgt_pro, lin, false );
            WRITE( lst_file, lin )
          end
          else WRITE( lst_file, ' proc_nil' );

      lgt_null:
          if lgt_parmlst <> nil then
          begin
            in_int.p := lgt_parmlst;
            with lgt_parmlst^ do
            begin
              WRITE( lst_file, ' ', in_int.i:10,' -> ',
                               lgt_kind, ':', lgt_disp, ' ' );
              case lgt_kind of
                lgt_codep:
                  begin
                    WRITE( lst_file, lgt_pcode );
                    if (lgt_pcode = pcod_noop) and (lgt_parmlst <> nil) then
                    begin
                      in_int.p := lgt_parmlst;
                      WRITE( lst_file, ' -> ', lgt_parmlst^.lgt_kind, ' at ', in_int.i:10 )
                    end
                  end;

                lgt_varbl:
                  begin
                    WRITE( lst_file, lgt_disp:0);
                    if lgt_ide <> nil then
                      with lgt_ide^.ide_name^ do
                        WRITE( lst_file, ' "', s:l, '"');
                    WRITELN( lst_file );
                    LGT_WRITE( icol + 6, 0, p1^.lgt_parmlst );
                  end;

                lgt_const:
                  if lgt_cte <> nil then
                  with lgt_cte^ do
                  begin
                    WRITE( lst_file, ' ', val_kind );
                    case val_kind of
                      form_char, form_lit, form_int:
                        WRITE( lst_file,' ', val_ival:0 );

                      form_set, form_wset: WRITE( lst_file, ' ', val_set.siv ); 

                      form_lset, form_wlset:
                        if val_sar <> nil then
                        begin
                          bnx := false; WRITE( lst_file, ' [' );
                          for i := 0 to val_size - 1 do
                          begin
                            if bnx then WRITE( lst_file, ',' )
                                   else bnx := false;
                            WRITE( lst_file, val_sar^[i].siv )
                          end;
                          WRITE( lst_file, ']' )
                        end;

                      form_wwset: WRITE( lst_file, ' 0' ); 

                      form_single, form_double: WRITE( lst_file,' ', val_rval );

                      form_array, form_record:
                        begin
                          in_int.v := val_lst; WRITE( lst_file, in_int.i:10 );
                          WRITE( lst_file, ' sz:', val_size:0 )
                        end;

                      form_string:
                        begin
                          in_int.s := val_str; WRITE( lst_file, ' ', in_int.i:10 );
                          WRITE( lst_file, ' sz:', val_size:0 )
                        end;

                      form_wild:
                        if val_tab <> nil then
                        begin { case table }
                          WRITE( lst_file, ' Case_tab: ', val_size:1, '/' );
                          j := 4;
                          for i := 0 to val_size - 1 do
                          begin
                            WRITE( lst_file, ' ', val_tab^.lw[i]:1 );
                            j := j + 1;
                            if j = 10 then
                            begin  j := 0; WRITELN( lst_file ); LST_NEWLINE  end
                          end;
                          if j <> 0 then
                          begin  WRITELN( lst_file ); LST_NEWLINE  end
                        end;

                    otherwise
                    end { case val_kind }
                  end;

                lgt_ctlflow: WRITE( lst_file, ' ', lgt_stm );

              otherwise
              end
            end
          end;

      lgt_vartmp:
          begin
            if lgt_nwt in lgt_status then WRITE( lst_file, ' New' );
            if lgt_frt in lgt_status then WRITE( lst_file, ' Free' )
          end;

      lgt_varbl:
          begin
            if lgt_ide <> nil then
            with lgt_ide^ ,ide_name^ do
            begin
              if lgt_typ <> nil then i := lgt_typ^.typ_size
                                else i := -1;
              WRITE( lst_file, ' "', s:l, '" sz=', i:0, '(',ide_lex:1,') ',
                               ide_class);
              if ide_class = cla_varbl then
              begin
                WRITE( lst_file, ' ', ide_vkind );
                if var_intaccess in ide_vacc then WRITE( lst_file, ' iu' )
                else
                  if var_used in ide_vacc then WRITE( lst_file, ' us' );
                if var_in in ide_vacc then WRITE( lst_file, ' in' );
                if var_out in ide_vacc then WRITE( lst_file, ' out' );
                if var_named in ide_vacc then WRITE( lst_file, ' identified' );
              end;
              if lgt_alloc <> ide_all then WRITE( lst_file, ' ** Bad Mem. **' )
            end
            else
              WRITE( lst_file , ' ident_nil' );
            if lgt_alloc = nil then WRITE( lst_file, ' ** NO Mem. **' )
          end;

      lgt_agregat:
          WRITE( lst_file, ' ', lgt_isz );

      lgt_const:
          if lgt_cte <> nil then
          with lgt_cte^ do
          begin
            WRITE( lst_file, ' ', val_kind );
            case val_kind of
              form_char,
              form_lit,
              form_int:
                WRITE( lst_file,' ', val_ival:0 );

              form_set,
              form_wset: WRITE( lst_file, ' ', val_set.siv ); 

              form_lset, form_wlset:
                if val_sar <> nil then
                begin
                  bnx := false;
                  WRITE( lst_file, ' [' );
                  for i := 0 to val_size - 1 do
                  begin
                    if bnx then WRITE( lst_file, ',' )
                           else bnx := false;
                    WRITE( lst_file, val_sar^[i].siv )
                  end;
                  WRITE( lst_file, ']' )
                end;

              form_wwset: WRITE( lst_file, ' 0' ); 

              form_single,
              form_double:
                WRITE( lst_file,' ', val_rval );

              form_array,
              form_record:
                begin
                  in_int.v := val_lst; WRITE( lst_file, in_int.i:10 );
                  WRITE( lst_file, ' sz:', val_size:0 )
                end;

              form_string:
                begin
                  in_int.s := val_str; WRITE( lst_file, ' ', in_int.i:10 );
                  WRITE( lst_file, ' sz:', val_size:0 )
                end;

              form_wild:
                if val_tab <> nil then
                begin { case table }
                  WRITE( lst_file, ' Case_tab: ', val_size:0, '/' );
                  j := 4;
                  for i := 0 to val_size - 1 do
                  begin
                    WRITE( lst_file, ' ', val_tab^.lw[i]:1 );
                    j := j + 1;
                    if j = 10 then
                    begin  j := 0; WRITELN( lst_file ); LST_NEWLINE  end
                  end;
                  if j <> 0 then
                  begin  WRITELN( lst_file ); LST_NEWLINE  end
                end;

            otherwise
            end { case val_kind }
          end { with }

    otherwise
    end; { case lgt_kind }

    if lgt_lide <> nil then
      with lgt_lide^.ide_name^ do
        WRITE( lst_file, '//"', s:l, '"' );
    WRITELN( lst_file );

    case lgt_kind of
      lgt_null, lgt_varbl, lgt_const:                  { Nothing to do } ;
      lgt_ctlflow:
        if (lgt_stm <> stm_goto) and (lgt_stm <> stm_jump) then
          LGT_WRITE_TREE( icol+2, lgt_parmlst )        { Follow all tree parameters }
    otherwise
      LGT_WRITE_TREE( icol+2, lgt_parmlst )            { Follow all tree parameters }
    end
  end { with }
  else
  begin
    LST_NEWLINE;
      WRITELN( lst_current^.lst_file, in_int.i:10, '/', ' ':icol, is:1, ' << Nil Pointer >>' );
  end
end LGT_WRITE;



procedure VAL_DUMP_SIMPLE( f: typ_forms; pv: val_ptr );
var
  eqv: record case integer of
         0: (usv: unsigned);
         1: (tb: array[1..4] of byte)
       end;

begin
  if pv <> nil then
  with pv^ do
  begin
    LST_PUT_STRING( ' (' );
    LST_PUT_INT( val_size, 0 );
    LST_PUT_CHAR( ')' );
    case f of
      form_char:
        begin
          LST_PUT_STRING( 'c:' ); LST_PUT_CHAR( CHR( val_ival ) )
        end;

      form_lit, form_wlit:
        begin
          LST_PUT_STRING( 'l:' ); LST_PUT_INT( val_ival, 0 )
        end;

      form_int:
        begin
          LST_PUT_STRING( 'i:' ); LST_PUT_INT( val_ival, 0 )
        end;

      form_single:
        begin
          LST_PUT_STRING( 'f:' ); LST_PUT_FLOAT( val_rval, 0, 0, 0 )
        end;

      form_double:
        begin
          LST_PUT_STRING( 'g:' ); LST_PUT_FLOAT( val_rval, 0, 0, 0 )
        end;

      form_pointer, form_nil: LST_PUT_STRING( '<Pointer>' );

      form_set, form_wset:
        begin
          eqv.usv := val_set.siv;
          LST_PUT_STRING( 's:[' );
          for ii := 1 to 4 do
          begin
            LST_PUT_INT( eqv.tb[ii], -8, 2 ); LST_PUT_CHAR( ' ' )
          end;
          LST_PUT_CHAR( ']' )
        end;

      form_wwset: LST_PUT_STRING( '<Large_Wild_Set>' );

      form_lset, form_wlset:
        if val_sar <> nil then
        begin
          LST_PUT_STRING( 'ws:[' );
          for i := 0 to val_size - 1 do
          begin
            if i > 0 then
            begin
              LST_PUT_CHAR( ',' );
              if i mod 2 = 0 then begin
                LST_EOLN; LST_NEWLINE; LST_PUT_STRING( ' * Set next * ' )
              end
            end;
            LST_PUT_INT( i, 0 ); LST_PUT_CHAR( ':' );
            eqv.usv := val_sar^[i].siv;
            for ii := 1 to 4 do
            begin
              LST_PUT_INT( eqv.tb[ii], -8, 2 ); LST_PUT_CHAR( ' ' )
            end
          end;
          LST_PUT_CHAR( ']' )
        end;

      form_string:
        if val_str <> nil then
        with val_str^ do
        begin
          LST_PUT_STRING( 'string[' );
          LST_PUT_INT( capacity, 0 ); LST_PUT_CHAR( '/' ); LST_PUT_INT( length, 0 );
          LST_PUT_STRING( ']:''' );
          if length > 0 then LST_PUT_STRING( val_str^ );
          LST_PUT_CHAR( '''' )
        end;

      form_range:
        if val_typ <> nil then
        with val_typ^ do
          if typ_form = form_range then
          begin
            if typ_parent <> nil then
              VAL_DUMP_SIMPLE( typ_parent^.typ_form, pv )
          end
          else VAL_DUMP_SIMPLE( typ_form, pv )

    otherwise
    end
  end
end VAL_DUMP_SIMPLE;


[global]
procedure VAL_DUMP( pv: val_ptr; icol, icnt, ishc: integer := 0 );
begin
  if pv <> nil then
  with pv^, lst_current^ do
  begin
    LST_NEWLINE;
    if icol > 0 then LST_PUT_MCHAR( ' ', icol );
    if icnt > 0 then
    begin  LST_PUT_INT( icnt, 7 ); LST_PUT_CHAR( '/' )  end
    else if icnt < 0 then
    begin
      LST_PUT_CHAR( 'D' );
      LST_PUT_INT( icnt + ishc + 1, 3 );
      LST_PUT_STRING( '   /' )
    end;
    case val_kind of
      form_file:
        LST_PUT_STRING( ' <File_Descriptor>' );

      form_array, form_conf, form_record:
        if val_lst <> nil then
        begin
          if val_kind <> form_record then LST_PUT_STRING( ' Array(' )
                                     else LST_PUT_STRING( ' Record(' );
          LST_PUT_INT( val_size, 0 ); LST_PUT_STRING( ') = [' );
          LST_EOLN;
          if val_descr > 0 then icnt := - val_descr
                           else icnt := 1;
          pv := val_lst;
          repeat
            VAL_DUMP( pv, icol + 8, icnt, val_descr );
            icnt := icnt + 1;
            if icnt = 0 then icnt := 1;
            pv := pv^.val_next
          until pv = nil;
          LST_PUT_MCHAR( ' ', icol + 9 );
          LST_PUT_CHAR( ']' )
        end;

    otherwise
      VAL_DUMP_SIMPLE( val_kind, pv )
    end;
    LST_EOLN
  end
end VAL_DUMP;



procedure ALL_DUMP_LOCATION( alp: all_ptr );
var
  p1: lgt_ptr;
  i:  integer;

begin
  i := 0;
  while alp <> nil do
  begin
    with alp^, lst_current^ do
    begin
      LST_NEWLINE; WRITE( lst_file, ' ', all_kind, ' ');
      if all_typ <> nil then WRITE( lst_file, all_typ^.typ_form, '<' );
      if all_ide = nil then
        WRITE( lst_file, 'no_identifier' )
      else
        with all_ide^.ide_name^ do
          WRITE( lst_file, '"', s:l, '"' );
      WRITE( lst_file, '>' );
      WRITELN( lst_file, ' ', all_align.int:0, ':', all_size:0, ':',
                              all_disp:0, '(', all_lex:-2, ')' );
      if all_cte <> nil then
      with all_cte^ do
      begin
        LST_NEWLINE;
        WRITELN( lst_file, ' With initial value (', val_kind, ') :' );
        LST_EOLN;
        VAL_DUMP( all_cte )
      end;

      p1 := all_first_u;
      i := 0;
      if p1 <> nil then
      begin
        LST_NEWLINE; WRITELN( lst_file, ' Used at : ' )
      end;
      while p1 <> nil do
      begin
        if i = 9 then
        begin
          i := 0;
          LST_NEWLINE;
          WRITELN( lst_file )
        end
        else WRITE( lst_file, ':' );
        in_int.p := p1; WRITE( lst_file, in_int.i:10 );
        i := i + 1;
        p1 := p1^.lgt_parmlst
      end;
      if i > 0 then WRITELN( lst_file )
    end;
    alp := alp^.all_nxt
  end
end ALL_DUMP_LOCATION;



[global]
procedure LGT_DUMP_ROUTINES;
var
  srv: srv_ptr;
  svp: svp_ptr;

begin
  if srv_first <> nil then
  begin
    srv := srv_first;
    while srv <> nil do
    with srv^ do
    begin
      LST_TEST_LINE( 4, 12 );
      LST_PUT_STRING( ' Service Routine # ' );
      LST_PUT_INT( srv_ide, 0 );
      LST_EOLN;
      LGT_WRITE_TREE( 2, srv_cod );
      LST_EOLN;
      LST_EOLN;
      srv := srv_nxt
    end
  end
end LGT_DUMP_ROUTINES;



[global]
procedure LGT_DUMP_PROC( pr: pro_ptr );
var
  md: string(  32 );
  ln: string( 255 );
  bf:       boolean;

begin { LGT_DUMP_PROC }
  in_int.e := pr;
  with pr^, lst_current^ do
  begin
    LST_PAGE; { Force a page skip on the next line output }
    with pro_stdname^ do
    begin
      md.length := l;
      for i := 1 to l do md.body[i] := s[i]
    end;
(*
    LST_PUT_STRING( ' LoGical Tree dump for the routine "' );
    LST_PUT_STRING( md );
    LST_PUT_STRING( '".' );
    LST_EOLN;
*)
    WRITEV( lin, ' LoGical Tree dump for the routine "', md, '" (', pro_pkind, ') at ', in_int.i:-10, ' f=' );
    DUMP_PRO_FLAGS( pr, lin, false );
    LST_PUT_STRING( lin ); LST_EOLN;
    LGT_WRITE_TREE( 2, pro_lgt );

    if pro_ldyn_all <> nil then
    begin
      LST_TEST_LINE( 4, 12 );
      LST_PUT_STRING( ' Dynamic Memory Allocation for the routine "' );
      LST_PUT_STRING( md );
      LST_PUT_STRING( '".' );
      LST_EOLN;
      ALL_DUMP_LOCATION( pro_fdyn_all )
    end;
  end
end LGT_DUMP_PROC;



procedure DUMP_DATA( p: val_ptr; in_var md, nam: string );
begin
  if p <> nil then
  begin
    LST_TEST_LINE( 4, 12 );
    LST_PUT_STRING( nam );
    LST_PUT_STRING( ' of the module "');
    LST_PUT_STRING( md );
    LST_PUT_STRING( '".' );
    LST_EOLN;
    while p <> nil do
    begin
      VAL_DUMP( p );
      p := p^.val_next
    end
  end
end DUMP_DATA;



procedure DUMP_ALLOC( p: all_ptr; in_var md, nam: string );
begin
  if p <> nil then
  begin
    LST_TEST_LINE( 4, 12 );
    LST_PUT_STRING( nam );
    LST_PUT_STRING( ' of the module "');
    LST_PUT_STRING( md );
    LST_PUT_STRING( '".' );
    LST_EOLN;
    ALL_DUMP_LOCATION( p )
  end
end DUMP_ALLOC;



[global]
procedure LGT_DUMP_STATIC( pr: pro_ptr );
var
  md: string( 32 );

begin
  with pr^ do
  begin
    with pro_stdname^ do
    begin
      md.length := l;
      for i := 1 to l do  md.body[i] := s[i]
    end;

    { *** Dump the Environemnt Constant Data Objects *** }
    DUMP_DATA( vagd_first,  md, ' Environment Data Section' );

    { *** Dump the Environment Objects with Initial Value *** }
    DUMP_ALLOC( algi_first, md, ' Environment Inited Section' );

    { *** Dump the Environment Objects without Initial Value *** }
    DUMP_ALLOC( algs_first, md, ' Environment Static Section' );

    { *** Dump the Constant Data Objects *** }
    DUMP_DATA( vald_first,  md, ' Data Section' );

    { *** Dump the Static Objects with Initial Value *** }
    DUMP_ALLOC( alsi_first, md, ' Static Inited Section' );

    { *** Dump the Static Objects without Initial Value *** }
    DUMP_ALLOC( alls_first, md, ' Static Section' )
  end
end LGT_DUMP_STATIC;


[global]
procedure DUMP_TYPES( icol: integer; ty: typ_ptr );
var
  ip:     ide_ptr;
  pr:     pro_ptr;
  i1, nn: integer;

begin
  if ty <> nil then
  with ty^, lst_current^ do
  begin
    in_int.t := ty;
    LST_NEWLINE; WRITE( lst_file, in_int.i:10, '/', ' ':icol, 'Type Form kind ', typ_form, ' :' );
    if typ_ide <> nil then with typ_ide^ do
      if ide_name <> nil then with ide_name^ do WRITE( lst_file, 'Ident = "', s:l );
    WRITELN( lst_file, '", Sizes ', typ_descr_size:0, ':', typ_size:0 );
    LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'Flags (subtyp,hasidsc,simple) ',
                                    typ_subtype, ':', typ_hasidsc, ':', typ_simple );
    if typ_parent <> nil then
    begin
      in_int.t := typ_parent;
      LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'Defined Parent Type at ', in_int.i:10 );
    end;

    if typ_attsub <> nil then 
    begin
      LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'Defined Attached Sub Type :' );
      DUMP_TYPES( icol + 2, typ_attsub )
    end;

    if typ_parmlst <> nil then
    begin
      LST_NEWLINE; WRITELN( lst_file, ' ':icol, ' Formal List :' );
      ip := typ_parmlst; i1 := 1;
      while ip <> nil do
      with ip^ do
      begin
        LST_NEWLINE; WRITE( lst_file, ' ':icol, i1:0 );
        if ide_name <> nil then with ide_name^ do WRITE( lst_file, ' Ident = "', s:l, '"');
        WRITELN( lst_file, ', offset=', ide_toffset:0 );
        if ide_tlink <> nil then
        begin
          LST_NEWLINE; WRITELN( lst_file, ' ':icol+2, 'With related ide_tlink:' );
          LGT_WRITE( icol+4, 0, ide_tlink )
        end;
        if ide_tlink2 <> nil then
        begin
          LST_NEWLINE; WRITELN( lst_file, ' ':icol+2, 'With related ide_tlink2:' );
          LGT_WRITE( icol+4, 0, ide_tlink2 )
        end;
        ip := ide_nxt; i1 := i1 + 1
      end
    end;

    if typ_actual <> nil then
    begin
      LST_NEWLINE; WRITELN( lst_file, ' ':icol, ' Actual List :' );
      LGT_WRITE_TREE( icol+2, typ_actual )
    end;
    if typ_comp_size <> nil then
    begin
      LST_NEWLINE; WRITELN( lst_file, ' ':icol, ' Comp_Size Tree :' );
      LGT_WRITE_TREE( icol+2, typ_comp_size )
    end;

    case typ_form of
      form_conf,
      form_array:
        begin
          LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'Ndim=', typ_idim, ',El Size=', typ_el_size );
          LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'Array Index :' );
          DUMP_TYPES( icol+2, typ_indtype );
          LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'Array Element :' );
          DUMP_TYPES( icol+2, typ_aeltype );
          LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'El_Comp_Size Tree :' );
          LGT_WRITE( icol+2, 0, typ_el_comp_size )
        end;

      form_variant,
      form_record:
        begin
          i1 := 1;
          ip := typ_firstfield;
          loop
            with ip^ do
            begin
              LST_NEWLINE; WRITE( lst_file, ' ':icol, i1:0 );
              if ide_name <> nil then with ide_name^ do WRITE( lst_file, ' Ident = "', s:l, '"');
              WRITELN( lst_file, ', offset=', ide_offset:0 );
              DUMP_TYPES( icol+2, ide_typ )
            end;
          exit if ip = typ_lastfield;
            ip := ip^.ide_nxt; i1 := i1 + 1
          end
        end;

      form_range:
        begin
          LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'Nvalues Tree' );
          LGT_WRITE_TREE( icol+2, typ_nvalue );
          LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'Low Tree' );
          LGT_WRITE_TREE( icol+2, typ_low );
          LST_NEWLINE; WRITELN( lst_file, ' ':icol, 'High Tree' );
          LGT_WRITE_TREE( icol+2, typ_high )
        end;

      form_fentry:
        begin
          pr := typ_entry;
          if pr <> nil then
          with pr^ do
          begin
            LST_NEWLINE;
            if pro_typ <> nil then WRITE( lst_file, ' ':icol, ' Function_type=', pro_typ^.typ_form )
                              else WRITE( lst_file, ' ':icol, ' procedure' );
            WRITELN( lst_file, '(' );
            ip := pro_parmlst;
            nn := 0;
            if pro_typ <> nil then if not pro_typ^.typ_simple then nn := -1;
            while ip <> nil do
            with ip^ do
            begin
              nn := nn + 1;
              LST_NEWLINE; WRITELN( lst_file, ' ':icol, ' Arg. #', nn:0, ' of type ', ide_typ^.typ_form );
              ip := ide_nxt
            end;
            LST_NEWLINE; WRITELN( lst_file, ')' )
          end
        end;

    otherwise
    end;
    LST_NEWLINE; WRITELN( lst_file, ' ':icol, '*** End of ', typ_form, ' ***' )
  end
end DUMP_TYPES;

end.
