%pragma trace 1;
program EXA_MSG( input, output );
{ to examine a standard error message file for mxdcmp }

const
  maxmaxdir  = 100;    { maximum possible size of directory in record }
  defmaxdir  =  10;    { default of maximum size of directory in record }
  maxerrline =  80;    { size of record (or error message line) }

type
  keytyp = word_unsigned;

const
  maxerrkey = maxerrline div keytyp"size;


type
  filespc = string( 128 );

  err_rec = record case boolean of
    false:( msg:packed array[1..maxerrline] of char);  { message line }
    true:(  key:packed array[1..maxerrkey] of keytyp); { array of key }
  end;


var
  msgnam: filespc := '';
  memdir: array[1..maxmaxdir] of err_rec;

  nbst: string(20);

  cline:  err_rec;
  ch:     char;
  maxdir, maxmsg,
  imsg, lmsg, ir, ib, irec: integer;

  outmsg, found:  boolean;

  errmsg: file of err_rec;
  inp: text;	{ input file }

  bok: boolean;

begin { EXA_MSG }
  WRITELN;
  WRITE( ' Message File (or EOF) =' );
  repeat
    bok := false;
  exit if EOF;
    READLN( msgnam );
    OPEN( errmsg, msgnam, [read_file,direct_file,error_file] );
    if iostatus <> 0 then
    begin
      WRITELN;
      WRITELN( ' Open error ', iostatus:-8,
               ', Cannot open the specified file.' );
      WRITE( ' Retry to get Message File name (or EOF) =' )
    end else bok := true
  until bok;

  if bok then
  begin
    READ( errmsg, memdir[1] );
    maxdir := memdir[1].key[1];
    for i := 2 to maxdir do
      READ( errmsg, memdir[i] );
    WRITELN( ' Index is loaded with ', maxdir:0, ' records .' );

    loop
      WRITE( ' message # = (EOF or -1 for end)' );
    exit if EOF;
      READLN( imsg );
    exit if imsg <= 0;
      found := false;
      ir := 1; ib := 2; irec := maxdir; lmsg := -1;

      loop
        lmsg := memdir[ir].key[ib];
        irec := irec + 1;
      exit if (lmsg = 0) or (lmsg = imsg);
        ib := ib + 1;
        if ib > maxerrkey then
        begin  ib := 1; ir := ir + 1  end
      end;

      if lmsg = 0 then
      begin { message not found }
        WRITELN;
        WRITELN( ' *** Message not found ***' );
      end
      else
      begin { message output }
        SEEK( errmsg, irec ); READ( errmsg, cline );
        WRITELN( ' ', irec:5,': ', lmsg:-5,' /', cline.msg, '/.' )
      end
    end;
    CLOSE( errmsg )
  end
end.
