{    **************************************************************
     *                                                            *
     *                                                            *
     *              *  C P A S  *  S Y S T E M  *                 *
     *                                                            *
     *                                                            *
     *      * * *   S t a n d a r d   L i b r a r y   * * *       *
     *                                                            *
     *                                                            *
     *          ---  Get Date/time (Array Version)  ---           *
     *                                                            *
     *   by :                                                     *
     *                                                            *
     *       P. Wolfers                                           *
     *         c.n.r.s.                                           *
     *         Laboratoire de Cristallographie                    *
     *         B.P.  166 X   38042  Grenoble Cedex                *
     *                           FRANCE.                          *
     *                                                            *
     **************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

module cpas__time_cht;

const
  jsec = 3600*24;
  dsta = 1970;
  asc0 = integer( '0' );

type
  ptr = ^string;

var
  monam: [static] array[1..12] of packed array[1..3] of char := (
    'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
    'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'
  );


[global 'PAS__DATE_CHT']
procedure DATE_CHT( out_var t: array[sz: integer] of char  );
var
  day, month, year: integer;

begin
  NTIME( curtim, false { Local time } );
  day   := curtim[4];
  month := curtim[5];
  year  := curtim[6];
  if sz >= 11 then
  begin
    t[1]  := char( day div 10 + asc0 );
    t[2]  := char( day mod 10 + asc0 );
    t[3]  := '-';
    t[4]  := monam[month,1];
    t[5]  := monam[month,2];
    t[6]  := monam[month,3];
    t[7]  := '-';
    t[8]  := char( year div 1000 + asc0 ); year := year mod 1000;
    t[9]  := char( year div  100 + asc0 ); year := year mod 100;
    t[10] := char( year div   10 + asc0 );
    t[11] := char( year mod   10 + asc0 );
    for i := 12 to sz do t[i] := ' '
  end
  else
    for i := 1 to sz do t[i] := ' '
end DATE_CHT;


[global 'PAS__TIME_CHT']
procedure TIME_CHT( out_var t: array[sz: integer] of char  );
var
  sec, mn, hou: integer;

begin
  NTIME( curtim, false { Local time } );
  sec := curtim[1];
  mn  := curtim[2];
  hou := curtim[3];
  if sz >= 8 then
  begin
    t[1] := char( hou div 10 + asc0 );
    t[2] := char( hou mod 10 + asc0 );
    t[3] := ':';
    t[4] := char( mn  div 10 + asc0 );
    t[5] := char( mn  mod 10 + asc0 );
    t[6] := ':';
    t[7] := char( sec div 10 + asc0 );
    t[8] := char( sec mod 10 + asc0 );
    for i := 9 to sz do t[i] := ' '
  end
  else
    for i := 1 to sz do t[i] := ' '
end TIME_CHT;


end.
