{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                    ---  RUN-TIME KERNEL  ---                          *
*                ---  String management Library  ---                    *
*               ---  Version  2.0-B -- 31/07/2007 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
module cpas__str;

const
  str_mod = true;

type
  ptr = ^string;

var
  buf: [static] string( 255 );


[global 'PAS__MAJOR_CHAR']
function MAJOR_CHAR( ch: char ): char;
begin
  if (ch >= 'a') and (ch <= 'z') then MAJOR_CHAR := CHR( ORD( ch ) - 32 )
                                 else MAJOR_CHAR := ch
end MAJOR_CHAR;


[global 'PAS__MINOR_CHAR']
function MINOR_CHAR( ch: char ): char;
begin
  if (ch >= 'A') and (ch <= 'Z') then MINOR_CHAR := CHR( ORD( ch ) + 32 )
                                 else MINOR_CHAR := ch
end MINOR_CHAR;


[global 'PAS__CHAR_IN_STR']
function CHAR_IN_STR( ch: char ): string( 1 );
begin
  CHAR_IN_STR.body[1] := ch;
  CHAR_IN_STR.length  :=  1
end CHAR_IN_STR;


[global 'PAS__CHA_TO_STR']
procedure CHA_CPY( var dst: string; ch: char );
var
  len: byte;

begin
  dst.length  :=  1;
  dst.body[1] := ch
end CHA_CPY;


[global 'PAS__CHT_TO_CHT']
procedure CHT_TO_CHT( var    dst: packed array[sd: integer] of char;
                      in_var src: packed array[ss: integer] of char );
var
  len: byte;

begin
  if ss > sd then len := sd
             else len := ss;
  for i := 1 to len do dst[i] := src[i];
  if ss < sd then
    for i := len + 1 to sd do dst[i] := ' '
end CHT_TO_CHT;


[global 'PAS__CHT_TO_STR']
procedure CHT_TO_STR(     var dst: string;
                       in_var src: packed array[sz: integer] of char );
var
  len: byte;

begin
  with dst do
  begin
    if sz > capacity then len := capacity
                     else len := sz;
    length := len;
    for i := 1 to len do body[i] := src[i]
  end
end CHT_TO_STR;


[global 'PAS__STR_TO_STR']
procedure STR_CPY( dst, src: ptr );
var
  len: byte;

begin
  if (src <> dst) and (dst <> nil) then
    with dst^ do
      if src <> nil then
      begin
        len := src^.length;
        if len > capacity then len := capacity;
        length := len;
        for i := 1 to len do body[i] := src^.body[i]
      end
      else length := 0
end STR_CPY;


[global 'PAS__SET_CASE']
procedure SET_CASE( var s: string; maj: boolean := true );
begin
  if maj then
  begin
    for ii := 1 to s.length do
      if (s[ii] >= 'a') and (s[ii] <= 'z') then s[ii] := CHR( ORD( s[ii] ) - 32 )
  end
  else
  begin
    for ii := 1 to s.length do
      if (s[ii] >= 'A') and (s[ii] <= 'Z') then s[ii] := CHR( ORD( s[ii] ) + 32 )
  end
end SET_CASE;


[global 'PAS__CON_CHA_CHA']
function CONCAT_CC( c1, c2: char ): string( 2 );
begin
  CONCAT_CC.length  :=  2;
  CONCAT_CC.body[1] := c1;
  CONCAT_CC.body[2] := c2
end CONCAT_CC;


[global 'PAS__CON_STR_CHA']
function CONCAT_SC( in_var s1: string; c2: char ): string;
var
  len: integer;

begin
  len := s1.length;
  if len >= function.capacity then len := function.capacity - 1;
  for i := 1 to len do  CONCAT_SC.body[i] := s1[i];
  CONCAT_SC.body[len+1] := c2;
  CONCAT_SC.length := len + 1
end CONCAT_SC;


[global 'PAS__CON_CHA_STR']
function CONCAT_CS(        c1: char;
                    in_var s2: string ): string;
var
  len: integer;

begin
  len := s2.length;
  if len >= function.capacity then len := function.capacity - 1;
  CONCAT_CS.body[1] := c1;
  for i := 1 to len do  CONCAT_CS.body[i+1] := s2[i];
  CONCAT_CS.length := len + 1
end CONCAT_CS;


[global 'PAS__CON_STR_STR']
function CONCAT_SS( in_var s1, s2: string ): string;
var
  sz0, sz1, sz2: integer;

begin
  if s1.length > function.capacity then sz0 := function.capacity
                                   else sz0 := s1.length;
  for i := 1 to sz0 do  CONCAT_SS.body[i] := s1[i];
  sz1 := function.capacity - sz0;
  if sz1 > s2.length then sz1 := s2.length;
  for i := 1 to sz1 do
  begin
    sz0 := SUCC( sz0 );
    CONCAT_SS.body[sz0] := s2[i]
  end;
  CONCAT_SS.length := sz0
end CONCAT_SS;


[global 'PAS__CON_CHT_CHA']
function CONCAT_TC( in_var s1: packed array[l1: integer] of char;
                           c2: char ): string;
var
  len: integer;

begin
  len := function.capacity;
  if l1 >= function.capacity then
  begin
    for i := 1 to len do  CONCAT_TC.body[i] := s1[i];
    CONCAT_TC.length := len
  end
  else
  begin
    for i := 1 to l1 do  CONCAT_TC.body[i] := s1[i];
    CONCAT_TC.body[l1+1] := c2;
    CONCAT_TC.length := l1 + 1
  end
end CONCAT_TC;


[global 'PAS__CON_CHA_CHT']
function CONCAT_CT(        c1: char;
                    in_var s2: packed array[l2: integer] of char ): string;
var
  len: integer;

begin
  len := l2;
  if len >= function.capacity then len := function.capacity - 1;
  CONCAT_CT.body[1] := c1;
  for i := 1 to len do  CONCAT_CT.body[i+1] := s2[i];
  CONCAT_CT.length := len + 1
end CONCAT_CT;


[global 'PAS__CON_STR_CHT']
function CONCAT_ST( in_var s1: string;
                    in_var s2: packed array[l2: integer] of char ): string;
var
  sz0, sz1, sz2: integer;

begin
  if s1.length > function.capacity then sz0 := function.capacity
                                   else sz0 := s1.length;
  for i := 1 to sz0 do  CONCAT_ST.body[i] := s1[i];
  sz1 := function.capacity - sz0;
  if sz1 > l2 then sz1 := l2;
  for i := 1 to sz1 do
  begin
    sz0 := SUCC( sz0 );
    CONCAT_ST.body[sz0] := s2[i]
  end;
  CONCAT_ST.length := sz0
end CONCAT_ST;


[global 'PAS__CON_CHT_STR']
function CONCAT_TS( in_var s1: packed array[l1: integer] of char;
                    in_var s2: string ): string;
var
  sz0, sz1, sz2: integer;

begin
  if l1 > function.capacity then sz0 := function.capacity
                            else sz0 := l1;
  for i := 1 to sz0 do  CONCAT_TS.body[i] := s1[i];
  sz1 := function.capacity - sz0;
  if sz1 > s2.length then sz1 := s2.length;
  for i := 1 to sz1 do
  begin
    sz0 := SUCC( sz0 );
    CONCAT_TS.body[sz0] := s2[i]
  end;
  CONCAT_TS.length := sz0
end CONCAT_TS;


[global 'PAS__CON_CHT_CHT']
function CONCAT_TT( in_var s1: packed array[l1: integer] of char;
                    in_var s2: packed array[l2: integer] of char ): string;
var
  sz0, sz1, sz2: integer;

begin
  if l1 > function.capacity then sz0 := function.capacity
                            else sz0 := l1;
  for i := 1 to sz0 do  CONCAT_TT.body[i] := s1[i];
  sz1 := function.capacity - sz0;
  if sz1 > l2 then sz1 := l2;
  for i := 1 to sz1 do
  begin
    sz0 := SUCC( sz0 );
    CONCAT_TT.body[sz0] := s2[i]
  end;
  CONCAT_TT.length := sz0
end CONCAT_TT;




[global 'PAS__SUBSTR_STR']
function  SUBSTR( in_var s: string; i, j: integer := 0 ): string;
begin
  { Check for the i value }
  if i < 1 then i := 1
           else if i > s.length then
	   begin  j := 0; goto EtResult end;
  { Check and set the j (result size) value }
  if j <= 0 then j := s.length - i + 1
            else if j + i - 1 > s.length then j := s.length - i + 1;
  { Check for no String overflow }
  if j > function.capacity then j := function.capacity;
  { Perform the SUBSTR function }
  for k := 1 to j do  SUBSTR.body[k] := s[k+i-1];
EtResult:
  SUBSTR.length := j
end SUBSTR;


[global 'PAS__SUBSTR_CHT']
function  SUBSTR( in_var s:    packed array[sz: integer] of char;
                         i, j: integer := 0 ): string;
begin
  { Check for the i value }
  if i < 1 then i := 1
           else if i > sz then
	   begin  j := 0; goto EtResult  end;
  { Check and set the j (result size) value }
  if j <= 0 then j := sz - i + 1
            else if j + i - 1 > sz then j := sz - i + 1;
  { Check for no String overflow }
  if j > function.capacity then j := function.capacity;
  { Perform the SUBSTR function }
  for k := 1 to j do  SUBSTR.body[k] := s[k+i-1];
EtResult:
  SUBSTR.length := j
end SUBSTR;



[global 'PAS__INDEX_CHA']
function INDEX_CHA( in_var s1: packed array[l1: integer] of char;
                           ch: char ): integer;
var
  find: boolean;
  i:    integer;

begin
  i := 0;
  find := false;
  while (i < l1) and not find do
  begin
    i := i + 1;
    find := (ch = s1[i]);
  end;
  if not find then i := 0;
  INDEX_CHA := i
end INDEX_CHA;


[global 'PAS__INDEX_STR']
function INDEX_STR( in_var s1: packed array[l1: integer] of char;
                    in_var s2: packed array[l2: integer] of char ): integer;
var
  find:    boolean;
  ch:      char;
  i, j, k: integer;

begin
  if s1"address = s2"address then i := 1 { one string }
  else  { s1 <> s2 }
  begin { two string => true index }
    find := false;
    i := 0;
    if (l2 > 0) and (l1 >= l2) then
    begin
      ch := s2[1];
      while (i <= (l1 - l2)) and not find do
      begin
        i := i + 1;
        if ch = s1[i] then
        begin
          j := i + 1;
          k := 2;
          while (k <= l2) and (s1[j] = s2[k]) do
          begin
            k := k + 1;
            j := j + 1
          end;
          find := (k > l2)
        end
      end
    end;
    if not find then i := 0
  end;
  INDEX_STR := i
end INDEX_STR;


[global 'PAS__NINDEX_CHA']
function NINDEX_CHA( in_var s: packed array[l: integer] of char;{ Main string }
                            c: char;            { Character to find }
                           nb: integer;         { Number of Occurence }
                           ip: integer :=-1;    { Start point in s }
                           nc: boolean := true  { Case Yes/No Sensitive [Yes] }
                   ): integer;
var
  c1:     char;
  fnd:    boolean;

begin
  fnd := false;
  if nb = 0 then nb := 1;
  if not nc then c := MAJOR_CHAR( c );
  if l > 0 then
    if nb > 0 then
    begin { Positive Scan }
      if ip <= 0 then ip := 1;
      while (ip <= l) and not fnd do
      begin
        if nc then c1 := s[ip]
              else c1 := MAJOR_CHAR( s[ip] );
        if c = c1 then
        begin
          nb := PRED( nb );
          fnd := (nb = 0)
        end;
        if not fnd then ip := ip + 1
      end
    end
    else
    begin { Negative Scan }
      nb := -nb;
      if (ip < 0) or (ip > l) then ip := l;
      while (ip > 1) and not fnd do
      begin
        if nc then c1 := s[ip]
              else c1 := MAJOR_CHAR( s[ip] );
        if c = c1 then
        begin
          nb := PRED( nb );
          fnd := (nb = 0)
        end;
        if not fnd then ip := ip - 1
      end
    end;

  if not fnd then ip := 0;
  NINDEX_CHA := ip
end NINDEX_CHA;


[global 'PAS__NINDEX_STR']
function NINDEX_STR( in_var s1: packed array[l1: integer] of char; { Main str.}
                     in_var s2: packed array[l2: integer] of char; { Sub-str. }
                            nb: integer;                           { Number of Occurence }
                            ip: integer :=   -1;                   { Start point in s }
                            nc: boolean := true                    { Case  Yes/No Sensitive [yes] }
                   ): integer;
var
  ie, i, j: integer;
  c1, c2:   char;
  fnd:      boolean;

begin
  fnd := false;
  if nb = 0 then nb := 1;
  if (l2 > 0) and (l1 >= l2) then
  begin { To find is Possible }
    ie := l1 - l2 + 1;
    if nb > 0 then
    begin { Positive Scan }
      if ip <= 0 then ip := 1;                { Set the Main Scan Start Index }
      if nc then c1 := s2[1]                  { Get the First Char of s2 }
            else c1 := MAJOR_CHAR( s2[1] );
      while (ip <= ie) and not fnd do
      begin { Main Loop for the first Character of s2 }
        if nc then c2 := s1[ip]               { Get the s2 char. to compare }
              else c2 := MAJOR_CHAR( s1[ip] );
        if c1 = c2 then                       { When the First Char matchs }
        begin { OK. for Secondary Scan }
          i := ip + 1;
          j := 2;
          fnd := true;
          while (j <= l2) and fnd do
          begin
            if nc then fnd := (s1[i] = s2[j])
                  else fnd := (MAJOR_CHAR( s1[i] ) = MAJOR_CHAR( s2[j] ));
            i := SUCC( i ); j := SUCC( j )
          end;
          if fnd then begin  nb := PRED( nb ); fnd := (nb = 0)  end
        end;
        if not fnd then ip := ip + 1
      end
    end
    else
    begin { Negative Scan }
      nb := -nb;
      if (ip < 0) or (ip > ie) then ip := ie;  
      if nc then c1 := s2[1]   { Get the First Char of s2 }
            else c1 := MAJOR_CHAR( s2[1] );
      while (ip > 0) and not fnd do
      begin                        { When the First Char matchs }
        if nc then c2 := s1[ip]
              else c2 := MAJOR_CHAR( s1[ip] );
        if c1 = c2 then
        begin { OK. for Secondary Scan }
          i := ip + 1;
          j := 2;
          fnd := true;
          while (j <= l2) and fnd do
          begin
            if nc then fnd := (s1[i] = s2[j])
                  else fnd := (MAJOR_CHAR( s1[i] ) = MAJOR_CHAR( s2[j] ));
            i := SUCC( i ); j := SUCC( j )
          end;
          if fnd then begin  nb := PRED( nb ); fnd := (nb = 0)  end
        end;
        if not fnd then ip := ip - 1
      end
    end;
  end;
  if not fnd then ip := 0;
  NINDEX_STR := ip
end NINDEX_STR;



[global 'PAS__LENGTH_STR']
function STR_LEN( in_var s: string ): integer;
begin
  STR_LEN := s.length
end STR_LEN;


[global 'PAS__MATCH_STR']
function STR_MATCH( in_var s1, s2: string ): integer;
var
  m, i, n: integer;

begin { STR_MATCH }
  
  if s1.length < s2.length then n := s1.length
                           else n := s2.length;
  i := 1;
  while (i <= n) and (s1[i] = s2[i]) do i := SUCC( i );
  if i > n then
    m := s1.length - s2.length
  else
    m := ORD( s1[i] ) - ORD( s2[i] );
  STR_MATCH := m
end STR_MATCH;


[global 'PAS__MATCH_CHT']
function CHT_MATCH( in_var s1: packed array[cap1: integer] of char;
                           l1: integer := 0;
                    in_var s2: packed array[cap2: integer] of char;
                           l2: integer := 0 ): integer;
var
  m, i, n: integer;

begin { CHT_MATCH }
  if l1 <= 0 then l1 := cap1;
  if l2 <= 0 then l2 := cap2;
  if l1 < l2 then n := 11
             else n := l2;
  i := 1;
  while (i <= n) and (s1[i] = s2[i]) do i := SUCC( i );
  if i > n then
    m := l1 - l2
  else
    m := ORD( s1[i] ) - ORD( s2[i] );
  CHT_MATCH := m
end CHT_MATCH;


[global 'PAS__STR_LSEP']
procedure STRING_LOCATE_SEP( in_var st: packed array[l:integer] of char;
                             in_var sp: packed array[n:integer] of char;
                                var tp: array[nsp:integer] of byte;
                                var ie: integer
                           );
var
  i, j: integer;

begin
  ie := 0;
  for i := 1 to l do
  begin
    j := 1;
    while (j <= n) and (sp[j] <> st[i]) do  j := j + 1;
    if j <= n then
    begin { Separator found }
      ie := SUCC( ie );
      if ie >= nsp then begin  ie := -PRED( ie ); goto ET_TOV  end;
      tp[ie] := j; ie := SUCC( ie ); tp[ie] := i
    end
  end;
ET_TOV:
end STRING_LOCATE_SEP;



[global 'PAS__LT_CHT']
function STR_LT ( in_var s1: packed array[l1:integer] of char;
                  in_var s2: packed array[l2:integer] of char ): boolean;
begin
  STR_LT := STR_MATCH( s1, l1, s2, l2 ) < 0
end STR_LT;

[global 'PAS__LE_CHT']
function STR_LE ( in_var s1: packed array[l1:integer] of char;
                  in_var s2: packed array[l2:integer] of char ): boolean;
begin
  STR_LE := STR_MATCH( s1, l1, s2, l2 ) <= 0
end STR_LE;

[global 'PAS__GE_CHT']
function STR_GE ( in_var s1: packed array[l1:integer] of char;
                  in_var s2: packed array[l2:integer] of char ): boolean;
begin
  STR_GE := STR_MATCH( s1, l1, s2, l2 ) >= 0
end STR_GE;

[global 'PAS__GT_CHT']
function STR_GT ( in_var s1: packed array[l1:integer] of char;
                  in_var s2: packed array[l2:integer] of char ): boolean;
begin
  STR_GT := STR_MATCH( s1, l1,  s2, l2 ) > 0
end STR_GT;

[global 'PAS__EQ_CHT']
function STR_EQ ( in_var s1: packed array[l1:integer] of char;
                  in_var s2: packed array[l2:integer] of char ): boolean;
begin
  STR_EQ := STR_MATCH( s1, l1, s2, l2 ) = 0
end STR_EQ;

[global 'PAS__NE_CHT']
function STR_NE ( in_var s1: packed array[l1:integer] of char;
                  in_var s2: packed array[l2:integer] of char ): boolean;
begin
  STR_NE := STR_MATCH( s1, l1, s2, l2 ) <> 0
end STR_NE;

[global 'PAS__LE_STR'] function STR_LE ( in_var s1, s2: string ): boolean;
begin
  STR_LE := STR_MATCH( s1, s2 ) <= 0
end STR_LE;

[global 'PAS__GE_STR'] function STR_GE ( in_var s1, s2: string ): boolean;
begin
  STR_GE := STR_MATCH( s1, s2 ) >= 0
end STR_GE;

[global 'PAS__GT_STR'] function STR_GT ( in_var s1, s2: string ): boolean;
begin
  STR_GT := STR_MATCH( s1, s2 ) > 0
end STR_GT;

[global 'PAS__EQ_STR'] function STR_EQ ( in_var s1, s2: string ): boolean;
begin
  STR_EQ := STR_MATCH( s1, s2 ) = 0
end STR_EQ;

[global 'PAS__NE_STR'] function STR_NE ( in_var s1, s2: string ): boolean;
begin
  STR_NE := STR_MATCH( s1, s2 ) <> 0
end STR_NE;


end.
