{    **************************************************************
     *                                                            *
     *                                                            *
     *              *  C P A S  *  S Y S T E M  *                 *
     *                                                            *
     *                                                            *
     *      * * *   S t a n d a r d   L i b r a r y   * * *       *
     *                                                            *
     *                                                            *
     *      ---  Double Precision Hyperbolic Function  ---        *
     *                                                            *
     *   by :                                                     *
     *                                                            *
     *       P. Wolfers                                           *
     *         c.n.r.s.                                           *
     *         Laboratoire de Cristallographie                    *
     *         B.P.  166 X   38042  Grenoble Cedex                *
     *                           FRANCE.                          *
     *                                                            *
     **************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

%pragma trace 0;
module CPAS__HYPERFNC;


[external 'PAS__ERROR'] procedure ERROR( nerr: integer ); external;




[global 'PAS__SHG']
function  SINH_G( v: double ): double;
var
  r: double;

begin
  r := EXP( v );
  SINH_G := 0.5*(r - 1.0/r)
end SINH_G;



[global 'PAS__CHG']
function  COSH_G( v: double ): double;
var
  r: double;

begin
  r := EXP( v );
  COSH_G := 0.5*(r + 1.0/r)
end COSH_G;


[global 'PAS__THG']
function  TANH_G( v: double ): double;
var
  r: double;

begin
  r := EXP( -2.0*ABS( v ) );
  r := (1.0 - r)/(1.0 + r);
  if v > 0.0 then TANH_G :=  r
             else TANH_G := -r
end TANH_G;




[global 'PAS__ASHG']
function  ARGSINH_G( v: double ): double;
var
  r: double;

begin
  r := LN( ABS( v ) + SQRT( SQR( v ) + 1 ) );
  if v < 0.0 then ARGSINH_G := -r
             else ARGSINH_G :=  r
end ARGSINH_G;



[global 'PAS__ACHG']
function  ARGCOSH_G( v: double ): double;
begin
  if v < 1.0 then ERROR( 805 );
  ARGCOSH_G := LN( v + SQRT( SQR( v ) - 1 ) )
end ARGCOSH_G;


[global 'PAS__ATHG']
function  ARGTANH_G( v: double ): double;
begin
  if ABS( v ) >= 1.0 then ERROR( 806 );
  ARGTANH_G := LN( (1 + v)/(1 - v) )*0.5
end ARGTANH_G;



end.
