#!/bin/sh
#
# System identification
#
kernel=$(uname)
processor=$(arch)
#
case $kernel in
  CYGWIN*)
    addrwidth="WIN32"
    processor="32"
#   dir_bld="Windows_bin_kit"
    exec_ext=".exe"
    ;;
  Linux)
    kernel="LINUX"
    case $processor in
      x86_64)
        addrwidth="64"
#       dir_bld="Linux_x86-64_bin_kit"
        ;;
      *)
#       dir_bld="Linux_i386_bin_kit"
        addrwidth="32"
        ;;
    esac
    ;;
  *)
    echo " Not identified Operating system \"${kernel}\" ==> Assume unknown UNIX."
    kernel="UNIX"
    addrwidth="32"
    ;;
esac
#
# SET up the Linux new Draw Server in the standard current directory.
#
DEF_DIR="$USR_LOCAL"
if ! test $DEF_DIR
then
  DEF_DIR="/usr/local"
fi
echo -n " Give the local target Directory [default is $DEF_DIR] "
read DEST_DIR
if ! test "$DEST_DIR"
then
  DEST_DIR="$DEF_DIR"
fi
if ! test -d "$DEST_DIR"
then
  echo -n " Do you want create it (Possible answerd Y/N) [default is Y] "
  read REP
  if test "$REP" = "n"
  then
    REP = "N"
  fi
  if test "$REP" = "N"
  then
#
#   Error the local directories does not exit and do not create it.
#
    echo "$DEST_DIR cannot be found or created."
    exit 2
  fi
  mkdir $DEST_DIR
  echo " The directory $DEST_DIR is created."
fi
export DEST_DIR
#
#  *** Set The Destination Directory for FLTK Draw Server and Library ***
#
# Create the environment files (not necessary for standard installation.
#
# For standard installation :
#
#     The Draw_server executable file should be in the PATH (the current
#     PATH variable of the system).
#     Typically Draw_server should be /usr/local/bin/Draw_server
#
#     The Server setting file should be located in the internal server
#     path "./:/etc:/usr/local/etc" and the name of draw_server_setting
#     is "draw_server.draw_setting".
#
# You must use the nenvironment variables DRAW_SERVER and/or DRAW_SERVER_SETTING
# only to test some new DRAW configuration as New Server and:or new Draw Configuration.
#
cat > draw_setup.sh <<_EOF
# export DRAW_SERVER=<to_replace_by_the_path_of_the_Draw_server_Executable_file>
# export DRAW_SERVER_SETTING=<Path_of_the Draw_Server_Setting_File>
_EOF

cat > draw_setup.csh <<_EOF
# setenv DRAW_SERVER <to_replace_by_the_path_of_the_Draw_server_Executable_file>
# setenv DRAW_SERVER_SETTING <Path_of_the Draw_Server_Setting_File>
_EOF

#
# Put all Draw Kit files in the required directories.
#
if ! test -e "$DEST_DIR/bin"
then
  mkdir $DEST_DIR/bin
fi
cp Draw_Server$exec_ext $DEST_DIR/bin/
#
if ! test -e "$DEST_DIR/etc"
then
  mkdir $DEST_DIR/etc
fi
if test -e "$DEST_DIR/etc/draw_server.draw_setting"
then
  cp draw_server.draw_setting $DEST_DIR/etc/draw_server_default.draw_setting
else
  cp draw_server.draw_setting $DEST_DIR/etc/
fi
cp draw_setup.* $DEST_DIR/etc/
#
if ! test -e "$DEST_DIR/lib"
then
  mkdir $DEST_DIR/lib
fi
cp libdraw.a $DEST_DIR/lib/
#
if ! test -e "$DEST_DIR/include"
then
  mkdir $DEST_DIR/include
fi
cp draw_defs.* $DEST_DIR/include/
if ! test -e "$DEST_DIR/include/draw"
then
  mkdir $DEST_DIR/include/draw
fi
tar -xzvf include_draw.tgz
cp draw/* $DEST_DIR/include/draw/
rm -f -R draw
#
if test -e "$DEST_DIR/cpas"
then
  cp draw_defs.pas $DEST_DIR/cpas/
fi
if ! test -e "$DEST_DIR/Draw_Fonts"
then
  mkdir $DEST_DIR/Draw_Fonts
fi
cp *.ttf $DEST_DIR/Draw_Fonts/
#
# Create the graph area with example files,
#                            documentation file,
#                        and header files for fortran and cpascal.
#
if ! test -e "$DEST_DIR/graph"
then
  mkdir $DEST_DIR/graph
fi
if ! test -e "$DEST_DIR/graph/Draw_Examples"
then
  mkdir $DEST_DIR/graph/Draw_Examples
fi
tar -xzvf Draw_Examples.tgz
cp Draw_Examples/* $DEST_DIR/graph/Draw_Examples/
ln -s $DEST_DIR/graph/Draw_Examples/calibration$exec_ext $DEST_DIR/bin/calibration$exec_ext
rm -f -R Draw_Examples
cp draw_version.dat $DEST_DIR/graph/
cp draw_guide.* $DEST_DIR/graph/
cp draw_defs.* $DEST_DIR/graph/
#
# Start a test (if it exist).
#
if test -e draw_ivp$exec_ext
then
# source draw_setup.sh
  cat <<_EOF


*********************************************************************************
*                                                                               *
*     Now, We start the Installation Verification Program.                      *
*                                                                               *
*     You must clic on Resume or quit in file menu to end the installation      *
*     process.                                                                  *
*                                                                               *
*********************************************************************************

_EOF
  ./draw_ivp$exec_ext
fi
#
# Send the user setup message
#
cat <<_EOF

*********************************************************************************
*                                                                               *
*     The Draw Library and Server Task was succesfully installed.               *
*                                                                               *
*     From theis DRAW Version (1.4A) no call of setup file are required.        *
*     The builtin setup file are just take in place to replace the old ones     *
*     but they are no-operation script file.                                    *
*                                                                               *
*     To Compile and link a program you must specify                            *
*       -L$DEST_DIR/lib/ -ldraw                                                 *
*     and use the appropriate file :                                            *
*       For fortran $DEST_DIR/include/draw_defs.for                             *
*       For cpas    $DEST_DIR/include/draw_defs.pas                             *
*       For C and C++ :                                                         *
*                                                                               *
*                 include $DEST_DIR/include/draw_env.h   in the source file,    *
*            or                                                                 *
*                 -I$DEST_DIR/include       in the compiler command and         *
*                      #include <draw_env.h>             in the source file.    *
*                                                                               *
*                                                                               *
*     The program "$DEST_DIR/graph/Draw_Example/calibration" can be used        *
*     to modify the "$DEST_DIR/etc/draw_server.draw_setting" file to get        *
*     a good scale of each graphic (with 1 screen cm = 1 true centimeter).      *
*                                                                               *
*                                                                               *
*     Good Luke!                                                                *
*                                                                               *
*********************************************************************************

_EOF
#
