%pragma trace 1;
program Essai_Sys_Vol( input, output );

%include 'PASENV:draw_defs.pas' {, list_on};


const

  max_nbc = 2;
  pi      = 4.0*ARCTAN( 1.0 );
  inrd    = pi/180.0;
  dim     = 25;

  stp     =  2.0;
  sts     = 10.0;

var

  bstatus: boolean;
  unit: unit_type;
  i, j, k, irep: integer;
  xs, ys, xx, yy: Dfloat;

  status: Dint;
  dview: Dfloat := 100.0;
  xc, yc, xd, yd: Dfloat;

  iseg, imatp, imatpr, imats: [static] Dint := 0;

  php, phs: Dfloat;

  spec_color:  array[1..4] of Dfloat := [0.8, 0.8, 0.8, 1.0];
  light_color: array[1..4] of Dfloat := [0.0, 1.0, 1.0, 1.0];
  light_pos:   array[1..3] of Dfloat := [0.0, 50.0,  25.0];



procedure DISPLAY_SURFACE;
var
  xx, yy, zz: Dfloat;
  i, j, k, l, m: integer;

  faces_tb:  array[1..4] of Dint := ( 3, 3, 3, 3 );
  vertex_tb: [static] array[1..12] of Dpoint3 := [
    [ 0.5, 0.5,-0.5], [-0.5, 0.5, 0.5], [ 0.5,-0.5, 0.5],
    [-0.5,-0.5,-0.5], [ 0.5,-0.5, 0.5], [-0.5, 0.5, 0.5],
    [ 0.5,-0.5, 0.5], [-0.5,-0.5,-0.5], [ 0.5, 0.5,-0.5],
    [-0.5, 0.5, 0.5], [ 0.5, 0.5,-0.5], [-0.5,-0.5,-0.5] ];

 ref_mat: [static] Dmatrix := [ [0.0, 1.0, 0.0, 0.0],
                                [0.0, 0.0, 1.0, 0.0],
                                [1.0, 0.0, 0.0, 0.0] ];


  {
     GL_POINTS,         /*  0  for  GL Codes */
     GL_LINES,          /* -1 */
     GL_LINE_STRIP,     /* -2, Use by draw_out 1 */
     GL_LINE_LOOP,      /* -3 */
     GL_TRIANGLES,      /* -4 */
     GL_TRIANGLE_STRIP, /* -5 */
     GL_TRIANGLE_FAN,   /* -6 */
     GL_QUADS,          /* -7 */
     GL_QUAD_STRIP,     /* -8 */
     GL_POLYGON         /* -9, Use by draw_out 3 */
  }


begin { DISPLAY_SURFACE }
  iseg := DRAW$NEW_SEG( 1 );
  DRAW$PUT_SEG_MAT( iseg, ref_mat );

  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_SPECULAR_COLOR, Dcolor[1.0, 1.0, 1.0, 0.15] );
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_SHININESS, Dvalue[100.0] );

  DRAW$LIGHT_DEFINE( 0,      LIGHT_POSITION, Dpoint3[ 90.0,  5.0,  50.0] );

  DRAW$LIGHT_DEFINE( 0, LIGHT_AMBIENT_COLOR, Dcolor[ 0.6, 0.6, 0.6, 1.0] );
  DRAW$LIGHT_DEFINE( 0, LIGHT_DIFFUSE_COLOR, Dcolor[ 1.0, 1.0, 1.0, 1.0] );
  DRAW$LIGHT_DEFINE( 0, LIGHT_SPECULAR_COLOR, Dcolor[ 1.0, 1.0, 1.0, 1.0] );

  DRAW$COLOR( 0.6, 0.6, 0.3, 1.0 );

  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_EMISSION_COLOR, Dcolor[0.0, 0.0, 0.0, 1.0] );


  DRAW$DEFINE_COLOR( 0, 0.7, 0.7, 0.7, 1.0 );
  { DRAW$LIGHT_ON_OFF( 0, 0 ); { Eteint la lampe }
  { DRAW$LIGHT_ON_OFF( 0, 1 ); { Allume la lampe }


  DRAW$VIEW( 0.0 );

  php := 90.0; phs := 0.0;


(*
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_DIFFUSE_COLOR, Dcolor[1.0, 0.9, 0.2, 1.00] );
  DRAW$MAT_LIGHT_PROP( MAT_BACK_FACE, MAT_DIFFUSE_COLOR, Dcolor[0.0, 0.0, 0.5, 1.00] );
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_EMISSION_COLOR, Dcolor[0.0, 0.0, 0.0, 1.0] );
*)
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_DIFFUSE_COLOR, Dcolor[1.0, 0.9, 0.2, 1.0] );

  DRAW$SPHERE( 0.0, -20.0, 0.0, 5.0, 32, 32, 4 );

  DRAW$COLOR( 0.2, 0.4, 0.9, 1.0 );

  { In order: (x,y,z) of center of base, th, ph the theta and phi for axis orientation,
              lg: the length of the cylinder, rb, rt; radius of base and top,
              and divisions in xy and along z } 
  DRAW$CYLINDER( 0.0, 0.0, 0.0, 90.0, 45.0, 4.0, 1.5, 4.5, 32, 32, 4 );

  { In order: (x,y,z) of center of base, th, ph the theta and phi for axis orientation,
              ri, re: internal and external radius,
              sa and ea: start and end angles, and divisions along xy and r } 

  DRAW$COLOR( 0.9, 0.9, 0.0, 1.0 );
  DRAW$DISK( 0.0, 0.0, 0.0, 90.0, 30.0, 0.0, 1.0, 0.0, 360.0, 32, 32, 4 );

  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_EMISSION_COLOR, Dcolor[0.0, 0.0, 0.0, 1.0] );
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_DIFFUSE_COLOR, Dcolor[0.75, 0.75, 0.0, 1.0] );
(*
  DRAW$COLOR( 0.9, 0.3, 0.0, 1.0 );
*)
  DRAW$SPHERE( -15.0, 22.0, 0.0, 10.0, 32, 32, 4 );

  imats := DRAW$PUSH_MATRIX;

  DRAW$MOVE_MAT3( imats, 0.0, 15.0, 0.0 );
  DRAW$ROTATE_MAT3( imats, 0.0, 0.0, 0.0, -40.0, 0.0, 20.0 );
  DRAW$SCALE_MAT3( imats, 0.0, 0.0, 0.0, 10.0, 10.0, 10.0 );

  DRAW$FILL_ATTR( 1, 0 );
  DRAW$LINE_ATTR( 1, 2.5 );
  DRAW$COLOR( 0.1, 0.1, 0.8, 1.0 );  
(*DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_SPECULAR_COLOR, Dcolor[0.0, 0.0, 0.4, 1.0] );*)

  DRAW$POLYHEDRAL( faces_tb, vertex_tb );

  DRAW$COLOR( 0.0, 0.0, 0.0, 1.0 );  
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_EMISSION_COLOR, Dcolor[0.0, 0.3, 0.3, 0.6] );
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_DIFFUSE_COLOR, Dcolor[0.2, 0.8, 0.8, 0.4] );

  DRAW$ALPHA_SET( 2 );
  DRAW$FILL_ATTR( 2, 512 ); { when 0: fill front = 1, fill back = 2; n*256 = Deep Shift of n.0 }

  DRAW$COLOR( 0.15, 0.35, 0.85, 0.65 );

(*
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT1_EMISSION_COLOR, Dcolor[0.0, 0.3, 0.3, 0.2] );
*)
  DRAW$OUT_MODE( 4 ); { Fill Cube/Triangles with Normals }

  DRAW$POLYHEDRAL( faces_tb, vertex_tb, 16 );
  DRAW$FILL_ATTR( 0, 1 );
  DRAW$ALPHA_SET( 0 );

  DRAW$POP_MATRIX;

  DRAW$SEG_END;
end DISPLAY_SURFACE;

var
  server_name: string(128);

begin { MAIN }

  {****************************************************}
  {          INITIALYSE THE DRAWING SYSTEM             }
  {****************************************************}

  Draw_Server_Mode := DrwSrv_Do_Lighting + DrwSrv_Enable_Light0;

  DRAW$INIT( xs, ys, unit, 'Essai Graphic' );
  WRITELN( 'xs = ', xs, '   ys = ', ys, '   unit = ', unit );

  DRAW$GET_SERVER_NAME( server_name );

  WRITELN( ' Server Name = "', server_name, '".' );

  bstatus := DRAW$PICTURE3( 'Objects', 60.0, 60.0, 60.0, true, true );

  DRAW$LIGHT_ON_OFF( 0, 1 );                      { Allume la lampe # 0 }

(*DRAW$PIC_VIEW( 0 );*)
(*DRAW$TIME_ANIM( 25 );*)

  DISPLAY_SURFACE;


stop_anim:
  DRAW$SET_STOP_ANIM( 0 );   { Clear any stop mode }

  irep := DRAW$DIALOG( 1 );
(*
  if irep >= 0 then
  begin { Does not stop }
    DRAW$SET_STOP_ANIM( 1 ); { Set the single stop mode }
    for i := 0 to 4 do
      for j := 1 to 180 do
      begin
        php := stp*j + 90.0;
        phs := sts*j + 90.0;
        DRAW$ROTATE_MAT3( imatp,  0.0,  0.0,  0.0,   { px, py, pz }
                                  0.0,  0.0,  stp ); { 0.0, 0.0, Delta_Phi }
        DRAW$ROTATE_MAT3( imats,  0.0,  0.0,  0.0,   { px, py, pz }
                                  0.0,  0.0,  sts ); { 0.0, 0.0, Delta_Phi }

        if Draw_Anim_State > 0 then goto stop_anim;

        { WRITELN( ' Php = ', php:12:2, ', Phs = ', phs:12:2 ); }
        SLEEP( 0.05 ); 
      end
  end;
*)
  DRAW$END;
  WRITELN( ' Fin Essai Volumes.' )
end Essai_Sys_Vol.
