%pragma trace 1;
(*
[inherit( 'DRAW_INSTALL:DRAW_DEFS'{'LIB:DRAW_DEFS'},
           'SYS$LIBRARY:PASCAL$LIB_ROUTINES')]
*)
program Essai_Surface( input, output );

%include 'DRAWENV:draw_defs.pas' {, list_on};


const

  max_nbc = 2;
  pi      = 4.0*ARCTAN( 1.0 );
  inrd    = pi/180.0;
  dim     = 25;

var

  bpen, bscal, bmargin, bstatus: boolean;
  unit: unit_type;
  i, j, k, irep, box: integer;
  xs, ys, xx, yy: Dfloat;

  untx, unty, name, angmsg: string( 255 ) := '';


  status: Dint;
  ome, chi, phi, dview: Dfloat := 0.0;
  xc, yc, xd, yd: Dfloat;

  iseg, aseg: [static] Dint := 0;

  cmat: array[1..3,1..3] of Dfloat;

  surface: array[-dim..dim,-dim..dim] of Dpoint3;


procedure DISPLAY_SURFACE;
var
  x_axe, y_axe, z_axe, box: [static] Dint;
  bx_dir: [static] array[1..5] of Dint;
  xx, yy, zz: Dfloat;
  i, j, k, l, m: integer;

begin { DISPLAY_SURFACE }

  DRAW$VIEW( dview );

  DRAW$TEXT_ATTR( 3, 5, 1, 1.0, 0.0 );
  DRAW$TEXT_FONT( 3 );
  DRAW$STRING( 0.0, -13.0, 0.0, 1.0, 'Z = Exp( - 5*( x^2 + y^2 ) )' );

  aseg := DRAW$NEW_SEG( 2 );

  ome :=  90.0; chi :=  80.0; phi := -40.0;

  WRITEV( angmsg, ' Ome = ', ome:8:2, ', Chi = ', chi:8:3, ', Phi = ', phi:8:3 );
  DRAW$STRING( 0.0, -15.0, 0.0, 1.0, angmsg );

  DRAW$SEG_END;

  iseg := DRAW$NEW_SEG( 3 );
  WRITELN( ' Create Segment # ', iseg:3 );

  DRAW$ROTATE_SEG3( iseg, 0.0, 0.0, 0.0, ome, chi, phi );
  DRAW$SEG_ORIENTATION( iseg, 0.0, 0.0, 0.0 );                { Attach the rotation to the mouse in dialog }

  WRITELN( ' The Figure can be rotated with the mouse (by default).' );


  { The flag parameter (last one) must be flag the axis characteristics as this :

    the value must be a set of this following constantes :

    *****   Axis Flags   *****

    Axis_Log       =     1; (* Axis is in Log10 Coordinate *)
    Axis_Left      =     2; (* Ticks and displayed value at left position ( else at right ) *)
    Axis_VOther    =     4; (* Value are in other side (than ticks) *)
    Axis_NFrs      =     8; (* Does not display the first Ticks *)
    Axis_NFVl      =    16; (* Does not display the first Value *)
    Axis_NLsT      =    32; (* Does not display the last Ticks *)
    Axis_NLVl      =    64; (* Does not display the last Value *)
    Axis_NZer      =   128; (* Does not display the Zero Ticks *)
    Axis_NZVl      =   256; (* Does not display the Zero Value *)
    Axis_Arrow     =   512; (* Put an arrow at the end of axis *)
    Axis_ArroF     =  1024; (* Fill mode for Axis_Arrow *)
    Axis_Tilte     =  2048; (* Axis character are tilted with ticks *)
    Axis_VPath     =  4096; (* String Path (2 bits) for Ticks Value *)
    Axis_Upath     = 16384; (* String Path (2 bits) for Axis Unit *)


    *****   Axis Plot Directives and Flags for Draw_Plot   *****

    Axis_Plot_X    =     1; (* Plot an X axis *)
    Axis_Plot_Y    =     2; (* Plot an Y axis *)
    Axis_Plot_Z    =     3; (* Plot a  Z axis *)
    Axis_PFlg_TVl  =     4; (* Ticks values and Unit String will be Displayed *)
    Axis_PFlg_TPrm =     8; (* The ticks left and right sides are permutted *)
    Axis_PFlg_TSym =    16; (* The Ticks must be symmetrized *)
    Axis_PFlg_XEnd =    32; (* Plot Axis with a shift of x axis size *)
    Axis_PFlg_YEnd =    64; (* Plot Axis with a shift of Y axis size *)
    Axis_PFlg_ZEnd =   128; (* Plot Axis with a shift of Z axis size *)
    Axis_PFlg_XPos =   256; (* Plot Axis at specified X shift *)
    Axis_PFlg_YPos =   512; (* Plot Axis at specified Y shift *)
    Axis_PFlg_ZPos =  1024; (* Plot Axis at specified Z shift *)
 
  }

  x_axe := DRAW$NEW_AXIS( Dpoint3[ 1.0, 0.0, 0.0], Dpoint3[ 0.0, 1.0, 1.0], 20.0, -1.0, 1.0, -3,
                                   Axis_UMiddle );
  y_axe := DRAW$NEW_AXIS( Dpoint3[ 0.0, 1.0, 0.0], Dpoint3[-1.0, 0.0,-1.0], 20.0, -1.0, 1.0, -3,
                                   Axis_UMiddle );
  z_axe := DRAW$NEW_AXIS( Dpoint3[ 0.0, 0.0, 1.0], Dpoint3[ 1.0, 1.0, 0.0], 20.0,  0.0, 1.0, -3,
                                   Axis_Arrow + Axis_ArroF {+ Axis_VOther} );


  Draw$Set_Axis_Unit( x_axe, 'Cm (X)' );
  Draw$Set_Axis_Unit( y_axe, 'Cm (Y)' );
  Draw$Set_Axis_Unit( z_axe, 'Gaussian' );

  { The second parameter is the some of values as 1, 2, 4, 8, 16, 32, 64 to take in account the szuccessive parameters:
     For example, in the next line, 124 = 64+32+16+8 == 2^3+2^4+2^5+2^6 to select the use of the parameters -0.4, 0.8, 3, 5 and 2 }

  Draw$Set_Axis_Value( x_axe, 2, 124,,      , -0.4, 0.8, 3,  5, 2 );    { Set Position, Font # 3 (bold), Field and decimal }
  Draw$Set_Axis_Value( x_axe, 4,  16,,      , -9.0, 2.0, 7 );           { Set Position and font # 7 (Bold+Italic) for Unit String }
  Draw$Set_Axis_Value( y_axe, 2, 126,, 180.0, -0.4, 0.8, 3,  5, 2 );    { Set Angle, Position, Font # 3 (bold), Field and decimal for ticks values }
  Draw$Set_Axis_Value( y_axe, 4,  18,, 180.0,     ,    , 7 );           { Set Angle, Position and font # 7 (Bold+Italic) for Unit String }
  Draw$Set_Axis_Value( z_axe, 2, 112,,      ,     ,    , 3,  5, 2 );    { Set Value Font, Field and decimal }
  Draw$Set_Axis_Value( z_axe, 4,  16,,      ,     ,    , 7 );           { Set Position and font # 7 (Bold+Italic) for Unit String }

  bx_dir[1] := Axis_PFlg_TVl  +                       { Tick Values, }
               Axis_Plot_X;                           { Plot X axis }
  bx_dir[2] := Axis_PFlg_TVl  + Axis_PFlg_TPrm +      { Tick Values, at end'X axis, }
               Axis_Plot_Y;                           { Plot Y axis }
  bx_dir[3] := Axis_PFlg_XEnd + Axis_PFlg_SymU +      { No Tick Values, mv symetry Ope. }
               Axis_PFlg_TPrm + Axis_Plot_Y;          { Plot Y axis }
  bx_dir[4] := Axis_Pflg_SymV +                       { No Tick Values, with mv sym. ope., }
               Axis_PFlg_YEnd + Axis_Plot_X;          { at end'Y axis, Plot X axis }

  bx_dir[5] := Axis_PFlg_TVl + Axis_Plot_Z;           { Tick Values, Plot Y axis }


  box := DRAW$NEW_BOX( Dpoint3[ -10.0, -10.0, -5.0], x_axe, y_axe, z_axe, bx_dir );

  DRAW$LINE_ATTR( 1, 2.0 );                           { Make axis line not to fine }

  DRAW$PLOT_BOX( box );

  DRAW$LINE_ATTR( 1, 1.0 );                           { Reset to basic line }

  DRAW$OPEN_BOX( box );

  DRAW$OUT_MODE( 1 );


  for i := -dim to dim do
  begin
    xx := i/dim;
    for j := -dim to dim do
    begin
      yy := j/dim;
      zz := EXP( -( xx**2 + yy**2 )*5.0 ); 
      surface[i,j][1] := xx;
      surface[i,j][2] := yy;
      surface[i,j][3] := zz;
    end
  end;

  {
     GL_POINTS,         /*  0  for  GL Codes */
     GL_LINES,          /* -1 */
     GL_LINE_STRIP,     /* -2, Use by draw_out 1 */
     GL_LINE_LOOP,      /* -3 */
     GL_TRIANGLES,      /* -4 */
     GL_TRIANGLE_STRIP, /* -5 */
     GL_TRIANGLE_FAN,   /* -6 */
     GL_QUADS,          /* -7 */
     GL_QUAD_STRIP,     /* -8 */
     GL_POLYGON         /* -9, Use by draw_out 3 */
  }

  DRAW$COLOR( 0.3, 0.5, 0.7 );
  DRAW$FILL_ATTR( 2, 1 );
  { DRAW$FILL_ATTR( 0, 1 (* 1 = Front, 2 = Back *) ); }

  DRAW$OUT_MODE( -5 {GL_TRIANGLE_STRIP} );

  for i := -dim to dim-1 do
  begin
    DRAW$PLOT3( surface[i,-dim][1], surface[i,-dim][2], surface[i,-dim][3], false );
    for j := -dim to dim-1 do
    begin
      DRAW$PLOT3( surface[i+1,j][1], surface[i+1,j][2], surface[i+1,j][3], true );
      DRAW$PLOT3( surface[i,j+1][1], surface[i,j+1][2], surface[i,j+1][3], true )
    end;
    DRAW$PLOT3( surface[i+1,dim][1], surface[i+1,dim][2], surface[i+1,dim][3], true )
  end;
  DRAW$PLOT3( 0.0, 0.0, 0.0, false );

  DRAW$COLOR( 0.8, 0.5, 0.1 );
  DRAW$FILL_ATTR( 1, 1 );
  DRAW$OUT_MODE( -5 {GL_TRIANGLE_STRIP} );

  for i := -dim to dim-1 do
  begin
    DRAW$PLOT3( surface[i,-dim][1], surface[i,-dim][2], surface[i,-dim][3], false );
    for j := -dim to dim-1 do
    begin
      DRAW$PLOT3( surface[i+1,j][1], surface[i+1,j][2], surface[i+1,j][3], true );
      DRAW$PLOT3( surface[i,j+1][1], surface[i,j+1][2], surface[i,j+1][3], true )
    end;
    DRAW$PLOT3( surface[i+1,dim][1], surface[i+1,dim][2], surface[i+1,dim][3], true )
  end;
  DRAW$PLOT3( 0.0, 0.0, 0.0, false );

  DRAW$COLOR( 0.8, 0.5, 0.1 );
  DRAW$OUT_MODE( 1 {GL_LINE_STRIP} );
(*
  DRAW$FILL_ATTR( 1, 1 );

  for i := -dim to dim do
  begin
    DRAW$PLOT3( surface[i,-dim][1], surface[i,-dim][2], surface[i,-dim][3], false );
    for j := 1-dim to dim do
      DRAW$PLOT3( surface[i,j][1], surface[i,j][2], surface[i,j][3], true );
  end;
  DRAW$PLOT3( 0.0, 0.0, 0.0, false );

  for j := -dim to dim do
  begin
    DRAW$PLOT3( surface[-dim,j][1], surface[-dim,j][2], surface[-dim,j][3], false );
    for i := 1-dim to dim do
      DRAW$PLOT3( surface[i,j][1], surface[i,j][2], surface[i,j][3], true );
  end;
  DRAW$PLOT3( 0.0, 0.0, 0.0, false );
*)

  DRAW$CLOSE_BOX;
  DRAW$SEG_END;
end DISPLAY_SURFACE;


procedure UPDATE_ANGLE_DISPLAY;
begin
  DRAW$UPDATE_SEG( aseg {, 0} );
  WRITEV( angmsg, ' Ome = ', ome:8:2, ', Chi = ', chi:8:3, ', Phi = ', phi:8:3 );
  DRAW$STRING( 0.0, -15.0, 0.0, 1.0, angmsg );
  DRAW$SEG_END;
end UPDATE_ANGLE_DISPLAY;



procedure ROTATE_PLOT;
var
  come, some, cchi, schi, cphi, sphi, rome, rchi, rphi: Dfloat;
  pmat, mat: array[1..3,1..3] of Dfloat;

begin
  rome := inrd*ome; rchi := inrd*chi; rphi := inrd*phi;
  come := COS( rome ); some := SIN( rome );
  cchi := COS( rchi ); schi := SIN( rchi );
  cphi := COS( rphi ); sphi := SIN( rphi );

  UPDATE_ANGLE_DISPLAY;

  DRAW$VIEW( dview );
  DRAW$SEG_UNIT_TRANSF( iseg );
  DRAW$ROTATE_SEG3( iseg,  0.0,  0.0,  0.0, ome, chi, phi );

end ROTATE_PLOT;



procedure UPDATE_ANGLES;
var
  ir:                          integer;
  mat:                         Dmatrix;
  cc, sc, co, so, cp, sp:       Dfloat;

(*
  ome = inrd*ome; chi = inrd*chi; psi = inrd*psi;
  co = cos( ome ); cc = cos( chi ); cp = cos( psi );
  so = sin( ome ); sc = sin( chi ); sp = sin( psi );
  m[1,1] =  co*cc*cp - so*sp;                     /* m11 */
  m[1,2] = -co*cc*sp - so*cp;                     /* m12 */
  m[1,3] =  co*sc;                                /* m13 */
  m[1,4] =  px - m[ 0]*px - m[ 4]*py - m[ 8]*pz;  /* m14 */
  m[2,1] =  so*cc*cp + co*sp;                     /* m21 */
  m[2,2] = -so*cc*sp + co*cp;                     /* m22 */
  m[2,3] =  so*sc;                                /* m23 */
  m[2,4] =  py - m[ 1]*px - m[ 5]*py - m[ 9]*pz;  /* m24 */
  m[3,1] = -sc*cp;                                /* m31 */
  m[3,2] =  sc*sp;                                /* m32 */
  m[3,3] =  cc;                                   /* m33 */
  m[3,4] =  pz - m[ 2]*px - m[ 6]*py - m[10]*pz;  /* m34 */
*)

begin
  ir := DRAW$GET_SEG_MAT( iseg, mat );
  if ir > 0 then
  begin { we have the segment matrix }
(*  WRITELN( ' Matrix is ', mat[1,1]:8:4, ', ', mat[1,2]:8:4, ', ', mat[1,3]:8:4, ', ', mat[1,4]:8:4 );
    WRITELN( '           ', mat[2,1]:8:4, ', ', mat[2,2]:8:4, ', ', mat[2,3]:8:4, ', ', mat[2,4]:8:4 );
    WRITELN( '           ', mat[3,1]:8:4, ', ', mat[3,2]:8:4, ', ', mat[3,3]:8:4, ', ', mat[3,4]:8:4 );
*)
    cc := mat[3,3];
    sc := SQRT( 1.0 - SQR( cc ) );
    if ABS( sc ) < 1.0e-5 then
    begin
      ome := 0.0;
      if cc > 0 then chi :=   0.0
                else chi := 180.0;
      phi := ARCTAN( mat[1,2]/cc, -mat[1,1]/cc )/inrd;
    end
    else
    begin
      cp := - mat[3,1]/sc;
      sp :=   mat[3,2]/sc;
      co :=   mat[1,3]/sc;
      so :=   mat[2,3]/sc;
      ome := ARCTAN( so, co )/inrd;
      phi := ARCTAN( sp, cp )/inrd;
      chi := ARCCOS( cc )/inrd
    end;
    UPDATE_ANGLE_DISPLAY
  end
end UPDATE_ANGLES;



begin { MAIN }

  {****************************************************}
  {          INITIALYSE THE DRAWING SYSTEM             }
  {****************************************************}
  { The external procedure

      DRAW$DEF_MENU( code: Dint; in_var name: [optional] string );

                  is a procedure to modify by insertion the DRAW$DIALOG
    standard menu setting.

    The code are :
      Menu_Close             Close the currently opened menu.
      Menu_Open              Open the next Standard Menu.
      Menu_Skip              Skip_the next standard (Menu or Entry).
      Menu_New    <Name>     Create and Open a new user menu of specified name.
      Menu_Entry  <Name>     Create a menu entry of specified name.
      Menu_Separ             Create a Separator menu Entry.

    The directives Menu_Entry and Menu_Separ allocate an integer identifier
    to the new menu elements beginning from 1. This identifier is returned by
    the procedure DRAW$DIALOG when the corresponding entry is selected by
    the mouse.
    The Menu_skip can be used with the form n*16+Menu_Skip where n is a skip number
    with the following specificities:
      If n < 0 the skip go to the end of current standard menu else,
      if n > 0 the result is to skip n entry in the current standard menu.

  }

  DRAW$SET_MENU_SPC( Menu_Skip );                 { Skip the standard menu "File" }
  DRAW$SET_MENU_SPC( Menu_New, '&Rotate' );       { Create a New menu "Rotate" }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Omega' );      { Create a New menu entry "Omega" with id = 1 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Chi' );        { Create a New menu entry "Chi"   with id = 2 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Phi' );        { Create a New menu entry "Phi"   with id = 3 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Dist' );       { Create a New menu entry "Dist"  with id = 4 }
  DRAW$SET_MENU_SPC( Menu_Close );                { Close the user menu "Rotate" }
  DRAW$SET_MENU_SPC( Menu_Close );                { Close the main standard menu (barre menu) }

  DRAW$INIT( xs, ys, unit, 'Essai Graphic' );
  WRITELN( 'xs = ', xs, '   ys = ', ys, '   unit = ', unit );


  bscal   := true;
  bmargin := true;
  bstatus := DRAW$PICTURE3( 'Surface Gaussienne', 48.0, 36.0, 48.0, bscal, bmargin );

  (* DRAW$PIC_VIEW( 0 ); *)


  DISPLAY_SURFACE;

  repeat
    irep := DRAW$DIALOG( 3 );
    if irep = 100000 then UPDATE_ANGLES
    else
    begin
      if irep >= 1 then WRITELN( ' Dialogue answerd = ', irep:0 )
                   else if irep < 0 then goto et_stop;
      case irep of
        1: { Euler Angle Omega Function }
          begin
            status := DRAW$GET_VALUE( 'Eulerian Angle Omega', ome, -180.0, 180.0 );
            if status <> 1 then ome :=  90.0;
            ROTATE_PLOT
          end;

        2: { Euler Angle chi Function }
          begin
            status := DRAW$GET_VALUE( 'Eulerian Angle Chi', chi, -180.0, 180.0 );
            if status <> 1 then chi :=  80.0;
            ROTATE_PLOT
          end;

        3: { Euler Angle Phi Function }
          begin
            status := DRAW$GET_VALUE( 'Eulerian Angle Phi', phi, -180.0, 180.0 );
            if status <> 1 then phi := -40.0;
            ROTATE_PLOT
          end;

        4: { View Distance }
          begin
            status := DRAW$GET_VALUE( 'Distance of View', dview, 0.0, 500.0 );
            if status <> 1 then dview := 0.0;
            ROTATE_PLOT
          end
      end { case }
    end
  until irep = 0;

et_stop:
  DRAW$END;
  WRITELN( ' End of Essai Surface.' )
end Essai_Surface.
