%pragma trace 1;
(*
[inherit( 'DRAW_INSTALL:DRAW_DEFS'{'LIB:DRAW_DEFS'},
           'SYS$LIBRARY:PASCAL$LIB_ROUTINES')]
*)
program ESGR( input, output );

%include 'DRAWENV:draw_defs.pas' {, list_on};


const

  max_nbc = 2;
  pi      = 4.0*ARCTAN( 1.0 );
  inrd    = pi/180.0;

var

  binit, bpen, bscal, bmargin, bstatus: boolean;
  unit: unit_type;
  leseg, lepic,
  i, j, k, irep, x_axis, y_axis, box1,
                 x2_axe, y2_axe, box2: integer;
  xs, ys, xx, yy: Dfloat;

  untx, unty, name: string( 255 );

  xa_dir: Dpoint3 := [  1.0,  0.0,  0.0 ];
  xt_dir: Dpoint3 := [  0.0,  1.0,  0.0 ];
  ya_dir: Dpoint3 := [  0.0,  1.0,  0.0 ];
  yt_dir: Dpoint3 := [ -1.0,  0.0,  0.0 ];

  xa_di2: Dpoint3 := [  1.0,  0.0,  0.0 ];
  xt_di2: Dpoint3 := [  0.0,  1.0,  0.0 ];
  ya_di2: Dpoint3 := [  0.0,  1.0,  0.0 ];
  yt_di2: Dpoint3 := [ -1.0,  0.0,  0.0 ];


  
  bx_dir: array[1..2] of integer;
  bx_shift: array[1..2] of Dfloat;
  bx_di2: array[1..4] of integer;

  ax_tfre, ay_tfre,
  ax_tknd, ay_tknd: array[1..4] of Dint;
  ax_tsiz, ay_tsiz: array[1..4] of Dfloat;

  status, segb1, iseg1, iseg2, iseg3, iseg4: Dint;
  angle: Dfloat := 90.0;
  xc, yc, xd, yd: Dfloat;

  curve: array[1..1600] of Dfloat;



  procedure CREATE_BOX1;
  begin
    segb1 := DRAW$NEW_SEG( 100 );
    WRITELN( ' Create Box 1: Create Segment # ', segb1:3 );
    DRAW$LINE_ATTR( 1, 1.0 );

    { The flag parameter (last one) must be flag the axis characteristics
      as this :
      the value must be a set of this following constantes :

      *****   Axis Flags   *****

      Axis_Log       =    1;  (* Axis is in Log10 Coordinate *)
      Axis_Left      =    2;  (* Ticks and displayed value at left position ( else at right ) *)
      Axis_VOther    =    4;  (* Value are in other side (than ticks) *)
      Axis_NFrs      =    8;  (* Does not display the first Ticks *)
      Axis_NFVl      =   16;  (* Does not display the first Value *)
      Axis_NLsT      =   32;  (* Does not display the last Ticks *)
      Axis_NLVl      =   64;  (* Does not display the last Value *)
      Axis_NZer      =  128;  (* Does not display the Zero Ticks *)
      Axis_NZVl      =  256;  (* Does not display the Zero Value *)
      Axis_Arrow     =  512;  (* Put an arrow at the end of axis *)
      Axis_ArroF     = 1024;  (* Fill mode for Axis_Arrow *)
      Axis_Tilte     = 2048;  (* Axis character are tilted with ticks *)


      *****   Axis Plot Directives and Flags for Draw_Plot   *****

      Axis_Plot_X    =    1;  (* Plot an X axis *)
      Axis_Plot_Y    =    2;  (* Plot an Y axis *)
      Axis_Plot_Z    =    3;  (* Plot a  Z axis *)
      Axis_PFlg_TVl  =    4;  (* Ticks values and Unit String will be Displayed *)
      Axis_PFlg_TPrm =    8;  (* The ticks left and right sides are permutted *)
      Axis_PFlg_TSym =   16;  (* The Ticks must be symmetrized *)
      Axis_PFlg_XEnd =   32;  (* Plot Axis with a shift of x axis size *)
      Axis_PFlg_YEnd =   64;  (* Plot Axis with a shift of Y axis size *)
      Axis_PFlg_ZEnd =  128;  (* Plot Axis with a shift of Z axis size *)
      Axis_PFlg_XPos =  256;  (* Plot Axis at specified X shift *)
      Axis_PFlg_YPos =  512;  (* Plot Axis at specified Y shift *)
      Axis_PFlg_ZPos = 1024;  (* Plot Axis at specified Z shift *)
 
    }

    x_axis := DRAW$NEW_AXIS( xa_dir, xt_dir, 36.0,  0.0, 360.0,  36, Axis_Arrow+Axis_ArroF );
    y_axis := DRAW$NEW_AXIS( ya_dir, yt_dir, 10.0, -1.0,   1.0,  10, Axis_Arrow+Axis_ArroF+Axis_VOther );


    ax_tfre[1] := 18; ax_tknd[1] := 1; ax_tsiz[1] := 0.6;
    ax_tfre[2] :=  9; ax_tknd[2] := 1; ax_tsiz[2] := 0.4;
    ax_tfre[3] :=  1; ax_tknd[3] := 1; ax_tsiz[3] := 0.2;

    ay_tfre[1] :=  5; ay_tknd[1] := 1; ay_tsiz[1] := 0.6;
    ay_tfre[2] :=  1; ay_tknd[2] := 1; ay_tsiz[2] := 0.3;


    Draw$Set_Axis_Unit( x_axis, 'Degree' );
    Draw$Set_Axis_Unit( y_axis, 'Sinus/Cosinus' );

    Draw$Set_Axis_Ticks( x_axis,  0,  3, ax_tfre, ax_tknd, ax_tsiz );
    Draw$Set_Axis_Ticks( y_axis,  0,  2, ay_tfre, ay_tknd, ay_tsiz );

    Draw$Set_Axis_Value( x_axis, 2, 112,,,,, 4,  4, 0 ); { Set Value Font, Field and decimal }
    Draw$Set_Axis_Value( y_axis, 2, 112,,,,, 4,  5, 1 ); { Set Value Font, Field and decimal }

    bx_dir[1] := Axis_PFlg_YPos + Axis_PFlg_TSym + { Axis with Y shift specified at y axis value }
                 Axis_PFlg_TVl  + Axis_Plot_X;     { symmetrized ticks, Tick Values, X axis at y = 0 }
    bx_dir[2] :={Axis_PFlg_TPrm +}Axis_PFlg_TVl + Axis_Plot_Y; { Tick Values, L./R. Permuttation }

    bx_shift[1] := 0.0;
    bx_shift[2] := 0.0;

    box1   := DRAW$NEW_BOX( Dpoint3[3.0, 2.0, 0.0], x_axis, y_axis, 0, bx_dir, bx_shift );

    DRAW$COLOR( 1 );
    DRAW$PLOT_BOX( box1 );
    DRAW$SEG_END
  end CREATE_BOX1;



begin { MAIN }

  {****************************************************}
  {          INITIALYSE THE DRAWING SYSTEM             }
  {****************************************************}
  { The external procedure

      DRAW$DEF_MENU( code: Dint; in_var name: [optional] string );

                  is a procedure to modify by insertion the DRAW$DIALOG
    standard menu setting.

    The code are :
      Menu_Close             Close the currently opened menu.
      Menu_Open              Open the next Standard Menu.
      Menu_Skip              Skip_the next standard (Menu or Entry).
      Menu_New    <Name>     Create and Open a new user menu of specified name.
      Menu_Entry  <Name>     Create a menu entry of specified name.
      Menu_Separ             Create a Separator menu Entry.

    The directives Menu_Entry and Menu_Separ allocate an integer identifier
    to the new menu elements beginning from 1. This identifier is returned by
    the procedure DRAW$DIALOG when the corresponding entry is selected by
    the mouse.
    The Menu_skip can be used with the form n*16+Menu_Skip where n is a skip number
    with the following specificities:
      If n < 0 the skip go to the end of current standard menu else,
      if n > 0 the result is to skip n entry in the current standard menu.

  }

  DRAW$SET_MENU_SPC( Menu_Open );                 { Enter in the standard menu "File" }
  DRAW$SET_MENU_SPC( Menu_Skip );                 { Skip "Save" Entry }
  DRAW$SET_MENU_SPC( Menu_Entry, '&XY' );         { Create a New Entry "XY" with id = 1 }
  DRAW$SET_MENU_SPC( Menu_Skip+2*Menu_Fact );     { Skip to end of Standard File Menu (if -1)}
  DRAW$SET_MENU_SPC( Menu_Separ );                { Create a Separator (always a line) }
  DRAW$SET_MENU_SPC( Menu_Entry, 'A&ngle' );      { Create a New Entry "Angle" with id = 2 }
  DRAW$SET_MENU_SPC( Menu_Close );                { Close the standard menu "File" }
  DRAW$SET_MENU_SPC( Menu_New, 'E&dit' );         { Create a New menu "Edit" }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Delete' );     { Create a New menu entry "Delete" with id = 3 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Plot 1' );     { Create a New menu entry "Plot" with id = 4 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Plot 2' );     { Create a New menu entry "Plot" with id = 5 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Plot 3' );     { Create a New menu entry "Plot" with id = 6 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Insert' );     { Create a New menu entry "Insert" with id = 7 }
  DRAW$SET_MENU_SPC( Menu_Close );                { Close the user menu "Edit" }
  DRAW$SET_MENU_SPC( Menu_New, '&Input' );        { Create a New menu "Input" }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Point' );      { Create a New menu entry "Point" with id = 8 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Window' );     { Create a New menu "Window" with id = 9 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Curve 1' );    { Create a New menu "Curve 1" with id = 10 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&Curve 2' );    { Create a New menu "Curve 2" with id = 11 }
  DRAW$SET_MENU_SPC( Menu_Entry, '&PicK Seg' );   { Create a New menu "Pick Seg" with id = 12 }
  DRAW$SET_MENU_SPC( Menu_Close );                { Close the user menu "Input" }
  DRAW$SET_MENU_SPC( Menu_Close );                { Close the main standard menu (barre menu) }

  DRAW$INIT( xs, ys, unit, 'Essai Graphic' );
  WRITELN( 'xs = ', xs, '   ys = ', ys, '   unit = ', unit );

  segb1 := 0; iseg1 := 0; iseg2 := 0; iseg3 := 0; iseg4 := 0;

  bscal   := true;
  bmargin := true;
  bstatus := DRAW$PICTURE( 'RESULTATS', 42.0, 32.0, bscal, bmargin );

(*
  DRAW$PIC_VIEW( 0 );
*)

 repeat
   irep := DRAW$DIALOG( 1 );
    if irep >= 1 then
      WRITELN( ' Dialogue answerd = ', irep:0 )
    else
      if irep < 0 then goto et_stop;
    case irep of
      7: begin { Ajouter/Insert Function }
          iseg1 := DRAW$NEW_SEG( 1 );
          WRITELN( ' Insert: Create Segment # ', iseg1:3 );

          DRAW$LINE_ATTR( 1, 3.0 );
          DRAW$COLOR( 4 );

          DRAW$PLOT( 7.0, 3.0, false );
          DRAW$PLOT( 9.0, 2.0, true );
          DRAW$PLOT( 8.0, 6.0, true );
          DRAW$PLOT( 7.0, 3.0, true );
          DRAW$PLOT( 7.0, 3.0, false );

          DRAW$PLOT3( 3.0, 3.0, 0.1, false );
          DRAW$PLOT3( 5.0, 2.0, 0.4, true );
          DRAW$PLOT3( 4.0, 6.0, 0.2, true );
          DRAW$PLOT3( 3.0, 3.0, 0.1, true );
          DRAW$PLOT3( 3.0, 3.0, 0.1, false );

          DRAW$PLOT3( 3.0, 8.0, 0.1, false );
          DRAW$PLOT3( 5.0, 7.0, 0.4, true );
          DRAW$PLOT3( 4.0,11.0, 0.2, true );
          DRAW$PLOT3( 3.0, 8.0, 0.1, true );
          DRAW$PLOT3( 3.0, 8.0, 0.1, false );

          DRAW$STRING( 1.0, 12.0, 0.0, 1.0, ' Ceci est Ma Chaine de caracteres.' );

          DRAW$SEG_END;

        end;

      2: { Angle Function }
        begin
          status := DRAW$GET_VALUE( 'Donner un Angle(bis)', angle, 10.0, 130.0 );
          if status <> 1 then angle := 90.0;
          xt_dir[1] := COS( inrd*angle ); xt_dir[2] := SIN( inrd*angle );
          ya_dir := xt_dir;
        end;

      1, 8: { Point XY }
        if iseg2 > 0 then
        begin
          DRAW$OPEN_BOX( box1 );
          status := DRAW$GET_POSITION( xc, yc );
          WRITELN( ' Status = ', status:4, ' Xc = ', xc:12:2, ', Yc = ', yc:12:2 );
          DRAW$CLOSE_BOX
        end;

      4: { Plot 1 }
        begin
          if segb1 = 0 then CREATE_BOX1;
          iseg2 := DRAW$NEW_SEG( 2 );
          WRITELN( ' Plot 1: Create Segment # ', iseg2:3 );

          DRAW$OPEN_BOX( box1 );
          DRAW$OUT_MODE( 1 );
          DRAW$LINE_ATTR( 2, 2.0 );
          DRAW$COLOR( 2 );
          DRAW$PLOT( 0.0, 0.0, false );
          for i := 1 to 360 do
          begin
            xx := i; yy := sin( i*inrd );
            DRAW$PLOT( xx, yy, true );
          end;
          DRAW$PLOT( 1.0, 0.0, false );

          DRAW$CLOSE_BOX;
          DRAW$SEG_END;
          DRAW$SEG_ATTR( iseg2, 2, 1, 2, 0.5 )
        end;

      3: { Delete }
        begin
          if iseg1 > 0 then
          begin
            WRITELN( ' Try to Delete Segment # ', iseg1:4 );
            DRAW$DEL_SEG( iseg1 );
            WRITELN( ' Delete Segment # ', iseg1:3 );
            iseg1 := 0
          end;
          if iseg2 > 0 then
          begin
            WRITELN( ' Try to Delete Segment # ', iseg2:4 );
            DRAW$DEL_SEG( iseg2 );
            WRITELN( ' Delete Segment # ', iseg2:3 );
            iseg2 := 0
          end;
          if iseg3 > 0 then
          begin
            WRITELN( ' Try to Delete Segment # ', iseg3:4 );
            DRAW$DEL_SEG( iseg3 );
            WRITELN( ' Delete Segment # ', iseg3:3 );
            iseg3 := 0
          end;
          if iseg4 > 0 then
          begin
            WRITELN( ' Try to Delete Segment # ', iseg4:4 );
            DRAW$DEL_SEG( iseg4 );
            WRITELN( ' Delete Segment # ', iseg3:4 );
            iseg3 := 0
          end;
          if segb1 > 0 then
          begin
            WRITELN( ' Try to Delete Segment # ', segb1:4 );
            DRAW$DEL_SEG( segb1 );
            WRITELN( ' Delete Segment # ', segb1:4 );
            segb1 := 0
          end;

        end;

      5: { Plot 2 }
        begin
          if segb1 = 0 then CREATE_BOX1;
          iseg4 := DRAW$NEW_SEG( 4 );
          WRITELN( ' Plot 2: Create Segment # ', iseg4:3 );
          DRAW$LINE_ATTR( 3, 2.0 );
          DRAW$COLOR( 3 );
          DRAW$PLOT_BOX( box1 );
          DRAW$OPEN_BOX( box1 );
          DRAW$OUT_MODE( 1 );
          DRAW$PLOT( 0.0, 1.0, false );
          for i := 1 to 360 do
          begin
            xx := i; yy := cos( i*inrd );
            DRAW$PLOT( xx, yy, true );
          end;
          DRAW$PLOT( 1.0, 0.0, false );
          DRAW$CLOSE_BOX;
          DRAW$SEG_END;
          DRAW$SEG_ATTR( iseg4, 2, 1, 2, 0.5 )
        end;

      6: { Plot 3 }
        begin
          iseg3 := DRAW$NEW_SEG( 3 );
          DRAW$COLOR( 1 );
          WRITELN( ' Plot 3: Create Segment # ', iseg3:3 );

          { The flag parameter (last one) must be flag the axis characteristics
            as this :
              the value must be a set of this following constantes :

            *****   Axis Flags   *****

            Axis_Log       =    1;  (* Axis is in Log10 Coordinate *)
            Axis_Left      =    2;  (* Ticks and displayed value at left position ( else at right ) *)
            Axis_VOther    =    4;  (* Value are in other side (than ticks) *)
            Axis_NFrs      =    8;  (* Does not display the first Ticks *)
            Axis_NFVl      =   16;  (* Does not display the first Value *)
            Axis_NLsT      =   32;  (* Does not display the last Ticks *)
            Axis_NLVl      =   64;  (* Does not display the last Value *)
            Axis_NZer      =  128;  (* Does not display the Zero Ticks *)
            Axis_NZVl      =  256;  (* Does not display the Zero Value *)
            Axis_Arrow     =  512;  (* Put an arrow at the end of axis *)
            Axis_ArroF     = 1024;  (* Fill mode for Axis_Arrow *)
            Axis_Tilte     = 2048;  (* Axis character are tilted with ticks *)


            *****   Axis Plot Directives and Flags for Draw_Plot   *****

            Axis_Plot_X    =    1;  (* Plot an X axis *)
            Axis_Plot_Y    =    2;  (* Plot an Y axis *)
            Axis_Plot_Z    =    3;  (* Plot a  Z axis *)
            Axis_PFlg_TVl  =    4;  (* Ticks values and Unit String will be Displayed *)
            Axis_PFlg_TPrm =    8;  (* The ticks left and right sides are permutted *)
            Axis_PFlg_TSym =   16;  (* The Ticks must be symmetrized *)
            Axis_PFlg_XEnd =   32;  (* Plot Axis with a shift of x axis size *)
            Axis_PFlg_YEnd =   64;  (* Plot Axis with a shift of Y axis size *)
            Axis_PFlg_ZEnd =  128;  (* Plot Axis with a shift of Z axis size *)
            Axis_PFlg_XPos =  256;  (* Plot Axis at specified X shift *)
            Axis_PFlg_YPos =  512;  (* Plot Axis at specified Y shift *)
            Axis_PFlg_ZPos = 1024;  (* Plot Axis at specified Z shift *)
 
          }

          x2_axe := DRAW$NEW_AXIS( xa_di2, xt_di2, 36.0,  -2.0,    3.0,  5,        0 );
          y2_axe := DRAW$NEW_AXIS( ya_di2, yt_di2, 15.0,  0.01, 1000.0, -1, Axis_Log );


          Draw$Set_Axis_Unit( x2_axe, 'x' );
          Draw$Set_Axis_Unit( y2_axe, '10^x' );

          { Draw$Set_Axis_Ticks( x2_axe, 0, 3, ax_tfre, ax_tknd, ax_tsiz ); }
          { Draw$Set_Axis_Ticks( y2_axe, 0, 2, ay_tfre, ay_tknd, ay_tsiz ); }

          Draw$Set_Axis_Value( x2_axe, 2, 112,,,,, 4,  5,  2 ); { Set Value Font, Field and decimal }
          Draw$Set_Axis_Value( y2_axe, 2, 112,,,,, 4,  5,  2 ); { Set Value Font, Field and decimal }

          bx_di2[1] := Axis_PFlg_TVl  + Axis_Plot_X; { Tick Values, Plot X axis }
          bx_di2[2] := Axis_PFlg_TPrm + Axis_PFlg_TVl  + Axis_Plot_Y; { Tick Values, L./R. Perm., Plot Y axis }
          bx_di2[3] := Axis_PFlg_YEnd + Axis_PFlg_TPrm + Axis_Plot_X; { Shift at Ymax, L./R. Perm., Plot X axis }
          bx_di2[4] := Axis_PFlg_XEnd + Axis_Plot_Y; { Shift at Xmax, Plot Y axis }


          box2   := DRAW$NEW_BOX( Dpoint3[3.0, 15.0, 0.0], x2_axe, y2_axe, 0, bx_di2 );

          DRAW$COLOR( 0.2, 0.2, 0.0 );
          DRAW$LINE_ATTR( 1, 1.0 );
          DRAW$PLOT_BOX( box2 );
          DRAW$OPEN_BOX( box2 );
          DRAW$LINE_ATTR( 4, 2.0 );
          DRAW$OUT_MODE( 1 );
          bpen := false;
          for i := -200 to 300 do
          begin
            xx := i/100.0; yy := 10**xx;
            DRAW$PLOT( xx, yy, bpen );
            bpen := true;
          end;
          DRAW$PLOT( 0.0, 1.0, false );
          DRAW$CLOSE_BOX;
          DRAW$SEG_END;
          DRAW$SEG_ATTR( iseg3, 2, 1, 2, 0.5 )
        end;

      9: { Window }
        if iseg2 > 0 then
        begin
          DRAW$OPEN_BOX( box1 );
          status := DRAW$GET_WINDOW( xc, xd, yc, yd );
          WRITELN( ' Status = ', status:4, ' win =[', xc:12:2, ',', xd:12:2, ',',
                                              yc:12:2, ',', yd:12:2, '].' );
          DRAW$CLOSE_BOX
        end;

     10: { Get Curve 1 }
        if iseg2 > 0 then
        begin
          DRAW$OPEN_BOX( box1 );
          irep := DRAW$GET_CURVE( curve, k, false, true );
          WRITELN( '*** ', k:0, ' Read points: ' );
          j := 0;
          for i := 1 to k do
          begin
            WRITELN( '   ', i:4, '/ ', curve[j+1]:8:2, curve[j+2]:8:2 );
            j := j + 2
          end;
          DRAW$CLOSE_BOX
        end;

      11: { Get Curve 2 }
        if iseg3 > 0 then
        begin
          DRAW$OPEN_BOX( box2 );
          irep := DRAW$GET_CURVE( curve, k, false, false );
          WRITELN( '*** ', k:0, ' Read points: ' );
          j := 0;
          for i := 1 to k do
          begin
            WRITELN( '   ', i:4, '/ ', curve[j+1]:8:2, curve[j+2]:8:2 );
            j := j + 2
          end;
          DRAW$CLOSE_BOX
        end;

      12: { Pick Seg }
        begin
          status := DRAW$SEG_PICK( leseg, lepic );
          WRITELN( ' Pick_Res = ', status:0, ', iseg = ', leseg:0, ' and picid = ', lepic:0 )
        end


    end { case }
  until irep = 0;

et_stop:
  DRAW$END;
  WRITELN( ' End of EsGr.' )
end EsGr.






