/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*              D R A W   -   C L I E N T   L I B R A R Y                *
*                                                                       *
*              (Environment/Header File for DRAW Library)               *
*                              (Part L4)                                *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/



#ifndef _DRW_ENVL4                   /* To avoid Multi-definitions */
#  define _DRW_ENVL4  0

#  ifdef _DRAWLIB_L4BASE_
#    define ext4rf
#    define ext4ini( val )        = val
#  else
#    define ext4rf extern
#    define ext4ini( val )
#  endif




/***********************************************************************/
/**                                                                   **/
/**           C O N S T A N T E S    D E F I N I T I O N S            **/
/**                                                                   **/
/***********************************************************************/


#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */


/* Define the Allocation size of axis unit string */

#define _USZ_           64

#define  BX_VALU         4
#define  BX_TRVM         8
#define  BX_TSYM        16

#define  BX_XSHEND      32
#define  BX_YSHEND      64
#define  BX_ZSHEND     128
#define  BX_XSHPOS     256
#define  BX_YSHPOS     512
#define  BX_ZSHPOS    1024

#define  AX_LOG          1
#define  AX_LEFT         2
#define  AX_NFRS         4
#define  AX_NFVL         8
#define  AX_NLST        16
#define  AX_NLVL        32
#define  AX_NZER        64
#define  AX_NZVL       128
#define  AX_ARRO       256






/***********************************************************************/
/**                                                                   **/
/**            V A R I A B L E S    D E F I N I T I O N S             **/
/**                                                                   **/
/***********************************************************************/





/***********************************************************************/
/**                                                                   **/
/**  P R O C E D U R E S / F U N C T I O N S   D E F I N I T I O N S  **/
/**                                                                   **/
/***********************************************************************/


int  Draw_New_Axis( Draw_Point3 u_axis, Draw_Point3 v_axis,
                    float       length, float         vinf,
                    float         vsup, int           ntck, int          flags );


int Draw_New_Box( Draw_Point3 org, int ix, int iy, int iz, int dtb[], int dsz,
                                                           float stb[], int nfz,
                                                           int dtbdim, int stbdim );

int Draw__Easy_Box_2D( float ox, float oy, float sx, float sy, float* mm,
                       char* ux, char* uy, int  lux, int  luy, int    ns );

void Draw_Free_Box( int ib, Char axflg );
void DRW_API( free_box_list ) ();

void Draw__Set_Axis_Value( int    ax, int    cd, int     n,
                           float* p1, float* p2, float* p3, float* p4,
                           int*   p5, int*   p6, int*   p7 );
int  Draw__Get_Axis_Value( int    ax, int    cd, int     n,
                           float* p1, float* p2, float* p3, float *p4,
                           int*   p5, int*   p6, int*   p7 );

int  Draw__Get_Box_Value( int box, int cd, int n, void * tb );

void Draw_Plot_Axis( int ia, Draw_Point3 org, int fvl );
void Draw_Plot_Box( int ib );
void Draw_Open_Box( int ib );
void DRW_API( close_box ) ();

#endif

