/*  P A S - P. WOLFERS SOFTWARE: V2.0-4 OF 15-OCT-2006 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 200 ) = {
  9,   9, 103, 101, 116,  95, 100, 101, 108,  97, 121,  64,  64,  47, 104, 111,
109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47,
102, 108, 116, 107,  95, 115, 101, 114, 118, 101, 114,  95, 115, 114,  99,  95,
 86,  48,  46,  57,  47,  68, 114,  97, 119,  95,  69, 120,  97, 109, 112, 108,
101, 115,  47, 101, 115, 112, 114, 111, 103,  46, 112,  97, 115,  10,  10,  99,
104,  97, 110, 103, 101,  95,  98, 111, 120,   7,   7, 116, 105, 109, 101,  40,
115,  41,   3,   3,  99, 112, 115,   8,   8, 110, 101, 119,  95, 116, 115, 101,
103,  12,  12, 105, 110,  99, 114, 101,  97, 115, 101,  95,  98, 111, 120,   7,
  7, 116, 105, 109, 101,  40, 115,  41,   3,   3,  99, 112, 115,   6,   6, 101,
115, 112, 114, 111, 103,  24,  24,  80, 114, 111, 103, 114, 101, 115, 115, 105,
118, 101,  32, 112, 108, 111, 116,  32, 101, 120,  97, 109, 112, 108, 101,   7,
  7, 116, 105, 109, 101,  40, 115,  41,   3,   3,  99, 112, 115,   2,   2,  47,
 32,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 32 ) = {
205, 204, 204,  61,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
205, 204, 204,  61,   0,   0,   0,   0, 205, 204, 204,  61,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 224 );

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL Draw_AnmSSt;


/* Function/procedure prototypes. */
void DRW_API( end )();
SL Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid);
UB Draw_Pas_Picture(V F_title, F F_px, F F_py, UB F_bscale, UB F_blimit);
void Draw_Pic_View(UB F_flags);
SL Draw_Time_Anim(SL F_per);
void Draw_Set_Stop_Anim(SL F_md);
void Draw_Out_Mode(SL F_n);
void Draw_Line_Attr(SL F_n, F F_r);
void Draw_Marker_Attr(SL F_n, F F_r);
SL Draw_New_Seg(SL F_n);
void DRW_API( seg_end )();
SL Draw_Update_Seg(SL F_n, SL F_fapp);
void Draw_Progplot(F F_x, F F_y);
void Draw_ProgSetting(SL F_seg, SL F_ide);
SL Draw_Dialog(SL F_flags);
SL Draw_Easy_Box_2D(F F_ox, F F_oy, F F_sx, F F_sy, F F_mx1, F F_mx2, F F_my1, F
F_my2, V F_ux, V F_uy, SL F_ns);
void Draw_Free_Box(SL F_ib, UB F_axflg);
void Draw_Plot_Box(SL F_ib);
void Draw_Open_Box(SL F_ib);
void DRW_API( close_box )();


/* Procedure/Function : " get_delay "  */
void ESPROG_get_delay(F F_time, F *F_del, F *F_int){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=40; /* line # 40 */
  Rv0=F_time-(float)(F_time>0.0?(SL)(F_time+0.5):(SL)(F_time-0.5));
  (*F_int)=exp(-PAS__F_SQR(Rv0/Ri.f[0]));
  while (1){
    Rv1=PAS__RANDOM(Ri.sl+1);
    if (Rv1>(F)0.000000E-01)  break;
  }
  (*F_del)=(F)1.000000E-01*log(Rv1/Ri.f[0]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " change_box "  */
void ESPROG_change_box(F F_xmin, F F_xmax){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=50; /* line # 50 */
  DRW_API( seg_end )();
  DRW_API( close_box )();
  Draw_Update_Seg(1,0);
  Draw_Free_Box(Rs.sl[0],0);
  Draw_Out_Mode(1);
  Ra.sl[3]=55; /* line # 55 */
  Draw_Line_Attr(1, (F)2.000000E+00);
  Rs.sl[0]=Draw_Easy_Box_2D((F)2.000000E+00, (F)2.000000E+00, (F)2.600000E+01, (F)
2.000000E+01, F_xmin, F_xmax, (F)0.000000E-01, (F)1.000000E+00, Rd.s+89,Rd.s+98,2);
  Draw_Plot_Box(Rs.sl[0]);
  Draw_Open_Box(Rs.sl[0]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " new_tseg "  */
void ESPROG_new_tseg(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+103;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=68; /* line # 68 */
  DRW_API( seg_end )();
  if (Ri.sl[2]>0) Rv0=Rs.f[Ri.sl[2]*3+2];
  else Rv0=Rs.f[49];
  Ri.sl[2]=Ri.sl[2]+1;
  if (Ri.sl[2]>=16) Ri.sl[2]=Ri.sl[2]-16;
  Rv1=(Rs.s+Ri.sl[2]*12+4);
  Ra.sl[3]=73; /* line # 73 */
  if (((SL *)Rv1)[0]==0) {
    ((SL *)Rv1)[0]=Draw_New_Seg(Ri.sl[2]+10);
    ((F *)Rv1)[1]=Rv0;
    ((F *)Rv1)[2]=Rv0+Rs.f[50];
  }
  else {
    Ra.sl[3]=82; /* line # 82 */
    ESPROG_change_box(Rv0, Rv0+Rs.f[50]);
    Draw_Update_Seg(Ri.sl[2]+10,0);
    Draw_Out_Mode(2);
    Draw_Marker_Attr(2, (F)2.000000E+00);
  }
  Ra.sl[3]=87; /* line # 87 */
  Ri.sl[3]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " increase_box "  */
void ESPROG_increase_box(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+113;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=94; /* line # 94 */
  if (Rs.sl[0]!=0) {
    DRW_API( close_box )();
    Draw_Free_Box(Rs.sl[0],0);
  }
  Ra.sl[3]=99; /* line # 99 */
  Rs.f[50]=(Ri.f[4]-Rs.f[49])*(F)1.250000E+00;
  Rs.sl[0]=Draw_Easy_Box_2D((F)2.000000E+00, (F)2.000000E+00, (F)2.600000E+01, (F)
2.000000E+01, Rs.f[49],Rs.f[49]+Rs.f[50],(F)0.000000E-01, (F)1.000000E+00, Rd.s+
127,Rd.s+136,2);
  Draw_Update_Seg(1,0);
  Draw_Plot_Box(Rs.sl[0]);
  DRW_API( seg_end )();
  Ra.sl[3]=104; /* line # 104 */
  Draw_Open_Box(Rs.sl[0]);
  Draw_Update_Seg(Ri.sl[2]+10,1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " esprog "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  F Rv2;
  UB Rv3;
  F Rv4;
  register int Rf0;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[51]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+204;
  Rs.v[52]=Rd.s+141;
  Rs.v[53]=Rd.s+11;
  Rs.sl[54]=112; /* line # 112 */
  Rv0=0;
  for( Rf0=16;Rf0>0;Rf0-- ) {
    Rs.sl[Rv0*3+1]=0;
    Rv0++;
  }
  Ri.f[4]=(F)0.000000E-01;
  Rs.f[49]=(F)0.000000E-01;
  Rs.f[50]=(F)6.000000E+02;
  Rs.sl[54]=117; /* line # 117 */
  Ri.sl[2]=-1;
  Draw_Pas_Init(&Rv1, &Rv2, &Rv3, NULL);
  Draw_Pas_Picture(Rd.s+149,(F)3.000000E+01, (F)2.000000E+01,1,1);
  Draw_Pic_View(0);
  Rs.sl[54]=122; /* line # 122 */
  Draw_New_Seg(1);
  Rs.sl[0]=Draw_Easy_Box_2D((F)2.000000E+00, (F)2.000000E+00, (F)2.600000E+01, (F)
2.000000E+01, Rs.f[49],Rs.f[49]+Rs.f[50],(F)0.000000E-01, (F)1.000000E+00, Rd.s+
175,Rd.s+184,2);
  Draw_Line_Attr(1, (F)2.000000E+00);
  Draw_Plot_Box(Rs.sl[0]);
  Rs.sl[54]=127; /* line # 127 */
  Draw_Time_Anim(10);
  Draw_Open_Box(Rs.sl[0]);
  Ri.sl[2]=0;
  ESPROG_new_tseg();
  while (1){
    Rs.sl[54]=135; /* line # 135 */
    Draw_Set_Stop_Anim(0);
    Ri.sl[5]=Draw_Dialog(1);
    if (Ri.sl[5]>=0) {
      Draw_Set_Stop_Anim(1);
      Rs.sl[54]=140; /* line # 140 */
      Draw_Open_Box(Rs.sl[0]);
      while (1){
        Ri.sl[3]=Ri.sl[3]+1;
        ESPROG_get_delay(Ri.f[4],Ri.f+6,&Rv4);
        Ri.f[4]=Ri.f[4]+Ri.f[6];
        Rs.sl[54]=145; /* line # 145 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_INT(Ri.sl[3],4,0);
        PAS__WRITE_STR(Rd.s+189,-1,-1,32);
        PAS__WRITE_SNGL(Ri.f[4],10,3,0);
        PAS__WRITE_SNGL(Rv4,10,4,0);
        PAS__WRITE_EOLN();
        if (Ri.f[4]>Rs.f[49]+Rs.f[50]) ESPROG_increase_box();
        if (Ri.f[6]>(F)0.000000E-01) PAS__DELAY(Ri.f[6]);
        Draw_Progplot(Ri.f[4],Rv4);
        if (Ri.sl[3]>=128) {
          Rs.sl[54]=151; /* line # 151 */
          Draw_ProgSetting(0,0);
          ESPROG_new_tseg();
        }
        if (Draw_AnmSSt>0)  break;
      }
    }
    if (Ri.sl[5]<0)  break;
  }
  Rs.sl[54]=158; /* line # 158 */
  DRW_API( end )();
  PAS__curr_cntx=Rs.v[51];
  PAS__EXIT( 0 );
}
