program ESFONT;

%include 'DRAWENV:draw_defs.pas';

const
  MAX_SEG  =        20;
  MAX_FNT  =        20;
  MIN_FNB  =         8; { Equal to the predefined Font number }

  not_defined = '-- Undefined --';

  Font_Styles =  Draw_Menu[ 6, 8, 'BitMap',
                                  'PixMap',
                                  'Outline',
                                  'Polygon',
                                  'Extrude',
                                  'Texture'
                          ];

type
  seg_rec = record
    seg_iseg:             Dint;
    seg_px, seg_py:     Dfloat;
    seg_col:            Dcolor
  end;


  fnt_rec = record
    fnt_ifnt,
    fnt_istl:             Dint
  end;


var
  xp, yp:               Dfloat;
  unt:               unit_type;
  bstat:                 Dbool;
  strtmp:               string;
  cfont:             Dint := 0;                 { Current font to use }

  seg_tb: array[1..MAX_SEG] of seg_rec;

  fnt_tb: array[1..MAX_FNT] of fnt_rec;

  setup,                                        { Setup Pannel Identifier }
  irp, ist, nseg, nfnt:      Dint := 0;


  font_path: [static] string := '';

  font_menu: [static] array[1..MIN_FNB+MAX_FNT] of ^string;


  pdef_name: [static] array[1..MIN_FNB] of string( 16 )
                         := [ 'Def Font # 0', 'Def Font # 1', 'Def Font # 2', 'Def Font # 3',
                              'Def Font # 4', 'Def Font # 5', 'Def Font # 6', 'Def Font # 7' ];

  Styles: [static] Choice_list( 6, 8 ) := [ 'BitMap',
                                            'PixMap',
                                            'Outline',
                                            'Polygon',
                                            'Extrude',
                                            'Texture'
                                          ];

  TxtPth: [static] Choice_list( 4, 6 ) := [ 'RIGHT',    { PATH_RIGHT }
                                            'LEFT',     { PATH_LEFT }
                                            'UP',       { PATH_UP }
                                            'DOWN'      { PATH_DOWN }
                                          ];

  TxtAln: [static] Choice_list( 5, 8 ) := [ 'NORMAL',   { TXT_HALN_NORMAL => TXT_HALN_LEFT }
                                            'LEFT',     { TXT_HALN_LEFT }
                                            'CENTER',   { TXT_HALN_CENTRE }
                                            'RIGHT',    { TXT_HALN_RIGHT }
                                            'JUSTIFY'   { TXT_HALN_JUSTIFY }
                                          ];

  def_color:     Dcolor := [ 0.2, 0.2, 0.8, 1.0];       { Initial Default color }

  Char_High:     Dfloat := 1.0;         { Character Height }
  Char_Xsca:     Dfloat := 1.0;         { Character X/Y scaling (for vectorial fonts only) }
  Char_Depth:    Dfloat := 0.5;         { Character depth (for extruded fonts only) }
  Char_Spacing:  Dfloat := 0.0;         { Character Spacing }
  Line_Spacing:  Dfloat := 1.0;         { Spacing between the lines in a Text box }

  Char_Path:     Dint := TXT_PATH_RIGHT;{ Character PATH }
  Txt_Align:     Dint := TXT_HALN_LEFT; { Text in Box Alignement }

  fselect:       Dbool := true;         { Input font Name mode }





procedure SET_FONT_NAME( ifnt: Dint; var pst: ^string );
var
  fent, fnam:   string;
  istl, indx:     Dint;

begin
  indx := DRAW$FONT_INFO( ifnt, fnam, istl );
  if indx >= 0 then
  begin
    WRITEV( fent, Styles[istl]:9, ' : ' );
    indx := INDEX( fnam, '/', -1 );
    if indx > 0 then WRITEV( fent:false, SUBSTR( fnam, indx + 1 ) )
               else WRITEV( fent:false, fnam );
    NEW( pst, fent.length );
    pst^ := fent
  end
end SET_FONT_NAME;



function NEW_FONT( in_var fnam: string; istl: integer ): integer;
var
  ir,  ist:    integer;
  fen, fnm:     string;

begin
  ir := 1;
  while ir <= MAX_FNT do
    if fnt_tb[ir].fnt_ifnt >= 0 then ir := ir + 1
                                else exit;
  if ir <= MAX_FNT then
  begin
    with fnt_tb[ir] do
    begin
      fnt_ifnt := ir - 1;
      fnt_istl :=   istl;
      fnt_ifnt := DRAW$INSTALL_FONT( fnt_ifnt, istl, fnam );
      if fnt_ifnt < 0 then
      begin
        WRITEV( strtmp, ' We Cannot Install the font "', fnam, '".' );
        DRAW$MESSAGE( strtmp );
        fnt_ifnt := -1;
        ir := -1
      end
      else SET_FONT_NAME( ir - 1, font_menu[ir] )
    end;
    NEW_FONT := ir
  end
  else NEW_FONT := -1
end NEW_FONT;



procedure INSTALL_NEW_FONT( istl: integer );
var
  nam:       string(255) := '';
  fidx, status:        integer;

  Filtre: [static] Draw_Menu( 2, 6 ) := [ '*.ttf',
                                          '*.*'
                                        ];

begin
  if fselect then status := DRAW$SELECT_FILE( 'True-Type Font File', Filtre, font_path, nam, fidx )
             else status := DRAW$GET_STRING( 'True-Type Font Fname', '', nam );
  if status > 0 then
  begin
    fidx := NEW_FONT( nam, istl );
    WRITE( ' The Installation of the Font "', nam, '" in the mode ', Styles[istl] );
    if fidx > 0 then
    begin
      WRITELN( ' is a success with index = ', fidx:-3, ' and font # = ', fnt_tb[fidx].fnt_ifnt, '.' );
      cfont := fnt_tb[fidx].fnt_ifnt            { Set font to use it for the next object }
    end
    else WRITELN( ' was failed.' )
  end
end INSTALL_NEW_FONT;



procedure SELECT_A_FONT;
var
  ir: Dint;

begin
  ir := DRAW$GET_CHOICE( 'Choice of Font', font_menu );
  if ir >= 1 then
  begin
    cfont := fnt_tb[ir].fnt_ifnt;               { Set font to use it for the next object }
    WRITELN( ' Select the font "', font_menu[ir], '" with # ', fnt_tb[ir].fnt_ifnt:0 )
  end
end SELECT_A_FONT;



procedure CHANGE_COLOR;
var
  ist:       Dint;
  r, g, b: Dfloat;

begin
  r := def_color[1];
  g := def_color[2];
  b := def_color[3];
  ist := DRAW$GET_COLOR( 'Color to use', r, g, b );
WRITELN( ist );
  if ist >= 0 then
  begin
    def_color[1] := r;
    def_color[2] := g;
    def_color[3] := b;
    DRAW$PANNEL_PUT( setup )
  end
end CHANGE_COLOR;


function CREATE_SEGMENT( x, y: Dfloat ): Dint;
var
  ir, isg, ist:   Dint;
  mat:         Dmatrix;

begin
  ir := 1;
  while ir <= MAX_SEG do
    if seg_tb[ir].seg_iseg > 0 then ir := ir + 1
                               else exit;
  if ir <= MAX_SEG then
  begin
    isg := DRAW$NEW_SEG( ir );
    with seg_tb[ir] do
    begin
      seg_iseg := isg;
      DRAW$MOVE_SEG( isg, x, y );
      ist := DRAW$GET_SEG_MAT( isg, mat );
      seg_px   :=   x;
      seg_py   :=   y
    end;
    DRAW$SEG_ATTR( isg, 2 { Detectable }, 1 { No High Light }, 2 { Visible }, 0.5 { Priority } );
    DRAW$SET_PICKID( ir );
    DRAW$COLOR( def_color[1], def_color[2], def_color[3], def_color[4] )
  end
  else isg := -1;
  CREATE_SEGMENT := ir
end CREATE_SEGMENT;



procedure CREATE_NEW_STRING;
var
  str:                  string;
  iseg, status:           Dint;
  bsx, bsy, xx, yy:     Dfloat;

begin
  status := DRAW$GET_STRING( 'String to Create', 'This is a String', str );
  if status > 0 then
  begin
    status := DRAW$GET_POSITION( xx, yy );
  end;
  if status >= 0 then
  begin
    iseg := CREATE_SEGMENT( xx, yy );
    DRAW$TEXT_FONT( cfont );
    DRAW$TEXT_ATTR( TXT_HALN_CENTRE, TXT_VALN_HALF, Char_Path,
                    Char_XSca {path scale}, Char_Spacing {spacing}, Char_Depth {depth} );

    { Line to test the GET_STRING_BOX function }
    status := DRAW$GET_STRING_BOX( cfont, str, Char_High, bsx, bsy );

    WRITELN( ' New string "', str, '" with h = ', Char_High, ' and a box size of (', bsx:6:2, ',', bsy:6:2, ').' );

    DRAW$STRING( 0.0, 0.0, 0.0, Char_High, str );
    DRAW$SEG_END
  end
end CREATE_NEW_STRING;



procedure CREATE_NEW_TEXT;
var
  txt:                          string;
  iseg, status:                   Dint;
  x1, y1, x2, y2, bx, by:       Dfloat;

begin
  status := DRAW$GET_STRING( 'Text to Create', 'This is a Text', txt );
  if status > 0 then status := DRAW$GET_WINDOW( x1, y1, x2, y2 );

  if (status >= 0) and (x2-x1 > 1.0) and (y2-y1 > 1.0) then
  begin
    iseg := CREATE_SEGMENT( (x1 + x2)/2.0, (y1 + y2)/2.0 );
    DRAW$TEXT_FONT( cfont );
    bx := x2 - x1; by := y2 - y1;
    DRAW$TEXT_ATTR( TXT_HALN_CENTRE, TXT_VALN_HALF, TXT_PATH_RIGHT,
                    Char_XSca {path scale}, 0.0 {spacing}, Char_Depth {depth} );
    DRAW$TEXT_IN_BOX( 0.0, 0.0, bx, by, txt, Txt_Align,, Char_High, Line_Spacing );
    DRAW$SEG_END;
    WRITELN( ' Create a Text Box centered at (', x1:5:2, ', ', y1:5:2, ') with the sizes ', bx:5:2, '*', by:5:2, ', seg = ', iseg:0 );
    WRITELN( ' The text is "', txt, '".' );
  end
end CREATE_NEW_TEXT;



procedure ORIENT_SEGMENTS;
var
  ir, isg, status: Dint;
  mat:         Dmatrix;

begin
  repeat
    status := DRAW$SEG_PICK( isg, ir );
WRITELN( isg, ir );
  exit if isg <= 0 or status < 0;
    with seg_tb[ir] do
    begin
      ir := DRAW$GET_SEG_MAT( isg, mat );
      WRITELN( ' Before Orientation of segment # ', isg:0, ' :' );
      WRITELN( ' Matrix is ', mat[1,1]:6:3, mat[1,2]:6:3, mat[1,3]:6:3, '  ', mat[1,4]:6:3 );
      WRITELN( '           ', mat[2,1]:6:3, mat[2,2]:6:3, mat[2,3]:6:3, '  ', mat[2,4]:6:3 );
      WRITELN( '           ', mat[3,1]:6:3, mat[3,2]:6:3, mat[3,3]:6:3, '  ', mat[3,4]:6:3 );
      seg_px := mat[1,4]; seg_py := mat[2,4];
      ir := DRAW$SEG_ORIENTATION( isg, seg_px, seg_py, 0.0, true {, false } );
      ir := DRAW$GET_SEG_MAT( isg, mat );
      WRITELN( ' After Orientation of segment # ', isg:0, ' :' );
      WRITELN( ' Matrix is ', mat[1,1]:6:3, mat[1,2]:6:3, mat[1,3]:6:3, '  ', mat[1,4]:6:3 );
      WRITELN( '           ', mat[2,1]:6:3, mat[2,2]:6:3, mat[2,3]:6:3, '  ', mat[2,4]:6:3 );
      WRITELN( '           ', mat[3,1]:6:3, mat[3,2]:6:3, mat[3,3]:6:3, '  ', mat[3,4]:6:3 )
    end
  until false
end ORIENT_SEGMENTS;



procedure MOVE_SEGMENTS;
var
  ir, isg, status: Dint;
  mat:          Dmatrix;

begin
(*
  status := DRAW$SEG_PICK( isg, ir );
  if status >= 0 then
  begin
    ir := DRAW$GET_SEG_MAT( isg, m1 );
    ir := DRAW$SEG_MOVE( isg {, true } );
*)
  repeat
    isg := DRAW$SEG_MOVE( 0, true );            { Perform individual requests }
  exit if isg <= 0;
    ir := DRAW$GET_SEG_MAT( isg, mat );
    with seg_tb[ir] do
    begin
      WRITELN( ' After Move of segment # ', isg:0, ' :' );
      WRITELN( ' Matrix is ', mat[1,1]:6:3, mat[1,2]:6:3, mat[1,3]:6:3, '  ', mat[1,4]:6:3 );
      WRITELN( '           ', mat[2,1]:6:3, mat[2,2]:6:3, mat[2,3]:6:3, '  ', mat[2,4]:6:3 );
      WRITELN( '           ', mat[3,1]:6:3, mat[3,2]:6:3, mat[3,3]:6:3, '  ', mat[3,4]:6:3 );
      seg_px := mat[1,4];
      seg_py := mat[2,4]
(*    seg_px := seg_px + m2[1,4] - m1[1,4];
      seg_py := seg_py + m2[2,4] - m1[2,4] *)
    end
  until false
end MOVE_SEGMENTS;



procedure REMOVE_SEGMENT;
var
  ir, isg, status: Dint;

begin
  status := DRAW$SEG_PICK( isg, ir );
  if status >= 0 then
  begin
    WRITELN( ' Destroye the segment # ', isg:4, ir:4 );
    DRAW$DEL_SEG( seg_tb[ir].seg_iseg );
    seg_tb[ir].seg_iseg := -1
  end
end REMOVE_SEGMENT;


procedure INIT_FONT_TABLES;
var
  mentry,
  fnam:         string;
  isl, len:       Dint;
  pst:         ^string;

begin
  for ii := 1 to MAX_FNT do
    if ii <= MIN_FNB then fnt_tb[ii].fnt_ifnt := ii - 1
                     else fnt_tb[ii].fnt_ifnt := -1;

  { Initialize the Font Name table }
  for ii := 1 to MIN_FNB+MAX_FNT do
    if ii <= MIN_FNB then
    begin
      DRAW$TEXT_FONT( ii-1 );
      SET_FONT_NAME( ii-1, font_menu[ii] )
    end
    else font_menu[ii] :=  not_defined"address;

  DRAW$FONT_INFO( -1, font_path, isl );
  isl := INDEX( font_path, ';' );
  if (isl > 1) then font_path := SUBSTR( font_path, 1, isl - 1 )
               else if isl = 1 then font_path := '.';
  if font_path[font_path.length] <> '/' then font_path := font_path||'/'
;WRITELN( ' "', font_path, '"' )
end INIT_FONT_TABLES;



procedure PANNEL_SETUP;
{ *** Create the Input Setup Pannel *** }
begin
  setup := DRAW$PANNEL_CREATE( 12.0, 7.2, 'EsFont Setup' );
  DRAW$PANNEL_ATTR( setup,  true, 'HELVETICA', 3 );     { Set Label Character Font in Bold }
  DRAW$PANNEL_ATTR( setup, false, 'HELVETICA', 0 );     { Set Text/value Character Font }

  DRAW$PANNEL_ATTR( setup, Drw_Align_Left );
  DRAW$PANNEL_ATTR( setup, false, 12.0 );               { Set Text/value Character Size }
  DRAW$PANNEL_ATTR( setup,  true, 12.0 );               { Set Label Character Size }
  DRAW$PANNEL_ADD( setup,  2.6, 3.5, 1.4, 0.8, 'Red  ', def_color[1], 0.0, 1.0, 0.05 );
  DRAW$PANNEL_ADD( setup,  2.6, 2.5, 1.4, 0.8, 'Green', def_color[2], 0.0, 1.0, 0.05 );
  DRAW$PANNEL_ADD( setup,  2.6, 1.5, 1.4, 0.8, 'Blue ', def_color[3], 0.0, 1.0, 0.05 );

  DRAW$PANNEL_ATTR( setup,  true, 'HELVETICA', 3 );     { Set Label Character Font in Bold }
  DRAW$PANNEL_ADD( setup, 10.0, 6.4, 1.5, 0.6, 'Character Spacing', Char_Spacing, -5.0, 5.0, 0.1 );
  DRAW$PANNEL_ADD( setup, 10.0, 5.6, 1.5, 0.6, 'Character Height', Char_High, 0.1, 10.0, 0.1 );
  DRAW$PANNEL_ADD( setup, 10.0, 4.8, 1.5, 0.6, 'Character Depth', Char_Depth, 0.05, 10.0, 0.05 );
  DRAW$PANNEL_ADD( setup, 10.0, 4.0, 1.5, 0.6, 'Character X/Y Scaling', Char_XSca, 0.1, 10.0, 0.1 );
  DRAW$PANNEL_ADD( setup,  9.5, 3.2, 2.0, 0.6, 'Line Spacing in Text Box', Line_Spacing, 0.1, 4.0, 0.1 );
  DRAW$PANNEL_ADD( setup,  9.5, 2.4, 2.0, 0.6, 'Text Path', Char_Path, TxtPth );
  DRAW$PANNEL_ADD( setup,  9.5, 1.6, 2.0, 0.6, 'Text In Box Alignement', Txt_Align, TxtAln );
  DRAW$PANNEL_ADD( setup, 11.1, 0.9, 0.6, 0.6, 'Input Font name by file selection', fselect );

  DRAW$PANNEL_ATTR( setup, Drw_Align_Top );
  DRAW$PANNEL_ATTR( setup, true, 20.0 );
  DRAW$PANNEL_ATTR( setup, true, 'HELVETICA', 3 );     { Set Text/value Bold Character Font }
  DRAW$PANNEL_ADD_FRAME( setup, 0.5, 1.0, 4.0, 4.5, 'New Object Color', 1.5, 0 );

end PANNEL_SETUP;



procedure INIT_DRAW;
var
  iph: Dint;

begin
  { Create the configuration of Menus }
  DRAW$SET_MENU_SPC( Menu_Skip );               { Skip "File" menu Entry }
  DRAW$SET_MENU_SPC( Menu_New, 'F&ont' ) ;      { Create a New menu "Font" }
  DRAW$SET_MENU_SPC( Menu_Entry,  'BitMap', 11, ORD( 'b' ) );       { Create a New menu entry  "Bitmap font" with id = 11 }
  DRAW$SET_MENU_SPC( Menu_Entry,  'PixMap', 12, ORD( 'p' ) );       { Create a New menu entry  "Pixmap font" with id = 12 }
  DRAW$SET_MENU_SPC( Menu_Entry, 'Outline', 13, ORD( 'l' ) );       { Create a New menu entry "OutLine font" with id = 13 }
  DRAW$SET_MENU_SPC( Menu_Entry, 'Polygon', 14, ORD( 'v' ) );       { Create a New menu entry "Polygon font" with id = 14 }
  DRAW$SET_MENU_SPC( Menu_Entry, 'Extrude', 15, ORD( 'e' ) );       { Create a New menu entry "Extrude font" with id = 15 }
  DRAW$SET_MENU_SPC( Menu_Entry, 'Texture', 16,ORD('T')+Drw_SHIFT );{ Create a New menu entry "Texture font" with id = 16 }
  DRAW$SET_MENU_SPC( Menu_Entry, 'S&elect',  1, ORD( 'f' ) );       { Create a New menu entry  "Select font" with id =  1 }
  DRAW$SET_MENU_SPC( Menu_Entry,  'C&olor',  8, ORD( 'c' ) );       { Create a New menu entry        "Color" with id =  8 }
  DRAW$SET_MENU_SPC( Menu_Entry,  'S&etup',  7,ORD('S')+Drw_SHIFT );{ Create a New menu entry        "Setup" with id =  7 }
  DRAW$SET_MENU_SPC( Menu_Close );              { Close the "Font" menu }
  DRAW$SET_MENU_SPC( Menu_New, 'O&bject' );     { Create a New menu "Object" }
  DRAW$SET_MENU_SPC( Menu_Entry, 'S&tring',  2, ORD( 's' ) );       { Create a New menu entry       "String" with id =  2 }
  DRAW$SET_MENU_SPC( Menu_Entry,   'T&ext',  3, ORD( 't' ) );       { Create a New menu entry  "Text in Box" with id =  3 }
  DRAW$SET_MENU_SPC( Menu_Entry,'O&rientation',4,ORD('o' ) );       { Create a New menu entry  "Orientation" with id =  4 }
  DRAW$SET_MENU_SPC( Menu_Entry,    'M&ove', 5, ORD( 'm' ) );       { Create a New menu entry         "Move" with id =  5 }
  DRAW$SET_MENU_SPC( Menu_Entry,  'R&emove', 6, ORD( 'r' ) );       { Create a New menu entry       "Remove" with id =  6 }
  DRAW$SET_MENU_SPC( Menu_Close );              { Close the "Object" menu }
  DRAW$SET_MENU_SPC( Menu_Close );              { Close the main standard menu (barre menu) }


  { Set the Lighting and no init error modes }
  Draw_Server_Mode := DrwSrv_Do_Lighting + DrwSrv_Enable_Light0 + DrwSrv_Disable_IniErr;

  { Initialize The DRAW Copntext }
  DRAW$INIT( xp, yp, unt, 'Draw : Essai Font' );

  { Stop on not found Server }
  if Draw_Server_Flags = 0 then
  begin
    WRITELN( ' *** The DRAW_SERVER Cannot start ***' );
    PASCAL_EXIT( 2 )
  end;

  DRAW$DEFINE_COLOR( 0, 0.8, 0.8, 0.7, 1.0 );

  { Initialize the DRAW picture in 3D mode }
  bstat := DRAW$PICTURE3( 'Essai Fonts', 20.0, 15.0, 15.0, true, true );

  { Define the light # 0 properties }
  DRAW$LIGHT_DEFINE( 0,       LIGHT_POSITION, Dpoint3[ 18.0,  24.0,  32.0]  );
  DRAW$LIGHT_DEFINE( 0,  LIGHT_AMBIENT_COLOR,  Dcolor[  0.5,  0.5,  0.5,  1.0] );
  DRAW$LIGHT_DEFINE( 0,  LIGHT_DIFFUSE_COLOR,  Dcolor[  0.4,  0.4,  0.4,  1.0] );
  DRAW$LIGHT_DEFINE( 0, LIGHT_SPECULAR_COLOR,  Dcolor[  1.0,  0.7,  0.7,  1.0] );

  { Define the matiere properties }
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_SPECULAR_COLOR, Dcolor[0.80, 0.80, 0.80, 1.0] );
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_EMISSION_COLOR, Dcolor[0.00, 0.00, 0.00, 1.0] );
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_DIFFUSE_COLOR,  Dcolor[0.95, 0.95, 0.80, 1.0] );
  DRAW$MAT_LIGHT_PROP( MAT_FRONT_FACE, MAT_SHININESS,      Dvalue[25.0] );
(*
  DRAW$MAT_LIGHT_PROP( MAT_BACK_FACE,  MAT_SPECULAR_COLOR, Dcolor[1.0, 1.0, 1.0, 0.55] );
  DRAW$MAT_LIGHT_PROP( MAT_BACK_FACE,  MAT_SHININESS,      Dvalue[100.0] );
  DRAW$MAT_LIGHT_PROP( MAT_BACK_FACE,  MAT_EMISSION_COLOR, Dcolor[0.0, 0.0, 0.0, 1.0] );
  DRAW$MAT_LIGHT_PROP( MAT_BACK_FACE,  MAT_DIFFUSE_COLOR,  Dcolor[1.0, 0.9, 0.2, 1.0] );
*)

  DRAW$LIGHT_ON_OFF( 0, 1 );                    { Set On the Light # 0 }

  PANNEL_SETUP                                  { Create the Pannel setup }

end INIT_DRAW;


begin { Main ESFONT }

  INIT_DRAW;                                    { Initilize the Draw System (Library + Server) }

  { Initialize the Segment table }
  for ii := 1 to MAX_SEG do  seg_tb[ii].seg_iseg := -1;

  INIT_FONT_TABLES;                             { Initialize the Font tables }

  DRAW$TEXT_FONT( 0 );                          { To start select the font #0 }

  CREATE_SEGMENT( 0.0, 0.0 );
  DRAW$COLOR( 1.0, 0.9, 0.2, 1.0 );
  DRAW$SPHERE( 0.0, 0.0, -4.0, 2.0, 32, 32, 4 );
  DRAW$SEG_END;

  { Main Loop top wait events }
  repeat
    irp := DRAW$DIALOG( 1 );
    DRAW$PANNEL_GET( setup );
    if irp > 0 then
    case irp of
      11..16:
          INSTALL_NEW_FONT( irp - 10 ); { Install new font }

      1:  SELECT_A_FONT;        { Change of Font }

      2:  CREATE_NEW_STRING;    { Create a String Segment }

      3:  CREATE_NEW_TEXT;      { Create Text (in box) }

      4:  ORIENT_SEGMENTS;      { Change of Segment Orientation }

      5:  MOVE_SEGMENTS;        { Move Segment(s) until clic out of any segment }

      6:  REMOVE_SEGMENT;       { Remove Object }

      7:  DRAW$PANNEL_OPEN( setup );    { Open the setup Pannel to Change Parameters }

      8:  CHANGE_COLOR;         { Select the nexty used color by get color }

    otherwise
    end;
  until irp <= 0;

  DRAW$END;
  WRITELN( ' End of EsFont.' )
end ESFONT.

