DRWH	=	Draw_Root

include $(PAS_DIR)/system.make

# Standard defines:
PAS	=	$(PAS_BIN)/pcmp

Bin	=	$(PRD_DIR)/Draw_Examples

INCDIR	=	-I$(PAS_INC) -I$(INC_DIR)

LIBDIR	=	-L$(PAS_LIB) -L$(LIB_DIR)

LIBS	= -ldraw -lcpas -lm

Src	=	$(PRD_DIR)/Draw_Examples

#C_FLAGS	=	-O2               ---- Defined in system.make
#C_FLAGS	=	-g

P_FLAGS	=
F_FLAGS	=	-O2

SRCP	=\
	$(Src)/esli.pas\
	$(Src)/esgr.pas\
	$(Src)/esgr2.pas\
	$(Src)/essurf.pas\
	$(Src)/essol.pas\
	$(Src)/esvol.pas\
	$(Src)/esinc.pas\
	$(Src)/calibration.pas

SRCF	=\
	$(Src)/gksstrupl.for\
	$(Src)/substrupl.for

SRCC	=\
	$(Src)/esli.c\
	$(Src)/esgr.c\
	$(Src)/esgr2.c\
	$(Src)/essurf.c\
	$(Src)/essol.c\
	$(Src)/esvol.c\
	$(Src)/esinc.c\
	$(Src)/calibration.c


# User defines:

#@# Targets follow ---------------------------------


all:	$(Bin)/esli\
	$(Bin)/esgr\
	$(Bin)/esgr2\
	$(Bin)/essurf\
	$(Bin)/essol\
	$(Bin)/esvol\
	$(Bin)/esinc\
	$(Bin)/calibration
#	$(Bin)/struplo

cleanobjs:
	rm -f esli.c esgr.c esgr2.c essurf.c essol.c esvol.c

cleanbin:
	rm -f esli esgr esgr2 essurf essol esvol
# struplo

clean:	cleanobjs cleanbin

cleanall:	cleanobjs cleanbin



#@# Dependency rules follow -----------------------------

$(Bin)/esli: $(Src)/esli.pas
	$(PAS) $(P_FLAGS) $(Src)/esli.pas
	$(CC) -o $(Bin)/esli $(C_FLAGS) $(INCDIR) esli.c $(LIBDIR) $(LIBS)

$(Bin)/esgr: $(Src)/esgr.pas
	$(PAS) $(P_FLAGS) $(Src)/esgr.pas
	$(CC) -o $(Bin)/esgr $(C_FLAGS) $(INCDIR) esgr.c $(LIBDIR) $(LIBS)

$(Bin)/esgr2: $(Src)/esgr2.pas
	$(PAS) $(P_FLAGS) $(Src)/esgr2.pas
	$(CC) -o $(Bin)/esgr2 $(C_FLAGS) $(INCDIR) esgr2.c $(LIBDIR) $(LIBS)

$(Bin)/essurf: $(Src)/essurf.pas
	$(PAS) $(P_FLAGS) $(Src)/essurf.pas
	$(CC) -o $(Bin)/essurf $(C_FLAGS) $(INCDIR) essurf.c $(LIBDIR) $(LIBS)

$(Bin)/essol: $(Src)/essol.pas
	$(PAS) $(P_FLAGS) $(Src)/essol.pas
	$(CC) -o $(Bin)/essol $(C_FLAGS) $(INCDIR) essol.c $(LIBDIR) $(LIBS)

$(Bin)/esvol: $(Src)/esvol.pas
	$(PAS) $(P_FLAGS) $(Src)/esvol.pas
	$(CC) -o $(Bin)/esvol $(C_FLAGS) $(INCDIR) esvol.c $(LIBDIR) $(LIBS)

$(Bin)/esinc: $(Src)/esinc.pas
	$(PAS) $(P_FLAGS) $(Src)/esinc.pas
	$(CC) -o $(Bin)/esinc $(C_FLAGS) $(INCDIR) esinc.c $(LIBDIR) $(LIBS)

$(Bin)/calibration: $(Src)/calibration.pas
	$(PAS) $(P_FLAGS) $(Src)/calibration.pas
	$(CC) -o $(Bin)/calibration $(C_FLAGS) $(INCDIR) calibration.c $(LIBDIR) $(LIBS)

#$(Bin)/struplo: $(Src)/gksstrupl.o $(Src)/substrupl.o
#	$(FOR) -o $(Bin)/struplo $(F_FLAGS) $(Src)/gksstrupl.o\
#	$(Src)/substrupl.o $(LIBDIR) $(LIBS)
#
#$(Src)/gksstrupl.o: $(Src)/gksstrupl.for
#	$(FOR) $(F_FLAGS) $(INCDIR) -c -o $@ $<
#
#$(Src)/substrupl.o: $(Src)/substrupl.for
#	$(FOR) $(F_FLAGS) $(INCDIR) -c -o $@ $<
#
