//
// Prototype for single process Client using socket (to work with Srv.cxx).
//

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>


extern "C" {

int Cli_Sock_Open( int port, char* host = NULL );
void Cli_Sock_Close( void );
int Cli_Sock_Read( char* buf, int buflen );
int Cli_Sock_Write( char* buf, int buflen );

}


int main( int argc, char** argv )
{
  int port, ie, ii, sz;
  char buf[255];
  char ch;

  if (argc < 2) {
    printf( " CLI Error: Use the command \"cli <port_number>\"\n" );
    return 2;
  } else port = atoi( argv[1] );

  ie = Cli_Sock_Open( port );
  if (ie == 0) printf( " Client OK on %d.\n", ie );
          else printf( " Client on error %d\n", ie );

  do {
    printf( " type the message:\n " );
    for (ii = 0; ii<255;ii++) buf[ii] = 0;
    gets( buf );
    sz = strlen( buf );
    if (sz&&(buf[sz-1]<' ')) buf[--sz] = 0;
    if (!sz) break;
    printf( " CLT send (%d) \"%s\" to SRV.\n", sz, buf );
    sz = Cli_Sock_Write( buf, sz+1 );
    printf( " %d bytes sent.\n", sz );
    if (sz<=0) {
      printf( " CLI Write Error %d\n", errno );
      return 2;
    }
    sz = Cli_Sock_Read( buf, 255 );
    if (sz > 0) printf( " CLI receive \"%s\" from SRV.\n", buf );
           else  if (sz < 0) printf( " CLI Read ERROR %d\n", errno );
  } while (sz > 0);
  Cli_Sock_Close();
  if (sz == 0) printf( " CLI : Normal Exit\n" );
         else  printf( " CLI read Error.\n" );

  return 0;
}
