// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *    D R A W   -   C L I E N T   C O N N E C T I O N   M A N A G E R       *
// *                                                                          *
// *          (Kernel to Open/close the bidirectional IO Channel)             *
// *                                                                          *
// *                                 by                                       *
// *                                                                          *
// *           Pierre Wolfers, Laboratoire de Cristallographie                *
// *                                                                          *
// *           CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166                *
// *                                                                          *
// *                      F 38042 GRENOBLE CEDEX 9                            *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////




#if !defined( _WIN32 ) || defined( __CYGWIN__ )
/*
 *       For any Unix like Operating Systems.
 *
*/

# include <stdio.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <string.h>
# include <netdb.h>
# include <unistd.h>

static int                    sock;
static struct sockaddr_in srv_addr;

int Cli_Sock_Open( int port, char* host )
{
  char dfhost[] = "127.0.0.1";
  struct hostent *server;

  if ((sock = socket( AF_INET, SOCK_STREAM, 0 )) < 0) return -2;
  if (!host) host = dfhost;
  if (!(server = gethostbyname( host ))) return -6;
  bzero( (char*) &srv_addr, sizeof( srv_addr ) );
  srv_addr.sin_family = AF_INET;
  bcopy( (char*)server->h_addr, (char*)&srv_addr.sin_addr.s_addr, server->h_length );
  srv_addr.sin_port   = htons( port );
  if (connect( sock, (struct sockaddr *)&srv_addr, sizeof( srv_addr ) ) != 0) return -7;
  return 0;
}



void Cli_Sock_Close( void )
{
  close( sock );
}



int Cli_Sock_Read( char* buf, int buflen )
{
  return read( sock, buf, buflen );
}


int Cli_Sock_Write( char* buf, int buflen )
{
  return write( sock, buf, buflen );
}






#else
/*
 *       For Windows Operating Systems.
 *
*/

# include <stdio.h>
# include <winsock2.h>
# include <string.h>

static WSADATA                wsaData;
static SOCKET                    sock;
static struct sockaddr_in server_addr,
                          client_addr;

# define Do_Exit( ierr ) { WSACleanup(); return ierr; }


int Clt_Sock_Open( int port, char* host = NULL )
{
  int    addr_len = sizeof( server_addr );
  HOSTENT *server;

  WSAStartup( 0x0101, &wsaData );

  if ((sock = socket( AF_INET, SOCK_STREAM, 0 )) < 0) Do_Exit( -2 );
  memset( &server_addr, 0, sizeof( server_addr ) );
  server_addr.sin_family = AF_INET;
  server_addr.sin_port   = htons( port );
  if (host) {
    if (!(server = gethostbyname( host ))) return -6;
    /* server_addr.sin_addr.s_addr = inet_addr( server->h_addr_list[0] }; */
    server_addr.sin_addr.S_un.S_un_b.s_b1 = (unsigned char)server->h_addr_list[0][0];
    server_addr.sin_addr.S_un.S_un_b.s_b2 = (unsigned char)server->h_addr_list[0][1];
    server_addr.sin_addr.S_un.S_un_b.s_b3 = (unsigned char)server->h_addr_list[0][2];
    server_addr.sin_addr.S_un.S_un_b.s_b4 = (unsigned char)server->h_addr_list[0][3];
  }
  else
    server_addr.sin_addr.s_addr = htonl( 0x7F000001 );
  if (connect( sock, (sockaddr*)&server_addr, addr_len) != 0) Do_Exit( -3 );
  return 0;
}



void Sock_Close( void )
{
  closesocket( sock );
  WSACleanup();
}



int Sock_Read( char* buf, int buflen )
{
  return recv( sock, buf, buflen, 0 );
}


int Sock_Write( char* buf, int buflen )
{
  return send( sock, buf, buflen, 0 );
}



#endif


/*************************     E N D    ******************************/
