program TEST_PANNEL;

  %include 'DRAWENV:draw_defs';

type
  color = ( white,
            black,
              red,
            green,
            blue
          );

  txt_buf( sz: integer ) = array[1..sz] of char;

var
  un:                unit_type;
  ip, pa1, pa2:           Dint;

  aa, al, bb, be, cc,
        ga, px, py, uu: Dfloat;

  brh:                   Dbool;

  tch: Choice_List( 5, 5 ) := [ 'white',
                                'black',
                                  'red',
                                'green',
                                 'blue' ];

  col:               Dint := 1;
  ivl, ist, irv, icl:     Dint;
  str:   string := 'et voila!';

  buf:                ^txt_buf;
  txtsz, ii:              Dint;
  inp:                    text;
  ch:                     char;
  bp:                    Dbool;

  file_to_read, sbuf:   string;

  stvar:          string( 64 );

begin
  DRAW$SET_MENU_SPC( Menu_Skip );               { Skip the standard menu "File" }
  DRAW$SET_MENU_SPC( Menu_Open );               { Open the View Menu }
  DRAW$SET_MENU_SPC( Menu_Skip + 4*Menu_fact ); { Skip behind the UnZomm entry }
  DRAW$SET_MENU_SPC( Menu_Entry, 'Cell Setup', 1, Drw_CTRL+ORD('p') );
  DRAW$SET_MENU_SPC( Menu_Close );
  DRAW$SET_MENU_SPC( Menu_Close );
  DRAW$INIT( px, py, un, 'Test Pannel' );
  DRAW$PICTURE( '*Test_Pannel*', 15.0, 15.0, true, true );

  DRAW$OUT_MODE( 1 );
  DRAW$PLOT(  3.0,  3.0, false );
  DRAW$PLOT(  7.5, 12.0,  true );
  DRAW$PLOT( 12.0,  3.0,  true );
  DRAW$PLOT(  3.0,  3.0,  true );
  DRAW$PLOT(  0.0,  0.0, false );

  aa := 4.0; bb := 2*aa; cc := 4*aa;
  brh := false;

  pa1 := DRAW$PANNEL_CREATE( 24.0, 10.0, 'Cell Pannel' );

  WRITELN( ' The Pannel # ', pa1:0, ' is created.' );

  DRAW$PANNEL_ATTR( pa1, 0 );
  DRAW$PANNEL_ATTR( pa1, true, 20.0 );
  DRAW$PANNEL_ATTR( pa1, true, 'HELVETICA', 3 );
  DRAW$PANNEL_ADD_FRAME( pa1, 4.0, 8.8, 16.0, 1.0, 'Ceci est un titre', 3.0 );

  DRAW$PANNEL_ATTR( pa1, 33 { Drw_Align_Inside_Top } );
  DRAW$PANNEL_ADD_FRAME( pa1, 2.0, 5.90, 20.0, 2.2, 'Unit Cell', 2.0, 2 );

  DRAW$PANNEL_ATTR( pa1, Drw_Align_Left );
  DRAW$PANNEL_ATTR( pa1, true, 12.0 );
  DRAW$PANNEL_ATTR( pa1, true, 'TIMES', 2 );
  DRAW$PANNEL_ADD( pa1,  6.0, 6.3, 2.5, 0.5, 'Param�tre A :', aa, 1.0, 100.0, 0.0001 );
  irv := DRAW$PANNEL_ADD( pa1, 12.0, 6.3, 2.5, 0.5, 'B :', bb, 1.0, 100.0, 0.0001 );
  DRAW$PANNEL_ADD( pa1, 18.0, 6.3, 2.5, 0.5, 'C :', cc, 1.0, 100.0, 0.0001 );
  DRAW$PANNEL_ATTR( pa1, true, 'TIMES', 1 );
  DRAW$PANNEL_ADD( pa1,  4.0, 5.2, 2.5, 0.5, 'Rhomb Flag', brh );
  icl := DRAW$PANNEL_ADD( pa1, 10.0, 5.2, 2.5, 0.5, 'Color', col, tch );
  DRAW$PANNEL_ADD( pa1, 15.0, 5.2, 2.5, 0.5, 'Integer = ', ivl, -20, 20 );
  DRAW$PANNEL_ADD( pa1,  4.0, 4.5, 16.0, 0.5, 'String = ', str );

  if argc > 1 then file_to_read := argv[1]^
              else file_to_read := '.bashrc';

  if FILE_ACCESS_CHECK( file_to_read,, [read_file] ) then
  begin
    RESET( inp, file_to_read );
    txtsz := 0;
    while not EOF( inp ) do begin  GET( inp ); txtsz := txtsz + 1  end;
    CLOSE( inp );
    NEW( buf, txtsz );
    ii := 1;
    RESET( inp, file_to_read );
    while not EOF( inp ) do begin  buf^[ii] := inp^; GET( inp ); ii := ii + 1   end;
    CLOSE( inp )
  end
  else
  begin
    WRITEV( sbuf, ' TEST_PANNEL Cannot read the file "', file_to_read, '".' );
    NEW( buf, sbuf.length );
    for i := 1 to sbuf.length do buf^[i] := sbuf[i]
  end;

  DRAW$PANNEL_ADD_TEXT( pa1,  2.0, 1.2, 20.0, 3.0, 'Text', buf^ );

  stvar := ' Voilà, c''est le début.';

  ist := DRAW$PANNEL_ADD( pa1, 4.0, 0.5, 16.0, 0.5, 'String = ', stvar, false );

  ip := DRAW$PANNEL_REQUEST( pa1 );

  WRITELN( ' Pannel request status = ', ip:0, ' : ', Draw_Pannel_Ident:0 );
  DRAW$PANNEL_GET( pa1 );
  WRITELN( ' Pan 1 Changed (by request) with A = ', aa:12:4, ', B= ', bb:12:4, ', C = ', cc:12:4 );
  WRITELN( ' ':31, 'Bool = ', brh, ', Color = ', color( col - 1 ):8, ', Int = ', ivl:5 );
  WRITELN( ' ':31, 'Str ="', str, '"' );

  bb := 12.256;
  DRAW$PANNEL_CHANGE( pa1, irv );
  stvar := 'et maintenant, c''est la suite.';
  DRAW$PANNEL_CHANGE( pa1, ist );
  col := 3;
  DRAW$PANNEL_CHANGE( pa1, icl );

  DRAW$PANNEL_OPEN( pa1 );
  bp := true;

  repeat
    ip := DRAW$DIALOG( 1 );
    if ip = 1 then if bp then begin  DRAW$PANNEL_CLOSE( pa1 ); bp := false  end
                         else begin  DRAW$PANNEL_OPEN( pa1 ); bp := true  end;
    WRITELN( ' Dialog return = ', ip:0 );
    WRITELN( ' Pannel flag = ', Draw_Pannel_Ident:0 );
    if Draw_Pannel_Ident <> 0 then
    begin
      DRAW$PANNEL_GET( pa1 );
      WRITELN( ' Pan 1 request return with :  A = ', aa:12:4, ', B= ', bb:12:4, ', C = ', cc:12:4 );
      WRITELN( ' ':31, 'Bool = ', brh, ', Color = ', color( col - 1 ):8, ', Int = ', ivl:5 );
      WRITELN( ' ':31, 'Str ="', str, '"' )
    end;
    uu := aa; aa := bb; bb := cc; cc := uu;
    DRAW$PANNEL_PUT( pa1 )
  until ip <= 0;
  WRITELN( ' DRAW_END with ', ip:0 );
  DRAW$END
end TEST_PANNEL.
