#ifdef PNG_GEN_USE



/* local prototype */

static png_structp             png_ptr;
static png_infop              info_ptr;
static int   color_type, interlace_type, sample_depth;
static jmp_buf                  jmpbuf;
static char             **row_pointers;


static void writepng_error_handler( png_structp png_ptr, png_const_charp msg );



void writepng_version_info( void )
{
  fprintf( stderr, "   Compiled with libpng %s; using libpng %s.\n",
                   PNG_LIBPNG_VER_STRING, png_libpng_ver );
  fprintf( stderr, "   Compiled with zlib %s; using zlib %s.\n",
                   ZLIB_VERSION, zlib_version );
}




/* returns 0 for success, 2 for libpng problem, 4 for out of memory, 11 for
 *  unexpected pnmtype; note that outfile might be stdout */

int writepng_init( int width, int height )
{
  /* could also replace libpng warning-handler (final NULL), but no need: */

  png_ptr = png_create_write_struct( PNG_LIBPNG_VER_STRING,
                                     NULL,
                                     writepng_error_handler,
                                     NULL );
  if (!png_ptr) return 1;                       /* out of memory */

  info_ptr = png_create_info_struct( png_ptr );
  if (!info_ptr) {
    png_destroy_write_struct( &png_ptr, NULL );
    return 1;                                   /* out of memory */
  }


  /* setjmp() must be called in every function that calls a PNG-writing
   * libpng function, unless an alternate error handler was installed--
   * but compatible error handlers must either use longjmp() themselves
   * (as in this program) or exit immediately, so here we go: */

  if (setjmp( jmpbuf )) {
    png_destroy_write_struct( &png_ptr, &info_ptr );
    return 2;
  }


  /* Make sure outfile is (re)opened in BINARY mode */

  png_init_io( png_ptr, fimg );


  /* set the compression levels--in general, always want to leave filtering
   * turned on (except for palette images) and allow all of the filters,
   * which is the default; want 32K zlib window, unless entire image buffer
   * is 16K or smaller (unknown here)--also the default; usually want max
   * compression (NOT the default); and remaining compression flags should
   * be left alone */

  png_set_compression_level( png_ptr, Z_BEST_COMPRESSION );
/*
    >> this is default for no filtering; Z_FILTERED is default otherwise:
    png_set_compression_strategy(png_ptr, Z_DEFAULT_STRATEGY);
    >> these are all defaults:
    png_set_compression_mem_level(png_ptr, 8);
    png_set_compression_window_bits(png_ptr, 15);
    png_set_compression_method(png_ptr, 8);
 */


  /* set the image parameters appropriately */

  color_type = PNG_COLOR_TYPE_RGB;

//interlace_type = PNG_INTERLACE_ADAM7;
  interlace_type = PNG_INTERLACE_NONE;
  sample_depth   =                  8;

  png_set_IHDR( png_ptr, info_ptr, width, height,
                sample_depth, color_type, interlace_type,
                PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT );
/*
    if (mainprog_ptr->have_text) {
        png_text  text[6];
        int  num_text = 0;

        if (mainprog_ptr->have_text & TEXT_TITLE) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "Title";
            text[num_text].text = mainprog_ptr->title;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_AUTHOR) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "Author";
            text[num_text].text = mainprog_ptr->author;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_DESC) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "Description";
            text[num_text].text = mainprog_ptr->desc;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_COPY) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "Copyright";
            text[num_text].text = mainprog_ptr->copyright;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_EMAIL) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "E-mail";
            text[num_text].text = mainprog_ptr->email;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_URL) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "URL";
            text[num_text].text = mainprog_ptr->url;
            ++num_text;
        }
        png_set_text(png_ptr, info_ptr, text, num_text);
    }
*/

  /* write all chunks up to (but not including) first IDAT */

  png_write_info( png_ptr, info_ptr );


  /* if we wanted to write any more text info *after* the image data, we
   * would set up text struct(s) here and call png_set_text() again, with
   * just the new data; png_set_tIME() could also go here, but it would
   * have no effect since we already called it above (only one tIME chunk
   * allowed) */


  /* set up the transformations:  for now, just pack low-bit-depth pixels
   * into bytes (one, two or four pixels per byte) */

  png_set_packing( png_ptr );
  /*  png_set_shift(png_ptr, &sig_bit);  to scale low-bit-depth values */

  /* OK, that's all we need to do for now; return happy */
  return 0;
}



/* returns 0 for success, 2 for libpng (longjmp) problem */

int writepng_encode_image( void )
{
  /* as always, setjmp() must be called in every function that calls a
   * PNG-writing libpng function */
  png_byte **Map_Vect;
  png_byte       *row;
  int               i;

  if (setjmp( jmpbuf )) {
    png_destroy_write_struct( &png_ptr, &info_ptr );
    png_ptr  = NULL;
    info_ptr = NULL;
    return 2;
  }

  if (Map_Vect = (png_byte **)malloc( Img_Height*sizeof( png_byte* ) )) {
    row = (png_byte*)Img_Map;
    for (i = Img_Height - 1; i >= 0; i--) { Map_Vect[i] = row; row += Img_Width*3; }
// for (i = 0; i < Img_Height; i++) { Map_Vect[i] = row; row += Img_Width*3; }

    /* and now we just write the whole image; libpng takes care of interlacing
     * for us */

    png_write_image( png_ptr, (png_byte**) Map_Vect );


    /* since that's it, we also close out the end of the PNG file now--if we
     * had any text or time info to write after the IDATs, second argument
     * would be info_ptr, but we optimize slightly by sending NULL pointer: */

    png_write_end( png_ptr, NULL );
    free( (void*)Map_Vect );
  } else return -10;

  return 0;
}




/* returns 0 if succeeds, 2 if libpng problem */

int writepng_encode_row( GLubyte* row )  /* NON-interlaced only! */
{
  /* as always, setjmp() must be called in every function that calls a
   * PNG-writing libpng function */

  if (setjmp( jmpbuf )) {
    png_destroy_write_struct( &png_ptr, &info_ptr );
    png_ptr = NULL;
    info_ptr = NULL;
    return 2;
  }


  /* image_data points at our one row of image data */

  png_write_row( png_ptr, (png_byte*) row );
  return 0;
}



void writepng_cleanup( void )
{
  if (png_ptr && info_ptr)
    png_destroy_write_struct( &png_ptr, &info_ptr );
}



/* returns 0 if succeeds, 2 if libpng problem */

int writepng_encode_finish( void )   /* NON-interlaced! */
{
  /* as always, setjmp() must be called in every function that calls a
   * PNG-writing libpng function */

  if (setjmp( jmpbuf )) {
    png_destroy_write_struct( &png_ptr, &info_ptr );
    png_ptr = NULL;
    info_ptr = NULL;
    return 2;
  }


  /* close out PNG file; if we had any text or time info to write after
   * the IDATs, second argument would be info_ptr: */

  png_write_end( png_ptr, NULL );
  return 0;
}




static void writepng_error_handler( png_structp png_ptr, png_const_charp msg )
{
    /* This function, aside from the extra step of retrieving the "error
     * pointer" (below) and the fact that it exists within the application
     * rather than within libpng, is essentially identical to libpng's
     * default error handler.  The second point is critical:  since both
     * setjmp() and longjmp() are called from the same code, they are
     * guaranteed to have compatible notions of how big a jmp_buf is,
     * regardless of whether _BSD_SOURCE or anything else has (or has not)
     * been defined. */

    fprintf( fmsg, "Write PNG Error: writepng libpng error: %s\n", msg );
    fflush( fmsg );

    longjmp( jmpbuf, 1 );
}





#endif




