/*  P A S - P. WOLFERS SOFTWARE: V2.0-4 OF 15-OCT-2006 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 1928 ) = {
 13,  13, 115, 101, 116,  95, 102, 111, 110, 116,  95, 110,  97, 109, 101,  61,
 61,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83,
111, 102, 116,  47,  68, 114,  97, 119,  95,  70,  76,  84,  75,  95, 115, 114,
 99,  95,  86,  49,  46,  52,  67,  45,  98,  97, 115, 101,  47, 115, 101, 114,
118, 101, 114,  47, 101, 115, 102, 111, 110, 116,  46, 112,  97, 115,   3,   3,
 32,  58,  32,   8,   8, 110, 101, 119,  95, 102, 111, 110, 116,  29,  29,  32,
 87, 101,  32,  67,  97, 110, 110, 111, 116,  32,  73, 110, 115, 116,  97, 108,
108,  32, 116, 104, 101,  32, 102, 111, 110, 116,  32,  34,   2,   2,  34,  46,
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,  16,  16, 105, 110, 115, 116,  97, 108, 108,  95, 110, 101, 119,  95, 102,
111, 110, 116,  19,  19,  84, 114, 117, 101,  45,  84, 121, 112, 101,  32,  70,
111, 110, 116,  32,  70, 105, 108, 101,  20,  20,  84, 114, 117, 101,  45,  84,
121, 112, 101,  32,  70, 111, 110, 116,  32,  70, 110,  97, 109, 101,   0,   0,
 31,  31,  32,  84, 104, 101,  32,  73, 110, 115, 116,  97, 108, 108,  97, 116,
105, 111, 110,  32, 111, 102,  32, 116, 104, 101,  32,  70, 111, 110, 116,  32,
 34,  14,  14,  34,  32, 105, 110,  32, 116, 104, 101,  32, 109, 111, 100, 101,
 32,  27,  27,  32, 105, 115,  32,  97,  32, 115, 117,  99,  99, 101, 115, 115,
 32, 119, 105, 116, 104,  32, 105, 110, 100, 101, 120,  32,  61,  32,  14,  14,
 32,  97, 110, 100,  32, 102, 111, 110, 116,  32,  35,  32,  61,  32,  12,  12,
 32, 119,  97, 115,  32, 102,  97, 105, 108, 101, 100,  46,  13,  13, 115, 101,
108, 101,  99, 116,  95,  97,  95, 102, 111, 110, 116,  14,  14,  67, 104, 111,
105,  99, 101,  32, 111, 102,  32,  70, 111, 110, 116,  18,  18,  32,  83, 101,
108, 101,  99, 116,  32, 116, 104, 101,  32, 102, 111, 110, 116,  32,  34,   9,
  9,  34,  32, 119, 105, 116, 104,  32,  35,  32,  12,  12,  99, 104,  97, 110,
103, 101,  95,  99, 111, 108, 111, 114,  12,  12,  67, 111, 108, 111, 114,  32,
116, 111,  32, 117, 115, 101,  14,  14,  99, 114, 101,  97, 116, 101,  95, 115,
101, 103, 109, 101, 110, 116,  17,  17,  99, 114, 101,  97, 116, 101,  95, 110,
101, 119,  95, 115, 116, 114, 105, 110, 103,  16,  16,  83, 116, 114, 105, 110,
103,  32, 116, 111,  32,  67, 114, 101,  97, 116, 101,  16,  16,  84, 104, 105,
115,  32, 105, 115,  32,  97,  32,  83, 116, 114, 105, 110, 103,  13,  13,  32,
 78, 101, 119,  32, 115, 116, 114, 105, 110, 103,  32,  34,  11,  11,  34,  32,
119, 105, 116, 104,  32, 104,  32,  61,  32,  20,  20,  32,  97, 110, 100,  32,
 97,  32,  98, 111, 120,  32, 115, 105, 122, 101,  32, 111, 102,  32,  40,   2,
  2,  41,  46,  15,  15,  99, 114, 101,  97, 116, 101,  95, 110, 101, 119,  95,
116, 101, 120, 116,  14,  14,  84, 101, 120, 116,  32, 116, 111,  32,  67, 114,
101,  97, 116, 101,  14,  14,  84, 104, 105, 115,  32, 105, 115,  32,  97,  32,
 84, 101, 120, 116,  32,  32,  32,  67, 114, 101,  97, 116, 101,  32,  97,  32,
 84, 101, 120, 116,  32,  66, 111, 120,  32,  99, 101, 110, 116, 101, 114, 101,
100,  32,  97, 116,  32,  40,   2,   2,  44,  32,  17,  17,  41,  32, 119, 105,
116, 104,  32, 116, 104, 101,  32, 115, 105, 122, 101, 115,  32,   8,   8,  44,
 32, 115, 101, 103,  32,  61,  32,  14,  14,  32,  84, 104, 101,  32, 116, 101,
120, 116,  32, 105, 115,  32,  34,   2,   2,  34,  46,  15,  15, 111, 114, 105,
101, 110, 116,  95, 115, 101, 103, 109, 101, 110, 116, 115,  33,  33,  32,  66,
101, 102, 111, 114, 101,  32,  79, 114, 105, 101, 110, 116,  97, 116, 105, 111,
110,  32, 111, 102,  32, 115, 101, 103, 109, 101, 110, 116,  32,  35,  32,   2,
  2,  32,  58,  11,  11,  32,  77,  97, 116, 114, 105, 120,  32, 105, 115,  32,
  2,   2,  32,  32,  11,  11,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,   2,   2,  32,  32,  11,  11,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,   2,   2,  32,  32,  32,  32,  32,  65, 102, 116, 101, 114,  32,  79,
114, 105, 101, 110, 116,  97, 116, 105, 111, 110,  32, 111, 102,  32, 115, 101,
103, 109, 101, 110, 116,  32,  35,  32,   2,   2,  32,  58,  11,  11,  32,  77,
 97, 116, 114, 105, 120,  32, 105, 115,  32,   2,   2,  32,  32,  11,  11,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   2,   2,  32,  32,  11,  11,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   2,   2,  32,  32,  13,
 13, 109, 111, 118, 101,  95, 115, 101, 103, 109, 101, 110, 116, 115,  25,  25,
 32,  65, 102, 116, 101, 114,  32,  77, 111, 118, 101,  32, 111, 102,  32, 115,
101, 103, 109, 101, 110, 116,  32,  35,  32,   2,   2,  32,  58,  11,  11,  32,
 77,  97, 116, 114, 105, 120,  32, 105, 115,  32,   2,   2,  32,  32,  11,  11,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   2,   2,  32,  32,  11,
 11,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   2,   2,  32,  32,
 14,  14, 114, 101, 109, 111, 118, 101,  95, 115, 101, 103, 109, 101, 110, 116,
 24,  24,  32,  68, 101, 115, 116, 114, 111, 121, 101,  32, 116, 104, 101,  32,
115, 101, 103, 109, 101, 110, 116,  32,  35,  32,  16,  16, 105, 110, 105, 116,
 95, 102, 111, 110, 116,  95, 116,  97,  98, 108, 101, 115,  15,  15,  45,  45,
 32,  85, 110, 100, 101, 102, 105, 110, 101, 100,  32,  45,  45,   2,   2,  32,
 34,  12,  12, 112,  97, 110, 110, 101, 108,  95, 115, 101, 116, 117, 112,  12,
 12,  69, 115,  70, 111, 110, 116,  32,  83, 101, 116, 117, 112,   9,   9,  72,
 69,  76,  86,  69,  84,  73,  67,  65,   9,   9,  72,  69,  76,  86,  69,  84,
 73,  67,  65,   5,   5,  82, 101, 100,  32,  32,   5,   5,  71, 114, 101, 101,
110,   5,   5,  66, 108, 117, 101,  32,   9,   9,  72,  69,  76,  86,  69,  84,
 73,  67,  65,  17,  17,  67, 104,  97, 114,  97,  99, 116, 101, 114,  32,  83,
112,  97,  99, 105, 110, 103,  16,  16,  67, 104,  97, 114,  97,  99, 116, 101,
114,  32,  72, 101, 105, 103, 104, 116,  15,  15,  67, 104,  97, 114,  97,  99,
116, 101, 114,  32,  68, 101, 112, 116, 104,  21,  21,  67, 104,  97, 114,  97,
 99, 116, 101, 114,  32,  88,  47,  89,  32,  83,  99,  97, 108, 105, 110, 103,
 24,  24,  76, 105, 110, 101,  32,  83, 112,  97,  99, 105, 110, 103,  32, 105,
110,  32,  84, 101, 120, 116,  32,  66, 111, 120,   9,   9,  84, 101, 120, 116,
 32,  80,  97, 116, 104,  22,  22,  84, 101, 120, 116,  32,  73, 110,  32,  66,
111, 120,  32,  65, 108, 105, 103, 110, 101, 109, 101, 110, 116,  33,  33,  73,
110, 112, 117, 116,  32,  70, 111, 110, 116,  32, 110,  97, 109, 101,  32,  98,
121,  32, 102, 105, 108, 101,  32, 115, 101, 108, 101,  99, 116, 105, 111, 110,
  9,   9,  72,  69,  76,  86,  69,  84,  73,  67,  65,  16,  16,  78, 101, 119,
 32,  79,  98, 106, 101,  99, 116,  32,  67, 111, 108, 111, 114,   9,   9, 105,
110, 105, 116,  95, 100, 114,  97, 119,   5,   5,  70,  38, 111, 110, 116,   6,
  6,  66, 105, 116,  77,  97, 112,   6,   6,  80, 105, 120,  77,  97, 112,   7,
  7,  79, 117, 116, 108, 105, 110, 101,   7,   7,  80, 111, 108, 121, 103, 111,
110,   7,   7,  69, 120, 116, 114, 117, 100, 101,   7,   7,  84, 101, 120, 116,
117, 114, 101,   7,   7,  83,  38, 101, 108, 101,  99, 116,   6,   6,  67,  38,
111, 108, 111, 114,   6,   6,  83,  38, 101, 116, 117, 112,   7,   7,  79,  38,
 98, 106, 101,  99, 116,   7,   7,  83,  38, 116, 114, 105, 110, 103,   5,   5,
 84,  38, 101, 120, 116,  12,  12,  79,  38, 114, 105, 101, 110, 116,  97, 116,
105, 111, 110,   5,   5,  77,  38, 111, 118, 101,   7,   7,  82,  38, 101, 109,
111, 118, 101,  17,  17,  68, 114,  97, 119,  32,  58,  32,  69, 115, 115,  97,
105,  32,  70, 111, 110, 116,  37,  37,  32,  42,  42,  42,  32,  84, 104, 101,
 32,  68,  82,  65,  87,  95,  83,  69,  82,  86,  69,  82,  32,  67,  97, 110,
110, 111, 116,  32, 115, 116,  97, 114, 116,  32,  42,  42,  42,  11,  11,  69,
115, 115,  97, 105,  32,  70, 111, 110, 116, 115,   0,   0,   0,   0, 144,  65,
  0,   0, 192,  65,   0,   0,   0,  66,   0,   0,   0,  63,   0,   0,   0,  63,
  0,   0,   0,  63,   0,   0, 128,  63, 205, 204, 204,  62, 205, 204, 204,  62,
205, 204, 204,  62,   0,   0, 128,  63,   0,   0, 128,  63,  51,  51,  51,  63,
 51,  51,  51,  63,   0,   0, 128,  63, 205, 204,  76,  63, 205, 204,  76,  63,
205, 204,  76,  63,   0,   0, 128,  63,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0, 128,  63,  51,  51, 115,  63,  51,  51, 115,  63,
205, 204,  76,  63,   0,   0, 128,  63,   0,   0, 200,  65,   6,   6, 101, 115,
102, 111, 110, 116,  15,  15,  32,  69, 110, 100,  32, 111, 102,  32,  69, 115,
 70, 111, 110, 116,  46,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 744 ) = {
  6,   8,   8,   6,  66, 105, 116,  77,  97, 112,   0,   0,   8,   6,  80, 105,
120,  77,  97, 112,   0,   0,   8,   7,  79, 117, 116, 108, 105, 110, 101,   0,
  8,   7,  80, 111, 108, 121, 103, 111, 110,   0,   8,   7,  69, 120, 116, 114,
117, 100, 101,   0,   8,   7,  84, 101, 120, 116, 117, 114, 101,   0, 255,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
  2,   6,   6,   5,  42,  46, 116, 116, 102,   0,   6,   3,  42,  46,  42,   0,
  0,   0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 205, 204,  76,  62, 205, 204,  76,  62,
205, 204,  76,  63,   0,   0, 128,  63,   0,   0,   0,   0,   1,   0,   0,   0,
  0,   0, 128,  63,   0,   0,   0,   0,   0,   0,   0,  63,   0,   0, 128,  63,
  2,   0,   0,   0,   0,   0, 128,  63,   4,   6,   6,   5,  82,  73,  71,  72,
 84,   0,   6,   4,  76,  69,  70,  84,   0,   0,   6,   2,  85,  80,   0,   0,
  0,   0,   6,   4,  68,  79,  87,  78,   0,   0,   5,   8,   8,   6,  78,  79,
 82,  77,  65,  76,   0,   0,   8,   4,  76,  69,  70,  84,   0,   0,   0,   0,
  8,   6,  67,  69,  78,  84,  69,  82,   0,   0,   8,   5,  82,  73,  71,  72,
 84,   0,   0,   0,   8,   7,  74,  85,  83,  84,  73,  70,  89,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 992 );

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL Draw_SrvMod;
extern SL Draw_Srv_Flg;


/* Function/procedure prototypes. */
void Draw_End();
void Draw_Pas_Set_Menu_Spc(SL F_cd, V F_name, SL F_id, SL F_ky);
SL Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid);
UB Draw_Pas_Picture_3D(V F_title, F F_px, F F_py, F F_pz, UB F_bscale, UB F_blimit)
;
SL Draw_Dialog(SL F_flags);
void Draw_Pas_String(F F_x, F F_y, F F_theta, F F_high, V F_str, SL F_oflg);
void Draw_Pas_Text_In_Box(F F_xx, F F_yy, F F_bx, F F_by, V F_txt, SL F_sz, SL F_hal
, SL F_flg, F F_hc, F F_ls);
void Draw_Sphere(F F_xc, F F_yc, F F_zc, F F_r, SL F_plg, SL F_plt, SL F_flg);
void Draw_Set_ColorA(F F_r, F F_v, F F_b, F F_a);
void Draw_Define_ColorA(SL F_icol, F F_r, F F_g, F F_b, F F_a);
void Draw_Text_Font(SL F_n, SL F_tp);
SL Draw_Pas_Install_Font(SL F_ifnt, SL F_istl, V F_fnam);
SL Draw_Pas_Font_Info(SL F_ifnt, V F_fpath, SL *F_stl);
SL Draw_Pas_Get_String_Box(SL F_ifnt, V F_str, F F_hg, F *F_bx, F *F_by);
void Draw_Text_Attr(SL F_n1, SL F_n2, SL F_n3, F F_re, F F_rs, F F_rd);
void Draw_Pas_Message(V F_str);
SL Draw_Pas_Get_Str_Choice(V F_title, V F_menu, SL F_dim, SL F_nsz);
SL Draw_Pas_Get_String(V F_title, V F_default, V F_value);
SL Draw_Pas_Get_Color(V F_title, F *F_r, F *F_g, F *F_b);
SL Draw_Pas_Select_MFile(V F_title, V F_filtr, V F_defst, V F_resul, SL *F_flidx
, SL F_nwflg, SL F_nszfl);
SL Draw_Seg_Pick(SL *F_seg_id, SL *F_pick_id);
SL Draw_Get_Position(F *F_xx, F *F_yy, UB F_in_epure);
SL Draw_Get_Window(F *F_x1, F *F_x2, F *F_y1, F *F_y2);
SL Draw_New_Seg(SL F_n);
void Draw_Seg_End();
void Draw_Del_Seg(SL F_n);
void Draw_Seg_Attr(SL F_seg_id, SL F_det, SL F_hli, SL F_vis, F F_prior);
void Draw_Set_Pickid(SL F_pic_id);
void Draw_Move_Seg(SL F_iseg, F F_tx, F F_ty);
SL Draw_Get_Seg_Mat(SL F_iseg, V F_m);
SL Draw_Seg_Orient(SL F_iseg, F F_px, F F_py, F F_pz, UB F_interaction);
SL Draw_Seg_Move(SL F_iseg, UB F_interaction);
void Draw_Light_OnOff(SL F_light, SL F_flg);
void Draw_Light_Define(SL F_light, SL F_kind, V F_fparm, SL F_sz);
void Draw_Mat_Light_Prop(SL F_face, SL F_kind, V F_fparm, SL F_sz);
void Draw_Pannel_Align(SL F_id, SL F_aln);
void Draw_Pannel_Fsize(SL F_id, UB F_lbf, F F_sz);
void Draw_Pas_Pannel_Font(SL F_id, UB F_lbf, V F_nam, SL F_opt);
SL Draw_Pas_Pannel_Create(F F_w, F F_h, V F_t);
SL Draw_Pas_Pannel_B_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, UB *F_bv)
;
SL Draw_Pas_Pannel_E_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, SL *F_ev
, V F_choice, SL F_min);
SL Draw_Pas_Pannel_F_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, F *F_fv
, F F_min, F F_max, F F_step);
SL Draw_Pas_Pannel_Frame_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, F F_flw
, SL F_stl);
void Draw_Pannel_Open(SL F_ide);
SL Draw_Pannel_Get(SL F_ide);
SL Draw_Pannel_Put(SL F_ide);


/* Procedure/Function : " set_font_name "  */
void ESFONT_set_font_name(SL F_ifnt, V *F_pst){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+520;
  Ra.v[66]=Rd.s;
  Ra.v[67]=Rd.s+15;
  Ra.sl[136]=102; /* line # 102 */
  Rv0=Draw_Pas_Font_Info(F_ifnt, Ra.s,&Rv1);
  if (Rv0>=0) {
    PAS__VWRITE_INIT(Ra.s+257,1);
    PAS__WRITE_STR((Ri.s+Rv1*10-8),9,-1,32);
    PAS__WRITE_STR(Rd.s+78,-1,-1,32);
    PAS__WRITE_EOLN();
    Rv0=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],47,-1,-1,1);
    Ra.sl[136]=107; /* line # 107 */
    if (Rv0>0) {
      PAS__VWRITE_INIT(Ra.s+257,0);
      PAS__WRITE_STR(PAS__SUBSTR_STR(Ra.s+548,Ra.s,Rv0+1,0),-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__VWRITE_INIT(Ra.s+257,0);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Rv2=Ra.ub[258];
    (*F_pst)=PAS__NEW((SL)Rv2+2);
    ((UB *)(*F_pst))[0]=Rv2;
    PAS__STR_TO_STR((*F_pst),Ra.s+257);
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " new_font "  */
SL ESFONT_new_font(V F_fnam, SL F_istl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+83;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=122; /* line # 122 */
  Rv0=1;
  while (Rv0<=20)
  if (Rs.sl[Rv0*2-2]>=0) Rv0=Rv0+1;
  else  break;
  if (Rv0<=20) {
    Ra.sl[6]=128; /* line # 128 */
    Rv1=(Rs.s+Rv0*8-8);
    ((SL *)Rv1)[0]=Rv0-1;
    ((SL *)Rv1)[1]=F_istl;
    ((SL *)Rv1)[0]=Draw_Pas_Install_Font(((SL *)Rv1)[0],F_istl, F_fnam);
    Ra.sl[6]=133; /* line # 133 */
    if (((SL *)Rv1)[0]<0) {
      PAS__VWRITE_INIT(Ri.s+62,1);
      PAS__WRITE_STR(Rd.s+93,-1,-1,32);
      PAS__WRITE_STR(F_fnam,-1,-1,32);
      PAS__WRITE_STR(Rd.s+124,-1,-1,32);
      PAS__WRITE_EOLN();
      Draw_Pas_Message(Ri.s+62);
      ((SL *)Rv1)[0]=-1;
      Ra.sl[6]=138; /* line # 138 */
      Rv0=-1;
    }
    else ESFONT_set_font_name(Rv0-1,(Rs.v+Rv0+19));
    Ret=Rv0;
  }
  else {
    Ra.sl[6]=144; /* line # 144 */
    Ret=-1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " install_new_font "  */
void ESFONT_install_new_font(SL F_istl){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  PAS__STR_TO_STR(Ra.s,Rd.s+128);
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+385;
  Ra.v[35]=Rd.s+15;
  Ra.sl[72]=159; /* line # 159 */
  if (Ri.ub[319]) Rv0=Draw_Pas_Select_MFile(Rd.s+403,Ri.s+320,Ri.s+338,Ra.s,&Rv1,0,0);
  else Rv0=Draw_Pas_Get_String(Rd.s+424,Rd.s+446,Ra.s);
  if (Rv0>0) {
    Rv1=ESFONT_new_font(Ra.s,F_istl);
    Ra.sl[72]=164; /* line # 164 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+448,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+481,-1,-1,32);
    PAS__WRITE_STR((Ri.s+F_istl*10-8),-1,-1,32);
    if (Rv1>0) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+497,-1,-1,32);
      PAS__WRITE_INT(Rv1,-3,0);
      PAS__WRITE_STR(Rd.s+526,-1,-1,32);
      PAS__WRITE_INT(Rs.sl[Rv1*2-2],12,0);
      PAS__WRITE_CHAR(46);
      PAS__WRITE_EOLN();
      Ri.sl[149]=Rs.sl[Rv1*2-2];
    }
    else {
      Ra.sl[72]=170; /* line # 170 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+542,-1,-1,32);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " select_a_font "  */
void ESFONT_select_a_font(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+556;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=181; /* line # 181 */
  Rv0=Draw_Pas_Get_Str_Choice(Rd.s+571,Rs.s+160,28,0);
  if (Rv0>=1) {
    Ri.sl[149]=Rs.sl[Rv0*2-2];
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+587,-1,-1,32);
    PAS__WRITE_STR(Rs.v[Rv0+19],-1,-1,32);
    PAS__WRITE_STR(Rd.s+607,-1,-1,32);
    PAS__WRITE_INT(Rs.sl[Rv0*2-2],0,0);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " change_color "  */
void ESFONT_change_color(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  SL Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+618;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=197; /* line # 197 */
  Rv0=Ri.f[150];
  Rv1=Ri.f[151];
  Rv2=Ri.f[152];
  Rv3=Draw_Pas_Get_Color(Rd.s+632,&Rv0, &Rv1, &Rv2);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_INT(Rv3,12,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=202; /* line # 202 */
  if (Rv3>=0) {
    Ri.f[150]=Rv0;
    Ri.f[151]=Rv1;
    Ri.f[152]=Rv2;
    Ra.sl[6]=207; /* line # 207 */
    Draw_Pannel_Put(Ri.sl[154]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_segment "  */
SL ESFONT_create_segment(F F_x, F F_y){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register V Rv2;
  SL Rv3;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+646;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=218; /* line # 218 */
  Rv0=1;
  while (Rv0<=20)
  if (Rs.sl[Rv0*7+89]>0) Rv0=Rv0+1;
  else  break;
  if (Rv0<=20) {
    Ra.sl[6]=224; /* line # 224 */
    Rv1=Draw_New_Seg(Rv0);
    Rv2=(Rs.s+Rv0*28+356);
    ((SL *)Rv2)[0]=Rv1;
    Draw_Move_Seg(Rv1, F_x, F_y);
    Ra.sl[6]=229; /* line # 229 */
    Rv3=Draw_Get_Seg_Mat(Rv1, Ra.s+28);
    ((F *)Rv2)[1]=F_x;
    ((F *)Rv2)[2]=F_y;
    Draw_Seg_Attr(Rv1,2,1,2, (F)5.000000E-01);
    Ra.sl[6]=234; /* line # 234 */
    Draw_Set_Pickid(Rv0);
    Draw_Set_ColorA(Ri.f[150],Ri.f[151],Ri.f[152],Ri.f[153]);
  }
  else Rv1=-1;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " create_new_string "  */
void ESFONT_create_new_string(){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  F Rv2;
  SL Rv3;
  F Rv4;
  F Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+662;
  Ra.v[35]=Rd.s+15;
  Ra.sl[72]=250; /* line # 250 */
  Rv0=Draw_Pas_Get_String(Rd.s+681,Rd.s+699,Ra.s);
  if (Rv0>0) Rv0=Draw_Get_Position(&Rv1, &Rv2,1);
  Ra.sl[72]=255; /* line # 255 */
  if (Rv0>=0) {
    Rv3=ESFONT_create_segment(Rv1, Rv2);
    Draw_Text_Font(Ri.sl[149],0);
    Draw_Text_Attr(3,4, Ri.sl[155],Ri.f[156],Ri.f[157],Ri.f[158]);
    Ra.sl[72]=263; /* line # 263 */
    Rv0=Draw_Pas_Get_String_Box(Ri.sl[149],Ra.s,Ri.f[159],&Rv4, &Rv5);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+717,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+732,-1,-1,32);
    PAS__WRITE_SNGL(Ri.f[159],16,-6,0);
    PAS__WRITE_STR(Rd.s+745,-1,-1,32);
    PAS__WRITE_SNGL(Rv4,6,2,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_SNGL(Rv5,6,2,0);
    PAS__WRITE_STR(Rd.s+767,-1,-1,32);
    PAS__WRITE_EOLN();
    Draw_Pas_String((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, Ri.f[159]
    ,Ra.s,0);
    Ra.sl[72]=268; /* line # 268 */
    Draw_Seg_End();
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " create_new_text "  */
void ESFONT_create_new_text(){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  SL Rv5;
  F Rv6;
  F Rv7;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+771;
  Ra.v[35]=Rd.s+15;
  Ra.sl[72]=281; /* line # 281 */
  Rv0=Draw_Pas_Get_String(Rd.s+788,Rd.s+804,Ra.s);
  if (Rv0>0) Rv0=Draw_Get_Window(&Rv1, &Rv2, &Rv3, &Rv4);
  if ((Rv0>=0&&Rv3-Rv1>(F)1.000000E+00)&&Rv4-Rv2>(F)1.000000E+00) {
    Ra.sl[72]=286; /* line # 286 */
    Rv5=ESFONT_create_segment((Rv1+Rv3)/(F)2.000000E+00,(Rv2+Rv4)/(F)2.000000E+00);
    Draw_Text_Font(Ri.sl[149],0);
    Rv6=Rv3-Rv1;
    Rv7=Rv4-Rv2;
    Draw_Text_Attr(3,4,1, Ri.f[156],(F)0.000000E-01, Ri.f[158]);
    Ra.sl[72]=291; /* line # 291 */
    Draw_Pas_Text_In_Box((F)0.000000E-01, (F)0.000000E-01, Rv6, Rv7, Ra.s+2,(SL)
    Ra.ub[1],Ri.sl[160],0, Ri.f[159],Ri.f[161]);
    Draw_Seg_End();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+820,-1,-1,32);
    PAS__WRITE_SNGL(Rv1,5,2,0);
    PAS__WRITE_STR(Rd.s+854,-1,-1,32);
    PAS__WRITE_SNGL(Rv2,5,2,0);
    PAS__WRITE_STR(Rd.s+858,-1,-1,32);
    PAS__WRITE_SNGL(Rv6,5,2,0);
    PAS__WRITE_CHAR(42);
    PAS__WRITE_SNGL(Rv7,5,2,0);
    PAS__WRITE_STR(Rd.s+877,-1,-1,32);
    PAS__WRITE_INT(Rv5,0,0);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+887,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+903,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " orient_segments "  */
void ESFONT_orient_segments(){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;

  /* Code of procedure/function */
  while (1){
    Ra.v[0]=PAS__curr_cntx;
    PAS__curr_cntx=Ra.s;
    Ra.v[1]=Rd.s+907;
    Ra.v[2]=Rd.s+15;
    Ra.sl[6]=307; /* line # 307 */
    Rv0=Draw_Seg_Pick(&Rv1, &Rv2);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_INT(Rv1,12,0);
    PAS__WRITE_INT(Rv2,12,0);
    PAS__WRITE_EOLN();
    if (Rv1<=0||Rv0<0)  break;
    Rv3=(Rs.s+Rv2*28+356);
    Ra.sl[6]=312; /* line # 312 */
    Rv2=Draw_Get_Seg_Mat(Rv1, Ra.s+28);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+924,-1,-1,32);
    PAS__WRITE_INT(Rv1,0,0);
    PAS__WRITE_STR(Rd.s+959,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+963,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[7],6,3,0);
    PAS__WRITE_SNGL(Ra.f[8],6,3,0);
    PAS__WRITE_SNGL(Ra.f[9],6,3,0);
    PAS__WRITE_STR(Rd.s+976,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[10],6,3,0);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+980,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[11],6,3,0);
    PAS__WRITE_SNGL(Ra.f[12],6,3,0);
    PAS__WRITE_SNGL(Ra.f[13],6,3,0);
    PAS__WRITE_STR(Rd.s+993,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[14],6,3,0);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+997,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[15],6,3,0);
    PAS__WRITE_SNGL(Ra.f[16],6,3,0);
    PAS__WRITE_SNGL(Ra.f[17],6,3,0);
    PAS__WRITE_STR(Rd.s+1010,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[18],6,3,0);
    PAS__WRITE_EOLN();
    Ra.sl[6]=317; /* line # 317 */
    ((F *)Rv3)[1]=Ra.f[10];
    ((F *)Rv3)[2]=Ra.f[14];
    Rv2=Draw_Seg_Orient(Rv1,((F *)Rv3)[1],((F *)Rv3)[2],(F)0.000000E-01,1);
    Rv2=Draw_Get_Seg_Mat(Rv1, Ra.s+28);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1014,-1,-1,32);
    PAS__WRITE_INT(Rv1,0,0);
    PAS__WRITE_STR(Rd.s+1048,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1052,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[7],6,3,0);
    PAS__WRITE_SNGL(Ra.f[8],6,3,0);
    PAS__WRITE_SNGL(Ra.f[9],6,3,0);
    PAS__WRITE_STR(Rd.s+1065,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[10],6,3,0);
    PAS__WRITE_EOLN();
    Ra.sl[6]=322; /* line # 322 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1069,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[11],6,3,0);
    PAS__WRITE_SNGL(Ra.f[12],6,3,0);
    PAS__WRITE_SNGL(Ra.f[13],6,3,0);
    PAS__WRITE_STR(Rd.s+1082,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[14],6,3,0);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1086,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[15],6,3,0);
    PAS__WRITE_SNGL(Ra.f[16],6,3,0);
    PAS__WRITE_SNGL(Ra.f[17],6,3,0);
    PAS__WRITE_STR(Rd.s+1099,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[18],6,3,0);
    PAS__WRITE_EOLN();
    if (0)  break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " move_segments "  */
void ESFONT_move_segments(){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register V Rv2;

  /* Code of procedure/function */
  while (1){
    Ra.v[0]=PAS__curr_cntx;
    PAS__curr_cntx=Ra.s;
    Ra.v[1]=Rd.s+1103;
    Ra.v[2]=Rd.s+15;
    Ra.sl[6]=344; /* line # 344 */
    Rv0=Draw_Seg_Move(0,1);
    if (Rv0<=0)  break;
    Rv1=Draw_Get_Seg_Mat(Rv0, Ra.s+28);
    Rv2=(Rs.s+Rv1*28+356);
    Ra.sl[6]=349; /* line # 349 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1118,-1,-1,32);
    PAS__WRITE_INT(Rv0,0,0);
    PAS__WRITE_STR(Rd.s+1145,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1149,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[7],6,3,0);
    PAS__WRITE_SNGL(Ra.f[8],6,3,0);
    PAS__WRITE_SNGL(Ra.f[9],6,3,0);
    PAS__WRITE_STR(Rd.s+1162,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[10],6,3,0);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1166,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[11],6,3,0);
    PAS__WRITE_SNGL(Ra.f[12],6,3,0);
    PAS__WRITE_SNGL(Ra.f[13],6,3,0);
    PAS__WRITE_STR(Rd.s+1179,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[14],6,3,0);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1183,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[15],6,3,0);
    PAS__WRITE_SNGL(Ra.f[16],6,3,0);
    PAS__WRITE_SNGL(Ra.f[17],6,3,0);
    PAS__WRITE_STR(Rd.s+1196,-1,-1,32);
    PAS__WRITE_SNGL(Ra.f[18],6,3,0);
    PAS__WRITE_EOLN();
    ((F *)Rv2)[1]=Ra.f[10];
    Ra.sl[6]=354; /* line # 354 */
    ((F *)Rv2)[2]=Ra.f[14];
    if (0)  break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " remove_segment "  */
void ESFONT_remove_segment(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1200;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=368; /* line # 368 */
  Rv0=Draw_Seg_Pick(&Rv1, &Rv2);
  if (Rv0>=0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1216,-1,-1,32);
    PAS__WRITE_INT(Rv1,4,0);
    PAS__WRITE_INT(Rv2,4,0);
    PAS__WRITE_EOLN();
    Draw_Del_Seg(Rs.sl[Rv2*7+89]);
    Ra.sl[6]=373; /* line # 373 */
    Rs.sl[Rv2*7+89]=-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_font_tables "  */
void ESFONT_init_font_tables(){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1242;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=386; /* line # 386 */
  Rv0=1;
  for( Rf0=20;Rf0>0;Rf0-- ) {
    if (Rv0<=8) Rs.sl[Rv0*2-2]=Rv0-1;
    else Rs.sl[Rv0*2-2]=-1;
    Rv0++;
  }
  Ra.sl[6]=391; /* line # 391 */
  Rv1=1;
  for( Rf0=28;Rf0>0;Rf0-- ) {
    if (Rv1<=8) {
      Draw_Text_Font(Rv1-1,0);
      ESFONT_set_font_name(Rv1-1,(Rs.v+Rv1+19));
    }
    else {
      Ra.sl[6]=397; /* line # 397 */
      Rs.v[Rv1+19]=Rd.s+1260;
    }
    Rv1++;
  }
  Draw_Pas_Font_Info(-1, Ri.s+338,&Rv2);
  Rv2=PAS__INDEX_CHA(Ri.s+340,(SL)Ri.ub[339],59);
  if (Rv2>1) PAS__STR_TO_STR(Ri.s+338,PAS__SUBSTR_STR(Ra.s+28,Ri.s+338,1, Rv2-1));
  else {
    Ra.sl[6]=402; /* line # 402 */
    if (Rv2==1) PAS__CHA_TO_STR(Ri.s+338,46);
  }
  if (Ri.c[Ri.ub[339]+339]!=47) PAS__STR_TO_STR(Ri.s+338,PAS__CON_STR_CHA(Ra.s+28,
  Ri.s+338,47));
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1277,-1,-1,32);
  PAS__WRITE_STR(Ri.s+338,-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pannel_setup "  */
void ESFONT_pannel_setup(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1281;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=412; /* line # 412 */
  Ri.sl[154]=Draw_Pas_Pannel_Create((F)1.200000E+01, (F)7.200000E+00, Rd.s+1295);
  Draw_Pas_Pannel_Font(Ri.sl[154],1, Rd.s+1309,3);
  Draw_Pas_Pannel_Font(Ri.sl[154],0, Rd.s+1320,0);
  Draw_Pannel_Align(Ri.sl[154],4);
  Ra.sl[6]=417; /* line # 417 */
  Draw_Pannel_Fsize(Ri.sl[154],0, (F)1.200000E+01);
  Draw_Pannel_Fsize(Ri.sl[154],1, (F)1.200000E+01);
  Draw_Pas_Pannel_F_Item(Ri.sl[154],(F)2.600000E+00, (F)3.500000E+00, (F)1.400000E+00,
  (F)8.000000E-01, Rd.s+1331,Ri.f+150,(F)0.000000E-01, (F)1.000000E+00, (F)5.000000E-02);
  Draw_Pas_Pannel_F_Item(Ri.sl[154],(F)2.600000E+00, (F)2.500000E+00, (F)1.400000E+00,
  (F)8.000000E-01, Rd.s+1338,Ri.f+151,(F)0.000000E-01, (F)1.000000E+00, (F)5.000000E-02);
  Draw_Pas_Pannel_F_Item(Ri.sl[154],(F)2.600000E+00, (F)1.500000E+00, (F)1.400000E+00,
  (F)8.000000E-01, Rd.s+1345,Ri.f+152,(F)0.000000E-01, (F)1.000000E+00, (F)5.000000E-02);
  Ra.sl[6]=423; /* line # 423 */
  Draw_Pas_Pannel_Font(Ri.sl[154],1, Rd.s+1352,3);
  Draw_Pas_Pannel_F_Item(Ri.sl[154],(F)1.000000E+01, (F)6.400000E+00, (F)1.500000E+00,
  (F)6.000000E-01, Rd.s+1363,Ri.f+157,(F)-5.000000E+00, (F)5.000000E+00, (F)1.000000E-01);
  Draw_Pas_Pannel_F_Item(Ri.sl[154],(F)1.000000E+01, (F)5.600000E+00, (F)1.500000E+00,
  (F)6.000000E-01, Rd.s+1382,Ri.f+159,(F)1.000000E-01, (F)1.000000E+01, (F)1.000000E-01);
  Draw_Pas_Pannel_F_Item(Ri.sl[154],(F)1.000000E+01, (F)4.800000E+00, (F)1.500000E+00,
  (F)6.000000E-01, Rd.s+1400,Ri.f+158,(F)5.000000E-02, (F)1.000000E+01, (F)5.000000E-02);
  Draw_Pas_Pannel_F_Item(Ri.sl[154],(F)1.000000E+01, (F)4.000000E+00, (F)1.500000E+00,
  (F)6.000000E-01, Rd.s+1417,Ri.f+156,(F)1.000000E-01, (F)1.000000E+01, (F)1.000000E-01);
  Ra.sl[6]=428; /* line # 428 */
  Draw_Pas_Pannel_F_Item(Ri.sl[154],(F)9.500000E+00, (F)3.200000E+00, (F)2.000000E+00,
  (F)6.000000E-01, Rd.s+1440,Ri.f+161,(F)1.000000E-01, (F)4.000000E+00, (F)1.000000E-01);
  Draw_Pas_Pannel_E_Item(Ri.sl[154],(F)9.500000E+00, (F)2.400000E+00, (F)2.000000E+00,
  (F)6.000000E-01, Rd.s+1466,Ri.sl+155,Ri.s+648,1);
  Draw_Pas_Pannel_E_Item(Ri.sl[154],(F)9.500000E+00, (F)1.600000E+00, (F)2.000000E+00,
  (F)6.000000E-01, Rd.s+1477,Ri.sl+160,Ri.s+682,1);
  Draw_Pas_Pannel_B_Item(Ri.sl[154],(F)1.110000E+01, (F)9.000000E-01, (F)6.000000E-01,
  (F)6.000000E-01, Rd.s+1501,Ri.ub+319);
  Ra.sl[6]=433; /* line # 433 */
  Draw_Pannel_Align(Ri.sl[154],1);
  Draw_Pannel_Fsize(Ri.sl[154],1, (F)2.000000E+01);
  Draw_Pas_Pannel_Font(Ri.sl[154],1, Rd.s+1536,3);
  Draw_Pas_Pannel_Frame_Item(Ri.sl[154],(F)5.000000E-01, (F)1.000000E+00, (F)4.000000E+00,
  (F)4.500000E+00, Rd.s+1547,(F)1.500000E+00,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_draw "  */
void ESFONT_init_draw(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1565;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=448; /* line # 448 */
  Draw_Pas_Set_Menu_Spc(2, NULL,-1,0);
  Draw_Pas_Set_Menu_Spc(3, Rd.s+1576,-1,0);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1583,11,98);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1591,12,112);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1599,13,108);
  Ra.sl[6]=453; /* line # 453 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1608,14,118);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1617,15,101);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1626,16,65620);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1635,1,102);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1644,8,99);
  Ra.sl[6]=458; /* line # 458 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1652,7,65619);
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Draw_Pas_Set_Menu_Spc(3, Rd.s+1660,-1,0);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1669,2,115);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1678,3,116);
  Ra.sl[6]=463; /* line # 463 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1685,4,111);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1699,5,109);
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1706,6,114);
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Ra.sl[6]=471; /* line # 471 */
  Draw_SrvMod=1073742096;
  Draw_Pas_Init(Rs.f+236,Rs.f+237,Rs.ub+952,Rd.s+1715);
  Ra.sl[6]=477; /* line # 477 */
  if (Draw_Srv_Flg==0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1734,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  Ra.sl[6]=483; /* line # 483 */
  Draw_Define_ColorA(0, (F)8.000000E-01, (F)8.000000E-01, (F)7.000000E-01, (F)1.000000E+00);
  Rs.ub[953]=Draw_Pas_Picture_3D(Rd.s+1773,(F)2.000000E+01, (F)1.500000E+01, (F)
1.500000E+01,1,1);
  Ra.sl[6]=489; /* line # 489 */
  Draw_Light_Define(0,0, Rd.s+1788,3);
  Draw_Light_Define(0,1, Rd.s+1800,4);
  Draw_Light_Define(0,2, Rd.s+1816,4);
  Draw_Light_Define(0,3, Rd.s+1832,4);
  Ra.sl[6]=495; /* line # 495 */
  Draw_Mat_Light_Prop(0,3, Rd.s+1848,4);
  Draw_Mat_Light_Prop(0,5, Rd.s+1864,4);
  Draw_Mat_Light_Prop(0,2, Rd.s+1880,4);
  Draw_Mat_Light_Prop(0,4, Rd.s+1896,1);
  Ra.sl[6]=506; /* line # 506 */
  Draw_Light_OnOff(0,1);
  ESFONT_pannel_setup();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " esfont "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[120]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+960;
  Rs.v[121]=Rd.s+1900;
  Rs.v[122]=Rd.s+15;
  Rs.sl[246]=515; /* line # 515 */
  ESFONT_init_draw();
  Rv0=1;
  for( Rf0=20;Rf0>0;Rf0-- ) {
    Rs.sl[Rv0*7+89]=-1;
    Rv0++;
  }
  Rs.sl[246]=520; /* line # 520 */
  ESFONT_init_font_tables();
  Draw_Text_Font(0,0);
  ESFONT_create_segment((F)0.000000E-01, (F)0.000000E-01);
  Rs.sl[246]=525; /* line # 525 */
  Draw_Set_ColorA((F)1.000000E+00, (F)9.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Draw_Sphere((F)0.000000E-01, (F)0.000000E-01, (F)-4.000000E+00, (F)2.000000E+00,32,32,4);
  Draw_Seg_End();
  while (1){
    Rs.sl[246]=531; /* line # 531 */
    Ri.sl[184]=Draw_Dialog(1);
    Draw_Pannel_Get(Ri.sl[154]);
    if (Ri.sl[184]>0) switch (Ri.sl[184]) {
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:Rs.sl[246]=536; /* line # 536 */
      ESFONT_install_new_font(Ri.sl[184]-10);
      break;
      case 1:ESFONT_select_a_font();
      break;
      case 2:ESFONT_create_new_string();
      break;
      case 3:Rs.sl[246]=542; /* line # 542 */
      ESFONT_create_new_text();
      break;
      case 4:ESFONT_orient_segments();
      break;
      case 5:ESFONT_move_segments();
      break;
      case 6:Rs.sl[246]=548; /* line # 548 */
      ESFONT_remove_segment();
      break;
      case 7:Draw_Pannel_Open(Ri.sl[154]);
      break;
      case 8:ESFONT_change_color();
      break;
      default:break;
    }
    if (Ri.sl[184]<0)  break;
  }
  Rs.sl[246]=558; /* line # 558 */
  Draw_End();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1908,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[120];
  PAS__EXIT( 0 );
}
