// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *            F L T K / D R A W   -   S E R V E R   M O D U L E             *
// *                                                                          *
// *              Version  1.4-C for Draw Library Level V 2.4 A               *
// *                                                                          *
// *        (Draw interface for FLTK/OPENGL function and procedures)          *
// *                                                                          *
// *                                                                          *
// *        (Environment to manage the FLTK/OPENGL Interface Pannel)          *
// *                                                                          *
// *                                                                          *
// *                                  by                                      *
// *                                                                          *
// *                                                                          *
// *            Pierre Wolfers, Laboratoire de Cristallographie               *
// *                                                                          *
// *            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
// *                                                                          *
// *                       F 38042 GRENOBLE CEDEX 9                           *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


//
// Routine to get a Double value by using a FLTK ValueSlider in a child window.
//

#ifndef pannel_h
#define pannel_h

#include <stdio.h>

#include <fltk/Window.h>
#include <fltk/Input.h>
#include <fltk/Output.h>
#include <fltk/IntInput.h>
#include <fltk/FloatInput.h>
#include <fltk/ValueInput.h>
#include <fltk/CheckButton.h>
#include <fltk/ReturnButton.h>
#include <fltk/ToggleButton.h>
#include <fltk/Choice.h>
#include <fltk/TextDisplay.h>
#include <fltk/Item.h>
#include <fltk/MenuBar.h>
#include <fltk/file_chooser.h>
#include <fltk/Font.h>
#include <fltk/Style.h>


#include "Server_DrawGL.h"

#define UPN_ORG   20

using namespace fltk;


typedef enum {  UPN_BOOL       =    UPN_ORG + ITM_B,    // The different entry type for a pannel.
                UPN_ENUM       =    UPN_ORG + ITM_E,
                UPN_STRING     =    UPN_ORG + ITM_S,
                UPN_INTEGER    =    UPN_ORG + ITM_I,
                UPN_FLOAT      =    UPN_ORG + ITM_F,
                UPN_D_STRING   =    UPN_ORG + ITM_STR,
                UPN_D_TEXT     =    UPN_ORG + ITM_TXT,
                UPN_D_FRAME    =    UPN_ORG + ITM_FRM,
                UPN_BUTTON     =    UPN_ORG + ITM_BUT
             } UPN_Kind;



class User_Pannel: public Window {
public:
  User_Pannel*  wp_nxt;
  int           wp_ide;
  int           wp_cnt;
  int           wp_ret;
  int           wp_req;
  fltk::Flags   wp_aln;
  bool          wp_cha;
  Font         *wp_lbf, *wp_stf;
  float         wp_lbs,  wp_sts;
  ReturnButton* wp_bok;
  ToggleButton* wp_can;

  User_Pannel( int, int, int, int, const char* );
  User_Pannel( int, int, const char* );
  virtual ~User_Pannel();
  inline void Align( Flags );
  inline void Label_Font( Font* );
  inline void String_Font( Font* );
  inline void Label_FSize( float );
  inline void String_FSize( float );

};



class UPN_Bool: public CheckButton {
public:
  UPN_Bool( int, int, int, int, const char* = 0, bool = false );
  virtual ~UPN_Bool();
};



class UPN_Enum: public Choice {
public:
  int wpe_sz,
      wpe_mi;
  UPN_Enum( int, int, int, int, const char* = 0, int = 0, char** = 0, int = 0 );
  virtual ~UPN_Enum();
};



class UPN_String: public Input {
public:
  UPN_String( int, int, int, int, const char* = 0, int = 256, char* = 0 );
  virtual ~UPN_String();
};



class UPN_Integer: public ValueInput {
public:
  UPN_Integer( int, int, int, int, const char* = 0, int = 0, int = 0, int = 255 );
  virtual ~UPN_Integer();
};



class UPN_Float: public ValueInput {
public:
  UPN_Float( int, int, int, int, const char* = 0, float = 0.0,  float = 1.0, float = 0.0000001, float = 0.5 );
  virtual ~UPN_Float();
};



class UPN_Fstring: public Output {
public:
  UPN_Fstring( int, int, int, int, const char* = 0, int = 256, char* = 0 );
  virtual ~UPN_Fstring();
};



class UPN_D_Text: public TextDisplay {
public:
  UPN_D_Text( int, int, int, int, const char* = 0, char* = 0 );
  virtual ~UPN_D_Text();
};



class UPN_D_Frame: public Group {
public:
  float wpfr_lw;
  int   wpfr_st;

  UPN_D_Frame( int, int, int, int, const char* = 0, float = 0.0, int = 0 );
  virtual ~UPN_D_Frame();
  virtual void draw( void );
};




#endif
