// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *            F L T K / D R A W   -   S E R V E R   M O D U L E             *
// *                                                                          *
// *              Version  1.4-C for Draw Library Level V 2.4 A              *
// *                                                                          *
// *        (Draw interface for FLTK/OPENGL function and procedures)          *
// *                                                                          *
// *              (To manage the FLTK/OPENGL Interface Pannel)                *
// *                                                                          *
// *                                                                          *
// *                                  by                                      *
// *                                                                          *
// *                                                                          *
// *            Pierre Wolfers, Laboratoire de Cristallographie               *
// *                                                                          *
// *            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
// *                                                                          *
// *                       F 38042 GRENOBLE CEDEX 9                           *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


#include "Server_UI.h"

extern Draw_GL_UI* srvw0;

#include "Server_Pannel_UI.h"

#define OK_X    65
#define CA_X   130
#define OK_Y    35
#define OK_W    60
#define OK_H    30
#define OK_LSZ  10


// static fltk::Flags cur_align = fltk::ALIGN_LEFT;

static User_Pannel* blt_pannel = (User_Pannel*)0;

static User_Pannel* hwp_Frst   = (User_Pannel*)0;
static User_Pannel* hwp_Last   = (User_Pannel*)0;
static int          UsrPanIde  =               0;

static char Msg_Oky[] = "OK";
static char Msg_Can[] = "Cancel";
static char Msg_App[] = "Apply";

//static void cb_EXIT_Pannel( fltk::Widget* o, void* ) {
//  Widget* b = ((User_Pannel*)o)->child(0);
//  if (b->active()) ((User_Pannel*)o)->make_exec_return( false );
//}


static void cb_OKR_Pannel( fltk::Widget* o, void* p ) {
  ((User_Pannel*)p)->wp_ret = 0;
  ((User_Pannel*)p)->make_exec_return( true );
}


static void cb_Cancel_Pannel( fltk::Widget* o, void* p ) {
  ((User_Pannel*)p)->wp_ret = -1;
  ((User_Pannel*)p)->make_exec_return( true );
}


static void cb_Apply_Pannel( fltk::Widget* o, void* p ) {
  ((User_Pannel*)p)->wp_ret = 0;
  ((fltk::Button*)o)->value( false );
  DrwSrv_MWtb[m_Resume]->do_callback( DrwSrv_MWtb[m_Resume], (void*) 0 );
}


User_Pannel::User_Pannel( int w, int h, const char* label ):
             Window( w, h, label ) {
  shortcut(0xff1b);
  user_data((void*)(this));
//resizable(o);
  blt_pannel = this;

  wp_nxt =                    NULL;
  wp_ide =             ++UsrPanIde;
  wp_ret =                       0;
  wp_aln =        fltk::ALIGN_LEFT;
  wp_lbf =         fltk::HELVETICA;
  wp_lbs =                    16.0;
  wp_stf =         fltk::HELVETICA;
  wp_sts =                    14.0;
  wp_cha =                       0;
  wp_cnt =                       0;
  wp_req =                       0;             // Default to Pannel/Dialog request.

//this->copy_label( label );
  this->shortcut( 0 );                          // No shortcut to close the pannel.
  this->begin();
  { wp_bok = new ReturnButton( w - OK_X, h - OK_Y, OK_W, OK_H, Msg_App );  // Create the Apply Pannel Button.
    wp_bok->labelsize( OK_LSZ );
    wp_bok->shortcut( 0xff1b );                 // Set the Apply shortcut to Escape Key.
    wp_bok->callback( (Callback*) cb_Apply_Pannel, (void*)this );
    wp_bok->activate();
    wp_can = new ToggleButton( w - CA_X, h - OK_Y, OK_W, OK_H, Msg_Can );  // Create the Cancel request Button.
    wp_can->labelsize( OK_LSZ );
    wp_can->callback( (Callback*) cb_Cancel_Pannel, (void*)this );
    wp_can->deactivate();                       // Desactivate for pannel/dialog interaction.
  }
  this->end();
  if (hwp_Frst) hwp_Last->wp_nxt = blt_pannel;
           else hwp_Frst = blt_pannel;
  hwp_Last = blt_pannel;
}



void User_Pannel::Align( fltk::Flags aln ) { blt_pannel->wp_aln = aln; }
void User_Pannel::Label_Font( Font* fnt ) { blt_pannel->wp_lbf = fnt; }
void User_Pannel::String_Font( Font* fnt ) { blt_pannel->wp_stf = fnt; }
void User_Pannel::Label_FSize( float fsz ) { blt_pannel->wp_lbs = fsz; }
void User_Pannel::String_FSize( float fsz ) { blt_pannel->wp_sts = fsz; }



static void cb_upn_change( fltk::Widget* o, void* v ) { // Common Pannel CallBack routine.
  User_Pannel* p = ((User_Pannel*)(o->parent()));
  int id = p->wp_ide;
  p->wp_cha = 1;
  if (Drwgl_PanChg&&(Drwgl_PanChg != id)) Drwgl_PanChg = -1;
                                     else Drwgl_PanChg = id;
}



UPN_Bool::UPN_Bool( int x, int y, int w, int h, const char* lab, bool bv ):
          CheckButton( x, y, w, h, lab ) {
  type( UPN_BOOL );                                     // Set the item type.
  align( blt_pannel->wp_aln );                          // Set the required label alignement.
  labelfont( blt_pannel->wp_lbf );                      // Set the label font,
  labelsize( blt_pannel->wp_lbs );                      // ... the label size.
  value( bv );                                          // Set the value.
  callback( (Callback*) cb_upn_change );                // Set the Common Pannel CallBack routine.
}


UPN_Bool::~UPN_Bool() { free( (void*)(this->label()) ); }



UPN_Enum::UPN_Enum( int x, int y, int w, int h, const char* lab, int iv, char** list, int min ):
           Choice( x, y, w, h, lab ) {
  char*  na;
  Item*   p;

  type( UPN_ENUM );                                     // Set the Item type.
  wpe_sz = 0;                                           // Set the choice length.
  wpe_mi = min;                                         // Set the minimum value.
  align( blt_pannel->wp_aln );                          // Set the required label alignement.
  labelfont( blt_pannel->wp_lbf );                      // Set the label font,
  labelsize( blt_pannel->wp_lbs );                      // ... the label size.
  begin();
  while (list&&(na = *(list++))) {
    wpe_sz++;
    p =  new Item( 0 );                                 // Create each choice items.
    p->copy_label( na );                                // with a local string name copy.
    p->labelfont( blt_pannel->wp_stf );                 // Set the label font,
    p->labelsize( blt_pannel->wp_sts );                 // ... the label size.
  }
  end();
  value( iv );                                          // Set the initial value.
  callback( (Callback*) cb_upn_change );                // Set the Change callback.
}


UPN_Enum::~UPN_Enum() { free( (void*)(this->label()) ); }



UPN_String::UPN_String( int x, int y, int w, int h, const char* lab, int sz, char* str ):
            Input( x, y, w, h, lab ) {

  type( UPN_STRING );                                   // Set the Item type.
  align( blt_pannel->wp_aln );                          // Set the required label alignement.
  labelfont( blt_pannel->wp_lbf );                      // Set the label font,
  labelsize( blt_pannel->wp_lbs );                      // ... the label size.
  textfont( blt_pannel->wp_stf );                       // Set the label font,
  textsize( blt_pannel->wp_sts );                       // ... the label size.
  reserve( sz );                                        // Set the allocated string capacity.
  value( str );                                         // Set the initial value.
  callback( (fltk::Callback*) cb_upn_change );          // Set the Common Pannel CallBack routine.
  when( fltk::WHEN_CHANGED );                           // Perform the CallBack call 
}


UPN_String::~UPN_String() { free( (void*)(this->label()) ); }



UPN_Integer::UPN_Integer( int x, int y, int w, int h, const char* lab, int iv, int min, int max ):
            ValueInput( x, y, w, h, lab ){
  type( UPN_INTEGER );                                  // Set the Item type.
  align( blt_pannel->wp_aln );                          // Set the required label alignement.
  labelfont( blt_pannel->wp_lbf );                      // Set the label font,
  labelsize( blt_pannel->wp_lbs );                      // ... the label size.
  textfont( blt_pannel->wp_stf );                       // Set the label font,
  textsize( blt_pannel->wp_sts );                       // ... the label size.
  range( (double) min, (double) max );                  // Set the minimum and maximum value.
  step( (double) 1.0 );                                 // Set the step value.
  if (iv < min) iv = min; else if (iv > max) iv = max;
  value( (double) iv );                                 // Set the initial value.
  callback( (fltk::Callback*) cb_upn_change );          // Set the Common Pannel CallBack routine.
}


UPN_Integer::~UPN_Integer() { free( (void*)(this->label()) ); }



UPN_Float::UPN_Float( int x, int y, int w, int h, const char* lab, float vl, float min, float max, float stp ):
           ValueInput( x, y, w, h, lab ) {
  type( UPN_FLOAT );                                    // Set the Item type.
  align( blt_pannel->wp_aln );                          // Set the required label alignement.
  labelfont( blt_pannel->wp_lbf );                      // Set the label font,
  labelsize( blt_pannel->wp_lbs );                      // ... the label size.
  textfont( blt_pannel->wp_stf );                       // Set the label font,
  textsize( blt_pannel->wp_sts );                       // ... the label size.
  range( (double) min, (double) max );                  // Set the minimum and maximum value.
  step( (double) stp );                                 // Set the step value.
  if (vl < min) vl = min; else if (vl > max) vl = max;
  value( (double) vl );                                 // Set the initial value.
  callback( (Callback*) cb_upn_change );                // Set the Common Pannel CallBack routine.
}


UPN_Float::~UPN_Float() { free( (void*)(this->label()) ); }



UPN_Fstring::UPN_Fstring( int x, int y, int w, int h, const char* lab, int sz, char* str ):
             Output( x, y, w, h, lab ) {

  type( UPN_D_STRING );                                 // Set the Item type.
  align( blt_pannel->wp_aln );                          // Set the required label alignement.
  labelfont( blt_pannel->wp_lbf );                      // Set the label font,
  labelsize( blt_pannel->wp_lbs );                      // ... the label size.
  textfont( blt_pannel->wp_stf );                       // Set the label font,
  textsize( blt_pannel->wp_sts );                       // ... the label size.
  value( str );                                         // Set the initial value.
}


UPN_Fstring::~UPN_Fstring() { free( (void*)(this->label()) ); }




UPN_D_Text::UPN_D_Text( int x, int y, int w, int h, const char* lab, char* txt ):
            TextDisplay( x, y, w, h, lab ) {
  type( UPN_D_TEXT );                                   // Set the Item type.
  align( blt_pannel->wp_aln );                          // Set the required label alignement.
  labelfont( blt_pannel->wp_lbf );                      // Set the label font,
  labelsize( blt_pannel->wp_lbs );                      // ... the label size.
  textfont( blt_pannel->wp_stf );                       // Set the label font,
  textsize( blt_pannel->wp_sts );                       // ... the label size.
  buffer()->text( txt );                                // Set the text buffer.
}


UPN_D_Text::~UPN_D_Text() { free( (void*)(this->label()) ); }




UPN_D_Frame::UPN_D_Frame( int x, int y, int w, int h, const char* lab, float lw, int st ):
            Group( x, y, w, h, lab ) {
  type( UPN_D_FRAME );                                  // Set the Item type.
  wpfr_lw = lw;                                         // Set the Frame Line width ...
  wpfr_st = st;                                         // ... and line style.
  align( blt_pannel->wp_aln );                          // Set the required label alignement.
  labelfont( blt_pannel->wp_lbf );                      // Set the label font,
  labelsize( blt_pannel->wp_lbs );                      // ... the label size.
}


UPN_D_Frame::~UPN_D_Frame() { free( (void*)(this->label()) ); }



void UPN_D_Frame::draw() {
  Group::draw();
  line_style( wpfr_st, wpfr_lw );
  newpath();
  addvertex(   0,   0 );
  addvertex( w(),   0 );
  addvertex( w(), h() );
  addvertex(   0, h() );
  addvertex(   0,   0 );
  closepath();
  strokepath();
  line_style( 0, 0 );
}


User_Pannel::~User_Pannel() {
  User_Pannel*       p0;
  User_Pannel*       p1;

  p0 = 0;
  p1 = hwp_Frst;
  while (p1&&(p1 != this)) { p0 = p1; p1 = p1->wp_nxt; } // Locate the pannel to remove it from the pannel list.
  if (p1) {                                             // When the Pannel is found.
    this->hide();
    free( (void*)(this->label()) );
    if (p1 == hwp_Last) hwp_Last = p0;                  // Remove the pannel from pannel list.
    if (wp_ide = UsrPanIde)                             // When we destroye the identifier top pannel, ...
       if (p0) UsrPanIde = p0->wp_ide;                  // ... return the top identifier to the previous one.
          else UsrPanIde = 0;
    if (p0) p0->wp_nxt = p1->wp_nxt;                    // Clean the pannel queue.
       else hwp_Frst = p1->wp_nxt;
  }
}


/*
int User_Pannel::handle( int e )
{
  switch (e) {
    case fltk::

    default:
      return 0;
  }
}
*/


static User_Pannel* Locate_Pannel( int ident ) {
  User_Pannel* p = hwp_Frst;

  while (p&&(p->wp_ide != ident)) p = p->wp_nxt;
  return p;
}



int Draw_Create_Pannel() {
  char*          title;
  int       ww,     hh;

  ww = (int) (d_xscale*Sdrw_Get_Float() + 0.5 );        // Get the sizes of the pannel in pixel.
  hh = (int) (d_yscale*Sdrw_Get_Float() + 0.5 );
  if (ww < 2*OK_X) ww = 2*OK_X;
  if (hh < 2*OK_Y) hh = 2*OK_Y;
  title  = Sdrw_Get_String_Tmp();                       // Get the Pannel title.
//fprintf( fmsg, " Create Pannel <%s> of (%d,%d)\n", title, ww, hh );
//fflush( fmsg );
  User_Pannel* p = new User_Pannel( ww, hh, title );    // Create the pannel.
  return p->wp_ide;                                     // Return the pannel identifier to the user.
}



int Draw_Pannel_Attr() {
// To define all pannel item attributs.

  int             iat, icd, pid;
  float                     fsz;
  char*                     nam;
  User_Pannel*              pan;

  static int kndtb[] = { 0, BOLD, ITALIC, BOLD_ITALIC };

  icd = Sdrw_Get_Int();                                 // Get the Attribute code index.
  pid = Sdrw_Get_Int();                                 // Get the pannel identifier.
  blt_pannel = pan = Locate_Pannel( pid );              // Locate the user pannel reference.
  if (pan) {
    switch (icd) {
      case 0:                                           // Alignement step.
        iat = Sdrw_Get_Int();                           // Get the alignement Attribute.
        if (!iat) iat = ALIGN_LEFT;                     // The default value is at Left.
        pan->wp_aln = iat&ALIGN_MASK;                   // Set as Alignement Mask.
        break;

      case 1:                                           // Label Font size.
      case 2:                                           // String Font size.
        fsz = Sdrw_Get_Float();                         // Get the requested font size.
        if (icd == 1) pan->Label_FSize( fsz );
                 else pan->String_FSize( fsz );
        break;

      case 3:                                           // Label Font Name.
      case 4:                                           // String Font Name.
        nam = Sdrw_Get_String_Tmp();                    // Get the Font Name.
        iat = Sdrw_Get_Int();                           // Get the Bold/italic Attribute.
        if (iat < 0) iat = 0;
                else if (iat > 3) iat = 3;
        if (icd == 3) pan->Label_Font( font( nam, kndtb[iat] ) );
                 else pan->String_Font( font( nam, kndtb[iat] ) );
        break;

      default: ;
    }
    return 0;                                           // Send the OK acknowledge.
  }
  else return -1;                                       // Send the Not found acknowledge.
}



int Draw_Pannel_Add() {
  int   ide, typ, ivl, imi, ima,
      i, sz,  xx,  yy,  ww,  hh;
  float      rvl, rmi, rma, rst;
  char*                     lab;
  char*                     str;
  char**                    etb;
  User_Pannel*              pan;
  Widget*                   wid;

  ide = Sdrw_Get_Int();                                 // Get the pannel identifier.
  xx = (int) (d_xscale*Sdrw_Get_Float() + 0.5 );        // Get the position of item in the pannel (in pixel).
  yy = (int) (d_yscale*Sdrw_Get_Float() + 0.5 );
  ww = (int) (d_xscale*Sdrw_Get_Float() + 0.5 );        // Get the sizes of item in pixel.
  hh = (int) (d_yscale*Sdrw_Get_Float() + 0.5 );
  lab = Sdrw_Get_String_Tmp();                          // Get the Item Label.
  typ = Sdrw_Get_Char() + UPN_ORG;                      // Get the item type to insert.
  blt_pannel = pan = Locate_Pannel( ide );              // Get the user pannel reference.
  if (pan) {
    yy = pan->h() - yy - hh;                            // Adapt to window up side Y origine.
    pan->begin();
    switch (typ) {
      case UPN_BOOL:
        ivl = Sdrw_Get_Int();                           // Get the initial Boolean value.
        wid = new UPN_Bool( xx, yy, ww, hh, lab, (bool) ivl );      // Create the Boolean item.
        break;

      case UPN_ENUM:
        ivl = Sdrw_Get_Int();                           // Get the Default enum/choice value.
        if (ivl < 0) ivl = 0;
        imi = Sdrw_Get_Int();                           // Get the minimum ennumerated value.
        ivl -= imi;                                     // Set the internal minimum value to aero.
        sz  = Sdrw_Get_Int();                           // Get the ennumerated list of values.
        if (ivl >= sz) ivl = sz - 1;
        etb = (char**) malloc( (sz+1)*sizeof( char* ) );
        for (i=0; i<sz; i++) {
          etb[i] = Sdrw_Get_String_Tmp();               // Get the list of name choice/ennum.
        }
        etb[sz] = (char*)0;
        wid = new UPN_Enum( xx, yy, ww, hh, lab, ivl, etb, imi );  // Create the Choice/enum item.
        for (i=0; i<sz; i++) free( etb[i] );
        free( etb );
        break;

      case UPN_STRING:
        str = Sdrw_Get_String_Tmp();                    // Get the default string value.
        sz  = Sdrw_Get_Int();                           // Get the string capacity.
        wid = new UPN_String( xx, yy, ww, hh, lab, sz, str );     // Create the String item.
        break;

      case UPN_INTEGER:
        ivl = Sdrw_Get_Int();                           // Get the Default integer value.
        imi = Sdrw_Get_Int();                           // Get the minimum value.
        ima = Sdrw_Get_Int();                           // Get the maximum value.
        wid = new UPN_Integer( xx, yy, ww, hh, lab, ivl, imi, ima );
        break;

      case UPN_FLOAT:
        rvl = Sdrw_Get_Float();                         // Get the Default Floating value.
        rmi = Sdrw_Get_Float();                         // Get the minimum value.
        rma = Sdrw_Get_Float();                         // Get the maximum value.
        rst = Sdrw_Get_Float();                         // Get the step value.
        wid = new UPN_Float( xx, yy, ww, hh, lab, rvl, rmi, rma, rst );
        break;

      case UPN_D_STRING:
        str = Sdrw_Get_String_Tmp();                    // Get the default string value.
        sz  = Sdrw_Get_Int();                           // Get the string capacity.
        wid = new UPN_Fstring( xx, yy, ww, hh, lab, sz, str );     // Create the Not editable String item.
        break;

      case UPN_D_TEXT:
        sz  = Sdrw_Get_Int();                           // Get the Text Size.
        str = (char*)malloc( sz+1 );                    // Allocate temporary room for the buffer.
        Sdrw_Read_Block( (Char *) str, sz );            // Read all the text.
        str[sz] = 0;
        wid = new UPN_D_Text( xx, yy, ww, hh, lab, str );
        break;

      case UPN_D_FRAME:
        rvl = Sdrw_Get_Float();                         // Get the Line width.
        ivl = Sdrw_Get_Int();                           // Get the style value.
        wid = new UPN_D_Frame( xx, yy, ww, hh, lab, rvl, ivl );
        break;

      default: ;
    }
    pan->wp_cnt++;
    pan->end();
    return pan->wp_cnt;                                 // Send the OK acknowledge.
  }
  else return -1;                                       // Send the Not found acknowledge.
}




int Draw_Pannel_Change() {
  User_Pannel*              pan;
  Widget*                     o;
  int             idx, ivl, len;
  char*                     tmp;

  blt_pannel = (User_Pannel*)0;
  pan = Locate_Pannel( Sdrw_Get_Int() );                // Get the user pannel reference.
  if (pan) {
    idx = Sdrw_Get_Int() + 1;                           // Get the item index.
    if ((idx > 1)&&(idx <= pan->children())) {          // idx is in the correct range.
      o = pan->child( idx );                            // Get the child reference.
      switch (o->type()) {                              // Following the nature of item ...
        case UPN_BOOL:
          ((CheckButton*)o)->value( (bool)(Sdrw_Get_Char()==1) );   // Set a boolean value.
          break;

        case UPN_ENUM:
          ivl = Sdrw_Get_Int() - ((UPN_Enum*)o)->wpe_mi;
          len = ((UPN_Enum*)o)->wpe_sz;
          if (ivl < 0) ivl = 0;
                  else if (ivl >= len) ivl = len - 1;   // Set the value inside the limits.
          ((UPN_Enum*)o)->value( ivl );                 // Send a selected ennum/choice number.
          break;

        case UPN_STRING:
          ((Input*)o)->value( tmp = Sdrw_Get_String_Tmp() );        // Get and set a string value.
          free( tmp );
          break;

        case UPN_INTEGER:
        case FloatInput::INT:
          ((ValueInput*)o)->value( (double) Sdrw_Get_Int() );       // Get and set an integer value.
          break;

        case UPN_FLOAT:
        case FloatInput::FLOAT:
          ((ValueInput*)o)->value( (double) Sdrw_Get_Float() );     // Get and set a floating value.
          break;

        case UPN_D_STRING:
          ((Output*)o)->value( tmp = Sdrw_Get_String_Tmp() );       // Set the new string value.
          free( tmp );
          break;

        case UPN_D_TEXT:
          len = Sdrw_Get_Int();                         // Get the Text Size.
          tmp = (char*)malloc( len + 1 );               // Allocate temporary room for the buffer.
          Sdrw_Read_Block( (Char *) tmp, len );         // Read all the text.
          ((TextDisplay*)o)->buffer()->text( tmp );     // Change the text  to display.
          free( tmp );                                  // Free the temporary text memory.
          break;
      }
      if (pan->shown()) pan->redraw();                  // Update the pannel when it is shown.
      return 0;                                         // Normal returned value.
    }
    else return -2;                                     // Return bad item identifie.
  }
  else return -1;                                       // Return bad Pannel identifier.
}



int Draw_Pannel_EnaDis() {
  User_Pannel*              pan;
  Widget*                     o;
  int                       idx;

  blt_pannel = (User_Pannel*)0;
  pan = Locate_Pannel( Sdrw_Get_Int() );                // Get the user pannel reference.
  if (pan) {
    idx = Sdrw_Get_Int() + 1;                           // Get the item index.
    if ((idx > 1)&&(idx <= pan->children())) {          // idx is in the correct range.
      o = pan->child( idx );                            // Get the child reference.
      if (Sdrw_Get_Char()) o->activate();
                      else o->deactivate();
      return 0;                                         // Normal returned value.
    }
    else return -2;                                     // Return bad item identifie.
  }
  else return -1;                                       // Return bad Pannel identifier.
}



int Draw_Open_Pannel( int ide ) {
  User_Pannel*              pan;

  blt_pannel = (User_Pannel*)0;
  pan = Locate_Pannel( ide );                           // Get the user pannel reference.
  if (pan) {  pan->show(); Sdrw_Put_Int( 0 ); }
      else Sdrw_Put_Int( -1 );                          // Not found Pannel.
  return 0;                                             // Send the OK acknowledge.
}



int Draw_Close_Pannel( int ide ) {
  User_Pannel*              pan;

  blt_pannel = (User_Pannel*)0;
  pan = Locate_Pannel( ide );                           // Get the user pannel reference.
  if (pan) {  pan->hide(); Sdrw_Put_Int( 0 ); }
      else Sdrw_Put_Int( -1 );                          // Not found Pannel.
  return 0;                                             // Send the OK acknowledge.
}



int Draw_Put_Pannel_Values() {
// Put Pannel values to the server from the User Program.
  User_Pannel*              pan;
  Widget*                     o;
  int          i, val, siz, len;
  char*                     tmp;

  blt_pannel = (User_Pannel*)0;
  pan = Locate_Pannel( Sdrw_Get_Int() );                // Get the user pannel reference.
  if (pan) {                                            // When the Pannel is found.
    siz = pan->children();                              // Get the number of item in the pannel.
    pan->wp_cha = 0;                                    // Clear the Change flag.
    for(i=2; i<siz; i++) {                              // Loop on all children (skip the OK button).
      o = pan->child( i );                              // Get the i'th child.
      switch (o->type()) {                              // Following the type of item:
        case UPN_BOOL:
          ((CheckButton*)o)->value( (bool)(Sdrw_Get_Char()==1) );       // Set a boolean value.
          break;

        case UPN_ENUM:
          val = Sdrw_Get_Int() - ((UPN_Enum*)o)->wpe_mi;
          len = ((UPN_Enum*)o)->wpe_sz;
          if (val < 0) val = 0;
                  else if (val >= len) val = len - 1;   // Set the value inside the limits.
          ((UPN_Enum*)o)->value( val );                 // Send a selected ennum/choice number.
          break;

        case UPN_STRING:
          ((Input*)o)->value( tmp = Sdrw_Get_String_Tmp() );            // Get and set a string value.
          free( tmp );
          break;

        case UPN_INTEGER:
        case FloatInput::INT:
          ((ValueInput*)o)->value( (double) Sdrw_Get_Int() );           // Get and set an integer value.
          break;

        case UPN_FLOAT:
        case FloatInput::FLOAT:
          ((ValueInput*)o)->value( (double) Sdrw_Get_Float() );         // Get and set a floating value.
          break;
      }
    }
    if (pan->shown()) pan->redraw();                    // Update the pannel when it is shown.
    return 0;                                           // Send the OK acknowledge.
  }
  else return -1;                                       // Not found Pannel acknowledge.
}



int Draw_Get_Pannel_Values() {
// Get Pannel value to the User Program from the Server.
  User_Pannel*              pan;
  Widget*                     o;
  int                i, iv, siz;
  float                      vl;

  blt_pannel = (User_Pannel*)0;
  pan = Locate_Pannel( Sdrw_Get_Int() );                // Get the user pannel reference.
  if (pan) {                                            // When the Pannel is found.
    siz = pan->children();                              // Get the number of item in the pannel.
    Sdrw_Put_Int( (pan->wp_cha)?1:0 );                  // Send the change pannel flag.
    for(i=2; i<siz; i++) {                              // Loop on all children (skip the OK button).
      o = pan->child( i );                              // Get the i'th child.
      switch (o->type()) {                              // Following the type of item:
        case UPN_BOOL:
          Sdrw_Put_Char( ((CheckButton*)o)->value() );  // Send a boolean value.
          break;

        case UPN_ENUM:
          Sdrw_Put_Int( ((Choice*)o)->value() + ((UPN_Enum*)o)->wpe_mi );    // Send a selected ennum/choice number.
          break;

        case UPN_STRING:
          Sdrw_Put_String( ((Input*)o)->value(), 0 );   // Send a string value
          break;

        case UPN_INTEGER:
        case FloatInput::INT:
          vl = ((ValueInput*)o)->value();
          if (vl >= 0) iv = (int)(vl + 0.5); else iv = (int)(vl - 0.5);
          Sdrw_Put_Int( iv );                           // Send an integer value.
          break;

        case UPN_FLOAT:
        case FloatInput::FLOAT:
          Sdrw_Put_Float( ((ValueInput*)o)->value() );  // Send a floating value.
          break;
      }
    }
    pan->wp_cha = 0;                                    // Clear the Change flag.
    return 0;                                           // Send the OK acknowledge.
  }
  else return -1;                                       // Not found Pannel acknowledge.
}



int Draw_Pannel_Request( int ide )
{
  User_Pannel*              pan;
  int                       ist;

  blt_pannel = (User_Pannel*)0;

  pan = Locate_Pannel( ide );                           // Get the user pannel reference.
  if (pan) {                                            // When the Pannel is found.
    pan->wp_bok->label( Msg_Oky );                      // Set the label "OK" for request.
    pan->wp_bok->callback( (Callback*) cb_OKR_Pannel, (void*)pan );  // Change Callback to OK Action.
//  pan->wp_bok->activate();                            // Activate the OK button.
    pan->wp_can->activate();                            // Activate the Cancel button.
    pan->wp_req = 1;
    pan->wp_bok->shortcut( 0xff0d );                    // Return shortcut key for "OK".
    pan->show();                                        // Display the pannel.
    ist = pan->exec();                                  // Perform an exec of pannel request.
    if (ist) ist = pan->wp_ret;                         // When not close pannel, return the code.
       else  ist = -2;                                  // Close Pannel => -2.
    pan->wp_req = 0;
    pan->wp_can->deactivate();                          // De-Activate the Cancel button.
    pan->wp_bok->shortcut( 0xff1b );                    // Set Escape key shortcut for "Apply".
    pan->wp_bok->label( Msg_App );                      // Restore the label "Apply".
    pan->wp_bok->callback( (Callback*) cb_Apply_Pannel, (void*)pan );  // Change Callback to Apply action
    return ist;
  }
  return -1;                                            // Return the Uknown pannel status.
}



int Draw_Pannel_Destroy( int ide )
{
  User_Pannel*              pan;

  blt_pannel = (User_Pannel*)0;
  pan = Locate_Pannel( Sdrw_Get_Int() );                // Get the user pannel reference.
  if (pan) { 
    pan->~User_Pannel();                                // Destroy the pannel.
  }
  return 0;
}



int Draw_Pannel_Destroy_All()
{
  User_Pannel* p = hwp_Frst;
  User_Pannel* q;

  blt_pannel = (User_Pannel*)0;
  while (p) {
    q = p;
    p = p->wp_nxt;
    q->~User_Pannel();                                  // Destroy each pannel.
  }
  hwp_Frst = (User_Pannel*)0;
  hwp_Last = (User_Pannel*)0;
  return 0;
}


int Draw_Pannel_Dispatch( int pnlcd )
{
  int retcd;

  switch (pnlcd) {
	case cd_pannel_attr:
	  retcd = Draw_Pannel_Attr();
	break;

	case cd_pannel_create:
	  retcd = Draw_Create_Pannel();
	break;

	case cd_pannel_add:
	  retcd = Draw_Pannel_Add();
	break;

	case cd_pannel_enadis:
	  retcd = Draw_Pannel_EnaDis();
	break;

	case cd_pannel_change:
	  retcd = Draw_Pannel_Change();
	break;

	case cd_pannel_open:
	  retcd = Draw_Open_Pannel( Sdrw_Get_Int() );
	break;

	case cd_pannel_close:
	  retcd = Draw_Close_Pannel( Sdrw_Get_Int() );
	break;

	case cd_pannel_put:
	  retcd = Draw_Put_Pannel_Values();
	break;

	case cd_pannel_get:
	  retcd = Draw_Get_Pannel_Values();
	break;

	case cd_pannel_del:
	  retcd = Draw_Pannel_Destroy( Sdrw_Get_Int() );
	break;

	case cd_pannel_req:
      Drwgl_PanChg = 0;                         // Set Flag for no pannel interaction.
	  retcd = Draw_Pannel_Request( Sdrw_Get_Int() );
      Drwgl_PanChg = 0;                         // Reset Flag for no pannel interaction.
	break;

    default:
      fprintf( fmsg, " Unknown Pannel code %d\n", pnlcd );
      fflush( fmsg );
    retcd = -99;
  }
  return retcd;
}
