// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *            F L T K / D R A W   -   S E R V E R   M O D U L E             *
// *                                                                          *
// *              Version  1.4-C for Draw Library Level V 2.4 A               *
// *                                                                          *
// *        (Draw interface for FLTK/OPENGL function and procedures)          *
// *                                                                          *
// *                                                                          *
// *         (Draw interface for complex not graphical user input)            *
// *                                                                          *
// *                                  by                                      *
// *                                                                          *
// *            Pierre Wolfers, Laboratoire de Cristallographie               *
// *                                                                          *
// *            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
// *                                                                          *
// *                       F 38042 GRENOBLE CEDEX 9                           *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



#include <fltk/run.h>
#include <fltk/Menu.h>
#include <fltk/Group.h>
#include <fltk/Divider.h>


#include "Server_UI.h"
#include "Server_UsrInput.h"




extern Draw_GL_UI* srvw0;



using namespace fltk;


//==>>> Prepare The Menu structure as Required by User Task <<<========





void cb_User_Req(Item* o, void* v) {
  DrwSrv_Menu_Manager( m_Usereq + ((int*)v)[0] );
}



#define    Max_STACK   64                       // Size of Menu Stack.
#define    Max_ITEMS  256                       // Maximum number of User Item.
#define    Max_ENTRY  512                       // Maximum number of Item (User + Standard).


typedef struct {
                       Group*   S_Menu;         // Saved Menu Reference.
                       int      S_Size,         // Saved Menu Length.
                                S_Posi,         // Saved Menu Position.
                                S_Lmax;         // Maximum of LAbel Entry length.
               } S_Cntx;


static S_Cntx         M_Stk[Max_STACK];         // Stack of Save Scanned menu.

static int            M_Val[Max_ITEMS];         // Array of Menu Item Return Item.
static char           M_Att[Max_ITEMS];         // Array of Menu for User Item Flags.

#if 0
static Widget*        M_ETB[Max_ENTRY];         // Table of All Entry address (Ended by a NULL Pointer).
static char           M_FTB[Max_ENTRY];         // Related Flag table.
#endif

static int            menu_usr_cnt;             // Count of standard + user menu entries.


fltk::Widget*         DrwSrv_MWtb[Max_Menu_Entry];
int                   DrwSrv_WFtb[Max_Menu_Entry];



/*
static int test = 1;

static void show_entries()
{ Widget* p;
  printf( " menu entry list (%d)\n", menu_usr_cnt );
  for (int i=0;i<menu_usr_cnt;i++) {
    p = DrwSrv_MWtb[i];
    if (p) {
      if (i<m_FirstUser) {
        printf( " %d/ Standard Entry \"%s\"\n", i, p->label() );
      } else {
        printf( " %d/ User     Entry \"%s\"\n", i, p->label() );
      }
    }
  }
}
*/


void DrwGL_SenSens( int cod, int flg ) {
  fltk::lock();
  DrwSrv_MWtb[cod]->activate( (flg)?1:0 );
  fltk::unlock();
}

void DrwGL_Sensibility( int flg )
{
  static int flg_on[]  = { m_Save,     m_Print,    m_Resume,   m_Help,
                           m_Dinfo,    m_Grid,
// *** These following request can be usefull during a rtask run time. ***
//                         m_Zoom,     m_Scale,    m_UnZoom,   m_Reload,   m_Refresh,
                           0
                         };
  int i = 0;

  while (flg_on[i]) DrwGL_SenSens( flg_on[i++], flg );  // Enable/Disable the In-List Menu Functions.
  for(int i = m_FirstUser;i<menu_usr_cnt;i++)
                              DrwGL_SenSens( i, flg );  // Enable/Disable the User Dialog Functions.
  if (Drwgl_astpmod) DrwGL_SenSens( m_AStop, flg );     // Enable or Disable the Animation stop function.
  DrwGL_SenSens( m_ChView, (Drwgl_ViewMat&&flg) );      // Enable/Disable the Change view (Orientation) Function.

}



void DrwGL_Usr_Menu_Init()
{ /* Routine to prepare the Menu structure by using user information */
  int cd, fa, fv, Menu_Req;
  unsigned              ky;
  char*               name;

  menu_usr_cnt     =       m_FirstUser;

  Menu_Req = (Drwgl_usr_request&SERVER_DO_USER_MENUS)?1:0;

  if (Menu_Req) {
    Group*   M_Cur =  srvw0->Draw_Menu;         // Set the standard menu as Opened.
    Widget*  M_Ent = M_Cur->child( 0 );
    int      M_Stp =                -1;         // Initialize the stack to Empty.
    int      M_Siz = M_Cur->children();         // Get the Standard Menu Length.
    int      M_Skp =                 0;         // We begin by the first Item.
    int      M_Nen =                -1;         // Entry Number for Dialog Return Value.
    int      M_Flg =                 0;         // Current Flags Word.

    // Now We manage the User Menu Specifications.
    //    Mstd_Menu -> to  Standard Bar_Menu.
    do { // Loop on the Menu Request.
      if (M_Siz) M_Ent = M_Cur->child( M_Skp );
      Sdrw_Put_Code( cd_continue );             // Send acknowledge to user task.
      Sdrw_Dialog_Request();                    // Send request for next and get answerd.
      cd =         Sdrw_Get_Char();             // Get the Menu code operator.
      switch (cd) {
        case 0: // Close Current Menu.
          if (M_Stp < 0) {
            if (M_Cur) return;
            else {
              fprintf( fmsg, " Draw_server Error : User Menu Init Stack Underflow.\n" );
              fflush( fmsg );
              exit( 2 );
            }
          } else {
            M_Cur = M_Stk[M_Stp].S_Menu;
            M_Siz = M_Stk[M_Stp].S_Size;
            M_Skp = M_Stk[M_Stp].S_Posi;
            M_Stp--;
          }
        break;

        case 1: // Open the Current Standard Menu
          if (M_Stp < Max_STACK) M_Stp++;
          else { fprintf( fmsg, " Draw_server Error : User Menu Init Stack Overflow.\n" );
                 fflush( fmsg );
               }
          M_Stk[M_Stp].S_Menu = M_Cur;

          M_Stk[M_Stp].S_Size = M_Siz;
          M_Stk[M_Stp].S_Posi = M_Skp + 1;
          M_Cur = (Group*) M_Cur->child( M_Skp );
          M_Siz = M_Cur->children();
          if (M_Siz) M_Ent = M_Cur->child( 0 );
                else M_Ent = (Widget*)NULL;
          M_Skp = 0;
        break;

        case 2: // Skip <n> entry(ies).
          fa = Sdrw_Get_Char(); if (!fa) fa = 1;
          M_Skp += fa;
          M_Ent = M_Cur->child( M_Skp );
          if (M_Skp > M_Siz) M_Skp = M_Siz;
        break;

        case 3: // New Menu to Insert.
          name = Sdrw_Get_String_Tmp();
          fa   = Sdrw_Get_Char();
          fv   = Sdrw_Get_Char();
          M_Ent = (Widget*) new ItemGroup( name );
          if (fa) M_Ent->flags( INACTIVE );
          if (fv) M_Ent->flags( INVISIBLE );
          ((ItemGroup*)M_Cur)->insert( *M_Ent, M_Skp );
          if (M_Ent) {
            if (M_Stp < Max_STACK) M_Stp++;
            else { fprintf( fmsg, " Draw_server Error : User Menu Init Stack Overflow.\n" );
                   fclose( fmsg );
                   exit( 2 );
                 }
            M_Stk[M_Stp].S_Menu = M_Cur;
            M_Stk[M_Stp].S_Size = M_Siz + 1;
            M_Stk[M_Stp].S_Posi = M_Skp + 1;
            M_Skp = 0;
            M_Siz = 0;
            M_Cur = (Group*) M_Ent;
            M_Ent = NULL;
          } else { fprintf( fmsg, " Draw_server Error : User Sub-Menu \"%s\" cannot be created.\n", name );
                   fclose( fmsg );
                   exit( 2 );
                 }
        break;

        case 4: // Create a new Menu Entry.
          name = Sdrw_Get_String_Tmp();
          if (sdrw_read_left) ky = Sdrw_Get_Int();
                         else ky = 0;
          fa   = Sdrw_Get_Char();
          fv   = Sdrw_Get_Char();
          M_Flg = 0;
          if (fa) M_Flg  =  INACTIVE;
          if (fv) M_Flg  = INVISIBLE;
          if (M_Nen >= Max_ITEMS) {
            fprintf( fmsg, " Draw_server Error : Too Many User Item (Maximum is %d).\n", Max_ITEMS );
            fclose( fmsg );
            exit( 2 );
          } else M_Nen++;
          M_Ent = (Widget*) new Item( name, ky, (Callback*)cb_User_Req, (void*)&(M_Val[M_Nen]), M_Flg );
          ((ItemGroup*)M_Cur)->insert( *M_Ent, M_Skp );
          if (M_Ent) {
            M_Val[M_Nen] = M_Nen+1;
            M_Att[M_Nen] = (fa)?1:0 + (fv)?2:0; // Set the inactive and invisible flag.
            DrwSrv_MWtb[menu_usr_cnt]   = M_Ent; 
            DrwSrv_WFtb[menu_usr_cnt++] = 128 + M_Att[M_Nen];
            M_Skp++;
          } else {
            fprintf( fmsg, " Draw_server Error : User Menu Entry \"%s\" cannot be created.\n", name );
            fclose( fmsg );
            exit( 2 );
          }
        break;

        case 5: // Create Menu Bar.
          M_Ent = (Widget*) new Divider();
          if (M_Ent) ((ItemGroup*)M_Cur)->insert( *M_Ent, M_Skp++ );
          else {
            fprintf( fmsg, " Draw_server Error : User Menu Divider cannot be created.\n" );
            fflush( fmsg );
          }
        break;

        default: ;
      }
    } while (cd >= 0);
  }
}





void DrwSrv_Menu_Manager( int icd )
{
  static Draw_Ptr Grid_Seg = NULL;

  // Default: route menu and toolbar commands here

//if (test) { test = 0; show_entries(); }

//  if (reqflg||Spc_Cmd||(icd == m_Refresh)||(icd == m_AStop))
//if (reqflg||(icd == m_Refresh)||(icd == m_AStop))
  switch (icd) {
    case m_Help:
      fltk::alert(" FLTK DRAW Server : Not Implemented function Help.\n");
    break;

    case m_Exit:
      DrwSrv_Exit( 1 );
    break;

    case m_Resume:
      reqflg        =             0;            // Clear the Dialog mod.
      Drwgl_Dstatus =             0;            // Return the resume clic status.
      DrwGL_Sensibility( 0 );                   // Disable not run sensible function.
      Drwgl_Proceed = drwgl_nothing;            // Set the "running task" status.
      DrwSrv_End_Request();                     // Return to task exchange process.
    break;

    case m_AStop:
      if (Drwgl_astpmod) Drwgl_astpstate = Drwgl_astpmod;
    break;

    case m_Grid:
      if (!Grid_Seg)
        Grid_Seg = Draw_GPlot_Grid();
      else {
        Draw_Destroye( Grid_Seg );
        Grid_Seg = NULL;
      }
      srvw0->w_draw->redraw();
    break;

    case m_ChView:                              // Explicite View_Change Request by Dialog.
      if (Drwgl_ViewMat) {
        Drwgl_zoomview = 1;                     // Set implicite Change_View mode.
        Drwgl_Input = Drwgl_viewflg;            // Set the View_change (view, move or anonymous move) Request.
        reqflg = 2;                             // Flags the View_Change/Dialog request.
        srvw0->w_draw->Draw_Input_Request();
      }
    break;

    case m_Print:                               // Output a temporary Image file and print it.
//    fltk::alert(" FLTK DRAW Server : Not Implemented function Print.\n");
      DrwGL_Save_Image( 1 );                    // Output a temporary image file and print it.
    break;

    case m_Save:                                // Output an Image MAP File.
//    fltk::alert(" FLTK DRAW Server : Not Implemented function Save.\n");
      DrwGL_Save_Image( 0 );                    // Output the image file.
    break;

    case m_Zoom:                                // Explicite Zoom Request by Dialog.
      Drwgl_zoomview = 0;                       // Set Explicite Zoom mode.
      Drwgl_Input = drwgl_zoom;                 // Set The Request Kind.
      reqflg = 2;                               // Flags the Zoom/Dialog request.
      srvw0->w_draw->Draw_Input_Request();
    break;

    case m_UnZoom:                              // Explicite Annul of Last Zoom Request.
      dw_cxmin = dw_zxmin; dw_cxmax = dw_zxmax;
      dw_cymin = dw_zymin; dw_cymax = dw_zymax;
      dw_cwsx  =  dw_zwsx; dw_cwsy  =  dw_zwsy;
      dw_cwpx  =  dw_zwpx; dw_cwpy  =  dw_zwpy;

      cxy_scale   =   zxy_scale;                // Restore the Current Scales
      efcxy_scale = efzxy_scale;
      srvw0->w_draw->Draw_ScrollEdit();         // Reset the original scroll bar state.
      srvw0->w_draw->redraw();                  // Restore the original display.
    break;

    case m_Scale:
      {
        double sca, szx, szy, def;

        Drwgl_Input = drwgl_value;
        def = cxy_scale;
        Drwgl_valmin = (float) pow( 10.0, ((int) (log10( def ) + 0.5) - 1));
        Drwgl_valmax = Drwgl_valmin*100.0;

        Drwgl_status = Draw_GetVal( (double)Drwgl_valmin, (double)Drwgl_valmax,
                                    (double)Drwgl_valmin/100.0, def, "Scale (Log)", 1 );

        if (Drwgl_status <= 0) break;

        sca = cxy_scale/def;
        szx = dw_cwsx*sca;
        szy = dw_cwsy*sca;

        Drwgl_xcoord = dw_cwpx - szx; Drwgl_xcurr = dw_cwpx + szx;
        Drwgl_ycoord = dw_cwpy - szy; Drwgl_ycurr = dw_cwpy + szy;

        srvw0->w_draw->Draw_Scale( 0 );
        srvw0->w_draw->redraw();
        break;
      }

    case m_Refresh:
      srvw0->w_draw->redraw();
    break;

    case m_Reload:
      dw_cxmin = dw_zxmin = dw_sxmin; dw_cxmax = dw_zxmax = dw_sxmax;
      dw_cymin = dw_zymin = dw_symin; dw_cymax = dw_zymax = dw_symax;
      dw_cwsx  =  dw_zwsx =  dw_swsx; dw_cwsy  =  dw_zwsy =  dw_swsy;
      dw_cwpx  =  dw_zwpx =  dw_swpx; dw_cwpy  =  dw_zwpy =  dw_swpy;

      cxy_scale   = zxy_scale   =   sxy_scale;  // Restore the Current Scales
      efcxy_scale = efzxy_scale = efsxy_scale;
      srvw0->w_draw->Draw_ScrollEdit();         // Reset the original scroll bar state.
      srvw0->w_draw->redraw();                  // Restore the original display.
    break;

    default:
      if (icd > m_Usereq ) {
        reqflg        =              0;         // Clear the Dialog mod.
        Drwgl_Dstatus = icd - m_Usereq;         // Return the selected clic status.
        DrwGL_Sensibility( 0 );                 // Disable not run sensible function.
        Drwgl_Proceed =  drwgl_nothing;         // Set the "running task" status.
        DrwSrv_End_Request();                   // Return to task exchange process.
      }
  } // else fltk::alert(" FLTK DRAW Server : User Process busy, Wait Please.\n");
}




