// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *            F L T K / D R A W   -   S E R V E R   M O D U L E             *
// *                                                                          *
// *              Version  1.5-A for Draw Library Level V 2.5 A               *
// *                                                                          *
// *        (Draw interface for FLTK/OPENGL function and procedures)          *
// *                                                                          *
// *                  * * *   M a i n     M o d u l e   * * *                 *
// *                                   4                                       *
// *                                                                          *
// *                                  by                                      *
// *                                                                          *
// *                                                                          *
// *            Pierre Wolfers, Laboratoire de Cristallographie               *
// *                                                                          *
// *            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
// *                                                                          *
// *                       F 38042 GRENOBLE CEDEX 9                           *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


#include <unistd.h>

#include <fltk/run.h>
//#include <fltk/visual.h>
#include <fltk/Threads.h>

#include "Server_UI.h"


Draw_GL_UI* srvw0;


int main(int argc, char **argv)
{
  int rstatus;

  fltk::lock();                                 // ALWAYS call before any fltk calls

  Sdrw_Pre_Init();                              // Pre Init Setting to perform before the current setting.

  // Edit The Draw Server Name, Version  and Date Message.
  fprintf( fmsg, " %s %s %s\n", SERVER_NAME, SERVER_VERSION, SERVER_DATE );
  fflush( fmsg );

  Sdrw_Params_Setting();                        // Get information from the current setup files.

  Sdrw_Init();                                  // Perform the Basic Draw Init.

  Sdrw_Open_Gate( argc, argv );                 // Init the Pipe I/O channels.

//fprintf( fmsg, " Open Gate OK\n" );           // Debug Message.
//fflush( fmsg );

  Draw_Exchange_Init();                         // Initiate the Client Server Request.

//fprintf( fmsg, " Create Window of (%d*%d) with name \"%s\"\n", dt_rx, dt_ry, Drwgl_taskname );
//fflush( fmsg );

  srvw0 = new Draw_GL_UI( dt_rx, dt_ry, Drwgl_taskname );  // Create the Draw_server Class.

  DrwGL_Usr_Menu_Init();                        // Initialize the Main Menu Structures.
  DrwGL_Prev_Init();                            // First step DrawGL Manager initialization */

  srvw0->show();                                // Display the Draw_Server Window.

// Initial global objects.
// fltk::visual(fltk::DOUBLE_BUFFER|fltk::RGB_COLOR|fltk::ALPHA_BUFFER|fltk::DEPTH_BUFFER|fltk::DOUBLE_BUFFER);

  Draw_Extern_Init();                           // Complete User Init (Send Paper size and unit flag).

  DrwSrv_Start_Exchange();                      // Start the User Pipe Thread.

  DrwSrv_Start_Timer();                         // Start the Timer Thread.

//fprintf( fmsg, " User Exchange thread started.\n" );
//fflush( fmsg );

/*
  while (fltk::Window::first()) {
    fltk::wait( 1e20f );
#if (!defined( _WIN32 )) || defined( __CYGWIN__ )
    usleep( 1000 );
#endif
  }
*/

  rstatus = fltk::run();                        // Event Loop.

  fprintf( fmsg, "Draw_Server Exit.\n" );
  fclose( fmsg );

  return Drwgl_Dstatus;
}


//
// End of Draw_Server Main function.
//
