/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*          F L T K / D R A W   -   S E R V E R   M O D U L E            *
*                                                                       *
*            Version  1.4-C for Draw Library Level V 2.4 A               *
*                                                                       *
*      (Draw interface for FLTK/OPENGL function and procedures)         *
*                                                                       *
*                                                                       *
*                               by                                      *
*                                                                       *
*          Pierre Wolfers, Laboratoire de Cristallographie              *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/

/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/

/***********************************************************************/
/**                                                                   **/
/**              To Set all Graphic Devices parameters                **/
/**                                                                   **/
/***********************************************************************/


#include <unistd.h>

#include "Server_Env.h"

/* Define the default name for the Draw_Server setting File. */
#define   DEF_SETFILE       "draw_server.draw_setting"

/* Define the path to search the default Draw_Server setting File. */
#if (!defined( _WIN32)) || defined(__CYGWIN__)
#  define   SEARCH_PATH     ".;/etc;/usr/local/etc"
#else
#  define   SEARCH_PATH     ".;C:\\Program Files\\Draw_Env\\etc"
#endif

/* Define the Device/Logical(=env. var.) separator */
#define   PATH_SEPAR        ';'
#define   DEV_SEPAR         ':'

/* Define the maximum string size */
#define   MAX_STR           256


/* Define the directory separator */
#if (!defined( _WIN32)) || defined(__CYGWIN__)
/*   Unix/Linux/Cygwin Directory separator */
# define DIR_SEPAR         '/'
#else
/*   Windows Directory separator */
# define DIR_SEPAR         '\\'
#endif


// #define DEBUG


typedef enum { alpha,digit,period,comma,semicol,colon,addo,subo,mulo,divo,powo,
               quot,lpar,rpar,equo,oth,eofo,eolno,spacech,baseo,
               clto,cgto,ando,commento,lbra,rbra
             } chcat;



/* Item attribute definitions */


typedef enum { identsy, stringsy, integersy, floatsy, listsy,
               ct_stringsy, ct_integersy, ct_floatsy,
               commasy, semicolonsy, equalsy,
               separatorsy,
               eolnsy, eofsy, nothing
             } symbol;



/* List element record definition */

typedef struct { symbol  vtype;          /* Type of value */
                 int     vsize;          /* Size for array */
                 void *  vaddr;          /* Address where deposite (or value for constante) */
               } lstlm;


/* Identifier(s) definitions */


typedef struct { const char   * idname; /* Name of the identifier */
                 lstlm          vdescr; /* Related descriptor */
               } ident;



/* Item record definition (typically set by INSYMBOL) */


typedef struct { symbol             sy;  /* Type of item */
                 ident *          ptid;  /* Pointer to identifier */
                 float            fltv;  /* Read float value */
                 int              intv,  /* Read integer value */
                                  strl;  /*...and related length */
                 char strv[MAXLINESZ+1]; /* String/Identifier value... */
               } item;


/* Define an array of identifier pointers */

#define AD( v ) ((void *)(&v))


#if 0
static int   * dr_tb_rxy[]    = {       &dr_rx,       &dr_ry }; /* Indirection tables for lists of value ... */
static float * d_tb_brd_xy[]  = { &d_borders_x, &d_borders_y }; /* ... in list of individual parameters */
static float * ds_tb_rxy[]    = {       &ds_rx,       &ds_ry };
#endif

static lstlm drtbxy[] = { {  integersy,   1,           AD( dr_rx ) },  /* Pseudo Record Parameter "int dr_rx, dr_ry;" */
                          {  integersy,   1,           AD( dr_ry ) },
                          {    nothing,   0,                     0 }
                        },

             dtbord[] = { {    floatsy,   1,     AD( d_borders_x ) },  /* Pseudo Record Parameter "float d_borders_x, d_borders_y;" */
                          {    floatsy,   1,     AD( d_borders_y ) },
                          {    nothing,   0,                     0 }
                        },

             dstbxy[] = { {    floatsy,   1,           AD( ds_rx ) },  /* Pseudo Record Parameter "float ds_x, ds_y;" */
                          {    floatsy,   1,           AD( ds_ry ) },
                          {    nothing,   0,                     0 }
                        },

             coltab[] = { {    floatsy,   3,   AD( draw_srccoltb ) },
                          {    nothing,   3,                     0 }   /* Increment of array index = 3 (one array for all) */
                        },

             fntlst[] = { {   stringsy,   1,  AD( draw_fontnamtb ) },  /* Array of Pseudo Record Parameter for font table */
                          {  integersy,   1,  AD( draw_fontstyle ) },
                          {    nothing,   1,                     0 }   /* Increment of array index = 1 (array for each field) */
                        },

             font_0[] = { {   stringsy,   1, AD(draw_fontnamtb[0]) },
                          {  integersy,   1, AD(draw_fontstyle[0]) },
                          {    nothing,   0,                     0 }
                        };

static int   fnt_bitmap    =   FTGL_BITMAP,     /* These values must be set equal to FtMan.cxx ... */
             fnt_pixmap    =   FTGL_PIXMAP,     /* ... equivalent constante FTGL_* defined in  ... */
             fnt_outline   =  FTGL_OUTLINE,     /* ... the header file Server_Env.h . */
             fnt_polygon   =  FTGL_POLYGON,
             fnt_extrude   =  FTGL_EXTRUDE,
             fnt_texture   =  FTGL_TEXTURE;


static ident wsidtab[] = {
                {       "F_BITMAP", { ct_integersy, 1, AD( fnt_bitmap )        } },     /* Define the font style identifier */
                {       "F_PIXMAP", { ct_integersy, 1, AD( fnt_pixmap )        } },
                {      "F_OUTLINE", { ct_integersy, 1, AD( fnt_outline )       } },
                {      "F_POLYGON", { ct_integersy, 1, AD( fnt_polygon )       } },
                {      "F_EXTRUDE", { ct_integersy, 1, AD( fnt_extrude )       } },
                {      "F_TEXTURE", { ct_integersy, 1, AD( fnt_texture )       } },

                {    "COLOR_FLAGS", {    integersy, 1, AD( d_color_flags )     } },     /* Flag for color Screen */

                {      "SCR_WIDTH", {     floatsy,  1, AD( d_width )           } },     /* Screen size in Cm. */
                {     "SCR_HEIGHT", {     floatsy,  1, AD( d_height )          } },
                { "SCR_RESOLUTION", {      listsy,  1, AD( drtbxy )            } },     /* Screen resolution (2 values) in pixels */
                { "HCP_RESOLUTION", {   integersy,  1, AD( d_hc_resolution )   } },     /* Hard copy resolution multiplier */
                {      "WIN_SIZES", {      listsy,  1, AD( dstbxy )            } },     /* Window size in Cm (2 values) */
                {   "WIN_POSITION", {      listsy,  1, AD( dtbord )            } },     /* Low-left corner of Window coordinates in Cm (2 values) */

                {     "PET_STRING", {   integersy,  1, AD( pet_string )        } },     /* Prompt Echo type for Get String, ... */
                {     "PET_CHOICE", {   integersy,  1, AD( pet_choice )        } },     /* ... Get Choice, ... */
                {    "PET_ANSWERD", {   integersy,  1, AD( pet_answerd )       } },     /* ... Get Answerd, ... */
                {   "PET_POSITION", {   integersy,  1, AD( pet_position )      } },     /* ... Get Position, ... */
                {       "PET_LINE", {   integersy,  1, AD( pet_line )          } },     /* ... Get line dots, ... */
                {     "PET_STROKE", {   integersy,  1, AD( pet_stroke )        } },     /* ... Get line stroke, ... */
                {     "PET_WINDOW", {   integersy,  1, AD( pet_window )        } },     /* ... Get Window, ... */
                {      "PET_VALUE", {   integersy,  1, AD( pet_value )         } },     /* ... Get Value, ... */
                {       "PET_PICK", {   integersy,  1, AD( pet_pick )          } },     /* ... Get Segment pick, ... */

                {    "CHOICE_AREA", {     floatsy,  4, AD( d_ch_area )         } },     /* Screen Echo Arrea for choice input. */
                {    "STRING_AREA", {     floatsy,  4, AD( d_st_area )         } },     /* Screen Echo Arrea for string input. */
                {   "ANSWERD_AREA", {     floatsy,  4, AD( d_an_area )         } },     /* Screen Echo Arrea for answerd input. */
                {     "VALUE_AREA", {     floatsy,  4, AD( d_va_area )         } },     /* Screen Echo Arrea for value input. */

                {    "COLOR_TABLE", {      listsy,  8, AD( coltab )            } },     /* Table of Predefined colors  (8 colors = 8*[3 values]) */

                                                                                        /* Predefined colors table (individually) (3 value each) */
                {        "COLOR_0", {     floatsy,  3, AD( draw_srccoltb[0] )  } },     /* Color 0 usually white - Background Color */
                {        "COLOR_1", {     floatsy,  3, AD( draw_srccoltb[1] )  } },     /* Color 1 usually Black */
                {        "COLOR_2", {     floatsy,  3, AD( draw_srccoltb[2] )  } },     /* Color 2 usually Red */
                {        "COLOR_3", {     floatsy,  3, AD( draw_srccoltb[3] )  } },     /* Color 3 usually Blue */
                {        "COLOR_4", {     floatsy,  3, AD( draw_srccoltb[4] )  } },     /* Color 4 usually Green */
                {        "COLOR_5", {     floatsy,  3, AD( draw_srccoltb[5] )  } },     /* Color 5 usually Yellow */
                {        "COLOR_6", {     floatsy,  3, AD( draw_srccoltb[6] )  } },     /* Color 6 usually Cyan */
                {        "COLOR_7", {     floatsy,  3, AD( draw_srccoltb[7] )  } },     /* Color 7 usually Magenta */

                {     "FONT_TABLE", {      listsy, 16, AD( fntlst )            } },     /* Font Names List (16 strings) */

                                                                                        /* Predefined font (individually) (string, style) */
                {         "FONT_0", {      listsy,  1, AD( font_0 )            } },     /* Font 0 (usually normal PIXMAP style font) */
                {         "FONT_1", {      listsy, -1, AD( font_0 )            } },     /* Font 0 (usually normal POLYGON style font) */
                {         "FONT_2", {      listsy, -2, AD( font_0 )            } },     /* Font 0 (usually Bold PIXMAP style font) */
                {         "FONT_3", {      listsy, -3, AD( font_0 )            } },     /* Font 0 (usually Bold POLYGON style font) */
                {         "FONT_4", {      listsy, -4, AD( font_0 )            } },     /* Font 0 (usually Italic PIXMAP style font) */
                {         "FONT_5", {      listsy, -5, AD( font_0 )            } },     /* Font 0 (usually Italic POLYGON style font) */
                {         "FONT_6", {      listsy, -6, AD( font_0 )            } },     /* Font 0 (usually Bold Italic PIXMAP style font) */
                {         "FONT_7", {      listsy, -7, AD( font_0 )            } },     /* Font 0 (usually Bold Italic POLYGON style font) */

                {      "FONT_PATH", {    stringsy,  1, AD( draw_fontpath )     } },     /* Font Path to locate the font files (string with ";" sep.) ) */
                {             NULL, {     nothing,  1, 0                       } }
              };



static int  binstring   = false;
static int  cter        = false;
static int  ch, cmaj;

static chcat categ  = eolno;


            /* Character attribute array */

static chcat  attchr[96]    =
      {     /* _oth_ pour tous les autres */

   spacech,  commento, quot,     baseo,    alpha,    baseo,    ando,     quot,
/*   ' '       '!'     '"'        '#'       '$'       '%'      '&'       '\'' */

   lpar,     rpar,     mulo,     addo,     comma,    subo,     period,   divo,
/* '('       ')'       '*'       '+'        ','      '-'        '.'      '/'  */

   digit,    digit,    digit,    digit,    digit,    digit,    digit,    digit,
/*  '0'       '1'       '2'       '3'       '4'       '5'       '6'       '7' */

   digit,    digit,    colon,    semicol,  clto,     equo,     cgto,     oth,
/*  '8'       '9'       ':'        ';'     '<'       '='       '>'       '?'  */

   oth,      alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/* '@'        'A'       'B'       'C'       'D'       'E'       'F'       'G' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  'H'       'I'       'J'       'K'       'L'       'M'       'N'       'O' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  'P'       'Q'       'R'       'S'       'T'       'U'       'V'       'W' */

   alpha,    alpha,    alpha,    lbra,     oth,      rbra,     powo,     alpha,
/*  'X'       'Y'       'Z'      '['       '\\'      ']'       '^'        '_' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  '`'       'a'       'b'       'c'       'd'       'e'       'f'       'g' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  'h'       'i'       'j'       'k'       'l'       'm'       'n'       'o' */

   alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,    alpha,
/*  'p'       'q'       'r'       's'       't'       'u'       'v'       'w' */

   alpha,    alpha,    alpha,    oth,      oth,      oth,      oth,      oth
/*  'x'       'y'       'z'      '{'       '|'       '}'       '~'       '?'  */

      };





/* ------------- Character attribute definitions --------------- */

static int    num_stat = 0;     /* Static count of Graphical Work Station. */

static int        ierr;
static item        sym;

static FILE    *    fp;



static int match( const char *s1, const char *s2, int l1, int l2 )
{ /*
    To compare two identifier names
    the result value is :
      0 if s1 and s2 match,
      1 if s1 > s2 and -1 if s1 < s2
  */

  int i, j, bl;

  if (l1 > l2) j = l1;
          else j = l2;
  i = 1;
  bl = true;

  while ((i <= j) && bl) {
    bl = (s1[i] == s2[i]);
    if (bl) i = i + 1;
  }

  if (bl) {
    if (l1 == l2) return 0;
             else if (l1 > l2) return  1;
                          else return -1;
  } else
    if (s1[i] > s2[i]) return  1;
                  else return -1;
} /* match */



static ident * searchid( ident idt[], char *p, int len )
/* searchid: to search an identifier */
{
  int                i;
  const char      * nm;
  ident    * id = NULL;

  i =           0;
  do {
    id = &idt[i++];
    nm = id->idname;
  } while (nm&&(match( nm, p, strlen( nm ), len ) != 0));

  if (!nm) Draw_Error( "Identifier %s in setting file does not exist.", p );

  return id;
} /* searchid */



static void getdchar( void )
/* to get one character in the current line
   and set these characteristics */
{
  ch = getc(fp);
  if (ch == EOF) {
    ch = ' '; cmaj = ch; categ = eofo;
  }
  else
    if ((ch == 0) || ((ch == '\n' /* LINE FEED */)&&cter)) {
      categ = eolno; ch = 0;
    } else {
      if ((ch < ' ') || (ch > '~')) ch = ' ';
      cmaj = ch;
      if (cmaj > '_') cmaj = cmaj - 32;  /* convert lower to upper case */
      categ = attchr[ch - ' '];
    }
} /* getdchar */



static void comment( char cs )
{ /* READ A COMMENT TO PROCEED IN INPUT STREAM */

  cter = true;
  getdchar();
  while ((ch != cs) && (categ != eofo)) {
    getdchar();
  }
  cter = false;
  cmaj = ' ';
  categ = spacech;
  ch = ' '; /* set the space state */
} /* comment */



static void nextch( void )
{ /* get a character from the input stream */
  /* with comment elimination */
  /* nextch */

  getdchar();
  if (!binstring)
    if (ch == '{') comment( '}' );
              else if (ch == '!') comment( 0 );
} /* nextch */



static void skipspace( void )
{ /* to skip unsignificative space and comment */
  do {
    nextch();
  } while ((ch <= ' ') && (categ != eolno) && (categ != eofo));
} /* skipspace */



static void insymbol( void )
{ /* insymbol */
  /* Get a symbol in the source input stream and decode it */
  int     bint, ivl, base;
  double  rdig, rexp, rfac, rval;
  char     * s;

  if ((ch == ' ') && (categ != eolno) && (categ != eofo)) skipspace();
  sym.ptid = NULL;
  switch (categ) {
    case digit:  /* '0'...'9' */
    case period: /* '.'...number */
      /* assuming integer until shown other */
      ierr = false;
      rval = 0.0;
      rexp = ten;
      rfac = one;
      sym.sy = integersy;
      while (categ == digit) {
        rdig = ch - '0';
        nextch();
        rval = rval * ten + rdig;
      }
      if (categ == period) {
        nextch();
        sym.sy = floatsy;
        while (categ == digit) {
          rdig = ch - '0';
          nextch();
          rfac = rfac / ten;
          rval = rval + rfac * rdig;
        }
      }

      if ((cmaj == 'e') || (cmaj == 'E')) {
        sym.sy = floatsy;
        nextch();
        if ((ch == '+') || (ch == '-')) {
          if (ch == '-') rexp = one/rexp;
          nextch();
        }
        ivl = 0;
        while (categ == digit) {
          ivl = ivl * 10 + ( ch - '0');
          nextch();
        }
        if (ivl > 38) {
          Draw_Error( "EXPOSANT > 38 in setting file", NULL );
          ierr = true;
        }
        rfac = one;
        while (ivl != 0) {
          if ((ivl % 2) == 1)                   /* ODD ivl */ {
            ivl = ivl - 1;
            rfac = rfac * rexp;
          } else {                              /* Even ivl */
            ivl = ivl / 2;                      /* ivl div 2;*/
            rexp = rexp * rexp;                 /* sqr(rexp) */
          }
        }
        rval = rval * rfac;
      }

      if ((sym.sy == integersy) &&
          (rval <= RMAXINT) && (rval >= -RMAXINT-1.0)) {
        sym.fltv = floor( rval + 0.5 );         /* ROUND(rval) */
        sym.intv = (int) sym.fltv;
      } else {
        sym.intv = 0;
        sym.sy = floatsy;
      }
      sym.fltv = rval;
    break;

    case alpha: /* 'a'...'z'....IDENTIFIER or KEYWORD or OPERATOR */
                /* We must have MAXIDSIZE >= MAXLINESZ */
      sym.strv[0] =  0;
      sym.strl    =  0;
      ivl = 0;
      while ((categ == alpha) || (categ == digit) || (categ == period)) {
        if (ivl < MAXIDSIZE) sym.strv[ivl] = cmaj;
        ivl = ivl + 1;
        nextch();
      }
      if (ivl >= MAXIDSIZE) ivl = MAXIDSIZE;
      sym.strv[ivl] =        0;
      sym.strl      =      ivl;
      sym.sy        =  identsy;
      if (sym.ptid = searchid( wsidtab, sym.strv, sym.strl ))
        switch (sym.ptid->vdescr.vtype) {
         case ct_stringsy:
            sym.sy   = stringsy;
            s = ((char **)(sym.ptid->vdescr.vaddr)) [0];
            sym.strl = 0;
            if (s&&s[0]) while (s[sym.strl]) sym.strv[sym.strl++] = *(s++);
          break;

          case ct_integersy:
            sym.sy   = integersy;
            sym.intv = ((int *)(sym.ptid->vdescr.vaddr)) [0];
          break;

          case ct_floatsy:
            sym.sy   = floatsy;
            sym.fltv = ((float *)(sym.ptid->vdescr.vaddr)) [0];
          break;

          default: /* Nothing to do */ ;
        }
    break;

    case baseo: /* '#' or '%' --> IT IS A BASE */
      ierr = false;
      sym.sy = integersy;
	  base = 10;
      if (ch == '#')
      {
        nextch();
        base = 0;
        while (categ == digit)
        {
          base = base * 10 + ( ch - '0');
          nextch();
        }
        if (ch != '#')
        {
          Draw_Error( "Bad Base specification in setting file", NULL );
          ierr = true;
        }
      }
      else
        if (ch == '%')
        {
          base = 10;
          nextch();
          switch(ch)
          {
            case 'X':
            case 'x':
            case 'H':
            case 'h':
              base = 16;
            break;

            case 'D':
            case 'd':
              base = 10;
            break;

            case 'O':
            case 'o':
              base =  8;
            break;

            case 'B':
            case 'b':
              base =  2;
            break;

            default: /*base = 10;*/
            break;
          }
        }
        if (!ierr)
        {
          nextch();
          ivl = 0;
          while (ch > ' ')
          {
            if ((ch >= '0') && (ch <= '9')) ch = ch - '0';
            else
              if ((ch >= 'a') && (ch <= 'f')) ch = ch - 'a' + 10;
              else
                if ((ch >= 'A') && (ch <= 'F')) ch = ch - 'A' + 10;
            if (ch < base)
            {
              ivl = base*ivl + ch;
              nextch();
            }
            else ch = 0;
          }
          sym.intv = ivl;
          sym.fltv = sym.intv;
        }
    break;

    case equo:  /* '=' */
      sym.sy = equalsy;
      nextch();
    break;

    case comma: /* ',' */
      sym.sy = commasy;
      nextch();
    break;

    case semicol: /* ';' */
      sym.sy = semicolonsy;
      nextch();
    break;

    case quot:                                  /* Constructor of string */
      bint = true;
      sym.strv[0] =  0;
      sym.strl    =  0;
      ivl         =  0;
      binstring = true;
      while (bint) {
        nextch();
        if (categ == eolno) nextch();           /* To skip any line change */
        if (categ == eofo) bint = false;
        if (ch == '\'') {
          nextch();
          if (ch == '\'') sym.strv[ivl] = ch;
                     else bint = false;
        } else {
          sym.strv[ivl] = ch;
          if (bint && (ivl < MAXLINESZ))
            ivl = ivl + 1;
          else
            if (bint) {
              Draw_Error( "Line too long in setting file", NULL );
              bint = false;
            }
        }
      }
      sym.strv[ivl] = 0;
      binstring = false;
      sym.strl  =   ivl;
      sym.sy = stringsy;
    break;

    case eolno:
      sym.sy = eolnsy;
      nextch();
    break;

    case eofo:
      sym.sy = eofsy;
    break;

    default:    /* separator */
      sym.sy = separatorsy;
      nextch();
    break;

  } /* switch (categ) */

#ifdef DEBUG

  switch (sym.sy) {
    case identsy:     fprintf( fmsg, " Read key identifier (%d) \"%s\"\n", sym.strl, sym.strv ); break;
    case integersy:   fprintf( fmsg, " Read integer %d\n", sym.intv ); break;
    case floatsy:     fprintf( fmsg, " Read float %d\n", sym.fltv ); break;
    case stringsy:    fprintf( fmsg, " Read string (%d) \"%s\"\n", sym.strl, sym.strv ); break;
    case commasy:     fprintf( fmsg, " Read \",\"\n" ); break;
    case semicolonsy: fprintf( fmsg, " Read \";\"\n" ); break;
    case equalsy:     fprintf( fmsg, " Read \"=\"\n" ); break;
    case separatorsy: fprintf( fmsg, " Read other separator.\n" ); break;
    case eolnsy:      fprintf( fmsg, " Read EOLN\n" ); break;
    case eofsy:       fprintf( fmsg, " Read EOF\n" ); break;
    default: fprintf( fmsg, " read code = %d > %d\n", (int) sym.sy, (int) identsy ); break;
  }
  fflush( fmsg );

#endif

} /* insymbol */


static void skip_to_symbol( /*enum*/ symbol syv )
{
  while ((sym.sy != eofsy) && (sym.sy != syv)) insymbol();
}


static void errandskip( const char *msg, const char * id, /*enum*/ symbol syv )
{
  Draw_Error( msg, id );
  skip_to_symbol( syv );
}


static void set_list_value( lstlm * plist, int nval, const char * nam )
{
  int    ii, jj, idx, off, isz;
  char                     * s;
  lstlm                 * pfld;
  union {  void     *v;
           char    **s;
           int      *i;
           float    *f;  } ptr;

  /* loop on all term of the list */
  idx = 0;
  off = 0;

#ifdef DEBUG
  fprintf( fmsg, " Set list symbol \"%s\" with %d elements/offset.\n", nam, nval );
  fflush( fmsg );
#endif

  if (nval < 0) { off = -nval; nval = 1; }      /* Set offset when required (no loop on array of pseudo record) */
  do {                                          /* Loop on array of pseudo record  */
    pfld = plist;                               /* Get the Field list head pointer. */
    do {                                        /* Loop on the field of pseudo record */
      isz = pfld->vsize;                        /* Get the size of field as an array */
      jj = 0;

#ifdef DEBUG
      fprintf( fmsg, " New Field to set with %d elements *******\n", isz ); fflush( fmsg );
#endif

      do {                                      /* Loop on each element of field (that can be an array) */
        if ((pfld->vtype == floatsy)&&(sym.sy == integersy)) {          /* Convert integer value to float */
          sym.fltv = sym.intv; sym.sy   = floatsy;
        } else
          if ((pfld->vtype == integersy) && (sym.sy == floatsy)) {      /* Convert float value to integer (simule Round) */
            if (sym.fltv >= 0.0) sym.intv = (int) (sym.fltv + 0.5);
                            else sym.intv = (int) (sym.fltv - 0.5);
            sym.sy   = integersy;
          }
        ptr.v = pfld->vaddr;                    /* Get the address of field value */
//printf( " type expected = %d, type find = %d\n", pfld->vtype, sym.sy );
        if (pfld->vtype != sym.sy) {
          if (sym.sy != semicolonsy) Draw_Error( "Bad or missing value type for the list parameter \"%s\".", nam );

#ifdef DEBUG
          fprintf( fmsg, "     Deposite NULL value at [i=%d+o=%d+j=%d]\n", idx, off, jj );
#endif

          switch (pfld->vtype) {                /* Fill the incomplete record with zero (or empty string) */
            case integersy: ptr.i[idx+off+jj] =   0; break;        /* 0 int */
            case floatsy:   ptr.f[idx+off+jj] = 0.0; break;        /* 0.0 float */
            case stringsy:  ptr.s[idx+off+jj] =   0; break;        /* Null char* */
			default: ;
          }
          if ((sym.sy == stringsy)||(sym.sy == integersy)||(sym.sy == floatsy)) insymbol(); /* Skip unused value */
        } else {
          switch (pfld->vtype) {
            case integersy:

#ifdef DEBUG
              fprintf( fmsg, "     Deposite Integer Value %d [i=%d+o=%d+j=%d]\n", sym.intv, idx, off, jj );
#endif

              ptr.i[idx+off+jj] = sym.intv;
            break;

            case floatsy:

#ifdef DEBUG
              fprintf( fmsg, "     Deposite Float Value %f [i=%d+o=%d+j=%d]\n", sym.fltv, idx, off, jj );
#endif

              ptr.f[idx+off+jj] = sym.fltv;
            break;

            case stringsy:

#ifdef DEBUG
              fprintf( fmsg, "     Deposite String Value \"%s\" [i=%d+o=%d+j=%d]\n", sym.strv, idx, off, jj );
#endif

              s = (char *) malloc( sym.strl + 1 );
              for (ii = 0; ii <= sym.strl; ii++ ) s[ii] = sym.strv[ii];
              ptr.s[idx+off+jj] = s; 
            break;

			default: ;
          }
          insymbol();                           /* Skip to separator behind the value */
        }
        if (sym.sy == commasy) insymbol();       /* Skip the field separator if it is a comma */
      } while (++jj < isz);                     /* End loop on field as array(s) */

#ifdef DEBUG
      fprintf( fmsg, " End of Array loop\n" );
#endif

      pfld++;                                   /* Pass to the next list field */
    } while (pfld->vaddr);

#ifdef DEBUG
    fprintf( fmsg, " End of Field loop\n" );
#endif

    idx += pfld->vsize;                         /* Increments the pseudo record generation index */
  } while (--nval > 0);

#ifdef DEBUG
  fprintf( fmsg, " End of list.\n" );
  fflush( fmsg );
#endif

}



static void params_setting( const char * fspc, int * w_stat )
{
  union {  void     *v;
           char    **s;
           int      *i;
           float    *f;
        } ptr;

  int    nval, nvn, ii, indflg;
  char         * s      = NULL;
  ident        * currid = NULL;

  if (fp) {
    fprintf( fmsg, " Read the setup file \"%s\"\n", fspc );
    *w_stat = ++num_stat;
    ch    = ' ';
    cmaj  = ' ';
    categ = spacech;
    insymbol();
    while (sym.sy != eofsy) {
      if (sym.sy == identsy) {
        indflg = 0;                             /* Assume direct addressing mode until shown otherwise */
        currid = sym.ptid;                      /* Get the identifier address */
        if (currid) {
          insymbol();                           /* Gobble up the identifier */
          if (sym.sy == equalsy) insymbol();    /* Gobble up the equal separator when present */
          nval  = currid->vdescr.vsize;         /* Get the number of value (or of record ins array of record) */
          ptr.v = currid->vdescr.vaddr;         /* Get related address that is a pointer to:
                                                       when currid->idtype = listsy : The fields descriptor array,
                                                       else direct value or array address,
                                                */

          if (currid->vdescr.vtype == listsy)
            set_list_value( (lstlm*)(currid->vdescr.vaddr), nval, currid->idname );
          else {
            nval = abs( nval );
//printf( " Set symbol \"%s\" with %d elements.\n", currid->idname, nval );
            nvn = 0;
            do {
              if ((currid->vdescr.vtype == floatsy) && (sym.sy == integersy)) {
                sym.fltv = sym.intv;
                sym.sy   =  floatsy;
              } else
                if ((currid->vdescr.vtype == integersy) && (sym.sy == floatsy)) {
                  if (sym.fltv >= 0.0) sym.intv = (int) (sym.fltv + 0.5);
                                  else sym.intv = (int) (sym.fltv - 0.5);
                  sym.sy   = integersy;
                }
              if (currid->vdescr.vtype == sym.sy)
                switch (currid->vdescr.vtype) {
                  case integersy:
//printf( "     Deposite Integer Value %d [%d]\n", sym.intv, nvn );
                    *(ptr.i++) = sym.intv;
                    insymbol();
                  break;

                  case floatsy:
//printf( "     Deposite Float Value %f [%d]\n", sym.fltv, nvn );
                    *(ptr.f++) = sym.fltv;
                    insymbol();
                  break;

                  case stringsy:
//printf( "     Deposite String Value \"%s\" [%d]\n", sym.strv, nvn );
                    s = (char *) malloc( sym.strl + 1 );
                    for (ii = 0; ii <= sym.strl; ii++ ) s[ii] = sym.strv[ii];
                    *(ptr.s++) = s;
                    insymbol();
                  break;
				  
				  default: ;
                }
              else
              if (sym.sy = semicolonsy) {
                switch (currid->vdescr.vtype) {
                  case integersy: *(ptr.i++) =   0; break;
                  case floatsy:   *(ptr.f++) = 0.0; break;
                  case stringsy:  *(ptr.s++) =   0; break;
                  default: ;
                }
              } else
                errandskip( "Parameter value type do not match, unknown identifier or other syntax error.",
                            NULL, semicolonsy );

              if (sym.sy == commasy) {
                insymbol();
                if (nval-nvn < 1)
                  errandskip( "Too many value for the parameter \"%s\".", currid->idname, semicolonsy );
              }
            } while (++nvn < nval); /* while (nval < currid->nbvalue) */
          }
        } else errandskip( "Unknown identifier name \"%s\".", sym.strv, semicolonsy );
      } else errandskip( "A setting identifier was expected.", NULL, semicolonsy );
      if (sym.sy == semicolonsy) insymbol();
                            else Draw_Error( "A semicolon was expected.", NULL );
    } /* while (sym.sy != eofsy) ... */
  }
  else Draw_Error( "We can't find the Draw_Server Setting File (by default \"%s\"", fspc );
} /* Parameters_setting */



int Sdrw_Build_Filename( const char * fspc, char * buf )
{
  int               i, j, k, l, m, irp;
  char                              ch;
  char      src[MAX_STR], log[MAX_STR];
  char *                           trn;

  if (irp = 0) return -3;                                       /* Stop loop on recursive call */
  i = j = 0;
  if (fspc) {
    i = 0;
    while (fspc[i]&&(i < MAX_STR-1)) { src[i] = fspc[i]; i++; } /* Make a local copy of the initial string */
    src[i] = 0;

    if (i >= MAX_STR) return -1;                                /* Return on buffer overflow */

    irp = 8;                                                    /* Allow to eight recursive logical translation */


    if ((src[0] != '.')&&(src[0] != DIR_SEPAR)) {
// fprintf( fmsg, " Build_Filename use with (%d) \"%s\"\n", i, src ); fflush( fmsg );
      do {                                                      /* Loop on logical management (limited to 8 recursions) */
        j = l = 0;                                              /* Look for the end of logical name */
        while (src[j]&&(src[j] != DEV_SEPAR)&&((src[j] != DIR_SEPAR))) {
          ch = src[j];                                          /* Copy the original string to local src string, ...  */
          if ((ch >= 'a')&&(ch <= 'z')) ch = ch - ('a' - 'A');  /* ... performs the translation in capital letters for ... */
          log[j++] = ch;                                        /* ... and store it in the logical name string. */
        }
        log[j] = 0;                                             /* Put the terminal null for log string. */
                                                                /* Here i is the source length and j the log. name length */
// fprintf( fmsg, " Build_Filename LOG = (%d) \"%s\"\n", j, log ); fflush( fmsg );

        if (j>0) trn = getenv( log );                           /* Get a possible translation of logical name */
            else trn = 0;

        if (trn&&(trn[0])) {                                    /* We have find a translation */
          while (trn[l]) l++;                                   /* Find the translation string size */

// fprintf( fmsg, " Build_Filename TRN = (%d) \"%s\"\n", l, trn ); fflush( fmsg );

          if ((src[j] == DEV_SEPAR)&&(src[j+1])) {              /* When we have something to append behind the log. translation,  ... */
            src[j] = DIR_SEPAR;                                 /* ... replace the DEV separator by a directory separator, ... */
            if (trn[l-1] == DIR_SEPAR) l--;                     /* ... when this last separator was present in translation, remove it, ... */

            if (l !=j)                                          /* When a name move is required (normal case) */
              if (l < j) {
                k = j; m = l;
                while (k <= i) src[m++] = src[k++];             /* Backward move of name */
                i = l + i - j;
              } else {
                k = i; i = m = l + i - j;
                if (l >= MAX_STR) return -1;
                while (k >= j) src[m--] = src[k--];             /* Forward move of name */
              }
          } else src[l] = 0;
          for (k=0; k<l; k++) src[k] = trn[k];                  /* Put the logical translation in correct place. */
        }

//printf( " Res %d is \"%s\"\n", irp, src );

      } while (trn&&(--irp > 0));
    }
    for (j=0; j<=i; j++) buf[j] = src[j];                       /* Copy the result to the user buffer */

//printf( " Resultat is (%d) \"%s\"\n", i, buf );

    return 0;
  }
  return -2;
}



int Sdrw_Search_In_Path( const char * path, const char * name, char * buf )
{ /* Routine to search a file in a path list */
  char    fnm[MAX_STR];
  int      i, j, k, re;

  re = 0;
//fprintf( fmsg, "Search \"%s\"  /  \"%s\"\n", path, name ); fflush( fmsg );

  Sdrw_Build_Filename( name, buf );           /* Try to use the name without path */
  re = access( buf, F_OK );                   /* Check File for existence */

  i  = 0;
  while (re&&path[i]) {                       /* On failure, search in the PATH */
    j = k = 0;
    while (path[i]&&(path[i] != PATH_SEPAR)) fnm[j++] = path[i++];      /* Get one path entry (separator is ";") */
    if (path[i] == PATH_SEPAR) i++;                                     /* Skip the separator for the next path list entry */
    if (fnm[j-1] != DIR_SEPAR) fnm[j++] = DIR_SEPAR;                    /* Append a directory separator when it is not present. */
    while (name[k]&&(j<MAX_STR-1)) fnm[j++] = name[k++];                /* Append the file name to the directory comming from the path */
    fnm[j] = 0;                                 /* Append the final null character */
//  fprintf( fmsg, " Loop\n" ); fflush( fmsg );
    Sdrw_Build_Filename( fnm, buf );
//  fprintf( fmsg, " E Loop\n" ); fflush( fmsg );
    re = access( buf, F_OK );                   /* Check File for existence */
  }                                             /* Loop until open success or end of path */
  if (!re) return  0;
     else  return -1;
}


int  Sdrw_Check_Default_Path( char * spcf )
{
  int i;

  if ((spcf[0] == '.')||(spcf[0] == DIR_SEPAR))
    return 0;
  else {
    i = 0;
    while (spcf[i]&&(spcf[i] != DIR_SEPAR)&&(spcf[i] != DEV_SEPAR)) i++;
    if (spcf[i] == DEV_SEPAR) return 0;
                         else return 1;
  }
}



void Sdrw_Params_Setting( void )
{
  char buf[256];
  char *setfile;
  int        ir;

  g_flags = 0; // Set the server to uninitialized state.
  d_id    = 0; // Set the Graphical Work Stations as unreachable.

  // Try to find the setup file by using the DRAW_SERVER_SETTING environment variable.
  setfile = getenv( "DRAW_SERVER_SETTING" );

fprintf( fmsg, " Search PATH = <%s>\n", SEARCH_PATH );
fflush( fmsg );

  if (setfile&&setfile[0]) {
    if (!(fp = fopen( setfile, "r" ))) Draw_Error( "We can't open the Setting File \"%s\" from the environment", setfile );
  } else { // When the DRAW_SERVER_SETTING environment variable is not defined.
    setfile = buf;                             /* Set the file specification address for correct open message output */
    ir = Sdrw_Search_In_Path( SEARCH_PATH, DEF_SETFILE, buf );
    if (ir||(!(fp = fopen( buf, "r" )))) Draw_Error( "We can't open the Setting File \"%s\" by using the path search", buf );
  }

  // Now set the Draw Display Characteristic from Display_Setting files.
  if (fp) {
    params_setting( setfile, &d_id );

#ifdef DEBUG

    fprintf( fmsg, " Screen size = (%f,%f)\n", d_width, d_height );
    fprintf( fmsg, " Resolution = (%d,%d)\n", dr_rx, dr_ry );
    fprintf( fmsg, " Window sizes = (%f,%f)\n", ds_rx, ds_ry );
    fprintf( fmsg, " Window position = (%f,%f)\n", d_borders_x, d_borders_y );
    for(ir=0; ir<8; ir++) fprintf( fmsg, " Color # %d is (%f,%f,%f)\n", ir,
                                  draw_srccoltb[ir][0], draw_srccoltb[ir][1], draw_srccoltb[ir][2] );
    for(ir=0; ir<8; ir++) fprintf( fmsg, " Font # %d in mode %d name \"%s\"\n", ir, draw_fontstyle[ir], draw_fontnamtb[ir] );
    fflush( fmsg );

#endif
    fclose( fp );
  }

} /* all_params_setting */
