// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *            F L T K / D R A W   -   S E R V E R   M O D U L E             *
// *                                                                          *
// *              Version  1.4-C for Draw Library Level V 2.4 A               *
// *                                                                          *
// *        (Draw interface for FLTK/OPENGL function and procedures)          *
// *                                                                          *
// *                                                                          *
// *         (Perform all Init task and start the draw Server tasks)          *
// *                                                                          *
// *                                  by                                      *
// *                                                                          *
// *            Pierre Wolfers, Laboratoire de Cristallographie               *
// *                                                                          *
// *            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
// *                                                                          *
// *                       F 38042 GRENOBLE CEDEX 9                           *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////




#ifndef DRAWGL_H
#define DRAWGL_H 1

#include <fltk/Threads.h>
#include <fltk/run.h>
#include <fltk/Scrollbar.h>
#include <fltk/GlWindow.h>
#include <fltk/gl.h>
#include <fltk/Button.h>
#include <fltk/events.h>
#include <fltk/draw.h>
#include <fltk/Cursor.h>
#include <fltk/Flags.h>
#include <fltk/ask.h>
#include <fltk/Cursor.h>
#include <fltk/visual.h>


#include <GL/glu.h>
#include <stdio.h>
#include <math.h>
#include <errno.h>


#include "Server_Env.h"
#include "Server_DrawGL.h"


#define TIME_TICK         0.02



    enum {
        m_FirstCmd =   0, // Dummy Command
        m_Dinfo,          // Server Info.
        m_Help,           // Standard Help Command
        m_Open,           // Open a file
        m_Close,
        m_Save,
        m_Print,
        m_Exit,

        m_Dialog,         // TestDialog menu
        m_Scale,          // Change Scale
        m_Zoom,           // Perform a Zoom
        m_UnZoom,         // Undo last Zoom
        m_ChView,         // Mouse Change of View
        m_Reload,         // Reload Canvas at Original Scale.
        m_Refresh,        // Refresh Canvas.
        m_Grid,           // Set/lear the Grid.
        m_Resume,         // Continue after a Dialog User Request.
        m_AStop,          // Stop of User Animation.
        m_Usereq,         // User task answerd via dialog request.
        m_FirstUser       // Last item.
      };



#define Max_Menu_Entry       1024


extern fltk::Widget* DrwSrv_MWtb[Max_Menu_Entry];
extern int           DrwSrv_WFtb[Max_Menu_Entry];



void DrwSrv_Start_Exchange( void );

void DrwSrv_Start_Timer( void );

void DrwSrv_Exit( int );

void DrwSrv_Wait_For_Req( void );

void DrwSrv_End_Request( void );

void DrwSrv_Lock( void );

void DrwSrv_Unlock( void );

void DrwGL_Usr_Menu_Init();

void DrwSrv_Menu_Manager( int );

void DrwGL_SenSens( int, int );

void DrwGL_Sensibility( int );




class Draw_Window : public fltk::GlWindow {


private:

  GLint    mouse_status,                        //  Cursor Status (0=Up) (1=Down).
           mouse_kind,                          //  Cursor Request Kind.
           cursor_pb,
           cursor_ix,                           //  Screen Cursor Position (V pixel).
           cursor_iy,
           cursor_ib,                           //  Pressed Cursor Button.
           scroll_ok;                           //  Set when a Scrollbar Change is required.



// This value determines the scaling factor used to draw the cube.

public:

  float scrx_val, scrx_lrg, srcx_rat,
        scry_val, scry_lrg, scry_rat;

  Draw_Window( int x, int y, int w, int h, const char *l=0 );

  void Draw_Resize( int ww, int hh );

  int  Draw_Scale( int cfflg );                 // To Manage the Scale and coordinates Changes.

  int  handle( int e );                         // To Handle all mouse events.

  void Draw_Input_Request( void );              // To initiate all Mouse Request.


  /* Set the Horizontal (h) and vertical (v) Quantities.
   *
   * These functions are called by the Scrollbar widgets of Server_UI.
  */
  void x_scroll_change( int );
  void y_scroll_change( int );

  void Draw_ScrollEdit();

    /*The widget class draw() override.
     *
     *The draw() function initialize Gl for another round o f drawing
     * then calls specialized functions for drawing each of the
     * entities displayed in the cube view.
     *
     */
  void draw();

private:
    /* Draw the cube boundaries
     *
     * Draw the faces of the cube using the boxv[] vertices, using
     * GL_LINE_LOOP for the faces. The color is \#defined by CUBECOLOR.
     */

  void Send_Curve( void );
  void MouseDown( int x, int y, int button );
  void MouseUp( int x, int y, int button );
  void MouseMove( int x, int y );
  void MouseDrag( int x, int y, int button );

};


#endif

//
