// ****************************************************************************
// *                                                                          *
// *                                                                          *
// *                                                                          *
// *            F L T K / D R A W   -   S E R V E R   M O D U L E             *
// *                                                                          *
// *              Version  1.4-C for Draw Library Level V 2.4 A               *
// *                                                                          *
// *        (Draw interface for FLTK/OPENGL function and procedures)          *
// *                                                                          *
// *                                                                          *
// *         (Perform all Init task and start the draw Server tasks)          *
// *                                                                          *
// *                                  by                                      *
// *                                                                          *
// *                 Pierre Wolfers, Institut Neel/MCMF                       *
// *                                                                          *
// *            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
// *                                                                          *
// *                       F 38042 GRENOBLE CEDEX 9                           *
// *                                                                          *
// *                             F R A N C E                                  *
// *                                                                          *
// *                                                                          *
// *                                                                          *
// ****************************************************************************

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


// #include <semaphore.h>

#include <fltk/Threads.h>
#include <fltk/draw.h>
#include <fltk/Scrollbar.h>

#include "Server_UI.h"
#include "Server_DrawGL.h"
#include "Server_UsrInput.h"
#include "Server_AxisBox.h"


//
// The following code cannot run on window with cygwin - we must use the pure window code.
//
//#if (!defined( _WIN32)) || defined(__CYGWIN__)
//

// #define  _USEM

#ifndef _WIN32
//pthreads:

# ifdef _USEM

#   include <semaphore.h>

static  sem_t                      request_sem;         // Semaphore for Request synchro.

# else

static fltk::SignalMutex              exch_sem;
static int      exch_sig    =                0;

# endif
#endif



static int     MuttexCnt    =                0;

extern Draw_GL_UI* srvw0;

static fltk::Thread                exch_thread;

//static fltk::RecursiveMutex           exch_mut;
static fltk::Mutex                    exch_mut;


static int           clic_requ  =            0;

static double        timer_tick = DRWTIME_UNIT;

static char*         def_unit   = (char*) "cm";

static Draw_Ptr      Curve_Seg  =         NULL;

static int                     saved_plot_mode;

static int           scr_xp,  scr_xs,  scr_yp,  scr_ys;

static Draw_Dir                 *echo_seg = 0;

static float                    *echo_dtb = 0;




void DrwSrv_Start_Exchange( void )
{ int ie;
  // Start the pipe handler as a new thread.
  fprintf( fmsg, " *** User Exchange Thread Creation.\n" );
  fflush( fmsg );

#ifndef _WIN32

# ifdef _USEM
//  Use Unix semaphore:

  ie = sem_init( &request_sem, 0, 0 );
  if (ie)
  {
    if (ie == ENOSYS)
      fprintf( fmsg, " *** Error on Init Semaphore ENOSYS\n" );
    if (ie == 22)
      fprintf( fmsg, " *** Error on Init Semaphore EINVAR\n" );
    fclose( fmsg );
    exit ( 2 );
  }

# endif

#endif

  ie = fltk::create_thread( exch_thread, Draw_Sequence_Exec, NULL );
  if (ie<0)
  {
    fprintf( fmsg, " *** Error on Exchange Thread Creation: = %d:%d\n", ie, errno );
    fclose( fmsg );
    exit( 2 );
  }
}



void DrwSrv_Exit( int icd )
{ /* Stop Server Connection and Exit with the icd code values:
  0      for Exit by DRAW$END User Call,
  1      for Quit,
  2      for clic on close cross.
*/
  int ret;

  switch (icd) {
    case 2:   // Clic on window close cross.
    case 1:   // File menu choice Quit (or CTRL Q).
      if (reqflg) {                             // Exit When Dialog is Enabled.
        Drwgl_Dstatus = (Drwgl_exitmd&1)?-1:-10;// Set the Exit User Request Mode.
        if (Drwgl_Dstatus == -10)               // When the Exit is not user managed.
          ret = fltk::ask( "The User Task does not Manage Exit: Are You Sure ?\n" );
        else ret = 1;
        if (ret > 0) {
          reqflg = 0;                           // Simule a Resume Clic.
          Drwgl_Input   = drwgl_nothing;
          Drwgl_Dstatus =            -1;        // With the -1 result.
          DrwGL_Sensibility( 0 );               // Clear the Dialog Menu sensitivity.
          DrwSrv_End_Request();
        } else Drwgl_Dstatus = 0;
      } else {                                  // Exit during a run status.
        if ((reqnxt >= 0)|(reqnxt == -10))      // Suspect Exit tentative.
          if (fltk::ask( "Debugging Cancel Graphic Server, Are You Sure ?" )) reqnxt = -10;
        if (reqnxt < 0) {
          Draw_Pannel_Destroy_All();            // Destroy all existing Pannel.
          srvw0->w_wind->hide();                // Stop the server when required.
        }
      }
      break;

    default:  // Default is normal user directive DRAW$END.
              // ... or bad user directive code.
      Draw_Pannel_Destroy_All();                // Destroy all existing Pannel.
      srvw0->w_wind->hide();
      Drwgl_Dstatus = 0;
  }
//if ((status = wait( &cstatus )) == -1)
//if ((status = fltk::wait()) == -1) exit( 10 );
}



//
// The following code cannot run on window with cygwin - we must use the pure window code.
//
//#if (!defined( _WIN32)) || defined(__CYGWIN__)
//

#ifndef _WIN32
//  Use Unix semaphore:

void DrwSrv_Wait_For_Req( void )
{ int ie;

//fprintf( fmsg, " Wait for R : UnLock\n" ); fflush( fmsg );

  DrwSrv_Unlock();                              // UnLock the User Directive Execution Graph.
//fprintf( fmsg, " Wait for Request <%s> with Flags = %d\n", Drwgl_StatusStr[Drwgl_Input], Drwgl_flags );
//fflush( fmsg );

# ifdef _USEM

  ie = sem_wait( &request_sem );
  if (ie)
  {
    fprintf( fmsg, " *** Wait for Request err = %d:%d\n", ie, errno );
    fflush( fmsg );
  }

# else

  do {
    exch_sem.wait();
  } while (exch_sig == 0);
  exch_sig = 0;

# endif

//fprintf( fmsg, " *** End of Wait (sem) for Request, Continue in pipe Thread.\n" );
//fflush( fmsg );
}



void DrwSrv_End_Request( void )
{ int ie;
//fprintf( fmsg, " *** Post End of Request (to continue Pipe Thread).\n" );
//fflush( fmsg );

//fprintf( fmsg, " End of R : UnLock\n" ); fflush( fmsg );

# ifdef _USEM
  DrwSrv_Unlock();                              // UnLock the User Directive Execution Graph.
  ie = sem_post( &request_sem );
  if (ie)
  {
    fprintf( fmsg, " *** Post End of Request err = %d:%d \n", ie, errno );
    fflush( fmsg );
  }

# else

  exch_sig = 1;
  DrwSrv_Unlock();                              // UnLock the User Directive Execution Graph.
  exch_sem.signal();

# endif

}



#else // WIN32 (with or without Cygwin)
//Event:

HANDLE  exch_evnt = NULL;



void DrwSrv_Wait_For_Req( void )
{

  DrwSrv_Unlock();                              // UnLock the User Directive Execution Graph.

  if (!exch_evnt) {
    if (!(exch_evnt = CreateEvent( NULL, FALSE, TRUE ,NULL ))) {
      fprintf( fmsg, " CreateEvent Error.\n" );
      fflush( fmsg );
      exit( 2 );
    }
  }
  if (!ResetEvent( exch_evnt )) {
      fprintf( fmsg, " Reset Event Error.\n" );
      fflush( fmsg );
      exit( 2 );
  }

//fprintf( fmsg, " Wait for Request with Flags = %d\n", Drwgl_flags );
//fflush( fmsg );

  switch (WaitForSingleObject( exch_evnt, INFINITE )) {
    case WAIT_FAILED:
      fprintf( fmsg, " Wait Event Error.\n" );
      fflush( fmsg );
      exit( 2 );
    case WAIT_OBJECT_0:
//    fprintf( fmsg, " *** Wait Event Signaled => Resume Pipe Thread.\n" );
//    fflush( fmsg );
      break;
    case WAIT_ABANDONED:
      fprintf( fmsg, " Wait Abandoned Error.\n" );
      fflush( fmsg );
      break;
    default: ;
  }
}


void DrwSrv_End_Request( void )
{
//fprintf( fmsg, " *** Post End Of Request (to continue Pipe Thread).\n" );
//fflush( fmsg );

  DrwSrv_Unlock();                              // UnLock the User Directive Execution Graph.
  if (!SetEvent( exch_evnt )) {
    fprintf( fmsg, " Set Event Error.\n" );
    fflush( fmsg );
  }
}

#endif




void DrwSrv_Lock( void )
{
//int ie;

//fprintf( fmsg, " %d - Mutex Lock.\n", MuttexCnt );
//fflush( fmsg );
  MuttexCnt++;
  exch_mut.lock();

//ie = pthread_mutex_lock( &sdrw_data_mutex );
}



void DrwSrv_Unlock( void )
{
//int ie;

  if (MuttexCnt>0) { exch_mut.unlock(); MuttexCnt--; }

//fprintf( fmsg, " %d - Mutex UnLock.\n", MuttexCnt );
//fflush( fmsg );

//ie = pthread_mutex_unlock( &sdrw_data_mutex );
}



static void DrwSrv_Timer_cb( void* v )
{ // Tick timer procedure.
  static int          clk_cnt =             0;
  static int          astpmod =             0;
  static int         prv_mstatus =          0;
  static Drwgl_Inptyp curstat = drwgl_nothing;
  int                             ret, status;
  char                               buf[128];
  char*                                   rep;

//if (Drwgl_flags) {
//  fprintf( fmsg, " Timer with Drwgl_flags = %d\n", Drwgl_flags );
//  fflush( fmsg );
//}

  fltk::repeat_timeout( timer_tick, DrwSrv_Timer_cb, (void*)srvw0 );

  if (Drwgl_astpmod != astpmod) {
    DrwGL_SenSens( m_AStop, (Drwgl_astpmod)?1:0 );      // Set Menu Stop Sensitivity.
    astpmod = Drwgl_astpmod;
  }

  if (Drwgl_period_set != 0) {                  // Set a new timer Period.
    Drwgl_time_period = Drwgl_period_set;
    if (Drwgl_time_period>DRWCLOCK_COUNT) Drwgl_time_period = DRWCLOCK_COUNT;
    timer_tick = Drwgl_time_period*DRWTIME_UNIT;// Reset time Intervals.
    Drwgl_clock_count = (int)(DRWCLOCK_COUNT*DRWTIME_UNIT/timer_tick + 0.5);
    Drwgl_period_set = 0;
  }

  if (clk_cnt++ >= Drwgl_clock_count) {
    clk_cnt = 0;
    if (Drwgl_mactive) {                        // Input Interaction Is Active.
      float xx, yy, zz;
      Draw_Axis_Ptr u, v;
      char* xunit;
      char* yunit;
      char  defstr[] = "  ";

      if (Draw_Opened_Box) {                    // An Axis Box is currently Opened.
        u = Draw_Opened_Box->box_axis[0];
        v = Draw_Opened_Box->box_axis[1];
        xunit = (u)?u->axis_unit:NULL;
        yunit = (v)?v->axis_unit:NULL;

        Draw_UnScale( &xx, &yy, &zz, Drwgl_xcurr, Drwgl_ycurr, 0.0 ); 
      } else {                                  // No Axis box use => coordinates in cm.
        xx = Drwgl_xcurr - orgx;
        yy = Drwgl_ycurr - orgy;
        xunit = Drwgl_unitx;
        yunit = Drwgl_unity;
      }
      if (!xunit) xunit = defstr;
      if (!yunit) yunit = defstr;
      sprintf( buf, " X = %8.2f %s, Y = %8.2f %s ", xx, xunit, yy, yunit );
      srvw0->Mouse_Coord->value( buf );
      prv_mstatus = 1;
    } else if (prv_mstatus) { prv_mstatus = 0; srvw0->Mouse_Coord->value( "" ); }
  }


  if (curstat != Drwgl_Proceed) {               // Set the Status string in the status Bar.
    curstat = Drwgl_Proceed;
    srvw0->Status_Name->value( Drwgl_StatusStr[curstat] );
    Drwgl_flags |= DRWSTATUS_UPDATE;
  }

  if (Drwgl_flags&DRWSTATUS_UPDATE) {
    Drwgl_flags &= ~DRWSTATUS_UPDATE;
//fprintf( fmsg, " Refresh : lock\n" ); fflush( fmsg );
//  DrwSrv_Lock();
    fltk::lock();
    srvw0->w_draw->redraw();
    fltk::awake();
    fltk::unlock();
//fprintf( fmsg, " Refresh : Unlock\n" ); fflush( fmsg );
//  DrwSrv_Unlock();
  }


  if (Drwgl_flags&DRWSTATUS_INPUT) { 
    status = 1;
    Drwgl_flags &= ~DRWSTATUS_INPUT;            // Clear the Update and input flags.
    Drwgl_Proceed = Drwgl_Input;
    switch (Drwgl_Input) {
      case drwgl_dialog:
        reqflg = 1;                             // Set the Dialog flag.
        status = 0;                             // Leave ib the Dialog mode (user task must be locked).
        Drwgl_PanChg = 0;                       // Set Flag for no pannel interaction.
        DrwGL_Sensibility( 1 );                 // Set the Dialog Menu sensitivity.
        Drwgl_Dstatus = 0;                      // Set the default Exit Status is set.
      break;

      case drwgl_message:
        fltk::message( Drwgl_strmsg );          // Send a message request.
      break;

      case drwgl_dsplmsg:
        srvw0->User_Msg->value( Drwgl_strmsg ); // Send the User text in the user string display.
      break;

      case drwgl_choice:                        // User modal menu request;
        Drwgl_status = Draw_GetChoice( Drwgl_strmsg, Drwgl_strtab );
        Sdrw_Put_Int( Drwgl_status );
      break;

      case drwgl_answerd:                       // User  simple question (yes/no) request.
        ret = fltk::ask( Drwgl_strmsg );
        Sdrw_Put_Int( ret );
      break;

      case drwgl_string:                        // User get string Request.
        rep = (char*)fltk::input( Drwgl_strmsg, Drwgl_strdef );
        if (rep) {
		  int len = 0;
          if (Drwgl_strcap >= DRWSTRBUF_LENGTH) Drwgl_strcap = DRWSTRBUF_LENGTH - 1;
          if ((len = strlen( rep ))>Drwgl_strcap) {
            len = Drwgl_strcap;
            if (!fltk::ask( "Too long answerd will be troncated (max %d characters).",
                            Drwgl_strcap )) rep = NULL;
			
          }
		  Sdrw_Put_String( rep, len );
        } else Sdrw_Put_Char( 0 );
      break;

      case drwgl_file:                          // User get file path request.
        // Set the chooser mode.
        if (Drwgl_strcap > DRWSTRBUF_LENGTH) Drwgl_strcap = DRWSTRBUF_LENGTH;

        rep = Draw_GetFile( Drwgl_strmsg, Drwgl_strtab[0], Drwgl_strdef, Drwgl_newmd, Drwgl_fidx );
        // The first menu entry is the complete string of filter (separate by '\t' character in FLTK).
        // The Drwgl_fidx parameter is not used -- in this FLTK server first version.
        if (rep) {
		  int len = 0;
          if ((len = strlen( rep ))>Drwgl_strcap) {
            len = Drwgl_strcap;
            if (!fltk::ask( "Too long file path will be troncated (max %d characters).",
                            Drwgl_strcap )) rep = NULL;
          }
          Sdrw_Put_Char( Drwgl_fidx );
          Sdrw_Put_String( rep, len );
        } else {
          Sdrw_Put_Char( Drwgl_fidx );
          Sdrw_Put_Char( 0 );
		}
      break;

      case drwgl_color:                         // User must select a RGB Color.
        ret = Draw_Get_Color( Drwgl_strmsg, Drwgl_Rcolor, Drwgl_Gcolor, Drwgl_Bcolor );
        Sdrw_Put_Int( ret );
        Sdrw_Put_Float( Drwgl_Rcolor );
        Sdrw_Put_Float( Drwgl_Gcolor );
        Sdrw_Put_Float( Drwgl_Bcolor );
      break;

      case drwgl_value:                         // User get Floating Value Request.
        { double min, max, def, step;
          int lgflg = 0;                        // Assume linear mode.

          def = Drwgl_valdef;                   // Get the Default value.
          if (Drwgl_valmin > Drwgl_valmax) {    // Log mode is requested.
            max = Drwgl_valmin;                 // Set the Effective min and max.
            min = Drwgl_valmax;
            if ((min <= 0.0)||(max <= 0.0)) {
              min = 0.1; max = 10.0; step = 0.01;
            } else {
              if (max > 10.0*min) max = 10.0*min;
              step = min*0.1;
              if (step*0.1 > 0.0) step *= 0.1;
            }
            lgflg = 1;
          } else {                              // linear mode.
            min = Drwgl_valmin; max = Drwgl_valmax;
            if (min == max) { min = 0.0; max = 1.0; }
            step = (max - min)/100.0;           // Adapt the precision.
          }
          if (min == max) { min = 0.0; max = 1.0; }
          if (def < min) def = min;
                    else if (def > max) def = max;

          if ((Drwgl_valdef < Drwgl_valmin)||(Drwgl_valdef > Drwgl_valmax))
                 Drwgl_valdef=Drwgl_valmin;
          Drwgl_valret = def;
          Drwgl_status = Draw_GetVal( min, max, step, def, Drwgl_strmsg, lgflg );
          if (Drwgl_status == 1) Drwgl_valret = def;
          Sdrw_Put_Int( /* (lid == M_Cancel)?-1:1 */ Drwgl_status );
          Sdrw_Put_Float( Drwgl_valret );
          break;
        }

      case drwgl_pannelreq:
        Drwgl_status = Draw_Pannel_Dispatch( Drwgl_ident );
        Sdrw_Put_Int( Drwgl_status );
        Sdrw_Anim_acq( Drwgl_astpstate );
        if (Drwgl_ident != cd_pannel_req) Drwgl_Input = drwgl_nothing;
        break;

      default:                                  // For All User Mouse Requests.
        srvw0->w_draw->Draw_Input_Request();
        status = 0;
    }
    // Resume the User Request.
    if (status) {
      Drwgl_Input   = drwgl_nothing;
      DrwSrv_End_Request();
    } else if (!reqflg) DrwGL_Sensibility( 0 ); // Clear the Dialog Menu sensitivity.
  }
}


void DrwSrv_Start_Timer()
{
  fltk::add_timeout( timer_tick, DrwSrv_Timer_cb, (void*)srvw0 );   // Start the Timer.
}



Draw_Window::Draw_Window(int x, int y, int w, int h, const char *prgnam ) : GlWindow( x, y, w, h, prgnam )
{

  mode( fltk::DOUBLE_BUFFER|fltk::RGB_COLOR|fltk::ALPHA_BUFFER|fltk::DEPTH_BUFFER|fltk::DOUBLE_BUFFER );

  s_dt_rx  =     dt_rx;  s_dt_ry  =  dt_ry;     // Save it.

  ds_rx    =                dt_rx/d_xscale;     // Update the Window Size in (cm).
  ds_ry    =                dt_ry/d_yscale;

  s_dt_rx  =             dt_rx;  s_dt_ry  =              dt_ry;     // Save it.

  fprintf( fmsg, " Set init Window Size to (%d*%d) Pixels\n", s_dt_rx, s_dt_ry );
  fprintf( fmsg, "                      or (%f*%f) cm.\n", ds_rx, ds_ry );
  fflush( fmsg );

  mouse_status   =   0;                         // Cursor Up state.
  reqflg         =   0;                         // Remember for next client request.
  reqnxt         =   0;                         // Enable the User Task Command mode.
  scroll_ok      =   0;                         // Init the Scroll change flag.
  Drwgl_flags    =   0;                         // Init the Request flags word.

}



void Draw_Window::x_scroll_change( int pos )
{ // When move the Horizontal Scroll Bare.
//printf( " Scroll X: %d\n", pos );
  dw_cwpx = dw_cwsx + dw_swsx*(pos/5000.0 - 1.0);
  dw_cxmin = dw_cwpx - dw_cwsx;
  dw_cxmax = dw_cwpx + dw_cwsx;
  fltk::lock();
  redraw();
  fltk::unlock();
}



void Draw_Window::y_scroll_change( int pos )
{ // When move the Vertical Scroll Bare.
//printf( " Scroll Y: %d\n", pos );
  dw_cwpy = dw_swsy*(1.0 - pos/5000.0) - dw_cwsy;
  dw_cymin = dw_cwpy - dw_cwsy;
  dw_cymax = dw_cwpy + dw_cwsy;
  fltk::lock();
  redraw();
  fltk::unlock();
}



int Draw_Window::Draw_Scale( int cfflg )
{
  int    rq;
  float exc, px, py, ryx, sx, sy;
  Draw_Ptr check_seg;

  /***********************************************************************
  *   We must set  the new  plot in  the same proportions  by setting    *
  *   the variables  draw_u(x/y)(min/max)  for the user space and the    *
  *   variables ws_(x/y)(min/max)  for the system space the originals    *
  *   value are saved in draw_su(x/y)(min/max) and ws_s(x/y)(min/max)    *
  *   variables.                                                         *
  ***********************************************************************/

  /* Force coord/ycoord to be the minimums and */
  /* ... xcurr/ycurr to be the maximums.       */

  ryx = ds_ry/ds_rx;                            // Get the Window Y/X ratio.

  if (cfflg >= 0) {                             // When we define a New View.
    if ( Drwgl_xcoord > Drwgl_xcurr)
      { exc = Drwgl_xcoord; Drwgl_xcoord = Drwgl_xcurr; Drwgl_xcurr = exc; }
    if ( Drwgl_ycoord > Drwgl_ycurr)
      { exc = Drwgl_ycoord; Drwgl_ycoord = Drwgl_ycurr; Drwgl_ycurr = exc; }

    // Set the Correct High/Width Proportions.

    sx = (Drwgl_xcurr - Drwgl_xcoord)*0.5; sy = (Drwgl_ycurr - Drwgl_ycoord)*0.5;
    px = (Drwgl_xcurr + Drwgl_xcoord)*0.5; py = (Drwgl_ycurr + Drwgl_ycoord)*0.5;

    // Adjust to keep the same Y/X proportions.
    if (sy > ryx*sx) sx = sy/ryx;
                else sy = sx*ryx;
    if (cfflg) {                                // Mode with confirmation/
      check_seg = Draw_New_Sys_Seg( 3, 0 );     // Show the new Zoom limits as a new system segment.
      Draw_GPlot_Rect( px - sx, py - sy, px + sx, py + sy );
      draw_curseg = NULL;                       // fisnish the segment.
      fltk::lock();
      redraw();                                 // Perform A picture Redraw.
      rq = fltk::ask( "OK for Zoom?" ) == 1;    // Prompt the User for Agreement and delete the check rectangle.
      fltk::unlock();
      Draw_Destroye( check_seg );               // Destroye the segment ...
      if (!rq) { redraw(); return 0; }          // and return when the Zoom is canceled.
    }

    // Check for too small limits when cfflg = 0.
    if ((sx < dw_cwsx*0.05)||(sy < dw_cwsy*0.05)) return 0;   // Cancel any zoom with too small selection.

    // Save last View Setting.
    dw_zwsx  =  dw_cwsx; dw_zwsy  =  dw_cwsy; dw_zwpx  =  dw_cwpx; dw_zwpy  =  dw_cwpy;
    dw_zxmin = dw_cxmin; dw_zxmax = dw_cxmax; dw_zymin = dw_cymin; dw_zymax = dw_cymax;
    zxy_scale = cxy_scale; efzxy_scale = efcxy_scale;

  } else { // Restore old View.
    sx = dw_zwsx; sy = dw_zwsy;
    px = dw_zwpx; py = dw_zwpy;
  }

  // Here sx, sy, px and py are the new parameters.

//fprintf( fmsg, " Pict_Scale Initial Usr Size = %f,%f\n", dw_cwsx, dw_cwsy );
//fprintf( fmsg, " Pict_Scale required parm =(%f,%f,%f,%f)\n", sx, sy, px, py );
//fflush( fmsg );

  dw_cwsx  =      sx; dw_cwsy  =      sy; dw_cwpx  =      px; dw_cwpy  =      py;
  dw_cxmin = px - sx; dw_cymin = py - sy; dw_cxmax = px + sx; dw_cymax = py + sy;
  cxy_scale         =  0.5*ds_rx/dw_cwsx; efcxy_scale       =      1.0/cxy_scale;

//fprintf( fmsg, " Pict_Scale final parm = (%f,%f,%f,%f)\n", sx, sy, px, py );
//fprintf( fmsg, "*Pict_Scale -> minmax = (%f,%f,%f,%f)\n",
//               dw_cxmin, dw_cymin, dw_cxmax, dw_cymax );
//fprintf( fmsg, " zxy_scale = %f, cxy_scale = %f\n", zxy_scale, cxy_scale );
//fflush( fmsg );

  Draw_ScrollEdit();
  redraw();
  return 1;
}



void Draw_Window::Send_Curve( void )
{ // End of Get Line Request.
  // Finish to Create the new draw Segment.
  if (Drwgl_gptcnt) {
    draw_curseg = NULL;
//  fprintf( fmsg, " Send Curve point # %d/%d\n", Plot_Size, Drwgl_gptcnt );
//  fflush( fmsg );
    // Request User for Input Agreement.
    if (fltk::ask( "OK to Keep these Graphic Input?" ) == 1) {
      // Send the points to the User Program
      // When Required, Insert the Points in the Current User List.
      Drwgl_senddir = Draw_User_Append( Curve_Seg );
//    fprintf( fmsg, " Send Curve send the first data Packet.\n" );
//    fflush( fmsg );
      Draw_Send_Points( 0 );                    // Send the first packet (2D).
      Draw_ProgPlot_End();                      // Close the progressive 2D Plot Node.
      return;
    }
  }
  Draw_Destroye( Curve_Seg );
  Drwgl_senddir = NULL;
  Sdrw_Put_Int( 1 );
  Sdrw_Put_Int( 0 );
}



void Build_Rect_Echo( float x1, float y1, float x2, float y2 )
{
  echo_seg = Draw_New_Sys_Seg( 6, 0 );                  // Show the new Zoom limits as a new system segment.
  echo_seg->seg.seg_mat[14] = 0.5*Draw_pic_zz;          // Prepare to plot on the Top of Z plane.
  Draw_GPlot_Rect( x1, y1, x2, y2 );                    // Plot the Segment.
  echo_dtb = echo_seg->seg.seg_fdir->tab.plo_tab;       // Keep plot table for coordinates editing.
}



void Draw_Window::MouseDown( int x, int y, int button )
{
  if (reqflg==1) {                              // If Implicite Request from Draw$Dialog activity.
    Drwgl_Proceed = (Drwgl_zoomview)?Drwgl_viewflg:drwgl_zoom;     // Set The Request Identifier.
    reqflg        = 2;                          // Set the Dialog Activity Flag to req/Dialog status.
    clic_requ     = 1;                          // Set the Clic as already done.
    mouse_status  = 0;                          // Set to no push to execute the following code.
    Drwgl_mactive = 1;                          // Set the mouse request activity flag.
    // Set the (X,Y) coordinates string names.
    if (Drwgl_xusr_unt[0]) Drwgl_unitx = Drwgl_xusr_unt;
                      else Drwgl_unitx = def_unit;
    if (Drwgl_yusr_unt[0]) Drwgl_unity = Drwgl_yusr_unt;
                      else Drwgl_unity = def_unit;
    cursor( fltk::CURSOR_CROSS );               // Set the Mouse request cursor.
  }

  if (Drwgl_mactive&&(!mouse_status)) {         // When the mouse is active without pressed button.
    DrwGL_Get_World_XY( x, y );                 // Translate the screen coordinates to World one.
    switch (Drwgl_Proceed) {                    // Process The Request.
      case drwgl_line:
        if (!Drwgl_gptcnt) {                    // -- Drwgl_gptcnt = 0 done by Draw_Input_Request method.
          saved_plot_mode = draw_out_mode;
          Curve_Seg = Draw_New_Sys_Seg( 11, 0 );// Create the Line segment.
          Draw_Gen_Def_Color( Drwgl_eglin_col );
          if (Drwgl_eglin_mod > 1) {
            draw_out_mode =   2;                // Set the Marker Mode.
            Draw_Gen_Mattr( Drwgl_eglin_knd, Drwgl_eglin_siz );     // Select Marker kind and size.
          } else {
            draw_out_mode =   1;                // Set the line Mode.
            Draw_Gen_Lattr( Drwgl_eglin_knd, Drwgl_eglin_siz );     // Select Line kind and size.
          }
        }
      break;

      case drwgl_usr_zoom:
      case drwgl_zoom:
      case drwgl_window:
      case drwgl_pick:
      case drwgl_position:
        Drwgl_xcoord = Drwgl_xcurr;             // Store position in world coordinates.
        Drwgl_ycoord = Drwgl_ycurr;
      break;

      case drwgl_stroke:
        saved_plot_mode = draw_out_mode;        // Save the current mode.
        draw_out_mode =   1;                    // Set the line Mode.
        Curve_Seg = Draw_New_Sys_Seg( 11, 0 );  // Create the Echo/Stroke segment.
        Draw_ProgPlot( Drwgl_xcurr, Drwgl_ycurr );      // Put the first stroke vertex.
        Drwgl_gptcnt = 1;                       // Init to one the Stroke Vertex Count ...
        redraw();                               // and update the screen.
      break;

      case drwgl_usr_anmv:
      case drwgl_anmv:
        if (Drwgl_segment) {                    // A segment was Picked. (Drwgl_segment is its identifier number).
          Draw_Ptr p = Draw_Locate_Seg( Drwgl_segment );
          Drwgl_ViewMat = p->seg.seg_mat;
          Draw_Destroye( echo_seg );            // We destroye the pick echo segment
          echo_seg = 0;
        } else break;
      case drwgl_usr_view:
      case drwgl_view:
      case drwgl_usr_move:
      case drwgl_move:
        DrwGL_Init_View_Matrix( button == 2 );  // Button 1|3 are same - 2 do only to see.
      break;

      default: // Ignore Event.
        ;
    }
    mouse_status =  1;                          // Set the Push button status.
  }
}



void Draw_Window::MouseDrag( int x, int y, int button )
{
  float      x1, y1, x2, y2, px, py, sx, sy;

  if (Drwgl_mactive&&mouse_status) {
    DrwGL_Get_World_XY( x, y );
    switch (Drwgl_Proceed) {
      case drwgl_usr_zoom:
      case drwgl_zoom:
      case drwgl_window:
        sx = (Drwgl_xcurr - Drwgl_xcoord)*0.5; sy = (Drwgl_ycurr - Drwgl_ycoord)*0.5;
        px = (Drwgl_xcurr + Drwgl_xcoord)*0.5; py = (Drwgl_ycurr + Drwgl_ycoord)*0.5;
        x1 = px - sx; x2 = px + sx; y1 = py - sy; y2 = py + sy;
        if (!echo_seg) Build_Rect_Echo( x1, y1, x2, y2 );        // The first time, we create the echo segment,
                  else { // echo_dtb[0] = x1;  // ... and for other drag it, we update the coordinates.
                         // echo_dtb[1] = y1;  // Only x2 and y2 are changed during the zoom or window input.
                            echo_dtb[2] = x2;
                         // echo_dtb[3] = y1;
                            echo_dtb[4] = x2;
                            echo_dtb[5] = y2;
                         // echo_dtb[6] = x1;
                            echo_dtb[7] = y2;
                       }
        redraw();
      break;

      case drwgl_stroke:
        if (Drwgl_gptcnt >= Drwgl_gptmax) {     // If the buffer is full ...
          mouse_status  = 0;                    // Release the Mouse status.
          Drwgl_mactive = 0;                    // Clear the mouse activity mode.
          Send_Curve();                         // we resume the stroke user request ...
          fltk::lock();
          cursor( fltk::CURSOR_DEFAULT );
          fltk::unlock();
          Drwgl_Proceed = drwgl_nothing;
          DrwSrv_End_Request();
        } else {                                // else we append the new vertex ...
          Drwgl_gptcnt++;                       // to the stroke segment.
          Draw_ProgPlot( Drwgl_xcurr, Drwgl_ycurr );
          fltk::lock();
          redraw();                             // We update the screen.
          fltk::unlock();
        }
      break;

      case drwgl_usr_view:
      case drwgl_view:
        DrwGL_Change_View_Matrix();             // We update the view matrix.
        redraw();                               // Perform a picture Redraw.
      break;

      case drwgl_usr_anmv:
      case drwgl_anmv:
      case drwgl_usr_move:
      case drwgl_move:
        DrwGL_Change_Posit_Matrix();            // We update the view matrix.
        redraw();
      break;

      default: // Ignore.
        ;
    }
  }
}



void Draw_Window::MouseUp( int x, int y, int button )
{
  int     i;
  float  xc,  xd,  yc,  yd,  zc,  zd, exc;

  if (Drwgl_mactive&&mouse_status) {            // Check for mouse activity and status.
    DrwGL_Get_World_XY( x, y );                 // Translate the screen coordinates to World one.
    mouse_status = 0;                           // Release the Mouse status.
    switch (Drwgl_Proceed) {
      case drwgl_pick:
      case drwgl_position:
        Drwgl_mactive = 0;                      // Clear the mouse activity mode.
        // Compute the Screen Coordinates.
        Drwgl_xcoord = Drwgl_xcurr;
        Drwgl_ycoord = Drwgl_ycurr;
        Drwgl_status = (button != 2)?1:-1;
        if (Drwgl_Proceed == drwgl_pick) {      // For pick request, ...
          if (echo_seg) {                       // when an echo is displayed, we must delete it.
            Draw_Destroye( echo_seg );          // Destroye the segment.
            echo_seg = 0;
            redraw();
          }
          if (!Drwgl_segment) Drwgl_status = -1;// If no segment are pick-in, we return no pick status.
          Sdrw_Put_Int( Drwgl_status );
          Sdrw_Put_Int( Drwgl_segment );
          Sdrw_Put_Int( Drwgl_ident );
        } else {                                // For position request.
          Sdrw_Put_Int( Drwgl_status );         // Send the status.
          if (Draw_Opened_Box) {                // When a Axis Box is opened, we translate the coordinates ...
            Draw_UnScale( &xc, &yc, &zc, Drwgl_xcoord, Drwgl_ycoord, 0.0 );
          } else {
            xc = Drwgl_xcoord - orgx;           // else set in agreement with the user origine.
            yc = Drwgl_ycoord - orgy;
          }
          Sdrw_Put_Float( xc );                 // Send the coordinates.
          Sdrw_Put_Float( yc );
        }
        fltk::lock();
        cursor( fltk::CURSOR_DEFAULT );
        fltk::unlock();
        Drwgl_Proceed = drwgl_nothing;
        DrwSrv_End_Request();
      break;

      case drwgl_window:
        Drwgl_mactive = 0;                      // Clear the mouse activity mode.
        if (echo_seg) {                         // For an existing echo, we can clear it.
          Draw_Destroye( echo_seg );            // Destroye the segment.
          echo_seg = 0;
          redraw();
        }
        // Sort the World coordinates with Drwgl_*coord > Drwgl_*curr.
        if ( Drwgl_xcoord > Drwgl_xcurr)
          { exc = Drwgl_xcoord; Drwgl_xcoord = Drwgl_xcurr; Drwgl_xcurr = exc; }
        if ( Drwgl_ycoord > Drwgl_ycurr)
          { exc = Drwgl_ycoord; Drwgl_ycoord = Drwgl_ycurr; Drwgl_ycurr = exc; }

        Sdrw_Put_Int( (button != 2)?1:-1 );     // Send the request status.
        if (Draw_Opened_Box) {                  // Translate coordinates if an axis box if opened ...
          Draw_UnScale( &xc, &yc, &zc, Drwgl_xcoord, Drwgl_ycoord, 0.0 );
          Draw_UnScale( &xd, &yd, &zd, Drwgl_xcurr,  Drwgl_ycurr,  0.0 );
        } else {                                // else set in agreement with the user origine.
          xc = Drwgl_xcoord - orgx; yc = Drwgl_ycoord - orgy;
          xd = Drwgl_xcurr  - orgx; yd = Drwgl_ycurr  - orgy;
        }
        Sdrw_Put_Float( xc );                   // Send the rectangle coordinates and sizes.
        Sdrw_Put_Float( yc );
        Sdrw_Put_Float( xd );
        Sdrw_Put_Float( yd );
        fltk::lock();
        cursor( fltk::CURSOR_DEFAULT );         // Resume the User Request.
        fltk::unlock();
        Drwgl_Proceed = drwgl_nothing;
        DrwSrv_End_Request();
      break;

      case drwgl_usr_zoom:
      case drwgl_zoom:
      {
        Drwgl_mactive = 0;                      // Clear the mouse activity mode.
        if (echo_seg) {                         // When the echo is active.
          Draw_Destroye( echo_seg );            // We destroye the echo segment
          echo_seg = 0;
          redraw();                             // and we update the screen.
        }
        fltk::lock();
        cursor( fltk::CURSOR_DEFAULT );
        fltk::unlock();
        i = Draw_Scale( (clic_requ == 0) );     // Update the Draw_Picture screen.
        redraw();
        if (Drwgl_Proceed == drwgl_usr_zoom) {  // For Zoom User Request ...
          Drwgl_Proceed = drwgl_nothing;        // we resume the request.
          DrwSrv_End_Request();
        } else {                                // else for Zoom Dialog Request ...
          Drwgl_Proceed = drwgl_dialog;         // we return to Dialog context.
          clic_requ     =            0;
          reqflg        =            1;
        }
        break;
      }

      case drwgl_usr_anmv:
      case drwgl_anmv:
      case drwgl_usr_view:
      case drwgl_view:
      case drwgl_usr_move:
      case drwgl_move:
        Drwgl_mactive = 0;                      // Clear the mouse activity mode.
        fltk::lock();
        cursor( fltk::CURSOR_DEFAULT );
        fltk::unlock();
        i = DrwGl_Finish_View_Request();
        if ((Drwgl_Proceed == drwgl_usr_view)||
            (Drwgl_Proceed == drwgl_usr_move)||
            (Drwgl_Proceed == drwgl_usr_anmv)) {  // View/move/anonymous_move User Request.
          if (i) redraw();
          Sdrw_Put_Int( (i)?-1:Drwgl_segment );
          Drwgl_Proceed = drwgl_nothing;
          DrwSrv_End_Request();
        } else {                                // View Dialog Request.
          if (Drwgl_exitmd&2) {                 // Go out of Dialog when required.
            reqflg = 0;                         // Disable the dialog mode.
            Drwgl_Input =drwgl_nothing;
            Drwgl_Dstatus = 100000;             // Flag for stop on Mouse flagged action.
            DrwGL_Sensibility( 0 );             // Clear the Dialog Menu sensitivity.
            DrwSrv_End_Request();               // Return to the user mode.
          } else {
            Drwgl_Proceed = drwgl_dialog;       // Reset the Dialog context.
            clic_requ     =            0;
            reqflg        =            1;
          }
        }
      break;

    case drwgl_line:
      if ((button==2)||(Drwgl_gptcnt >= Drwgl_gptmax)) {
//      fprintf( fmsg, " Get_Line End with %d points.\n", Drwgl_gptcnt );
//      fflush( fmsg );
        // The line request is finished.
        Drwgl_mactive = 0;                      // Clear the mouse activity mode.
        fltk::lock();
        cursor( fltk::CURSOR_DEFAULT );         // Restore the default cursor.
        fltk::unlock();
        Send_Curve();                           // Initialize the Send the Data process.
        Curve_Seg = NULL;                       // Close the Line Input Segment ...
        Drwgl_Proceed = drwgl_nothing;          // and resume the user request.
        DrwSrv_End_Request();
      } else {
        // The line request is continuing.
        Drwgl_gptcnt++;                         // Append the new 2D vertex to the line segement ...
        Draw_ProgPlot( Drwgl_xcurr, Drwgl_ycurr );
        fltk::lock();
        cursor( fltk::CURSOR_DEFAULT );
        redraw();                               // and update the screen.
        fltk::unlock();
        return;
      }
    break;

    case drwgl_stroke:
      if (Drwgl_gptcnt < Drwgl_gptmax) {
        Draw_ProgPlot( Drwgl_xcurr, Drwgl_ycurr );
        redraw();
        Drwgl_gptcnt++;
      }
//    fprintf( fmsg, " Get_Stroke End point # %d\n", Drwgl_gptcnt );
//    fflush( fmsg );
      fltk::lock();
      fltk::cursor( fltk::CURSOR_DEFAULT );
      fltk::unlock();
      Send_Curve();
////  draw_out_mode = saved_plot_mode;
      Drwgl_Proceed = drwgl_nothing;
      DrwSrv_End_Request();
    break;

    default: // Ignore.
      ;
    }
//  Drwgl_Proceed = drwgl_nothing;
  }
}


void Draw_Window::MouseMove( int x, int y )
{ float   xx, yy;
  if (Drwgl_mactive&&(!mouse_status))
  {
    DrwGL_Get_World_XY( x, y );
    mouse_status  = 0;
    switch (Drwgl_Proceed) {
      case drwgl_pick:
      case drwgl_anmv:
      case drwgl_usr_anmv:
        DrwGL_Pick_Search( x, y );
//      Drwgl_pecho = 0;
        if (Drwgl_segment) {
          DrwGL_Get_World_XY( Drwgl_pechx, Drwgl_pechy );
          xx = Drwgl_xcurr; yy = Drwgl_ycurr;
          DrwGL_Get_World_XY( Drwgl_pechx + Drwgl_pechw, Drwgl_pechy + Drwgl_pechh );
          Build_Rect_Echo( xx, yy, Drwgl_xcurr, Drwgl_ycurr );
        } else {
          Draw_Destroye( echo_seg );            // We destroye the pick echo segment
          echo_seg = 0;
        }
        redraw();
        break;

      default: ;
    }
  }
}



int Draw_Window::handle( int e )
{
  int mx, my, bt;

  mx = fltk::event_x(); my = fltk::event_y(); bt = fltk::event_key();
//  srvw0->w_fram->make_current();
//  srvw0->w_fram->flags(srvw0->w_fram->flags()&~fltk::INVISIBLE);

  switch (e) {
    case 999: // Draw_request Event.
      fltk::lock();
      fltk::redraw();
      fltk::unlock();
      fprintf( fmsg, " Draw_Request Event 999 Set.\n" );
      fflush( fmsg );
      return 1;

    case fltk::PUSH:
      MouseDown( mx, my, bt );
      cursor_ix = mx, cursor_iy = my;
      return 1;

    case fltk::RELEASE:
      MouseUp( mx, my, bt );
      cursor_ix = mx, cursor_iy = my;
      return 1;

    case fltk::DRAG:
      if ((cursor_ix == mx)&&(cursor_iy == my)) return 1;
      MouseDrag( mx, my, bt );
      cursor_ix = mx, cursor_iy = my;
      return 1;

    case fltk::MOVE:
      if ((cursor_ix == mx)&&(cursor_iy == my)) return 1;
      MouseMove( mx, my );
      cursor_ix = mx, cursor_iy = my;
      return 1;

//  case fltk::MOUSEWHEEL:
//    ic = fltk::event_dy();
//    return 1;

    case fltk::ENTER:
      cursor_ix = mx, cursor_iy = my;
//    printf( "  Mouse is ENTER at (%d,%d)\n", mx , my );
      return 1;

    case fltk::LEAVE:
      cursor_ix = mx, cursor_iy = my;
//    printf( "  Mouse is LEAVE at (%d,%d)\n", mx, my );
      return 1;

    case fltk::SHOW:
      cursor_ix = -1, cursor_iy = -1;
      show();
      return 1;

  default:
    // let the base class handle all other events:
    //  return fltk::GlWindow::handle(event);
    //  printf( " IGNORE %d\n", e );
    return 0;
  }
}



void Draw_Window::Draw_ScrollEdit()
{
//
// Routine (method) to adapt the slider_sizes in the the W and Y Scrollbar.
// This routine update also the window parameters w_widt and w_high.
//
  fltk::Scrollbar* xb = srvw0->w_scrx;
  fltk::Scrollbar* yb = srvw0->w_scry;

  scr_xs = (int)(10000.0*(dw_cwsx/dw_iwsx) + 0.5);                      // Visible X Window sise in 1/10000.
  scr_ys = (int)(10000.0*(dw_cwsy/dw_iwsy) + 0.5);                      // Visible Y Window sise in 1/10000.
  scr_xp = (int)(5000.0*(1.0 + (dw_cwpx - dw_cwsx)/dw_iwsx) + 0.5);     // Related X position in 1/10000.
  scr_yp = (int)(5000.0*(1.0 - (dw_cwpy + dw_cwsy)/dw_iwsy) + 0.5);     // Related Y position in 1/10000.

  if (scr_xs>10000) scr_xs = 10000;
  if (scr_xp<0) scr_xp = 0;
  if (scr_xp+scr_xs>10000) scr_xp = 10000 - scr_xs;

  if (scr_ys>10000) scr_ys = 10000;
  if (scr_yp<0) scr_yp = 0;
  if (scr_yp+scr_ys>10000) scr_yp = 10000 - scr_ys;

  fltk::lock();
  xb->value( scr_xp, scr_xs, 0, 10000 );        // Update the X Scroll Bar.
  yb->value( scr_yp, scr_ys, 0, 10000 );        // Update the Y Scroll Bar.
  fltk::unlock();
}


void Draw_Window::Draw_Resize( int ww, int hh )
{
  float rscf;

  if (draw_noscalech > 1) { draw_noscalech = 0; /* return; */ } // Nothing to do on init mode.

  srvw0->w_widt = ww;                           // Get the OPENGL Drawing space (in pixel).
  srvw0->w_high = hh;

//fprintf( fmsg, " Resize from [%d,%d] to [%d,%d]\n", dt_rx, dt_ry, ww, hh );
//fprintf( fmsg, " Old Window sizes (cm) (%f,%f)\n", ds_rx, ds_ry );
//fflush( fmsg );

  if ((ww > 10)&&(hh > 10)) { // Not Null size.
//  fprintf( fmsg, " OLD rx=%f, ry=%f\n", ds_rx, ds_ry );
    ds_rx = ((float) ww)/d_xscale;              // Get the new window size in (screen) cm.
    ds_ry = ((float) hh)/d_yscale;
    dt_rx = ww; dt_ry = hh;                     // Set new window(= glViewport) sizes.

//  fprintf( fmsg, " rx=%f, ry=%f, Pic_xx = %f, Pic_yy = %f\n",
//                 ds_rx, ds_ry, Draw_pic_sx, Draw_pic_sy );
//  fprintf( fmsg, " Initial:     iw = (%f,%f), cw=(%f,%f).\n", dw_iwsx, dw_iwsy, dw_cwsx, dw_cwsy );
//  fprintf( fmsg, " Old Nominal: sw = (%f,%f).\n", dw_swsx, dw_swsy );
//  fprintf( fmsg, " Old Scales (Init, Nominal, P. Zoom, Current = %f, %f, %f, %f\n", ixy_scale, sxy_scale, zxy_scale, cxy_scale );

    /* Compute the new sxy_scale. The displayed frame
       - The picture proportions does not be changed. */
    if (!draw_noscalech) { // Change size with change of windows sizes.
      rscf = sxy_scale;                         // Save the old nominal scale.
      //. Compute the New Nominal Scale.
      if (ds_rx*dw_iwsy >= ds_ry*dw_iwsx) sxy_scale = (0.5*ds_ry)/dw_iwsy;
                                     else sxy_scale = (0.5*ds_rx)/dw_iwsx;
      rscf = sxy_scale/rscf;                    // Get the Scale change factor.
      zxy_scale *= rscf;  cxy_scale *= rscf;    // Set the new old zoom and new current scales.

      efsxy_scale = 1.0/sxy_scale;              // Set the new scales**-1 values.
      efzxy_scale = 1.0/zxy_scale;
      efcxy_scale = 1.0/cxy_scale;
    }

//  fprintf( fmsg, " New Scales (Init, Nominal, P. Zoom, Current = %f, %f, %f, %f\n", ixy_scale, sxy_scale, zxy_scale, cxy_scale );

    // Set the new nominal, previous zoom and current Window sizes.

    dw_swsx = (0.5*ds_rx)*efsxy_scale; dw_swsy = (0.5*ds_ry)*efsxy_scale;
    dw_zwsx = (0.5*ds_rx)*efzxy_scale; dw_zwsy = (0.5*ds_ry)*efzxy_scale;
    dw_cwsx = (0.5*ds_rx)*efcxy_scale; dw_cwsy = (0.5*ds_ry)*efcxy_scale;

    // Set the new World Window limits and saved one */

    dw_sxmin = dw_swpx - dw_swsx; dw_symin = dw_swpy - dw_swsy;
    dw_sxmax = dw_swpx + dw_swsx; dw_symax = dw_swpy + dw_swsy;
    dw_zxmin = dw_zwpx - dw_zwsx; dw_zymin = dw_zwpy - dw_zwsy;
    dw_zxmax = dw_zwpx + dw_zwsx; dw_zymax = dw_zwpy + dw_zwsy;
    dw_cxmin = dw_cwpx - dw_cwsx; dw_cymin = dw_cwpy - dw_cwsy;
    dw_cxmax = dw_cwpx + dw_cwsx; dw_cymax = dw_cwpy + dw_cwsy;

//  fprintf( fmsg, " New Current Position = (%f,%f), New Current Size = (%f,%f).\n",
//                 dw_cwpx, dw_cwpy, dw_cwsx, dw_cwsy );
//  fprintf( fmsg, " New P. Zoom Position = (%f,%f), New P. Zoom Size = (%f,%f).\n",
//                 dw_zwpx, dw_zwpy, dw_zwsx, dw_zwsy );
//  fprintf( fmsg, " New Nominal Position = (%f,%f), New Nominal Size = (%f,%f)\n",
//                 dw_sxmin, dw_sxmax, dw_symin, dw_symax );
//  fflush( fmsg );

  }
  Draw_ScrollEdit();
  scroll_ok = 1;
}



void Draw_Window::Draw_Input_Request( void )
{
  // Set the (X,Y) Coordinates string names.
  if (Drwgl_xusr_unt[0]) Drwgl_unitx = Drwgl_xusr_unt;
                    else Drwgl_unitx = def_unit;
  if (Drwgl_yusr_unt[0]) Drwgl_unity = Drwgl_yusr_unt;
                    else Drwgl_unity = def_unit;
  mouse_status  =                    0;         // Init the mouse status without push of button.
  Drwgl_mactive =                    1;         // Set the active mouse state.
  Plot_Size     =                    0;         // Init the plot sequence size.
  clic_requ     =                    0;         // Set as waiting a clic status.
  Drwgl_gptcnt  =                    0;         // Init line and stroke Vertex Count.
  Drwgl_Proceed =          Drwgl_Input;         // Set the request mode for status display.
  fltk::lock();
  cursor( fltk::CURSOR_CROSS );                 // Set the active mouse cursor.
  fltk::unlock();
  Drwgl_Input  =         drwgl_nothing;         // Clear the requested input identifier.
}



void Draw_Window::draw()
{
  static int DrwGL_Init_Flg = 0;

//
// This method is called on each OpenGL Window size change
// and for each redraw call.
//

  if (!DrwGL_Init_Flg) {
    DrwGL_Init();
    DrwGL_Init_Flg = 1;
//  Drwgl_Proceed = drwgl_nothing;
    Drwgl_GLInit = 1;
//  Drwgl_pecho  = 0;

  }

  if (!valid()) Draw_Resize( w(), h() );

  if (Drwgl_srvcall) {                  // Management of GL service Call.
    switch (Drwgl_srvcall) {            // Dispatch to the requested function.
      case DRWGL_GET_BOXSZ:  DrwGL_eval_string_box(); break;
      // For future.
      case DRWGL_SEG_APPEND:
      case DRWGL_SEG_REMOVE:
      case DRWGL_DIR_APPEND:
      case DRWGL_DIR_REMOVE:
     break;
  default: ; /* case DRWGL_MAK_IMAGE: not implemented */
    }
    Drwgl_srvcall = 0;
    DrwSrv_End_Request();               // Resume the Pipe Process.
  }

//if (Draw_Qfirst)                      // When the matrix change queue is not empty ...
//  Draw_Process_Seq( Draw_Qfirst, 1 ); // ... performs the specified actions.

  // Perform any Picture Build or Update.
  glPushMatrix();
  if (Drwgl_ImgFlg)
    DrwGL_GLBuild_Image();              // Save Picture Bit-Map.
  else {
//fprintf( fmsg, " Draw : Lock\n" ); fflush( fmsg );
    DrwSrv_Lock();                      // Normal Display Update
//fprintf( fmsg, " Draw exec\n" ); fflush( fmsg );
    DrwGL_Display();
//fprintf( fmsg, " Draw : UnLock\n" ); fflush( fmsg );
    DrwSrv_Unlock();
  }
  glPopMatrix();
}


