/***** DRAW Interface ROUTINES for OpenGL Graphic Libary *******/
/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*          F L T K / D R A W   -   S E R V E R   M O D U L E            *
*                                                                       *
*           Version  1.4-C for Draw Library Level V 2.4 A               *
*                                                                       *
*      (Draw interface for FLTK/OPENGL function and procedures)         *
*                                                                       *
*                               by                                      *
*                                                                       *
*         Pierre Wolfers, Laboratoire de Cristallographie               *
*                                                                       *
*         CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166               *
*                                                                       *
*                    F 38042 GRENOBLE CEDEX 9                           *
*                                                                       *
*                          F R A N C E                                  *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/

/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/


#ifndef _DRAWGL_BASE_ENV
# define _DRAWGL_BASE_ENV 0



/* include the environment SERVER */

# include "Server_GL.h"
# include "Server_Env.h"





/**************************************************************************/
/*                                                                        */
/*                 DRAW/GL Font Structure Definitions                     */
/*                                                                        */
/**************************************************************************/




      /******* Compatible with the font file of X-GKS ***********/

# define MXFBFSZ   16384          /* Maximal size of a Font draw table */



/* vc_type : semantics of vc_x and vc_y:
 *	s = character extent minimum
 *	S = character extent maximum
 *	m = move current position to
 *	d = draw to 
 *	e = end of character definition
 */
// typedef struct { /* Character Drawing directive */
//                  char         chd_dir,
//                               chd_flag;
//                  word         chd_x;
//                  word         chd_y;
//                } drwfnt_dir;



/*
 * Each font has 256 characters (some may be undefined) each of which is
 * defined by an array of vcharst structuresDraw_Locate_Seg( n );
 */

// typedef struct drwfnt_buf * drwlft_ptr;

// typedef struct drwfnt_buf { /* Font Descriptor */
//                     char    fnt_name[30];   /* Font Name */
//                     word    fnt_nominalx,   /* Nominal Char. Size (size 'm') */
//                             fnt_nominaly,
//                             fnt_top,        /* Displacment from y == 0 */
//                             fnt_cap,
//                             fnt_half,
//                             fnt_base,
//                             fnt_bottom;
//                     int     fnt_off_tb[256];/* offset into fnt_dtb to the
//                                              * beginning of each character.
//                                              * -1 => undefined char. */
//                     drwfnt_dir fnt_dtb[1];  /* the graphic directives */
// } drwfnt_buf;





/**************************************************************************/
/*                                                                        */
/*                 DRAW/GL Data Structure Definitions                     */
/*                                                                        */
/**************************************************************************/

# define DRWSTRBUF_LENGTH  256

# define DRWSTATUS_UPDATE    1
# define DRWSTATUS_INPUT     2
# define DRWSTATUS_LIFE      4

# define ATTRSTKSZ         256           /* Attribute Stack size */

# define DRWGL_BLD_ENA       1
# define DRWGL_BLD_DIS       2
# define DRWGL_BLD_DENA      4
# define DRWGL_BLD_DDIS      8

# define DRWGL_GET_BOXSZ     1           /* Service call indexies value(s) (must be > 0) */
# define DRWGL_MAK_IMAGE     2           /* To Create an high resolution image */
# define DRWGL_SEG_APPEND    3           /* To append a specified segment to the segment list */
# define DRWGL_SEG_REMOVE    4           /* To remove a specified segment from the segment list */
# define DRWGL_DIR_APPEND    5           /* To append a specified directive to the current segment */ 
# define DRWGL_DIR_REMOVE    6           /* To remove a specified directive from the current segment */



/* The Time unit is 0.001 second */
/* Define the Time Clock default periods */
/* 50ms for Clock Event and 500ms for X/Y Update */

# define DRWTIME_UNIT      0.001000
# define DRWTIME_PERIOD          50
# define DRWCLOCK_COUNT         500

# define UnitSz             32

#  ifdef _DRAWGL_DEF_GLOBAL
#    define exglrf
#    define exglini( val ) = val
#  else
#    define exglrf extern
#    define exglini( val )
#  endif



  /* Types for attribute stack */

typedef struct { /* Attribute Stack Element */
                int           lin_type,
                              mrk_type,
                              fil_type,
                              fil_styl,
                              txt_haln,
                              txt_valn,
                              txt_path,
                              lgh_stat;
                void *        txt_font;
                float         lin_size,
                              mrk_size,
                              txt_expf,
                              txt_spcf,
                              txt_dept;
                Draw_RGBA     col_rgba;
               } drwgl_astkel;



  /* Types of user Input Interaction */

typedef char  Drwgl_Strtyp[DRWSTRBUF_LENGTH];

typedef enum  { drwgl_nothing,
                drwgl_dialog,
                drwgl_message,
                drwgl_dsplmsg,
                drwgl_choice,
                drwgl_answerd,
                drwgl_string,
                drwgl_file,
                drwgl_color,
                drwgl_value,
                drwgl_pannelreq,
                drwgl_position,
                drwgl_window,
                drwgl_line,
                drwgl_stroke,
                drwgl_pick,
                drwgl_zoom,
                drwgl_usr_zoom,
                drwgl_view,
                drwgl_usr_view,
                drwgl_move,
                drwgl_usr_move,
                drwgl_anmv,
                drwgl_usr_anmv,
                drwgl_scale,
                drwgl_usr_scale,
                drwgl_print,
                drwgl_usr_print,
                drwgl_grid,
                drwgl_usr_grid,
                drwgl_reload,
                drwgl_refresh,
                drwgl_exit,
                drwgl_null
              } Drwgl_Inptyp;





/**************************************************************************/
/*                                                                        */
/*                       DRAW/GL Local Variables                          */
/*                                                                        */
/**************************************************************************/

#  ifdef _DRAWGL_DEF_GLOBAL

const char * Drwgl_StatusStr[drwgl_null] =
         { "Runing",               // drwgl_nothing or Run,
           "Dialogue Request",     // drwgl_dialog,
           "Message Request",      // drwgl_message,
           "Display_message",      // drwgl_dsplmsg,
           "Choice Request",       // drwgl_choice,
           "Answerd Request",      // drwgl_answerd,
           "String Request",       // drwgl_string,
           "File Request",         // drwgl_file,
           "Color Request",        // drwgl_color,
           "Value Request",        // drwgl_value,
           "Pannel Request",       // drwgl_pannelreq,
           "Position Request",     // drwgl_position,
           "Window Request",       // drwgl_window,
           "Line Request",         // drwgl_line,
           "Stroke Request",       // drwgl_stroke,
           "Segment Pick Request", // drwgl_pick,
           "Zoom Command",         // drwgl_zoom,
           "Zoom Request",         // drwgl_usr_zoom,
           "View_Command",         // drwgl_view,
           "View_Request",         // drwgl_usr_view,
           "Move_Command",         // drwgl_move,
           "Move_Request",         // drwgl_usr_move,
           "Anon. Move Command",   // drwgl_anmv,
           "Anon. Move Request",   // drwgl_usr_anmv,
           "Scale Command",        // drwgl_scale,
           "Scale Request",        // drwgl_usr_scale,
           "Print Command",        // drwgl_print,
           "Print Request",        // drwgl_usr_print,
           "Grid Command",         // drwgl_grid,
           "Grid Request",         // drwgl_usr_grid,
           "Reload Request",       // drwgl_reload,
           "Refresh Request",      // drwgl_refresh,
           "Exit Request"          // drwgl_exit,
         };

#  else

extern const char * Drwgl_StatusStr[drwgl_zoom+1];

#  endif



exglrf char  *       Drwgl_taskname,            /* Task Name pointer */
             *       Drwgl_unitx,               /* Current X Unit */
             *       Drwgl_unity;               /* Current Y Unit */

exglrf  char         Drwgl_xusr_unt[UnitSz],    /* User X Unit */
                     Drwgl_yusr_unt[UnitSz];    /* User Y Unit */

exglrf  GLuint       Drwgl_flags;               /* Status Flag Word for Interface */

exglrf  GLfloat *    Drwgl_ViewMat exglini( NULL );     /* Pointer to view matrix to edit by drwgl_view */

exglrf  int          Drwgl_zoomview,            /* Implicite Zoom - View Fip-flop */
                     Drwgl_print,               /* Print mode flag */
                     Drwgl_status,              /* Saved Status for some Request */
                     Drwgl_Dstatus,             /* Status for Dialog Request. */
                     Drwgl_clipflg,             /* Enable Clipping flag */
                     Drwgl_strcap,              /* Get String Capacity */
                     Drwgl_mactive,             /* Mouse ACtive Flag */
                     Drwgl_fidx,                /* Filter Index for get file */
                     Drwgl_newmd,               /* New mode flag for get file */
                     Drwgl_segment,             /* Picked Segment */
                     Drwgl_ident,               /* Returned Pick Identifier */
                     Drwgl_pechx,               /* Echo Rectangle values */
                     Drwgl_pechy,
                     Drwgl_pechw,
                     Drwgl_pechh,
                     Drwgl_ifont,               /* Font number for get box request */
                     Drwgl_gptmax,              /* Get Line/Strock Task Capacity */
                     Drwgl_gptcnt,              /* Get Line/Strock Point Count */
                     Drwgl_gptins,              /* Get Line/Strock Insertion flag */
                     Drwgl_sendflg,             /* Get Line/Strock Send Flag */
                     Drwgl_inpmdflg,            /* Model Coord Input Flag */ 
                     Drwgl_xlogflg,             /* X Log Scale Axis flag */
                     Drwgl_ylogflg,             /* Y Log Scale Axis flag */
                     Drwgl_segplcnt,            /* Segment plane Counter */
                     Drwgl_astpmod,             /* Animation Stop Mode */
                     Drwgl_astpstate,           /* Animation Stop State Flags */ 
                     Drwgl_exitmd;              /* Exit mode for Dialog Request */

exglrf  int          Drwgl_srvcall     exglini( 0 );    /* Service Call number or 0 */
exglrf  int          Drwgl_egpos_pcurs exglini( 1 );    /* Cursor type to use for Get position */
exglrf  int          Drwgl_eglin_col   exglini( 1 );    /* Color to use for Get_Line echo */
exglrf  int          Drwgl_eglin_mod   exglini( 2 );    /* Out_mode to use for Get_Line echo */
exglrf  int          Drwgl_eglin_knd   exglini( 2 );    /* Kind of Line/Marker to use for Get_Line echo */
exglrf  float        Drwgl_eglin_siz   exglini( 1.5 );  /* Size of Marker/line to use for Get_Line echo */

exglrf  float        Drwgl_timcnt      exglini( 0.0 );  /* Time Event IT count. */
exglrf  int          Drwgl_time_period exglini( DRWTIME_PERIOD );
exglrf  int          Drwgl_clock_count exglini( DRWCLOCK_COUNT );
exglrf  int          Drwgl_period_set  exglini( 0 );

exglrf  int          Drwgl_blend_flag  exglini( 0 );    /* Blending enable flag */
exglrf  int          Drwgl_light_flag  exglini( 0 );    /* Lighting enable flag */

exglrf  int          Drwgl_usr_request exglini( 0 );    /* User Requested options */

exglrf  int          Drwgl_usr_orient  exglini( 0 );    /* Orientation flag */

/* Table of enabled light flag for LIGHT_NUMBER=4 enabled Lights */
exglrf  int          Drwgl_light_entb[LIGHT_NUMBER];

exglrf  Drwgl_Inptyp Drwgl_viewflg;                     /* View or move input operation to DIALOG processed */
exglrf  Drwgl_Inptyp Drwgl_Input   exglini( drwgl_nothing );    /* Current Requested Input Request */
exglrf  Drwgl_Inptyp Drwgl_Proceed exglini( drwgl_nothing );    /* Current Handled Input Request */

exglrf  Drwgl_Strtyp Drwgl_strmsg,              /* Current Message/Title to output */
                     Drwgl_strdef,              /* Current Input String Default */
                     Drwgl_strbuf,              /* String Input Buffer */
                     Drwgl_curpat;              /* Current Path to use to manage the user Files */

exglrf  char**       Drwgl_strtab;              /* Menu string array */

exglrf  Draw_Ptr     Drwgl_pickptr,             /* Pointer of picked directive */
                     Drwgl_senddir,             /* Pointer to directive to Send */
                     Drwgl_currbrf,             /* Pointer to current box reference */
                     Drwgl_currplane;           /* Pointer to current 2D plot plane */

exglrf  float        Drwgl_FixX,                /* Fix point for Mouse Rotation */
                     Drwgl_FixY,
                     Drwgl_FixZ,
                     Drwgl_xcurr,               /* Current Cursor position */
                     Drwgl_ycurr,
                     Drwgl_xmodel,              /* Current model (coord.) position */
                     Drwgl_ymodel,
                     Drwgl_xcoord,              /* Current Selected position */
                     Drwgl_ycoord,
                     Drwgl_xfirst,              /* First X and Y Coordinates in the World ... */
                     Drwgl_yfirst,              /* ... reference with Origine at center */
                     Drwgl_winxsz,              /* Current Selected Region Size */
                     Drwgl_winysz,
                     Drwgl_valmin,              /* MiniMaxi for Get_Value */
                     Drwgl_valmax,
                     Drwgl_valdef,              /* Get_Value Default value */
                     Drwgl_valret,              /* Get Value result */
                     Drwgl_pickzmin,            /* Pick Minimum of z */
                     Drwgl_pickzmax,            /* Pick Maximum of z */
                     Drwgl_Rcolor,              /* RGB Color Input/output */
                     Drwgl_Gcolor,
                     Drwgl_Bcolor;


exglrf  GLdouble     Drwgl_mat_unit[16],        /* Unit Matrix to Keep */
                     Drwgl_proj_wrd[16],        /* System Projection Matrix */
                     Drwgl_modlview[16],        /* Current ModelView Matrix */
                     Drwgl_inpmat[16];          /* Current Input Model Matrix */

exglrf  GLboolean    Drwgl_stipple_state;       /* Stipple enabled or disabled */


exglrf  GLint        Drwgl_tile   exglini( 0 ); /* Flag for Hard-Copy tile partitionning */
exglrf  GLdouble     Drwgl_gxmin, Drwgl_gxmax,  /* Minimum and maximum (in pixels) to applied before generate an image tile */
                     Drwgl_gymin, Drwgl_gymax;

exglrf  GLint        Drwgl_wrdvport[4],         /* System View Port */
                     Drwgl_wprtport[4],         /* System Print View Port */
                     Drwgl_line_stipple,        /* Flag for Line Stipple Requirement */
                     Drwgl_fill_stipple,        /* Flag for Fill Area Stipple Requirement */
                     Drwgl_fill_front,          /* Flag for front face fill mode */
                     Drwgl_fill_back,           /* Flag for back face fill mode */
                     Drwgl_fill_Shift;          /* Flag for Polygon Depth Shift */

exglrf  GLdouble     Drwgl_cliplane0[4],        /* Plane of clipping */
                     Drwgl_cliplane1[4],
                     Drwgl_cliplane2[4],
                     Drwgl_cliplane3[4];

exglrf  drwgl_astkel Drwgl_AStack[ATTRSTKSZ];   /* Dynamic Attribute Stack */

exglrf  drwgl_astkel * Drwgl_Attr exglini( Drwgl_AStack ); /* Current Stack pointer as an address */

exglrf  int          Drwgl_AStkSp exglini( 0 ); /* Dynamic Attribute Stack pointer */
exglrf  int          Drwgl_GLInit exglini( 0 ); /* GL Init Done flag */
exglrf  int        Drwgl_ClrColor exglini( 0 ); /* Flag for Clear Color Change */

exglrf  int          Drwgl_ImgFlg exglini( 0 ); /* Flag to get image map */

exglrf  int          Drwgl_PanChg exglini( 0 ); /* Flag for pannel change */

exglrf  GLdouble  Drws_mix, Drws_miy, Drws_miz, /* Minimum and Maximum for User Selection */
                  Drws_max, Drws_may, Drws_maz,
                  Drwl_mix, Drwl_miy, Drwl_miz, /* Minimum and Maximum for Local limits */
                  Drwl_max, Drwl_may, Drwl_maz,
                  Drwh_mix, Drwh_miy, Drwh_miz, /* Minimum and Maximum for Echo limits */
                  Drwh_max, Drwh_may, Drwh_maz;

exglrf  int       Hits            exglini( 0 ); /* Flag for Selection Hits */



/****  All DRAW-GL interface routines  ****/

void          DrwGL_Usr_Menu_Init( void );

void          DrwGL_Prev_Init( void );
void          DrwGL_Init( void );

void          DrwGL_Seg_Unit_Transform( GLfloat* );
void          DrwGL_Move_Seg(   GLfloat*, float, float, float );
void          DrwGL_URot_Seg(   GLfloat*, float, float, float, float, float, float );
void          DrwGL_Rotate_Seg( GLfloat*, float, float, float, float, float, float );
void          DrwGL_Scale_Seg(  GLfloat*, float, float, float, float, float, float );
void          DrwGL_Transf_Seg( GLfloat*, float, float, float, float, float, float,
                                          float, float, float, float, float, float );

void          DrwGL_Alpha_Set( int );
void          DrwGL_Light_OnOff( int, int );
void          DrwGL_ColorRGB( Draw_RGBA );
void          DrwGL_Line_Attr( int, float );
void          DrwGL_Marker_Attr( int, float );
void          DrwGL_Fill_Attr( int, int );

void          DrwGL_Push_Bxrf( Draw_Ptr );
void          DrwGL_Pop_Bxrf( void );

void          DrwGL_Display_Seg( Draw_Ptr, GLenum );
void          DrwGL_Display( void );
void          DrwGL_Update_Display( void );
void          DrwGL_Inp_Req_Display( Char* );

void          DrwGL_Get_World_XY( int, int );
void          DrwGL_Init_View_Matrix( int );
void          DrwGL_Change_View_Matrix( void );
void          DrwGL_Change_Posit_Matrix( void );
int           DrwGl_Finish_View_Request( void );

void          DrwGL_Save_Image( int );
void          DrwGL_GLBuild_Image( void );
void          DrwGL_Pick_Search( int, int );
void          DrwHVertex( float x, float y, float z );
void          DrwGL_UsrXYZ( GLdouble x, GLdouble y, GLdouble z, int ini );

void          DrwGL_Display_Text( Draw_Ptr p, int sel );
void          DrwGL_Display_Text_Box( Draw_Ptr p, int sel );
void          DrwGL_Font_Selection( int fnt );
void          DrwGL_Font_Support_Init( void );

void          DrwGL_eval_string_box();

#endif
