/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*          F L T K / D R A W   -   S E R V E R   M O D U L E            *
*                                                                       *
*           Version  1.4-C for Draw Library Level V 2.4 A               *
*                                                                       *
*      (Draw interface for FLTK/OPENGL function and procedures)         *
*                                                                       *
*              (Environment/Header File for DRAW Library)               *
*                   (L4 Part: Axis boxs management)                     *
*                                                                       *
*      (Draw interface for FLTK/OPENGL function and procedures)         *
*                                                                       *
*                               by                                      *
*                                                                       *
*          Pierre Wolfers, Laboratoire de Cristallographie              *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/

/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/



#ifndef _DRW_ENVL4                              /* To avoid Multi-definitions */
#  define _DRW_ENVL4  0

#  ifdef _DRAWLIB_L4BASE_
#    define ext4rf
#    define ext4ini( val )        = val
#  else
#    define ext4rf extern
#    define ext4ini( val )
#  endif







/***********************************************************************/
/**                                                                   **/
/**           C O N S T A N T E S    D E F I N I T I O N S            **/
/**                                                                   **/
/***********************************************************************/


#  include <draw/draw_constantes.h>  /* Draw Server Constantes definitions */



/* Define the Allocation size of axis unit string */

#define _USZ_           64



/* Define the Axis Flags Bits */

#define  AX_LOG          1
/* Ticks at Left of Axis */
#define  AX_LEFT         2
/* Value are not of same side than ticks */
#define  AX_VOTH         4
/* No First Ticks */
#define  AX_NFRS         8
/* No Value for the First ticks */
#define  AX_NFVL        16
/* No Last ticks */
#define  AX_NLST        32
/* No Value for the Last ticks */
#define  AX_NLVL        64
/* No ticks #0 */
#define  AX_NZER       128
/* No Value for the ticks #0 */
#define  AX_NZVL       256
/* Extremity of axis is with arrow */
#define  AX_ARRO       512
/* Extremity of axis is with filled arrow */
#define  AX_ARRF      1024
/* String Value and unit are written with tilted characters (by U,V angle) */
#define  AX_TILT      2048
/* String Value path for characters 0..3 value (2 bits) */
#define  AX_VPATH     4096
/* String Unit path for characters 0..3 value (2 bits) */
#define  AX_UPATH    16384
/* Flag to enable the Coordinate simplification */
#define  AX_SPLIM    65536
/* Flag to set the Value string position */
#define  AX_VLEFT   131072
#define  AX_VRIGHT  262144
/* Flag to set the Unit string positions, place -> Middle of axis if required */
#define  AX_ULEFT   524288
#define  AX_URIGHT 1048576
#define  AX_UMIDLE 2097152



/* Define the Plot Box Directive Bits (Axis Ticks Options Bits ) */
/* The bits 0 and 1 (values 0/1/2/3) are used to define the axis to plot */

/*  Ticks values and Unit String will be Displayed */
#define  BX_VALU         4
/*  The ticks left and right sides are permutted */
#define  BX_TRVM         8
/*  The ticks are symmetrized */
#define  BX_TSYM        16
/* To plot with a shift of x axis size */
#define  BX_XSHEND      32
/* To plot with a shift of y axis size */
#define  BX_YSHEND      64
/* To plot with a shift of z axis size */
#define  BX_ZSHEND     128
/* To plot with a shift at x specified value */
#define  BX_XSHPOS     256
/* To plot with a shift at y specified value */
#define  BX_YSHPOS     512
/* To plot with a shift at z specified value */
#define  BX_ZSHPOS    1024
/* To applied a mmm symetry operator to tick direction vector */
/* Specify a secondary up tick vector mu tilted mirror */
#define  BX_TSYMU     2048
/* Specify a secondary up tick vector mv tilted mirror */
#define  BX_TSYMV     4096
/* Specify a secondary up tick vector mw tilted mirror */
#define  BX_TSYMW     8192
/* Specify a rotation of value and unity string of 180 degrees */
#define  BX_ROTUV    16384






/***********************************************************************/
/**                                                                   **/
/**                T Y P E S    D E F I N I T I O N S                 **/
/**                                                                   **/
/***********************************************************************/

typedef float  Draw_Point3[3],                  /* Define a space point */
               Draw_Point[2];                   /* Define a plane point */


typedef struct Draw_Axis   *     Draw_Axis_Ptr;

typedef struct Draw_Box    *      Draw_Box_Ptr;

typedef struct Draw_Tank   *     Draw_Tank_Ptr;

typedef struct Draw_Boxref *     Draw_BxRf_Ptr;


typedef struct Draw_Axis {                      /* Axis Record Definition */
          Draw_Axis_Ptr  axis_next;             /* Link to next defined axis */
          int            axis_ident;            /* Axis Integer Identifier */
          Draw_Point3    axis_vct,              /* Axis Direction */
                         axis_upd;              /* Axis Up (Ticks) Direction */
          float *        axis_ticktb;           /* Axis Ticks table */
          float          axis_length,           /* Axis length in Cm */
                         axis_vincr,            /* Axis increment size */
                         axis_vinf,             /* Axis Minimum Value */
                         axis_vsup,             /* Axis Maximum Value */
                         axis_vdel,             /* Axis Delta Increment Value */
                         axis_tcklen[4],        /* Axis Ticks Lengths for 4 Ticks # */
                         axis_vhigh,            /* Axis Values char High */
                         axis_vangl,            /* Axis Value String Path Angle */
                         axis_vaps[2],          /* Axis Values String position */
                         axis_uhigh,            /* Axis Unit char High */
                         axis_uangl,            /* Axis Unit String Path Angle */
                         axis_unps[2],          /* Axis Unit String position */
                         axis_scale,            /* Axis Scale (in Phys/cm) */
                         axis_evinf,            /* Axis Effective inf value */
                         axis_evsup,            /* Axis Effective sup value */
                         axis_eff;              /* Axis Length Efficience */
          int            axis_vfont,            /* Axis Value Font Number */
                         axis_ufont,            /* Axis Unit Font Number */
                         axis_frstck,           /* First ticks number */
                         axis_lsttck,           /* Last ticks number */
                         axis_tcknbr,           /* Total number of required ticks */
                         axis_refcnt,           /* Axis reference count */
                         axis_flags;            /* Ticks Value Flags : */
          char *         axis_unit;             /* Original Axis Unit String */
          char *         axis_eunit;            /* Used Axis Unit String */
          Char           axis_tfre[4],          /* Ticks Frequency */
                         axis_tshf[4],          /* Ticks Frequenct Shift */
                         axis_tknd[4];          /* Ticks Kind for each # */
          char           axis_field,            /* Value Field */
                         axis_decm;             /* Value Decimal field */
        } Draw_Axis;



typedef struct Draw_Box  {                      /* Axis Record Definition */
          Draw_Box_Ptr   box_next;              /* Link to next defined box */
          Draw_Point3    box_org;               /* Origine of the Box */
          int            box_ident,             /* Box Integer Identifier */
                         box_status;            /* Box Status bit set */
          Draw_Axis_Ptr  box_axis[3];           /* Link to related axis to use */
	  int            box_drtbsz,            /* Box Axis Directive table size */
	                 box_drshtbsz,          /* Box Axis Directive Shift table size */
                         box_drtb[16];          /* Box Axis Directive table */
          float          box_drshf[48],         /* Box Axis Directive Shift table */
                         box_dirmat[12],        /* Matrix to change: phys -> cm */
                         box_recmat[12],        /* Matrix to change: cm -> phys */
                         box_clip[24];          /* Clipping Equations */
          float          box_currp[3];          /* Current Pen position */
          Draw_BxRf_Ptr  box_refirst,           /* Box Curve List header */
                         box_reflast;
        } Draw_Box;



typedef struct Draw_Boxref {
          Draw_BxRf_Ptr  bxrf_nxt;              /* Link to next Curve reference */
          Draw_Box_Ptr   bxrf_box;              /* link to box owner */
          float     *    bxrf_tab;              /* The List of Point (in World Coordinates) */
        } Draw_BoxRef;



typedef struct Draw_Tank {                      /* Plot Directive Tank definition */
          Draw_Tank_Ptr  tnk_next;              /* Link to next defined Tank */
          int            tnk_ident;             /* Tank Identifier Number */
          Draw_Ptr       tnk_first,             /* First and Last pointer of directive */
                         tnk_last;
        } Draw_Tank;





/***********************************************************************/
/**                                                                   **/
/**            V A R I A B L E S    D E F I N I T I O N S             **/
/**                                                                   **/
/***********************************************************************/



ext4rf  Draw_Axis_Ptr    Draw_Curr_Axis   ext4ini( NULL );      /* current Axis Pointer */
ext4rf  Draw_Axis_Ptr    Draw_First_Axis  ext4ini( NULL );      /* Header of the Axis List */
ext4rf  Draw_Axis_Ptr    Draw_Last_Axis   ext4ini( NULL );
ext4rf  int              Draw_Curr_AIde   ext4ini( 0 );

ext4rf  Draw_Box_Ptr     Draw_Curr_Box    ext4ini( NULL );      /* Current Box in Use */
ext4rf  Draw_Box_Ptr     Draw_First_Box   ext4ini( NULL );      /* Header of the Box List */
ext4rf  Draw_Box_Ptr     Draw_Last_Box    ext4ini( NULL );
ext4rf  int              Draw_Curr_BIde   ext4ini( 0 );

ext4rf  Draw_Box_Ptr     Draw_Opened_Box  ext4ini( NULL );      /* Currently Opened Box */

ext4rf  Draw_Tank_Ptr    Draw_Tank_first  ext4ini( NULL );      /* Header for Tank List */
ext4rf  Draw_Tank_Ptr    Draw_Tank_last   ext4ini( NULL );





/***********************************************************************/
/**                                                                   **/
/**  P R O C E D U R E S / F U N C T I O N S   D E F I N I T I O N S  **/
/**                                                                   **/
/***********************************************************************/



void          Draw_Write_Int( char *, int *, int, int );
void          Draw_Write_Float( char *, int *, double, int, int, int, int );
void          Draw_Write_Fix( char *, int *, double, int, int, int );


Draw_Axis_Ptr Draw_Locate_Axis( int );
Draw_Box_Ptr  Draw_Locate_Box( int );

Draw_Axis_Ptr Draw_New_Axis( Draw_Point3, Draw_Point3, Draw_Point3,
                             float, float, float, int, int );

Draw_Box_Ptr  Draw_New_Box( Draw_Axis_Ptr, Draw_Axis_Ptr,
                            Draw_Axis_Ptr, Draw_Point3,
                            int, int*, int, float* );

void          Draw_Free_Box( Draw_Box_Ptr, Char axflg );

void          Draw_Free_Box_List();

int           Draw_Gen_Axis( Draw_Point3, Draw_Point3, float, float, float, int, int );
int           Draw_Gen_Box( Draw_Point3, int, int, int, int, int*, int, float* );

int           Draw_Easy_Box_2D( float, float, float, float, float*, char*, char*, int );

void          Draw_Axis_Setv( Draw_Axis_Ptr, int );
void          Draw_Axis_Getv( Draw_Axis_Ptr, int );
void          Draw_Box_Getv( Draw_Box_Ptr, int );

void          Draw_Enable_Axis( Draw_Axis_Ptr );

void          Draw_Plot_Axis( Draw_Axis_Ptr, Draw_Point3, int, Draw_Box_Ptr );
void          Draw_Plot_Box( Draw_Box_Ptr );
void          Draw_Open_Box( Draw_Box_Ptr );
void          Draw_Update_Box( Draw_Box_Ptr );
void          Draw_Close_Box();
void          Draw_Gen_SMplot( int, int, float * );
void          Draw_Gen_SMprogplot( float x, float y );
void          Draw_Gen_MSurface( int nraw, int ncol, int flg );
void          Draw_Gen_MSurface2( int, int, int, float, float, float, float );
void          Draw_Scale( float x, float y, float * tb, int ip );
void          Draw_Scale3( float  x, float  y, float  z, float * tb, int ip );
void          Draw_UnScale( float* x, float* y, float* z, float xi, float yi, float zi );

void          Draw_Axis_Inscale( float mi, float ma, int n,
                                 float *inf, float *sup, float *delta, float *ef );
void          Draw_Axis_Setvscale( float  inf, float sup,  float  delta, float  rsiz,
                                   float *fsiz, float *eff, float *scale );
float         Draw_Axis_AutoScale( Draw_Axis_Ptr ax, int ani, int ana );


#endif

