#
#  makefile to compile a version of FTGL with the FLTK 2 OpenGL Access Library.
#
configfile=../../server/fltk_config.make

include	$(configfile)

OBJ	=	../obj
LIB	=	../../lib
SRC	=	../cmpsrc


INS	=	-I/usr/include/freetype2 -I


AR	=	ar

A_FLAGS	=	-r











SRC_HEADERS = \
    FTGL/ftgl.h \
    FTGL/FTBBox.h \
    FTGL/FTBuffer.h \
    FTGL/FTPoint.h \
    FTGL/FTGlyph.h \
    FTGL/FTBitmapGlyph.h \
    FTGL/FTBufferGlyph.h \
    FTGL/FTExtrdGlyph.h \
    FTGL/FTOutlineGlyph.h \
    FTGL/FTPixmapGlyph.h \
    FTGL/FTPolyGlyph.h \
    FTGL/FTTextureGlyph.h \
    FTGL/FTFont.h \
    FTGL/FTGLBitmapFont.h \
    FTGL/FTBufferFont.h \
    FTGL/FTGLExtrdFont.h \
    FTGL/FTGLOutlineFont.h \
    FTGL/FTGLPixmapFont.h \
    FTGL/FTGLPolygonFont.h \
    FTGL/FTGLTextureFont.h \
    FTGL/FTLayout.h \
    FTGL/FTSimpleLayout.h \
    ${NULL}

SRC_GLYPH = \
    FTGlyph/FTGlyph.cpp \
    FTGlyph/FTGlyphImpl.h \
    FTGlyph/FTGlyphGlue.cpp \
    FTGlyph/FTBitmapGlyph.cpp \
    FTGlyph/FTBitmapGlyphImpl.h \
    FTGlyph/FTBufferGlyph.cpp \
    FTGlyph/FTBufferGlyphImpl.h \
    FTGlyph/FTExtrudeGlyph.cpp \
    FTGlyph/FTExtrudeGlyphImpl.h \
    FTGlyph/FTOutlineGlyph.cpp \
    FTGlyph/FTOutlineGlyphImpl.h \
    FTGlyph/FTPixmapGlyph.cpp \
    FTGlyph/FTPixmapGlyphImpl.h \
    FTGlyph/FTPolygonGlyph.cpp \
    FTGlyph/FTPolygonGlyphImpl.h \
    FTGlyph/FTTextureGlyph.cpp \
    FTGlyph/FTTextureGlyphImpl.h \
    $(NULL)

SRC_FONT = \
#    FTFont/FTFont.cpp \
#    FTFont/FTFontImpl.h \
#    FTFont/FTFontGlue.cpp \
#    FTFont/FTBitmapFont.cpp \
#    FTFont/FTBitmapFontImpl.h \
#    FTFont/FTBufferFont.cpp \
#    FTFont/FTBufferFontImpl.h \
#    FTFont/FTExtrudeFont.cpp \
#    FTFont/FTExtrudeFontImpl.h \
#    FTFont/FTOutlineFont.cpp \
#    FTFont/FTOutlineFontImpl.h \
#    FTFont/FTPixmapFont.cpp \
#    FTFont/FTPixmapFontImpl.h \
#    FTFont/FTPolygonFont.cpp \
#    FTFont/FTPolygonFontImpl.h \
#    FTFont/FTTextureFont.cpp \
#    FTFont/FTTextureFontImpl.h \
    $(NULL)

SRC_LAYOUT = \
#    FTLayout/FTLayout.cpp \
#    FTLayout/FTLayoutImpl.h \
#    FTLayout/FTLayoutGlue.cpp \
#    FTLayout/FTSimpleLayout.cpp \
#    FTLayout/FTSimpleLayoutImpl.h \
    $(NULL)


libftgl_la_SOURCES = \
    FTBuffer.cpp \
    FTCharmap.cpp \
    FTCharmap.h \
    FTCharToGlyphIndexMap.h \
    FTContour.cpp \
    FTContour.h \
    FTFace.cpp \
    FTFace.h \
    FTGlyphContainer.cpp \
    FTGlyphContainer.h \
    FTInternals.h \
    FTLibrary.cpp \
    FTLibrary.h \
    FTList.h \
    FTPoint.cpp \
    FTSize.cpp \
    FTSize.h \
    FTVector.h \
    FTVectoriser.cpp \
    FTVectoriser.h \
    FTUnicode.h \
    $(ftglyph_sources) \
    $(ftfont_sources) \
    $(ftlayout_sources) \
    $(ftgl_headers) \
    $(NULL)


OBJ_GLYPH = \
    $(OBJ)/FTBitmapGlyph.o \
    $(OBJ)/FTBufferGlyph.o \
    $(OBJ)/FTExtrudeGlyph.o \
    $(OBJ)/FTOutlineGlyph.o \
    $(OBJ)/FTGlyph.o \
    $(OBJ)/FTGlyphGlue.o \
    $(OBJ)/FTPixmapGlyph.o \
    $(OBJ)/FTPolygonGlyph.o \
    $(OBJ)/FTTextureGlyph.o \
    $(NULL)


OBJ_FONT = \
    $(NULL)


OBJ_LAYOUT = \
    $(NULL)


OBJS = \
    $(OBJ_GLYPH) \
    $(OBJ_FONT) \
    $(OBJ_LAYOUT) \
    $(NULL)



all:	$(LIB)/libftgl.a

clean:	rm $(OBJS) $(LIB)/libftgl.a


#
# Generate the Library.
#
$(LIB)/libftgl.a:	obj_glyph obj_font obj_layout obj_base
	$(AR) $(A_FLAGS) $(LIB)/libftgl.a $(OBJGLYPH) $() $() $(OBJS)
#
#
#  Glyph object compile.
#
obj_glyph: cpsrc_glyph $(OBJ_GLYPH) $(SRC)/config.h $(SRC)/FTInternals.h $(SRC_HEADERS) cln_glyph
#
# Copy Glyph sources to Main source directory.
cpsrc_glyph:	$(SRC_GLYPH) $(SRC)/FTGlyphImpl.h
	cp $(SRC_GLYPH) $(SRC)
#
# Compile each Glyph module.
#
$(OBJ)/FTBitmapGlyph.o:	$(SRC)/FTBitmapGlyph.cpp $(SRC)/FTBitmapGlyphImpl.h
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
$(OBJ)/FTBufferGlyph.o:	$(SRC)/FTBufferGlyph.cpp $(SRC)/FTBufferGlyphImpl.h
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
$(OBJ)/FTExtrudeGlyph.o:	$(SRC)/FTExtrudeGlyph.cpp $(SRC)/FTExtrudeGlyphImpl.h
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
$(OBJ)/FTGlyph.o:	$(SCR)/FTGlyph.cpp $(SRC)/FTVectoriser.h
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
$(OBJ)/FTGlyphGlue.o:	$(SRC)/FTGlyphGlue.cpp
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
$(OBJ)/FTOutlineGlyph.o:	$(SRC)/FTOutlineGlyph.cpp  $(SRC)/FTOutlineGlyphImpl.h $(SRC)/FTOutlineGlyphImpl.h
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
$(OBJ)/FTPixmapGlyph.o:	$(SRC)/FTPixmapGlyph.cpp $(SRC)FTPixmapGlyphImpl.h/ $(SRC)/FTVectoriser.h
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
$(OBJ)/FTPolygonGlyph.o:	$(SRC)/FTPolygonGlyph.cpp $(SRC)FTPolygonGlyphImpl.h  $(SRC)/FTVectoriser.h
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
$(OBJ)/FTTextureGlyph.o:	$(SRC)/FTTextureGlyph.cpp $(SRC)FTTextureGlyphImpl.h  $(SRC)/FTVectoriser.h
	$(CXX) $(CXXFLG) -I./ -c $< -o $@
#
cln_glyph:	rm $()
#
# Compile each Font module.
#
obj_font:

#
# Compile each Layout module.
#
obj_layout:



#
#
