#!/bin/sh
#
# Script to create the fltk_config.make file.
#
#          (fltk must be installed before)
#
# The $1 command argument (when specified) is used to specify an FLTK version number.
#
# Set default options.
u_cc="gcc"
u_cxx="g++"
use_gl=
use_img=
use_frm=
use_glut=
use_cc=
use_cxx=
use_debug=
opt_help=
opt_lvl="2"
fltk_vl=
fout="fltk_config.make"
exe_ext=

if test $# -le 0
then
  opt_help=1
fi

# Loop on all argument to set the parameters.
while test $# -gt 0
do
  case "$1" in
    -cc | -CC)
      use_cc=$2
      shift
      ;;
    -cxx | -CXX | -c++ | -C++)
      use_cxx=$2
      shift
      ;;
    -gl | -GL)
      use_gl=" --use-gl"
      ;;
    -glut | -GLUT)
      use_glut=" --use-glut"
      ;;
    -i | -I | -img | -IMG)
      use_img=" --use-images"
      ;;
    -frm | -FRM | -forms | -FORMS)
      use_frm=" --use-forms"
      ;;
    -vl |-VL)
      fltk_vl=$2
      shift
      ;;
    -g | -G)
      use_debug=" -g"
      ;;
    -o | -out | -OUT)
      fout=$2
      shift
      ;;
    -O | -opt | -OPT)
      opt_lvl = $2
      shift
      ;;
    -h | -H | -help | -HELP)
      opt_help=1
      ;;
    *)
      echo " make_fltk_config.sh : Unknown option \"$1\""
      opt_help=1
    ;;
  esac
# Skip to next option/arg. in the command line.
  shift
done

if test $opt_help
# Output the Help message on unknown option.
then
  echo "Usage: make_fltk_config.sh [OPTIONS]
Options:                                                                                              synonyms
    [-cc <cmp>]             use the specified C compiler (default is gcc), - ignored for fltk2,       -CC
    [-cxx or -c++ <cmp>]    use the specified C++ compiler (default is g++) - ignored for fltk2,      -CXX
    [-gl]                   use GL or MESA-GL,                                                        -GL
    [-img]                  use extra images formats (PNG, JPEG),                                     -i, -I, -IMG
    [-glut]                 use glut compatibility layer,                                             -GLUT
    [-forms]                use forms compatibility layer,                                            -FORMS, -frm -FRM
    [-g]                    set debugging mode,                                                       -G
    [-vl <version>]         specify a version as 2 for fltk2 (default -vl 2),                         -VL
    [-out <outfile_spc>]    Specify a not standard output,                                            -o, -OUT
    [-opt <lvl>]            Specify an optimize level (default: -opt 2),                              -O, -OPT
    [-help]                 To output this text.                                                      -HELP, -h, -H
"
  exit 1
fi

# Determine the operating system environment.
kernel=$(uname)
case $kernel in
  CYGWIN*)
    kernel="WIN32"
    exe_ext=".exe"
    ;;
  Linux)
    kernel="LINUX"
    ;;
  *)
    echo " Not identified Operating system \"${kernel}\" ==> Assume unknown UNIX."
    kernel="UNIX"
    ;;
esac


# Generate the specific command strings.
fl_conf="fltk${fltk_vl}-config${use_debug}${use_gl}${use_glut}${use_img}${use_frm}"
#echo " ***** Use the fltk config command \"$fl_conf\"     ********"

if test $fltk_vl
then
  if ! test $use_cc
  then
    use_cc="$($fl_conf --cc)"
  fi
  if ! test $use_cxx
  then
    use_cxx="$($fl_conf --cxx)"
  fi
fi

if ! test $use_cc
then
  use_cc=$u_cc
fi

if ! test $use_cxx
then
  use_cxx=$u_cxx
fi

# To write the sub-make file (we use the form $(command) in place of `command`.
echo "#
# Sub-Make File to define the FLTK compilation symbols (generated by \"make_fltk_config.sh\").
#

# Compiler specifications
CC  =   "${use_cc} -O${opt_lvl} ${use_debug}"
CXX =   "${use_cxx} -O${opt_lvl} ${use_debug}"

# Compiler flags specifications
CCFLG   =   $($fl_conf --cflags)
CXXFLG  =   $($fl_conf --cxxflags)

# linker flags (and libraries) specifications
LDFLG   =   $($fl_conf --ldflags)
LDSFLG  =   $($fl_conf --ldstaticflags)

EXETYP  =   ${exe_ext}
#
" > $fout
#
