#!/bin/sh
#
# SET up the Cygwin new Draw Server in the standard current directory.
#
DEF_TREE="/usr/local"
echo -n " Give the local target Directory [default is $DEF_TREE] "
read LOCAL_DIR
if ! test "$LOCAL_DIR"
then
  LOCAL_DIR="$DEF_TREE"
fi
if test ${LOCAL_DIR:${#LOCAL_DIR}-1:1} == "/"
then
  LOCAL_DIR=${LOCAL_DIR:0:${#LOCAL_DIR}-1}
fi
echo "target directory = $LOCAL_DIR"
if ! test -d "$LOCAL_DIR"
then
  echo -n " Do you want create it (Possible answerd Y/N) [default is Y] "
  read REP
  if test "$REP" = "n"
  then
    REP = "N"
  fi
  if test "$REP" = "N"
  then
#
# Error the local directories does not exit and do not create it.
#
    echo "$LOCAL_DIR cannot be found or created."
    exit 2
  fi
  mkdir $LOCAL_DIR
  echo " The target product directory $LOCAL_DIR is created."
fi
BIN_DIR=$LOCAL_DIR/bin
ETC_DIR=$LOCAL_DIR/etc
LIB_DIR=$LOCAL_DIR/lib
INC_DIR=$LOCAL_DIR/include
FNT_DIR=$LOCAL_DIR/Draw_Fonts
if ! test -d "$BIN_DIR"; then mkdir $BIN_DIR; fi
if ! test -d "$ETC_DIR"; then mkdir $ETC_DIR; fi
if ! test -d "$LIB_DIR"; then mkdir $LIB_DIR; fi
if ! test -d "$INC_DIR"; then mkdir $INC_DIR; fi
if ! test -d "$FNT_DIR"; then mkdir $FNT_DIR; fi

cp Draw_Server.exe $BIN_DIR
cp pc_screen_17.draw_setting $ETC_DIR
cp libdraw.a $LIB_DIR
cp draw_defs.* $INC_DIR
if ! test -e $FNT_DIR
then
  mkdir /usr/local/Draw_Fonts
fi
cp *.Drwfnt $FNT_DIR
#
# Create the draw setup file on local directory.
#
echo "export DRAW_SERVER=$BIN_DIR/Draw_Server.exe" >  draw_setup.sh
echo "export DRAW_SERVER_SETTING=$ETC_DIR/pc_screen_17.draw_setting" >> draw_setup.sh
echo "export DRAW_FONT=$FNT_DIR/" >> draw_setup.sh
#
echo "setenv DRAW_SERVER $BIN_DIR/Draw_Server.exe" >  draw_setup.csh
echo "setenv DRAW_SERVER_SETTING $ETC_DIR/pc_screen_17.draw_setting" >> draw_setup.csh
echo "setenv DRAW_FONT $FNT_DIR/" >> draw_setup.csh
#
echo
echo '     --------------- End of Draw Install ---------------'
echo
echo ' The Setup file "draw_setup.sh" is created for sh/bash users and'
echo ' the Setup file "draw_setup.csh" is created for csh/tcsh users.'
echo
echo ' These files executed be used by a source command in the appropriate login file'
echo ' as .login, .profile or .bashrc for sh users, and .cshrc or .tcshrc for sh/tcsh users.'
#
#
echo ' Successfull End of Binary Install of Draw on Linux/unix system.'
#
#