/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*               (Segments Control Graphic Directives)                *
*                     (Multi-Language Support)                       *
*                                                                    *
*                    Draw Library Version V 2.4                      *
*                                                                    *
*                           31-Jan-2009                              *
*                                                                    *
*                               by                                   *
*                                                                    *
*                  Pierre Wolfers,  Institut Neel                    *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */


/*********************************************************************/

int Draw_New_Seg( int n )
{ /* Open a new segment */
  Sdrw_Put_Code( cd_new_seg );
  Sdrw_Put_Int( n );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* Draw_New_Seg */



/*********************************************************************/

void Draw_Seg_End()
{ /* Force end of current segment */
  Sdrw_Put_Code( cd_seg_end );
  Sdrw_Server_Request();
} /* Draw_Seg_End */



/*********************************************************************/

void Draw_Del_Seg( int n )
{ /* Delete the specified Segment */
  Sdrw_Put_Code( cd_del_seg );
  Sdrw_Put_Int( n );
  Sdrw_Server_Request();
} /* Draw_Del_Seg */



/*********************************************************************/

int Draw_Update_Seg( int n, int fapp )
{ /* Update a specified existing segment */
  Sdrw_Put_Code( cd_update_seg );
  Sdrw_Put_Int( n );
  Sdrw_Put_Int( fapp );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* Draw_Update_Seg */



/*********************************************************************/

void Draw_Include_Seg( int n )
{ /* Include a specified existing segment */
  Sdrw_Put_Code( cd_exec_seg );
  Sdrw_Put_Int( n );
  Sdrw_Server_Request();
} /* Draw_Include_Seg */



/*********************************************************************/

void Draw_Seg_Attr( int seg_id, int det, int hli, int vis, float prior )
{ /* Set specified attributs to the specified segment */
  Sdrw_Put_Code( cd_seg_attr );
  Sdrw_Put_Int( seg_id );
  Sdrw_Put_Int( det );
  Sdrw_Put_Int( hli );
  Sdrw_Put_Int( vis );
  Sdrw_Put_Float( prior );
  Sdrw_Server_Request();
} /* Draw_Seg_Attr */



/*********************************************************************/

void Draw_Set_Pickid( int pic_id )
{ /* Set the specified pick identifier to the following part
     of current seg. */
  Sdrw_Put_Code( cd_seg_picid );
  Sdrw_Put_Int( pic_id );
  Sdrw_Server_Request();
} /* Draw_Set_Pickid */



/*********************************************************************/

int  Draw_Detectable( int det_flg )
{ /* Set the specified pick identifier to the following part
     of current seg. */
  Sdrw_Put_Code( cd_seg_pdetf );
  Sdrw_Put_Int( det_flg );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* Draw_Detectable */



/*********************************************************************/

int Draw_Seg_Inquire()
{ /* Set the specified pick identifier to the following part
     of current seg. */
  Sdrw_Put_Code( cd_seg_inquire );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* draw_seg_inquire */



/*********************************************************************/

int Draw_Push_Matrix()
{ /* Push a Matrix transformation */
  Sdrw_Put_Code( cd_gen_tmat );
  Sdrw_Put_Char( 1 );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
}


/*********************************************************************/

void Draw_Pop_Matrix()
{ /* Pop a Matrix transformation */
  Sdrw_Put_Code( cd_gen_tmat );
  Sdrw_Put_Char( 0 );
  Sdrw_Server_Request();
}


/*********************************************************************/

void Draw_Seg_Unit_Transf( int iseg, int upd )
{ /* Perform a Segment Translation */
  Sdrw_Put_Code( cd_init_trans_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Char( (upd != 0) );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Seg_Unit_Transf */



/*********************************************************************/

void Draw_Mat_Unit_Transf( int imat, int upd )
{ /* Perform a Segment Translation */
  Sdrw_Put_Code( cd_init_trans_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Char( (upd != 0) );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Mat_Unit_Transf */



/*********************************************************************/

void Draw_Transf_Seg( int iseg, float tx, float ty,
                                float px, float py, float theta,
                                float scx, float scy )
{ /* Perform a specified Segment transformation */
  Sdrw_Put_Code( cd_transform_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  tx );
  Sdrw_Put_Float(  ty );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Float( 0.0 );   /* Omega = 0.0 */   
  Sdrw_Put_Float( 0.0 );   /* Chi   = 0.0 */
  Sdrw_Put_Float( theta ); /* Psi   = Theta */
  Sdrw_Put_Float( scx );
  Sdrw_Put_Float( scy );
  Sdrw_Put_Float( 1.0 );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Transf_Seg */



/*********************************************************************/

void Draw_Transf_Mat( int imat, float tx, float ty,
                                float px, float py, float theta,
                                float scx, float scy )
{ /* Perform a specified Segment transformation */
  Sdrw_Put_Code( cd_transform_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  tx );
  Sdrw_Put_Float(  ty );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Float( 0.0 );   /* Omega = 0.0 */   
  Sdrw_Put_Float( 0.0 );   /* Chi   = 0.0 */
  Sdrw_Put_Float( theta ); /* Psi   = Theta */
  Sdrw_Put_Float( scx );
  Sdrw_Put_Float( scy );
  Sdrw_Put_Float( 1.0 );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Transf_Mat */



/*********************************************************************/

void Draw_Transf_Seg3( int iseg, float  tx, float  ty, float  tz,
                                 float  px, float  py, float  pz,
                                 float ome, float chi, float psi,
                                 float scx, float scy, float scz )
{ /* Perform a specified Segment transformation */
  Sdrw_Put_Code( cd_transform_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  tx );
  Sdrw_Put_Float(  ty );
  Sdrw_Put_Float(  tz );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float(  pz );
  Sdrw_Put_Float( ome );
  Sdrw_Put_Float( chi );
  Sdrw_Put_Float( psi );
  Sdrw_Put_Float( scx );
  Sdrw_Put_Float( scy );
  Sdrw_Put_Float( scz );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Transf_seg3 */



/*********************************************************************/

void Draw_Transf_Mat3( int imat, float  tx, float  ty, float  tz,
                                 float  px, float  py, float  pz,
                                 float ome, float chi, float psi,
                                 float scx, float scy, float scz )
{ /* Perform a specified Segment transformation */
  Sdrw_Put_Code( cd_transform_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  tx );
  Sdrw_Put_Float(  ty );
  Sdrw_Put_Float(  tz );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float(  pz );
  Sdrw_Put_Float( ome );
  Sdrw_Put_Float( chi );
  Sdrw_Put_Float( psi );
  Sdrw_Put_Float( scx );
  Sdrw_Put_Float( scy );
  Sdrw_Put_Float( scz );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Transf_Mat3 */



/*********************************************************************/

void Draw_Move_Seg( int iseg, float tx, float ty )
{ /* Perform a Segment Translation */
  Sdrw_Put_Code( cd_move_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  tx );
  Sdrw_Put_Float(  ty );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Move_Seg */



/*********************************************************************/

void Draw_Move_Mat( int imat, float tx, float ty )
{ /* Perform a Segment Translation */
  Sdrw_Put_Code( cd_move_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  tx );
  Sdrw_Put_Float(  ty );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Move_Mat */



/*********************************************************************/

void Draw_Move_Seg3( int iseg, float tx, float ty, float tz )
{ /* Perform a Segment Translation */
  Sdrw_Put_Code( cd_move_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  tx );
  Sdrw_Put_Float(  ty );
  Sdrw_Put_Float(  tz );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Move_Seg3 */



/*********************************************************************/

void Draw_Move_Mat3( int imat, float tx, float ty, float tz )
{ /* Perform a Segment Translation */
  Sdrw_Put_Code( cd_move_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  tx );
  Sdrw_Put_Float(  ty );
  Sdrw_Put_Float(  tz );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Move_Mat3 */



/*********************************************************************/

void Draw_Rotate_Seg( int iseg, float px, float py, float theta )
{ /* Perform a Segment Rotation */
  Sdrw_Put_Code( cd_rotate_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Float( 0.0 );   /* Omega = 0.0 */
  Sdrw_Put_Float( 0.0 );   /* Chi   = 0.0 */
  Sdrw_Put_Float( theta ); /* psi = Theta */
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Rotate_Seg */



/*********************************************************************/

void Draw_Rotate_Mat( int imat, float px, float py, float theta )
{ /* Perform a Segment Rotation */
  Sdrw_Put_Code( cd_rotate_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Float( 0.0 );   /* Omega = 0.0 */
  Sdrw_Put_Float( 0.0 );   /* Chi   = 0.0 */
  Sdrw_Put_Float( theta ); /* psi = Theta */
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Rotate_Mat */



/*********************************************************************/

void Draw_URot_Seg3( int iseg, float  px, float  py, float  pz,
                               float  th, float  ph, float  an )
{ /* Perform a Segment Rotation */
  Sdrw_Put_Code( cd_urotate_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float(  pz );
  Sdrw_Put_Float(  th );
  Sdrw_Put_Float(  ph );
  Sdrw_Put_Float(  an );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_URot_Seg3 */



/*********************************************************************/

void Draw_URot_Mat3( int imat, float  px, float  py, float  pz,
                               float  th, float  ph, float  an )
{ /* Perform a Segment Rotation */
  Sdrw_Put_Code( cd_urotate_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float(  pz );
  Sdrw_Put_Float(  th );
  Sdrw_Put_Float(  ph );
  Sdrw_Put_Float(  an );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_URot_Mat3 */



/*********************************************************************/

void Draw_Rotate_Seg3( int iseg, float  px, float  py, float  pz,
                                 float ome, float chi, float psi )
{ /* Perform a Segment Rotation */
  Sdrw_Put_Code( cd_rotate_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float(  pz );
  Sdrw_Put_Float( ome );
  Sdrw_Put_Float( chi );
  Sdrw_Put_Float( psi );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Rotate_Seg3 */



/*********************************************************************/

void Draw_Rotate_Mat3( int imat, float  px, float  py, float  pz,
                                 float ome, float chi, float psi )
{ /* Perform a Segment Rotation */
  Sdrw_Put_Code( cd_rotate_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float(  pz );
  Sdrw_Put_Float( ome );
  Sdrw_Put_Float( chi );
  Sdrw_Put_Float( psi );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Rotate_Mat3 */



/*********************************************************************/

void Draw_Scale_Seg( int iseg, float  px, float  py, float scx, float scy )
{ /* Perform a Segment scalling 2D */
  Sdrw_Put_Code( cd_scale_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Float( scx );
  Sdrw_Put_Float( scy );
  Sdrw_Put_Float( 1.0 );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Scale_Seg */



/*********************************************************************/

void Draw_Scale_Mat( int imat, float  px, float  py, float scx, float scy )
{ /* Perform a Segment scalling 2D */
  Sdrw_Put_Code( cd_scale_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float( 0.0 );
  Sdrw_Put_Float( scx );
  Sdrw_Put_Float( scy );
  Sdrw_Put_Float( 1.0 );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Scale_Mat */



/*********************************************************************/

void Draw_Scale_Seg3( int iseg, float  px, float  py, float  pz,
                                float scx, float scy, float scz )
{ /* Perform a Segment Scalling 3D */
  Sdrw_Put_Code( cd_scale_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float(  pz );
  Sdrw_Put_Float( scx );
  Sdrw_Put_Float( scy );
  Sdrw_Put_Float( scz );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Scale_Seg3 */



/*********************************************************************/

void Draw_Scale_Mat3( int imat, float  px, float  py, float  pz,
                                float scx, float scy, float scz )
{ /* Perform a Segment Scalling 3D */
  Sdrw_Put_Code( cd_scale_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float(  px );
  Sdrw_Put_Float(  py );
  Sdrw_Put_Float(  pz );
  Sdrw_Put_Float( scx );
  Sdrw_Put_Float( scy );
  Sdrw_Put_Float( scz );
  Sdrw_Server_Request();
  Draw_AnmSSt = Sdrw_Get_Char();
} /* Draw_Scale_Mat3 */



/*********************************************************************/

int Draw_Get_Seg_Mat( int iseg, float *m )
{ /* Get a copy of specified segment Matrix */
  int i, d;

  Sdrw_Put_Code( cd_get_transf_seg );
  Sdrw_Put_Int( iseg );
  Sdrw_Server_Request();
  d = Sdrw_Get_Int();
  if (d > 0) for (i = 0; i < d; i++) m[i] = Sdrw_Get_Float();
  return d;
}


/*********************************************************************/

int Draw_Get_Matrix( int imat, float *m )
{ /* Get a copy of specified Push(ed) Matrix */
  int i, d;

  Sdrw_Put_Code( cd_get_transf_mat );
  Sdrw_Put_Int( imat );
  Sdrw_Server_Request();
  d = Sdrw_Get_Int();
  if (d > 0) for (i = 0; i < d; i++) m[i] = Sdrw_Get_Float();
  return d;
}


/*********************************************************************/

int Draw_Put_Seg_Mat( int iseg, float *m )
{ /* Put a new Matrix for the specified segment */
  int i;

  Sdrw_Put_Code( cd_put_transf_seg );
  Sdrw_Put_Int( iseg );
  for (i = 0; i < 12; i++) Sdrw_Put_Float( m[i] );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
}


/*********************************************************************/

int Draw_Put_Matrix( int imat, float *m )
{ /* Put a new Matrix for the Push(ed) Matrix */
  int i;

  Sdrw_Put_Code( cd_put_transf_mat );
  Sdrw_Put_Int( imat );
  for (i = 0; i < 12; i++) Sdrw_Put_Float( m[i] );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
}


/*********************************************************************/

int Draw_Seg_Orient( int iseg, float px, float py, float pz, Char immed )
{
  Sdrw_Put_Code( cd_seg_orient );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Float( px );
  Sdrw_Put_Float( py );
  Sdrw_Put_Float( pz );
  Sdrw_Put_Char( (int) immed );
  Sdrw_Server_Request();       /* Send the Request */
  return Sdrw_Get_Int();
}


/*********************************************************************/

int Draw_Mat_Orient( int imat, float px, float py, float pz, Char immed )
{
  Sdrw_Put_Code( cd_mat_orient );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Float( px );
  Sdrw_Put_Float( py );
  Sdrw_Put_Float( pz );
  Sdrw_Put_Char( immed );
  Sdrw_Server_Request();       /* Send the Request */
  return Sdrw_Get_Int();
}


/*********************************************************************/

int Draw_Seg_Move( int iseg, Char immed )
{
  Sdrw_Put_Code( cd_seg_move );
  Sdrw_Put_Int( iseg );
  Sdrw_Put_Char( (int) immed );
  Sdrw_Server_Request();       /* Send the Request */
  return Sdrw_Get_Int();
}


/*********************************************************************/

int Draw_Mat_Move( int imat, Char immed )
{
  Sdrw_Put_Code( cd_mat_move );
  Sdrw_Put_Int( imat );
  Sdrw_Put_Char( immed );
  Sdrw_Server_Request();       /* Send the Request */
  return Sdrw_Get_Int();
}


/****************************    E N D    ****************************/
