(*

**********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*             D R A W   -   C L I E N T   L I B R A R Y              *
*                                                                    *
*                P A S C A L (C P A S)   M O D U L E                 *
*                                                                    *
*                 (Main Control Graphic Directives)                  *
*                    (Pascal Adaptation Support)                     *
*                                                                    *
*                    Draw Library Version V 2.4                      *
*                                                                    *
*                           28-Feb-2009                              *
*                                                                    *
*                               by                                   *
*                                                                    *
*                  Pierre Wolfers,  Institut Neel                    *
*                                                                    *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166           *
*                                                                    *
*                     F 38042 GRENOBLE CEDEX 9                       *
*                                                                    *
*                           F R A N C E                              *
*                                                                    *
*                                                                    *
*                                                                    *
**********************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*)

%pragma code_option c_code '#include <draw/draw_apientry.h>';
module DRAW$PASCAL_CONTROL;


const
  raster = 0;
  centimeter = 1;

  pi		 = (4.0*ARCTAN(1.0));
  fac_rad	 = (pi/180.0);

  max_menu   = 64;                        { 64 entries Max / menu }



type
  Dfloat = single;
  Dint   = cc__int;
  Dbool  = boolean;
  Dpoint3 = array[1..3] of Dfloat;


{*********************************************************************}
{************      Basic Draw CPAS Specific Routines      ************}
{*********************************************************************}


procedure DRAW_SET_MENU_SPC( cd, id: Dint; name: $wild_pointer; len, key: Dint );
external 'Draw_Set_Menu_Spc';


[global 'Draw_Pas_Set_Menu_Spc']
procedure DRAW$SET_MENU_SPC( cd: Dint; in_var name: [optional] string; id: Dint := -1; ky: Dint := 0 );
begin
  if name"address = nil then DRAW_SET_MENU_SPC( cd, id, nil, 0, 0 )
                        else DRAW_SET_MENU_SPC( cd, id, name.body[1]"address, name.length, ky );
end DRAW$SET_MENU_SPC;


{*********************************************************************}

function  draw_init( var x_paper, y_paper: Dfloat;
                     var             unit:  byte;
                         pt: $wild_pointer; len: Dint ): Dbool;
external 'Draw_Init';


[global 'Draw_Pas_Init']
function  DRAW$INIT( var x, y: Dfloat; var unit: byte;
                     in_var usrid: [optional] string ): Dbool;
var
  len:  Dint;
  sta: Dbool;

begin
  if usrid"address = nil then
    sta := draw_init( x, y, unit, nil, 0 )
  else
  begin
    len := usrid.length;
    sta := draw_init( x, y, unit, usrid.body[1]"address, len )
  end;
  Draw$Init := sta
end Draw$Init;



[global 'Draw_Pas_Get_Server_Name']
procedure DRAW$GET_SERVER_NAME( var s: string );
type
  buf = array[1..255] of char;

var
  len: integer;
  [external 'Draw_Srv_Name'] cst: ^buf;
  [external 'Draw_Srv_NameLength'] nln: integer;

begin
  len := nln;
  if len > s.capacity then len := s.capacity;
  for i := 1 to len do s[i] := cst^[i];
  s.length := len
end DRAW$GET_SERVER_NAME;


{*********************************************************************}

function  draw_picture( pt: $wild_pointer; len: byte;
                        x, y, z: Dfloat;
                        sca, marg: byte ): Dbool;
external 'Draw_Picture';


[global 'Draw_Pas_Picture']
function Draw$Picture( in_var title    : string;
                              px, py   : Dfloat;
                              sca, marg: Dbool  ): Dbool;
begin
  Draw$Picture := draw_picture( title.body"address, title.length,
                                px, py, 0.0, ORD( sca ), ORD( marg ) )
end Draw$Picture;


[global 'Draw_Pas_Picture_3D']
function Draw$Picture_3D( in_var title      : string;
                                 px, py, pz : Dfloat;
                                 sca, marg  : Dbool  ): Dbool;
begin
  Draw$Picture_3D := draw_picture( title.body"address, title.length,
                                  px, py, pz, ORD( sca ), ORD( marg ) )
end Draw$Picture_3D;


{*********************************************************************}

procedure draw_send_block( pt: $wild_pointer );
external 'Draw_Send_Block';


[global 'Draw_Pas_Send_Block']
procedure Draw_Send_Block( in_var pt: array[sz: Dint] of Dfloat );
begin
  draw_send_block( pt[1]"address )
end Draw_Send_Block;


{*********************************************************************}

procedure draw_mplot( dim: Dint; pt: $wild_pointer; flag: Dint );
external 'Draw_Mplot';

[global 'Draw_Pas_Mplot']
procedure Draw$Mplot( in_var   pt: array[sz: Dint] of Dfloat;
                              dim: Dint := 0;
                             flag: Dint := 3 );
type
  btn  = (b_00, b_01, b_3D, b_NV, b_04, b_05, b_06, b_07, b_08, b_09, b_10, b_11, b_12, b_13, b_14, b_15,
          b_16, b_17, b_18, b_19, b_20, b_21, b_22, b_23, b_24, b_25, b_26, b_27, b_28, b_29, b_30, b_31 );
  svty = set of btn;

var
  asz: integer;
  eqf: record case boolean of
         false:( iv: integer);
         true: ( sv: svty)
       end;

begin
  eqf.iv := flag;
  if b_3D in eqf.sv then asz := sz div 3     { 3D mode }
                    else asz := sz div 2;    { 2D mode }
  if b_NV in eqf.sv then asz := asz div 2;   { When the Normal Vectors are given by the user }
  if (dim > asz) or (dim <= 0) then dim := asz;
  draw_mplot( dim, pt[1]"address, flag )
end Draw$Mplot;


{*********************************************************************}

procedure draw_string( x, y, th, hgt: Dfloat;
                        s: $Wild_pointer; len, oflg: Dint );
external 'Draw_String';

[global 'Draw_Pas_String']
procedure Draw$String( x, y, th, hgt: Dfloat; in_var str: string; flg: Dint := 0 );
begin
  draw_string( x, y, th, hgt, str.body"address, str.length, flg )
end Draw$String;


{*********************************************************************}

procedure draw_text_in_box( xx, yy, bx, by: Dfloat; s: $Wild_pointer; len, hal, flg: Dint; hc, ls: Dfloat := 1.0 );
external 'Draw_Text_In_Box';

[global 'Draw_Pas_Text_In_Box']
procedure Draw$Text_In_Box( xx, yy, bx, by: Dfloat; in_var txt: array[sz: integer] of char; hal, flg: Dint := 0; hc, ls: Dfloat := 1.0 );
begin
  draw_text_in_box( xx, yy, bx, by, txt"address, sz, hal, flg, hc, ls )
end Draw$Text_In_Box;


{*********************************************************************}

procedure draw_surface( nraw, ncol, flg: Dint; vtbp: $Wild_pointer );
external 'Draw_Surface';

[global 'Draw_Pas_Surface']
procedure Draw$Surface( in_var vtb: array[nraw: integer, ncol: integer] of DPoint3; flg: Dint := 0 );
begin
  draw_surface( nraw, ncol, flg, vtb[1]"address )
end Draw$Surface;


[global 'Draw_Pas_SurfaceA']
procedure Draw$Surface( nraw, ncol, flg: Dint := 0 );
begin
  draw_surface( nraw, ncol, flg, nil )
end Draw$Surface;


{*********************************************************************}

procedure draw_surface2( nraw, ncol, flg: Dint; xo, yo, xs, ys: Dfloat; vtbp: $Wild_pointer );
external 'Draw_Surface2';

[global 'Draw_Pas_Surface2']
procedure Draw$Surface2( in_var vtb: array[nraw: integer, ncol: integer] of Dfloat;
                                xo, yo, xs, ys: Dfloat; flg: Dint := 0 );
begin
  draw_surface2( nraw, ncol, flg, xo, yo, xs, ys, vtb[1]"address )
end Draw$Surface2;


[global 'Draw_Pas_Surface2A']
procedure Draw$Surface2( nraw, ncol, flg: Dint := 0; xo, yo, xs, ys: Dfloat );
begin
  draw_surface2( nraw, ncol, flg, xo, yo, xs, ys, nil )
end Draw$Surface2;


{*********************************************************************}

procedure draw_polyhedral( nfc, nvt, flg: Dint; ftbp, vtbp: $Wild_pointer );
external 'Draw_Polyhedral';

[global 'Draw_Pas_Polyhedral']
procedure Draw$Polyhedral( in_var ftb: array[nfc: integer] of Dint;
                           in_var vtb: array[nvt: integer] of Dfloat; flg: Dint := 0 );
begin
  draw_polyhedral( nfc, nvt, flg, ftb[1]"address, vtb[1]"address )
end Draw$Polyhedral;



{*********************************************************************}
{************    Attribute Draw CPAS Specific Routines    ************}
{*********************************************************************}

function draw_install_font( ifnt, istl: Dint; fn: $Wild_pointer; len: Dint ): Dint;
external 'Draw_Install_Font';

[global 'Draw_Pas_Install_Font']
function  Draw$Install_Font( ifnt, istl: Dint; in_var fnam: string ): Dint;
begin
  Draw$Install_Font := draw_install_font( ifnt, istl, fnam.body"address, fnam.length )
end Draw$Install_Font;


function draw_font_info( ifnt: Dint; fn: $Wild_pointer; cap: Dint; var len, stl: Dint ): Dint;
external 'Draw_Font_Info';

[global 'Draw_Pas_Font_Info']
function  DRAW$FONT_INFO( ifnt: Dint; var fpath: string; var stl: Dint ): Dint;
var
  flen: Dint;

begin
  DRAW$FONT_INFO := draw_font_info( ifnt, fpath.body[1]"address, fpath.capacity, flen, stl );
  fpath.length := flen
end DRAW$FONT_INFO;



function  draw_get_string_box( ifnt: Dint; st: $wild_pointer; len: Dint; hg: Dfloat := 1.0; var bx, by: Dfloat ): Dint;
external 'Draw_Get_String_Box';

[global 'Draw_Pas_Get_String_Box']
function  DRAW$GET_STRING_BOX( ifnt: Dint; in_var str: string; hg: Dfloat; var bx, by: Dfloat ): Dint;
begin
  DRAW$GET_STRING_BOX := draw_get_string_box( ifnt, str.body"address, str.length, hg, bx, by )
end DRAW$GET_STRING_BOX;



{*********************************************************************}
{************       View Draw CPAS Specific Routines      ************}
{*********************************************************************}

procedure draw_clipbox( plim, pmod: $wild_pointer := nil ); external 'Draw_Clipbox';

[global 'Draw_Pas_Clipbox']
procedure DRAW$CLIPBOX( var lim: [optional] array[lsz: integer] of Dfloat;
                        var imd: [optional] array[msz: integer] of Byte );
begin
  draw_clipbox( lim"address, imd"address )
end DRAW$CLIPBOX;



end.
