/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 376 ) = {
 17,  17, 100, 114,  97, 119,  36, 115, 101, 116,  95, 109, 101, 110, 117,  95,
115, 112,  99,  79,  79,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114,
101,  47,  83, 111, 102, 116,  47,  68, 114,  97, 119,  95,  70,  76,  84,  75,
 95, 115, 114,  99,  95,  86,  49,  46,  52,  67,  45,  98,  97, 115, 101,  47,
 68, 114,  97, 119,  95,  76, 105,  98, 114,  97, 114, 121,  47, 100, 114,  97,
119, 108, 105,  98,  95, 112,  97, 115,  95,  99, 111, 110, 116, 114, 111, 108,
 46, 112,  97, 115,   9,   9, 100, 114,  97, 119,  36, 105, 110, 105, 116,  20,
 20, 100, 114,  97, 119,  36, 103, 101, 116,  95, 115, 101, 114, 118, 101, 114,
 95, 110,  97, 109, 101,  12,  12, 100, 114,  97, 119,  36, 112, 105,  99, 116,
117, 114, 101,  15,  15, 100, 114,  97, 119,  36, 112, 105,  99, 116, 117, 114,
101,  95,  51, 100,  15,  15, 100, 114,  97, 119,  95, 115, 101, 110, 100,  95,
 98, 108, 111,  99, 107,  10,  10, 100, 114,  97, 119,  36, 109, 112, 108, 111,
116,  11,  11, 100, 114,  97, 119,  36, 115, 116, 114, 105, 110, 103,  16,  16,
100, 114,  97, 119,  36, 116, 101, 120, 116,  95, 105, 110,  95,  98, 111, 120,
 12,  12, 100, 114,  97, 119,  36, 115, 117, 114, 102,  97,  99, 101,  12,  12,
100, 114,  97, 119,  36, 115, 117, 114, 102,  97,  99, 101,  13,  13, 100, 114,
 97, 119,  36, 115, 117, 114, 102,  97,  99, 101,  50,  13,  13, 100, 114,  97,
119,  36, 115, 117, 114, 102,  97,  99, 101,  50,  15,  15, 100, 114,  97, 119,
 36, 112, 111, 108, 121, 104, 101, 100, 114,  97, 108,  17,  17, 100, 114,  97,
119,  36, 105, 110, 115, 116,  97, 108, 108,  95, 102, 111, 110, 116,  14,  14,
100, 114,  97, 119,  36, 102, 111, 110, 116,  95, 105, 110, 102, 111,  19,  19,
100, 114,  97, 119,  36, 103, 101, 116,  95, 115, 116, 114, 105, 110, 103,  95,
 98, 111, 120,  12,  12, 100, 114,  97, 119,  36,  99, 108, 105, 112,  98, 111,
120,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern SL Draw_Srv_NameLength;
extern V Draw_Srv_Name;


/* Function/procedure prototypes. */
void Draw_Set_Menu_Spc(SL F_cd, SL F_id, V F_name, SL F_len, SL F_key);
UB Draw_Init(F *F_x_paper, F *F_y_paper, UB *F_unit, V F_pt, SL F_len);
UB Draw_Picture(V F_pt, UB F_len, F F_x, F F_y, F F_z, UB F_sca, UB F_marg);
void Draw_Send_Block(V F_pt);
void Draw_Mplot(SL F_dim, V F_pt, SL F_flag);
void Draw_String(F F_x, F F_y, F F_th, F F_hgt, V F_s, SL F_len, SL F_oflg);
void Draw_Text_In_Box(F F_xx, F F_yy, F F_bx, F F_by, V F_s, SL F_len, SL F_hal, 
SL F_flg, F F_hc, F F_ls);
void Draw_Surface(SL F_nraw, SL F_ncol, SL F_flg, V F_vtbp);
void Draw_Surface2(SL F_nraw, SL F_ncol, SL F_flg, F F_xo, F F_yo, F F_xs, F F_ys
, V F_vtbp);
void Draw_Polyhedral(SL F_nfc, SL F_nvt, SL F_flg, V F_ftbp, V F_vtbp);
SL Draw_Install_Font(SL F_ifnt, SL F_istl, V F_fn, SL F_len);
SL Draw_Font_Info(SL F_ifnt, V F_fn, SL F_cap, SL *F_len, SL *F_stl);
SL Draw_Get_String_Box(SL F_ifnt, V F_st, SL F_len, F F_hg, F *F_bx, F *F_by);
void Draw_Clipbox(V F_plim, V F_pmod);


/* Procedure/Function : " draw_Set_menu_spc "  */
void Draw_Pas_Set_Menu_Spc(SL F_cd, V F_name, SL F_id, SL F_ky){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=93; /* line # 93 */
  if (F_name==NULL) Draw_Set_Menu_Spc(F_cd, F_id,NULL,0,0);
  else Draw_Set_Menu_Spc(F_cd, F_id,((C *)F_name)+2,((UB *)F_name)[1],F_ky);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Init "  */
UB Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+100;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=114; /* line # 114 */
  if (F_usrid==NULL) Rv0=Draw_Init(F_x,F_y,F_unit,NULL,0);
  else {
    Rv1=((UB *)F_usrid)[1];
    Ra.sl[6]=119; /* line # 119 */
    Rv0=Draw_Init(F_x,F_y,F_unit,((C *)F_usrid)+2,Rv1);
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_server_name "  */
void Draw_Pas_Get_Server_Name(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+111;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=137; /* line # 137 */
  Rv0=Draw_Srv_NameLength;
  if (Rv0>((UB *)F_s)[0]) Rv0=((UB *)F_s)[0];
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)F_s)[Rv1+1]=((C *)Draw_Srv_Name)[Rv1-1];
    Rv1++;
  }
  ((UB *)F_s)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Picture "  */
UB Draw_Pas_Picture(V F_title, F F_px, F F_py, UB F_sca, UB F_marg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+133;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=157; /* line # 157 */
  Ret=Draw_Picture(F_title+2,((UB *)F_title)[1],F_px, F_py, (F)0.000000E-01,(SL)
  F_sca,(SL)F_marg);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Picture_3d "  */
UB Draw_Pas_Picture_3D(V F_title, F F_px, F F_py, F F_pz, UB F_sca, UB F_marg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+147;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=167; /* line # 167 */
  Ret=Draw_Picture(F_title+2,((UB *)F_title)[1],F_px, F_py, F_pz,(SL)F_sca,(SL)F_marg);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_send_block "  */
void Draw_Pas_Send_Block(V F_pt, SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+164;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=181; /* line # 181 */
  Draw_Send_Block((V)F_pt);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Mplot "  */
void Draw_Pas_Mplot(V F_pt, SL F_sz, SL F_dim, SL F_flag){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+181;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=207; /* line # 207 */
  Ra.sl[7]=F_flag;
  if (4&Ra.ul[7]) Rv0=F_sz/3;
  else Rv0=F_sz/2;
  if (8&Ra.ul[7]) Rv0=Rv0/2;
  if (F_dim>Rv0||F_dim<=0) F_dim=Rv0;
  Ra.sl[6]=212; /* line # 212 */
  Draw_Mplot(F_dim, (V)F_pt,F_flag);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_String "  */
void Draw_Pas_String(F F_x, F F_y, F F_th, F F_hgt, V F_str, SL F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+193;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=225; /* line # 225 */
  Draw_String(F_x, F_y, F_th, F_hgt, F_str+2,((UB *)F_str)[1],F_flg);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Text_in_box "  */
void Draw_Pas_Text_In_Box(F F_xx, F F_yy, F F_bx, F F_by, V F_txt, SL F_sz, SL F_hal
, SL F_flg, F F_hc, F F_ls){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+206;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=237; /* line # 237 */
  Draw_Text_In_Box(F_xx, F_yy, F_bx, F_by, F_txt,F_sz, F_hal, F_flg, F_hc, F_ls);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Surface "  */
void Draw_Pas_Surface(V F_vtb, SL F_nraw, SL F_ncol, SL F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+224;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=249; /* line # 249 */
  Draw_Surface(F_nraw, F_ncol, F_flg,(((S *)F_vtb)+0*(F_ncol*12+3&~3)));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Surface "  */
void Draw_Pas_SurfaceA(SL F_nraw, SL F_ncol, SL F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+238;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=256; /* line # 256 */
  Draw_Surface(F_nraw, F_ncol, F_flg,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Surface2 "  */
void Draw_Pas_Surface2(V F_vtb, SL F_nraw, SL F_ncol, F F_xo, F F_yo, F F_xs, F F_ys
, SL F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+252;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=269; /* line # 269 */
  Draw_Surface2(F_nraw, F_ncol, F_flg, F_xo, F_yo, F_xs, F_ys,(((S *)F_vtb)+0*(F_ncol*
4+3&~3)));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Surface2 "  */
void Draw_Pas_Surface2A(SL F_nraw, SL F_ncol, SL F_flg, F F_xo, F F_yo, F F_xs, 
F F_ys){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+267;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=276; /* line # 276 */
  Draw_Surface2(F_nraw, F_ncol, F_flg, F_xo, F_yo, F_xs, F_ys,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Polyhedral "  */
void Draw_Pas_Polyhedral(V F_ftb, SL F_nfc, V F_vtb, SL F_nvt, SL F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+282;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=289; /* line # 289 */
  Draw_Polyhedral(F_nfc, F_nvt, F_flg, (V)F_ftb,(V)F_vtb);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " draw_Install_font "  */
SL Draw_Pas_Install_Font(SL F_ifnt, SL F_istl, V F_fnam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+299;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=304; /* line # 304 */
  Ret=Draw_Install_Font(F_ifnt, F_istl, F_fnam+2,((UB *)F_fnam)[1]);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Font_info "  */
SL Draw_Pas_Font_Info(SL F_ifnt, V F_fpath, SL *F_stl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+318;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=317; /* line # 317 */
  Ret=Draw_Font_Info(F_ifnt,((C *)F_fpath)+2,((UB *)F_fpath)[0],&Rv0, F_stl);
  ((UB *)F_fpath)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Get_string_box "  */
SL Draw_Pas_Get_String_Box(SL F_ifnt, V F_str, F F_hg, F *F_bx, F *F_by){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+334;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=329; /* line # 329 */
  Ret=Draw_Get_String_Box(F_ifnt, F_str+2,((UB *)F_str)[1],F_hg, F_bx,F_by);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " draw_Clipbox "  */
void Draw_Pas_Clipbox(V F_lim, SL F_lsz, V F_imd, SL F_msz){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+355;
  Ra.v[2]=Rd.s+19;
  Ra.sl[6]=344; /* line # 344 */
  Draw_Clipbox(F_lim,F_imd);
  PAS__curr_cntx=Ra.v[0];
}
