/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               D R A W   -   C L I E N T   L I B R A R Y               *
*                                                                       *
*                   (Basic Input Graphic Directives)                    *
*                      (Multi-Language Support)                         *
*                                                                       *
*                     Draw Library Version V 2.4                        *
*                                                                       *
*                            31-Oct-2009                                *
*                                                                       *
*                                by                                     *
*                                                                       *
*                   Pierre Wolfers,  Institut Neel                      *
*                                                                       *
*           CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166             *
*                                                                       *
*                      F 38042 GRENOBLE CEDEX 9                         *
*                                                                       *
*                            F R A N C E                                *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/



/*///////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
///////////////////////////////////////////////////////////////////////*/




#include <draw/draw_common.h>
#include <draw/draw_env.h>      /* Load the DRAW library Environment */




#ifdef __CYGWIN__
# define MAX_PATH_LEN 255

void cygwin_win32_to_posix_path_list( const char* win32, char* posix );

 int cygwin_win32_to_posix_path_list_buf_size( const char* path_list );

 int cygwin_posix_to_win32_path_list_buf_size( const char* path_list );

void cygwin_posix_to_win32_path_list( const char* posix, char* win32 );

static char win_unx[MAX_PATH_LEN+1],
            unx_tmp[MAX_PATH_LEN+1];
# define _FILE_TRANS
#endif


void Draw_Message( char * str, int len )
{ /* Send a message as a Warning/error message (separated window) */
  Sdrw_Put_Code( cd_message );
  Sdrw_Put_String( str, len );
  Sdrw_Server_Request();
} /* draw__message */



/*********************************************************************/

void Draw_String_Display( char * str, int len )
{ /* Display a string in the information field */
  Sdrw_Put_Code( cd_text_display );
  Sdrw_Put_String( str, len );
  Sdrw_Server_Request();
} /* draw__message */



/*********************************************************************/

int Draw_Get_Choice( int len, char * menu[], int slen[] )
{ /* Perform a Menu Request */
  int i;

  Sdrw_Put_Code( cd_get_choice );
  Sdrw_Put_Int( len );
  for (i = 0; i <= len; i++)
    Sdrw_Put_String( menu[i], slen[i] );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* draw__get_choice */



/*********************************************************************/

int Draw_Get_Answerd( char * question, int len )
{ /* Request for a Yes/Not Question */
  Sdrw_Put_Code( cd_get_answerd );
  Sdrw_Put_String( question, len );
  Sdrw_Server_Request();
  return Sdrw_Get_Int();
} /* draw__get_answerd */



/*********************************************************************/

int Draw_Get_String( char * stit, int ltit,
                     char * sdef, int ldef,
                     char * sval, int capa )
{ /* Get String from Keyboard */
  Sdrw_Put_Code( cd_get_string );
  Sdrw_Put_String( stit, ltit );
  Sdrw_Put_String( sdef, ldef );
  Sdrw_Put_Char( capa );
  Sdrw_Server_Request();
  return Sdrw_Get_String_Lim( sval, capa );
} /* draw__get_string */



/*********************************************************************/

int Draw_Get_Value( char *stit, int ltit, float *val, float lw, float up )
{ /* Get A Numeric value (Radio Button) */
  int status;

  Sdrw_Put_Code( cd_get_value );
  Sdrw_Put_String( stit, ltit );
  Sdrw_Put_Float( *val );
  Sdrw_Put_Float(  lw );
  Sdrw_Put_Float(  up );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *val = Sdrw_Get_Float();
  return status;
} /* draw__get_value */



/*********************************************************************/

int Draw_Get_Color( char *stit, int ltit, float *r, float *v, float *b )
{ /* Get A Numeric value (Radio Button) */
  int status;

  Sdrw_Put_Code( cd_get_color );
  Sdrw_Put_String( stit, ltit );
  Sdrw_Put_Float( *r );
  Sdrw_Put_Float( *v );
  Sdrw_Put_Float( *b );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *r = Sdrw_Get_Float();
  *v = Sdrw_Get_Float();
  *b = Sdrw_Get_Float();
  return status;
} /* draw__get_value */


/*********************************************************************/

int Draw_Select_File( char *   stit, int  ltit,
                      char * fltr[], int fltl[], int flen,
                      int  *    fdx,
                      char *   sdef, int  ldef,
                      char *   sval, int  capa, int wflg )
{ /* Get a File specification */
  int i;

#ifdef _FILE_TRANS
  int        j, n;
  char      * pwd;
#endif

  Sdrw_Put_Code( cd_get_file );
  Sdrw_Put_Char( wflg );
  Sdrw_Put_Char( flen );
  Sdrw_Put_String( stit, ltit );
  for (i = 0; i < flen; i++)
    Sdrw_Put_String( fltr[i], fltl[i] );
  Sdrw_Put_Char( *fdx );

#ifdef _FILE_TRANS
  pwd = getenv( "PWD" );
  if (Draw_SrvMod&SERVER_DO_WIN32_FS) {
	i = 0;
	if (pwd&&pwd[0]) {
	  while ((i<MAX_PATH_LEN-1)&&(pwd[i])) { unx_tmp[i] = pwd[i]; i++; }
	  if (unx_tmp[i-1] != '/') { unx_tmp[i++] = '/'; unx_tmp[i] = '\0'; }
	}
    if (sdef&&sdef[0]) {
	  if (ldef<=0) ldef = strlen( sdef );
	  j = 0;
	  do { unx_tmp[i++] = sdef[j]; } while ((i<MAX_PATH_LEN-1)&&(sdef[j++])&&(j<ldef));
	  if (unx_tmp[i]) unx_tmp[i++] = '\0';
    }
	
    n = cygwin_posix_to_win32_path_list_buf_size( unx_tmp );
    cygwin_posix_to_win32_path_list( unx_tmp, win_unx );
    Sdrw_Put_String( win_unx, n );
    Sdrw_Put_Char( MAX_PATH_LEN );
  } else {
    Sdrw_Put_String( sdef, ldef );
    Sdrw_Put_Char( capa );
  }
#else
  Sdrw_Put_String( sdef, ldef );
  Sdrw_Put_Char( capa );
#endif

  Sdrw_Server_Request();
  *fdx = Sdrw_Get_Char();

#ifdef _FILE_TRANS
  if (Draw_SrvMod&SERVER_DO_WIN32_FS) {
    Sdrw_Get_String( win_unx );
    n = cygwin_win32_to_posix_path_list_buf_size( win_unx );
    if (n < capa) {
      cygwin_win32_to_posix_path_list( win_unx, sval );
      return  n;
    }
    else
      return -1;
  } else
    return Sdrw_Get_String( sval );

#else

  return Sdrw_Get_String( sval );

#endif
} /* draw__select_file */




/*********************************************************************/

int Draw_Seg_Pick( int *seg_id, int *pick_id )
{ /* request for "Clic" of a Segement */
  int status;

  Sdrw_Put_Code( cd_seg_pick );
  Sdrw_Put_Int( *seg_id );
  Sdrw_Put_Int( *pick_id );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *seg_id  = Sdrw_Get_Int();
  *pick_id = Sdrw_Get_Int();
  return status;
} /* draw_seg_pick */



/*********************************************************************/

int Draw_Get_Position( float *xx, float *yy, Char in_epure )
{ /* Request to get a Point coordinates */
  int status;

  Sdrw_Put_Code( cd_get_position );
  Sdrw_Put_Float( *xx );
  Sdrw_Put_Float( *yy );
  Sdrw_Put_Char( in_epure );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *xx = Sdrw_Get_Float();
  *yy = Sdrw_Get_Float();
  return status;
} /* Draw_Get_Position */


/*********************************************************************/

int Draw_Get_Window( float *x1, float *x2, float *y1, float *y2 )
{ /* Get the Rectangle (Window) Coordinates */
  int status;

  Sdrw_Put_Code( cd_get_window );
  Sdrw_Put_Float( *x1 );
  Sdrw_Put_Float( *x2 );
  Sdrw_Put_Float( *y1 );
  Sdrw_Put_Float( *y2 );
  Sdrw_Server_Request();
  status = Sdrw_Get_Int();
  *x1 = Sdrw_Get_Float();
  *x2 = Sdrw_Get_Float();
  *y1 = Sdrw_Get_Float();
  *y2 = Sdrw_Get_Float();
  return status;
} /* Draw_Get_Window */



/*********************************************************************/

int Draw_Get_Curve( float pt[], int cap, int *size, Char keep, Char f_stroke )
{ /* Get Line (f_stroke=0)/ Stroke (f_stroke==1), Store the points in
     pt table and final size in *size, capa is the size in Dpoint of
     the array pt */
  int j, status, npt, rdim;

  Sdrw_Put_Code( f_stroke==0?cd_get_line:cd_get_stroke );
  Sdrw_Put_Int( abs( cap/2 ) );  /* Transmit the total capacity */
  Sdrw_Put_Char( keep );         /* Send the Graphic append flag */
  *size = 0;                     /* Init the Point count */
  do {
    Sdrw_Server_Request();       /* Send the partial Request */
    status = Sdrw_Get_Int();     /* Get status */
    rdim   = Sdrw_Get_Int();     /* Get the number of receive point */
    for (j = 0; j < rdim; j++) {
      *(pt++) = Sdrw_Get_Float();/* Store the x in the user memory */
      *(pt++) = Sdrw_Get_Float();/* Store the y in the user memory */
    }
    *size += rdim;               /* Update the collected number of point */
  if (status&1) break;
    Sdrw_Put_Code( cd_continue );
    Sdrw_Put_Char( 0 );          /* Continue in 2D mode */
  } while (1);
                                 /* status = 1=> Finish, status = -1 stop. */
  return status;
} /* Draw_Get_Curve */



/*********************************************************************/

void Draw_Echo_Pos( int crsk )
{
  Sdrw_Put_Code( cd_echo_get_pos );
  Sdrw_Put_Int( crsk );
  Sdrw_Server_Request();
}



/*********************************************************************/

void Draw_Echo_Line( int col, int md, int knd, float sz )
{
  Sdrw_Put_Code( cd_echo_get_line );
  Sdrw_Put_Int( col );
  Sdrw_Put_Int( md );
  Sdrw_Put_Int( knd );
  Sdrw_Put_Float( sz );
  Sdrw_Server_Request();
}


/****************************    E N D    ****************************/
